package iax.security;

import junit.framework.TestCase;

public class MD5Test extends TestCase {
	private final String[] input = new String[] {
			"",
			"a",
			"abc",
			"message digest",
			"abcdefghijklmnopqrstuvwxyz",
			"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",
			"12345678901234567890123456789012345678901234567890123456789012345678901234567890"};
	private final byte[][] expected = new byte[][] {
			{(byte)0xd4,0x1d,(byte)0x8c,(byte)0xd9,(byte)0x8f,0x00,(byte)0xb2,0x04,(byte)0xe9,(byte)0x80,0x09,(byte)0x98,(byte)0xec,(byte)0xf8,0x42,0x7e},
			{0x0c,(byte)0xc1,0x75,(byte)0xb9,(byte)0xc0,(byte)0xf1,(byte)0xb6,(byte)0xa8,0x31,(byte)0xc3,(byte)0x99,(byte)0xe2,0x69,0x77,0x26,0x61},
			{(byte)0x90,0x01,0x50,(byte)0x98,0x3c,(byte)0xd2,0x4f,(byte)0xb0,(byte)0xd6,(byte)0x96,0x3f,0x7d,0x28,(byte)0xe1,0x7f,0x72},
			{(byte)0xf9,0x6b,0x69,0x7d,0x7c,(byte)0xb7,(byte)0x93,(byte)0x8d,0x52,0x5a,0x2f,0x31,(byte)0xaa,(byte)0xf1,0x61,(byte)0xd0},
			{(byte)0xc3,(byte)0xfc,(byte)0xd3,(byte)0xd7,0x61,(byte)0x92,(byte)0xe4,0x00,0x7d,(byte)0xfb,0x49,0x6c,(byte)0xca,0x67,(byte)0xe1,0x3b},
			{(byte)0xd1,0x74,(byte)0xab,(byte)0x98,(byte)0xd2,0x77,(byte)0xd9,(byte)0xf5,(byte)0xa5,0x61,0x1c,0x2c,(byte)0x9f,0x41,(byte)0x9d,(byte)0x9f},
			{0x57,(byte)0xed,(byte)0xf4,(byte)0xa2,0x2b,(byte)0xe3,(byte)0xc9,0x55,(byte)0xac,0x49,(byte)0xda,0x2e,0x21,0x07,(byte)0xb6,0x7a}};
	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testFinish() {
		for(int i = 0;i < 7;++i){
			MD5 digest = new MD5(input[i].getBytes());
			byte[] actual = digest.finish();
			assertEquals(16, actual.length);
			for(int j = 0;j < actual.length;++j){
				assertEquals(expected[i][j], actual[j]);
			}
		}
	}

	public void testDigest() {
		for(int i = 0;i < 7;++i){
			MD5 digest = new MD5();
			byte[] actual = digest.digest(input[i].getBytes());
			assertEquals(16, actual.length);
			for(int j = 0;j < actual.length;++j){
				assertEquals(expected[i][j], actual[j]);
			}
		}
	}

}
