package iax.client.protocol.user.command;

import iax.client.protocol.call.Call;
import iax.client.protocol.frame.ProtocolControlFrame;
import iax.client.protocol.peer.Peer;

/**
 * Implements the user command that unholds a call.
 */
public class UnHoldCall {

	public static void execute(Peer peer) {
        try {
            Call call = peer.getCall();
            ProtocolControlFrame unquelchCallFrame = 
                new ProtocolControlFrame(call.getSrcCallNo(), false, call.getDestCallNo(), call.getTimestamp(), call.getOseqno(),
                        call.getIseqno(), false, ProtocolControlFrame.UNQUELCH_SC);
            call.handleSendFrame(unquelchCallFrame);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}