#include "hole_punchd.h"

void	keep_alive_check (void);
void	check_json_table(void);

int	main(int argc, char *argv[])
{
 	int 	sock;
	int	sock_ifr;
	int	length;
	int	ret;
	time_t	atime;
 	struct	sockaddr_in	addr;
	struct	sockaddr_in	senderinfo;

	struct  addrinfo        hints;
        struct  addrinfo        *result, *rp;
        struct  ifreq   ifr;
	socklen_t	addrlen;
	char	senderstr[16];

 	char	buf[128];
	char	send_buff[64];

	int	recv_sw;
	int	i;
	struct        RepeaterTable   *next;
	char	PORT[10];

	log_file = fopen (LOG_FILE, "a");
	if (log_file == NULL)
	{
		return 1;
	}

	time(&start_time);
	fprintf (log_file, "%24.24s Hole Punch Server start\n", 
		ctime(&start_time));
	fflush (log_file);

	http_port = HTTP_PORT;
	json_port = JSON_PORT;
	json_sock_table_pnt = NULL;

	debug_sw = FALSE;
	sig_term = FALSE;
	debug_sw = FALSE;

	if (argc == 2)
	{
		if (memcmp (argv[1], "-D", 2)) debug_sw = TRUE;
	}
	handler_init();

        sock_ifr = socket (AF_INET, SOCK_DGRAM, 0);

        if (OwnIP.s_addr == 0)
        {
                memset (NicDevice, 0x00, sizeof(NicDevice));
                strcpy (NicDevice, NicDeviceInit);
                ifr.ifr_addr.sa_family = AF_INET;
                strncpy (ifr.ifr_name, NicDevice, IFNAMSIZ-1);
                ioctl (sock_ifr, SIOCGIFADDR, &ifr);
                OwnIP.s_addr = ((struct sockaddr_in *)&ifr.ifr_addr)->sin_addr.s_addr;
                time(&cur_time);
                fprintf  (log_file, "%24.24s Own IP address %s\n",
                                ctime(&cur_time), inet_ntoa(((struct sockaddr_in *)&ifr.ifr_addr)->sin_addr));
                fflush (log_file);
        }

 	sock = socket(AF_INET, SOCK_DGRAM, 0);

	addr.sin_family = AF_INET;
	addr.sin_port = htons(HOLE_PUNCH_PORT);
	addr.sin_addr.s_addr = INADDR_ANY;

 	bind(sock, (struct sockaddr *)&addr, sizeof(addr));

	pselectSet();
	FD_SET (sock, &fd_save);
	RepeaterTablePnt = NULL;

	portSet();

	while (1)
	{
		memcpy (&read_set, &fd_save, sizeof(fd_set));
		memcpy (&sigset, &save_sig, sizeof(save_sig));
		ret = pselect (FD_SETSIZE, &read_set, (fd_set *)NULL,
			(fd_set *)NULL, &timeout, &sigset);
		if (ret > 0)
		{
			if (FD_ISSET (sock, &read_set))
			{
 				memset(buf, 0, sizeof(buf));
				addrlen = sizeof(senderinfo);
 				length = recvfrom(sock, buf, sizeof(buf), 0, (struct sockaddr *)&senderinfo, &addrlen);
				if (length >= 16)
				{
					if (!memcmp (buf, "HPCH", 4))
					{ 
						if (length == 24) /* new version */
						{
							repeater_connect (senderinfo, buf, length);
							memset (send_buff, 0x00, sizeof(send_buff));
							sprintf (send_buff, "HPCH%d", ntohs(senderinfo.sin_port));
							sendto (sock, send_buff, 10, 0,(struct sockaddr *)&senderinfo,
								sizeof (struct sockaddr_in));

                                                        memset (&hints, 0x00, sizeof(struct addrinfo));
                                                        hints.ai_family = AF_INET;
                                                        hints.ai_socktype = SOCK_DGRAM;
                                                        hints.ai_protocol = 0;
                                                        memcpy (send_buff, &buf, length);
                                                        memcpy (send_buff, "HPFW", 4);
							memcpy (&send_buff[24], &senderinfo, sizeof (struct sockaddr));
                                                        sprintf (PORT, "%d\0", HOLE_PUNCH_PORT);
                                                        if (getaddrinfo (HOLE_PUNCH_SERVER, PORT, &hints, &result) == 0)
                                                        {
                                                                for (rp = result ; rp != NULL ; rp = rp->ai_next)
                                                                {
                                                                        if (OwnIP.s_addr != ((struct sockaddr_in *)(rp->ai_addr))->sin_addr.s_addr)
                                                                                sendto (sock, send_buff, length+sizeof(struct sockaddr), 0, rp->ai_addr, rp->ai_addrlen);
                                                                }
                                                        }
                                                        if (result) freeaddrinfo (result);
							
						}
						else if (length == 30)
						{
							inet_ntop(AF_INET, &senderinfo.sin_addr,
								senderstr, sizeof(senderstr));
							time(&atime);
							fprintf (log_file, "%24.24s Client:%10.10s (%s:%d)\n", 
								ctime(&atime), &buf[20], senderstr, ntohs(senderinfo.sin_port));
							fflush (log_file);
							next = RepeaterTablePnt;
							while (next)
							{
								if (!memcmp (inet_ntoa (next->repeater_addr.sin_addr), 
									&buf[4], strlen(buf) - 4))
								{
									memset (send_buff, 0x00, sizeof(send_buff));
									sprintf (send_buff, "HPCH%s:%d", senderstr,
									ntohs(senderinfo.sin_port));
									sendto (sock, send_buff, 26, 0, 
										(struct sockaddr *)&next->repeater_addr,
										sizeof(struct sockaddr_in));
									sprintf (send_buff, "HPCH%s:%d", 
										inet_ntoa (next->repeater_addr.sin_addr),
										ntohs (next->repeater_addr.sin_port));
									sendto (sock, send_buff, 26, 0,
										(struct sockaddr *)&senderinfo,
										sizeof (struct sockaddr_in));
								}
								next = next->f_chain;
							}
						}
					}
                                        else if (!memcmp (buf, "HPFW", 4))
                                        {
						if (length == (24+sizeof(struct sockaddr)))
						{
							memcpy (&senderinfo, &buf[24], sizeof (struct sockaddr));
                                        		repeater_connect (senderinfo, buf, length - sizeof(struct sockaddr));
						}
                                        }
					else if (!memcmp (buf, "DISC", 4))
					{
                                        	disconnect_hole_punch (buf);
                                                memset (&hints, 0x00, sizeof(struct addrinfo));
                                                hints.ai_family = AF_INET;
                                                hints.ai_socktype = SOCK_DGRAM;
                                                hints.ai_protocol = 0;
                                                memcpy (send_buff, &buf, 24);
                                                memcpy (send_buff, "DISW", 4);
                                                sprintf (PORT, "%d\0", HOLE_PUNCH_PORT);
                                                if (getaddrinfo (HOLE_PUNCH_SERVER, PORT, &hints, &result) == 0)
                                                {
                                                	for (rp = result ; rp != NULL ; rp = rp->ai_next)
                                                        {
                                                        	if (OwnIP.s_addr != ((struct sockaddr_in *)(rp->ai_addr))->sin_addr.s_addr)
                                                                	sendto (sock, send_buff, 24, 0, rp->ai_addr, rp->ai_addrlen);
                                                        }
                                                }
                                                if (result) freeaddrinfo (result);
                                   	}
                                        else if (!memcmp (buf, "DISW", 4))
                                        {
                                                disconnect_hole_punch (buf);
                                        }
					else if (!memcmp (buf, "STAT", 4) || !memcmp (buf, "STFW", 4))
					{
						if (memcmp (&buf[32], &buf[40], 7)) return;
						next = RepeaterTablePnt;
						while (next)
						{
							if (!memcmp (&buf[4], next->ar_callsign, 8))
							{
								time(&next->status_time);
								if (!memcmp (&buf[12], "ON  ", 4))
									next->status = ON;
								else
									next->status = OFF;
								if (length == 48)
								{
									memcpy (next->ur_call, &buf[16], 8);
									memcpy (next->my_call, &buf[24], 8);
									memcpy (next->rpt1_call, &buf[32], 8);
									memcpy (next->rpt2_call, &buf[40], 8);
								}
								else if (length == 32)
								{
									memcpy (next->ur_call, &buf[16], 8);
									memcpy (next->my_call, &buf[24], 8);
									memset (next->rpt1_call, 0x20, 8);
									memset (next->rpt2_call, 0x20, 8);
								}
								else
								{
									memset (next->ur_call, 0x20, 8);
									memset (next->my_call, 0x20, 8);
									memset (next->rpt1_call, 0x20, 8);
									memset (next->rpt2_call, 0x20, 8);
								}
								break;

							}
							next = next->f_chain;
						}
                                                if (!memcmp (buf, "STAT", 4))
                                                {
                                                        memset  (&hints, 0x00, sizeof(struct addrinfo));
                                                        hints.ai_family = AF_INET;
                                                        hints.ai_socktype = SOCK_DGRAM;
                                                        hints.ai_protocol = 0;
                                                        sprintf (PORT, "%d\0", HOLE_PUNCH_PORT);
                                                        if (getaddrinfo (HOLE_PUNCH_SERVER, PORT, &hints, &result) == 0)
                                                        {
                                                                memcpy (buf, "STFW", 4);
                                                                for (rp = result ; rp != NULL ; rp = rp->ai_next)
                                                                {
                                                                        if (OwnIP.s_addr != ((struct sockaddr_in *)(rp->ai_addr))->sin_addr.s_addr)
                                                                                sendto (sock, buf, length, 0, rp->ai_addr, rp->ai_addrlen);
                                                                }
                                                        }
                                                        if (result) freeaddrinfo (result);
                                                }	
					}
				}
			}
			if (FD_ISSET (http_sd, &read_set))
			{
				httpd_srv_accept();
			}
			if (FD_ISSET (json_sd, &read_set))
			{
				json_srv_accept ();
			}
			if (http_port)
			{
				for (i = 0 ; i < FD_SETSIZE ; i++)
				{
					if (( i == sock)
						|| (i == json_sd)
						|| (i == http_sd)) goto skip;
					if (FD_ISSET (i, &read_set))
					{
						if (json_fd[i/8] & (0x01 << (i % 8))) json_srv_recv(i);
						else httpd_srv_recv (i);
					}
					skip: continue;
				}
			}

		}	
		keep_alive_check();
		status_check();
		check_json_table();
		if (sig_term) break;
	}
	close(sock);
	time(&cur_time);
	fprintf (log_file, "%24.24s Hole Punch Server end\n\n", ctime(&cur_time));
	fflush (log_file);
	fclose (log_file);
}

