OUTPUT_FORMAT("coff-sh")
OUTPUT_ARCH(sh)
ENTRY("_start")
MEMORY
{
	vector     : o = 0x00000000, l = 0x00400
	rom(rx)    : o = 0x0000a000, l = 0x06000
	ram(rwx)   : o = 0xfffff680, l = 0x00580
	stack(rw)  : o = 0xfffffc00, l = 0x00400
}
SECTIONS 				
{ 					
.vector 0x000: {
	_vec_top = . ; 
	*(.vector)                     
	} > vector
.text : {
	*(.text)
	*(.strings)
	*(.rodata) 				
   	 _etext = . ; 
	} > rom
.tors : {
	___ctors = . ;
	*(.ctors)
	___ctors_end = . ;
	___dtors = . ;
	*(.dtors)
	___dtors_end = . ;
	}  > rom
.data : AT ( ADDR(.tors) + SIZEOF(.tors) ){
	___data = . ;
	*(.data)
	*(.tiny)
	 _edata = .;
	} > ram
.bss : {
	 _bss_start = . ;
	*(.bss)
	*(COMMON)
	 _end = . ;  
	}  >ram
.stack 0xfffffffc : {
	 _stack = . ;
	*(.stack)
	}  > stack
}
