#include "reg704x.h"

extern void prstr(char *x);
extern int velocity;
extern int steering_angle;

void init_CMT(void)
{
	CMCSR0 = 0x0043;	//B7.6　コンペアマッチフラグ　割り込み許可フラグ　B1.0　ともにクロックセレクトフラグ　Φ/５１２＝５６kHz
	CMCOR0 = 5600-1;	//比較する数 16bit これで5,600カウント　100m秒
	IPRG |= 0x00f0;		//割り込み優先度設定　IPRのＡ〜Ｈに　4つずつの機能が設定されておりCMT0はB4〜7
	CMSTR = 0x0001;		//タイマスタートレジスタ　B0.1　CMT0　CMT1のスタートを設定する
}

void MakeSteeringAngle(void)
{
	double z;
		
	steering_angle = ADDRA0 >> 6;
	z = steering_angle*5.0/1023.0;
	z = -(z -1.20)/0.0296;
	steering_angle = (int)(z*100);
}
//Xmm/sを返す
void MakeVelocity(void)
{
	static int oldMTU2_count = 32768;
	int nowMTU2_count;
	
	nowMTU2_count = (TCNT1 << 16);
	nowMTU2_count |= TCNT2;
	
	velocity = (nowMTU2_count - oldMTU2_count)*314.1592*10/400/1;
	
	oldMTU2_count = nowMTU2_count;
}

//コンペアマッチタイマーの割り込み
#pragma interrupt(int_cmt0)
void int_cmt0(void)
{
	int dummy;
	
	MakeVelocity();
	MakeSteeringAngle();
	
	dummy = CMCSR0;		//１回読まないとクリアできない
	CMCSR0 &= ~0x0080;	//マッチしたフラグをクリア
}

