
#include "scipBase.h"
#include "scip1.h"
#include "scip2.h"
#include "scipUtil.h"

int main()
{
	//URGのポート変数を作成
	tPort *port0;
	
	const int TOPSTARTSTEP = 0;
	const int TOPENDSTEP = 1127;
	const int STEPCLUSTER = 1;
	const double D2R = 3.1415/180.0;
	const int ON = 1;
	const int OFF = 0;

	int i;			//ステップナンバー用
	FILE *fpn,*fpgnu; //オドメトリとURGデータを1スキャン分ずつ保存するファイル用
	int stepNum;			//URGのステップナンバー保存用
	int *scan;
	int x,y;
	int block = OFF;
	
	port0 = scipConnect("/dev/ttyACM0");
	if(port0 == NULL)
	{
		perror("Could not connect to the ACM0 ¥n");
		exit(EXIT_FAILURE);
	}
	
	//各URGをスキップ２に変更（いらない？）
	switchToScip2(port0);
	
	fpgnu = popen("gnuplot","w");
	fprintf(fpgnu,"set xrange[-3000:3000]\n");
	fprintf(fpgnu,"set yrange[-3000:1000]\n");
	fprintf(fpgnu,"set size ratio -1\n");

	scip2StartStoringScan(port0);

	while(1)
	{
		fpn = fopen("log.dat","w");
		scan=scip2GetScan(port0,TOPSTARTSTEP,TOPENDSTEP,STEPCLUSTER,ENC_3BYTE,&stepNum);
		if(scan == NULL)	//デバッグ用
		{
			printf("can not get data");
			sleep(5);
		}
		for(i=TOPSTARTSTEP;i<TOPENDSTEP;i++)	//URGデータを保存
		{
			fprintf(fpn,"%d %d\n",i,scan[i]);
			x = (int)(scan[i]*cos(((i-560)*0.25-90.0)*D2R));
			y = (int)(scan[i]*sin(((i-560)*0.25-90.0)*D2R));
			fprintf(fpn,"%d %d %d \n",i,x,y);
			if( block == OFF && y < -20  && y > -1000 && x > -500 && x < 500)
			{
				block = ON;
			}
		}
		if(block == ON)
		{
			printf("block\n");
			block = OFF;
		}
		else
		{
			printf("nonblock\n");
		}
		fclose(fpn);
		free(scan);
		fprintf(fpgnu,"plot \"log.dat\" u 2:3, \"eria\" u 1:2 w l\n");
		fflush(fpgnu);
		usleep(10000);
	}

	return 0;
}
