/*
	呼出し元からスキャンデータ（オドメトリ含む）を受け取り
	スキャン時の自己位置を修正するプログラム
*/
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "aroundmap.h"
#include "localize3.h"

double errlength = 1000;
double errdeg = 20;
#if 0
int main(int argv,char *argc[])
{
	int filenum;
	struct pos NTPos = {0,0,0};
	struct pos NFPos = {0,0,0};
	struct pos OTPos = {0,0,0};
	struct pos OFPos = {0,0,0};
	int end;

	/*  filenum*/
        end = atoi(argc[1]);

	fprintf(stderr,"tes");

	for(filenum = 0;filenum <= end; filenum += 1 )
	{
		//マッチング対象のスキャンデータファイルからオドメトリを抜き出す
		NFPos = getodometori(filenum);
		
		//スキャンデータを位置姿勢情報を使ってグローバル座標上に展開する
		DownToGlobal(filenum,NFPos,'b');
			
		//ひとつ前のオドメトリとの差分から初期値にするのに正しいオドメトリをつくる
		NFPos = MakeRightPos(NFPos,OFPos,OTPos);
		
		//次回の変数作成のために古い今の位置を保存
		OFPos = getodometori(filenum);
		
		//マッチングに利用するマップの作成
		aroundmap(NFPos.x,NFPos.y,NFPos.th);
		
		//マッチングによる位置姿勢の修正
		NTPos = localize(filenum,NFPos.x,NFPos.y,NFPos.th);

		//スキャンデータを位置姿勢情報を使ってグローバル座標上に展開する
		DownToGlobal(filenum,NTPos,'l');
		
		//修整後の位置姿勢情報を保存
		OTPos = NTPos;
		
	}  
	return 0;
}
#endif
struct pos localize(int filenum,double oldpositionx,double oldpositiony,double oldpositionth)
{
  const int NOOVER = 0;
  const int OVER = 1;
  const int SCAN_DIST = 4900;
  const int L_MAX = 200;
  const double R2D = 180.0/3.14159265358979323846;
  const double D2R = 3.14159265358979323846/180.0;
  FILE *fpmap,*fpscan;
  FILE *fprate;
  char scanfilename[6];
  int over = NOOVER;
  double x,y,th;
  double kx,ky,kth;
  double dExt,dEyt,dEth;
  double E;
  double d = 0.0, dmin = 0.0, dist;
  double mapx[15000],mapy[15000];
  double scanx[2000],scany[2000];
  double convx[2000],convy[2000];
  double map_taiou_x[2000],map_taiou_y[2000];
  char s[256];
  double R00,R01,R10,R11;
  int i,j;
  int mappoint_num,scan_num,point_num;
  int Loop_count;
  
  double rate = 0.7;

  struct pos oldposition = {0.0,0.0,0.0};
  struct pos newposition;
  
static int counter = 0;
printf("count = %d\n",counter);
counter ++;
  kx=0.003;
  ky=0.003;
  kth=0.000000001;

  x = 0;
  y = 0;
  th = 0;

	//マップデータを開いて点を読み込む
  if((fpmap = fopen("aroundmap.map","r")) == NULL)
    {
      fprintf(stderr,"I could not open aroundmap.map¥n");
    }
    	//実際は5000点程度
  for(i = 0;fgets(s,255,fpmap) != NULL && i < 15000;i++)
  {
    sscanf(s,"%*s %lf %lf",&mapx[i],&mapy[i]);
  }
  mappoint_num = i;
  fclose(fpmap);

  sprintf(scanfilename,"0%d",filenum);
  if((fpscan = fopen(scanfilename,"r")) == NULL)
    {
      fprintf(stderr,"I could not open %s",scanfilename);
    }
  i = -1;
  while(fgets(s,255,fpscan) != NULL)
    {
      if(i == -1)
      {
//        sscanf(s,"%lf %lf %lf",&oldposition.x,&oldposition.y,&oldposition.th);
oldposition.x = oldpositionx;
oldposition.y = oldpositiony;
oldposition.th = oldpositionth;

      }
      else
      {
        sscanf(s,"%*s %lf %lf",&scanx[i],&scany[i]);
        //スキャンデータの使用範囲を指定
      	if( (fabs(scanx[i]) < 1000 && fabs(scany[i]) < 1000) || fabs(scanx[i]) > 6000 || fabs(scany[i]) > 6000)
	{
	  continue;
	}
	//範囲内のデータを一定密度になるように間引く
        for(j=0;j<i;j++)
	{
	//j番目の点の周囲SCAN_DIAST内に既に採用した点があれば採用しない
	  if( ((scanx[i]-scanx[j])*(scanx[i]-scanx[j]) + (scany[i]-scany[j])*(scany[i]-scany[j])) < SCAN_DIST )
	    {
	      over = OVER;
	      break;
	    }
	}
      }
      if(over == NOOVER)
	{
	  i++;
	}
      over = NOOVER;
    }
    //scan_numは何割をマッチングに使ったかを算出しマッチングの成否を判定するのに利用
  scan_num = i;
  fclose(fpscan);
  for(Loop_count=0;Loop_count<=L_MAX;Loop_count++)	//規定回数最急降下法により近づける現在は２００回
    {
      R00=cos(th);
      R01=sin(th);
      R10=-sin(th);
      R11=cos(th);

      point_num=0;		//最急降下法に用いる数初期化 スキャンデータ何点に付いてマッチングを行ったか
      dExt=dEyt=dEth=0.0;	//偏微分値を初期化
      E=0.0;			//評価関数を初期化
      //対応点探索と表示のループ
      for(j=0;j<=scan_num;j++)	//j番めのスキャン点をオドメトリデータをつかってマップの座標系に落とす
	{
	  convx[j]=(int)(R00*(scanx[j])+R10*(scany[j])+x);
	  convy[j]=(int)(R01*(scanx[j])+R11*(scany[j])+y);
	  dmin=100000000.0;

	  for(i=0;i<=mappoint_num;i++)	//i番目のマップ点と比較し一番距離の短いところを探す
	    {
	      d=(mapx[i]-convx[j])*(mapx[i]-convx[j])+(mapy[i]-convy[j])*(mapy[i]-convy[j]);
	      if(d<=dmin)
		{
		  dmin=d;
		  map_taiou_x[j]=mapx[i];
		  map_taiou_y[j]=mapy[i];
		}
	    }

	if(dmin>1000000.0)	//1m以上離れてたら最急降下法にもちいない
	{
		continue;
	}

	if(Loop_count>100)
	{
		if(dmin>40000.0)
		{//20cm以上離れてたら最急降下法に用いない
			continue;
		}
	}
	  point_num++;
	  dist=(map_taiou_x[j] - convx[j])*(map_taiou_x[j] - convx[j])	//距離を・・・dminじゃないの？
	    +(map_taiou_y[j] - convy[j])*(map_taiou_y[j] - convy[j]);
	  E=E+dist;

	  dExt += (-2.0*(map_taiou_x[j] - convx[j]));	//xに関して偏微分するとこ〜なる
	  dEyt += (-2.0*(map_taiou_y[j] - convy[j]));
	  dEth =dEth
	    + 2.0*( scanx[j]*R01 + scany[j]*R00)
	    *(map_taiou_x[j] - scanx[j]*R00 +scany[j]*R01-x)
	    + 2.0*(-scanx[j]*cos(th) + scany[j]*sin(th))
	    *(map_taiou_y[j] - scanx[j]*R01 -scany[j]*R00-y) ;

	}


      //変数の更新
      x += (-kx*dExt);
      y += (-ky*dEyt);
      th -= kth*dEth;
    }
    //対応点間の平均距離　マッチングに利用した割合　間引いた後のスキャン点数が表示される、　
    //経験上　理想的な環境では７割以上がマッチングに利用され　間引いた後の点数は２００〜３００点程度であったと思う
  printf("(E/point_num) = %lf point_num / scan_num = %lf scan_num = %d\n",sqrt(E/point_num),point_num / (double)scan_num, scan_num);

	//上記情報をログファイルにも記録
  fprate = fopen("rate.dat","a");
  if(fprate == NULL)
  {
  	printf("can not open rate.dat\n");
  }
  else
  {
  	fprintf(fprate,"file_numsqrt = %d sqrt(E/point_num) = %lf point_num / scan_num = %lf scan_num = %d\n",filenum,sqrt(E/point_num),point_num / (double)scan_num, scan_num);
  	fclose(fprate);
  }
#if 0
	//位置によってマッチング判定のレートを変更するならここを設定
  if(oldpositionx < 280000 || oldpositionx > 320000)
  {
  	rate = 0.1;
  }
  else if(oldpositionx >= 280000 && oldpositionx <= 320000)
  {
  	rate = 0.7;
  }
#endif
	//マッチングに成功したら誤差楕円を小さくし、失敗したら大きくする　errlength　マッチング前後での移動が許される距離　errdeg　回転が許される角度
  if(point_num / (double)scan_num > rate )
  {
  	newposition.th = oldposition.th + th * R2D;
  	newposition.x = oldposition.x + x * cos(newposition.th*D2R) + y * -sin(newposition.th*D2R);
  	newposition.y = oldposition.y + x * sin(newposition.th*D2R) + y * cos(newposition.th*D2R);
  	errlength /= 0.75;
  	if(errlength < 1000)
  	{
  		errlength = 1000;
  	}
  	errdeg /= 0.75;
  	if(errdeg < 20)
  	{
  		errdeg = 20;
  	}
  }
  else
  {
  	newposition.x = oldposition.x;
  	newposition.y = oldposition.y;
  	newposition.th = oldposition.th;
  	errlength *= 1.05;
  	if(errlength > 5000)
  	{
  		errlength = 5000;
  	}
  	errdeg *= 1.05;
  	if(errdeg > 90)
  	{
  		errdeg = 90;
  	}
  }
//  printf("x = %lf,y = %lf,th = %lf\n",x,y,th);
//  printf("newposition.x = %lf,newposition.y = %lf,newposition.th = %lf \n",newposition.x,newposition.y,newposition.th);
  return newposition;
}

struct pos getodometori(int filenum)
{
	struct pos Pos;
	FILE *fp;
	char filename[6];
	char s[256];
	
	sprintf(filename,"0%d",filenum);
	if((fp = fopen(filename,"r")) == NULL)
	{
		fprintf(stderr,"i could not open %s\n",filename);
	}
	fgets(s,255,fp);
	sscanf(s,"%lf %lf %lf %*s",&Pos.x,&Pos.y,&Pos.th);
	fclose(fp);
			
	return Pos;
}

struct pos MakeRightPos(struct pos newPos,struct pos oldPos,struct pos oldTPos)
{
	//研究ノート83p
	double dth,dist;
	struct pos Pos;
	double alha;
	const double D2R = 3.14159265358979323846/180.0;
	
	dist = sqrt(pow(newPos.x - oldPos.x, 2) + pow(newPos.y - oldPos.y, 2));
//	printf("dist = %lf\n",dist);
	
	dth = newPos.th - oldPos.th;
//	printf("dth = %lf\n",dth);

	Pos.th = dth + oldTPos.th;
	
	alha = atan2(newPos.y-oldPos.y,newPos.x-oldPos.x) - oldPos.th * D2R;
//	printf("%lf %lf\n",atan2(newPos.y-oldPos.y,newPos.x-oldPos.x),oldPos.th * D2R);
	
//	printf("alha = %lf\n",alha);
	Pos.x = dist * cos(alha+oldTPos.th*D2R) + oldTPos.x;
	Pos.y = dist * sin(alha+oldTPos.th*D2R) + oldTPos.y;
	
	return Pos;
}

void DownToGlobal(int filenum,struct pos Position,char label)
{
	char inname[7],outname[7];
	char s[256];
	double scanx,scany;
	FILE *fpin,*fpout;
	int i;
	double costh,msinth,sinth;
	const double D2R = 3.14159265358979323846/180.0;
	
	sprintf(inname,"0%d",filenum);
	if((fpin = fopen(inname,"r")) == NULL)
	{
		fprintf(stderr,"I could not open %s\n",inname);
	}
	
	sprintf(outname,"%c0%d",label,filenum);
	if((fpout = fopen(outname,"w")) == NULL)
	{
		fprintf(stderr,"I could not open %s\n",outname);
	}
		
	//マッチング後のスキャンデータ描画用
	costh = cos(Position.th * D2R);
	msinth = -sin(Position.th * D2R);
	sinth = sin(Position.th * D2R);
	
	//スキャンデータをグローバル座標上に展開
	for(i = -1;fgets(s,255,fpin) != NULL;i++)
	{
		if(i >=0)
		{
			sscanf(s,"%*s %lf %lf",&scanx,&scany);
			fprintf(fpout,"a %lf %lf\n",
				scanx * costh + scany * msinth + Position.x,
				scanx * sinth + scany * costh + Position.y);
		}
	}
	fclose(fpin);
	fclose(fpout);
	
}
