/*!
  \file
  \brief ǃItZbg̒vO

  \author Satofumi KAMIMURA

  $Id$

  𑖂点ƂB
  ̂ƂAsǂ␳ƌȂAJEgċL^B

  Wii WR̗v̂ŋNA"home" ŏIB
  "plus", "minus" ... ix̒
  ̍E ... ɐ񂷂B񂳂񐔂͕␳ƂċL^B
*/

#include "SteerOffsetHandler.h"
#include "WiiJoystick.h"
#include "SimulationCtrl.h"
#include "RobotCtrl.h"
#include "Delay.h"


enum {
  MaxVelocity = 4,		// [km/h]
  DelayMsec = 100,		// [msec]
};


static void updateLed(int velocity_km, WiiJoystick& joystick) {

  static int pre_velocity_km = 0;
  if (velocity_km == pre_velocity_km) {
    // ڕWxɕωȂ΁Axw߂͍ĔsȂ
    return;
  }
  pre_velocity_km = velocity_km;

  // LED \̍XV
  if (velocity_km > 0) {
    // ~߂̂Ƃ́ALED XVȂ

    unsigned char led_bits = 0;
    for (int i = 0; i < velocity_km; ++i) {
      led_bits >>= 1;
      led_bits |= 0x8;
    }
    joystick.setLed(led_bits);
  }
}


static int adjustOffset(RobotCtrlInterface* robot, WiiJoystick& joystick,
			int steer_offset) {

  int velocity_km = 1;
  updateLed(velocity_km, joystick);

  bool up_pressed = false, down_pressed = false;
  bool quit = false;
  while (quit == false) {

    // Home ꂽA~R}h𔭍sďI
    if (joystick.isButtonPressed(WiiJoystick::Button_Home)) {
      quit = true;
      robot->stop();
      continue;
    }

    if (joystick.isButtonPressed(WiiJoystick::Button_Plus)) {

      // ڕWxグBMaxVelcity 傫͂ȂȂ
      if ((up_pressed == false) && (velocity_km < MaxVelocity)) {
	++velocity_km;
	updateLed(velocity_km, joystick);
      }
      up_pressed = true;

    } else {
      up_pressed = false;
    }
    if (joystick.isButtonPressed(WiiJoystick::Button_Minus)) {

      // ڕWxB[ɂ͂ȂȂ
      if ((down_pressed == false) && (velocity_km > 1)) {
	--velocity_km;
	updateLed(velocity_km, joystick);
      }
      down_pressed = true;

    } else {
      down_pressed = false;
    }

    // i
    bool straight_pressed =
      joystick.isButtonPressed(WiiJoystick::Button_B) ||
      joystick.isButtonPressed(WiiJoystick::Button_A);

    if (straight_pressed) {
      robot->setVelocity(velocity_km);

    } else {
      // ꂽ~Ƃ
      robot->stop();
    }

    // ]
    int handle = (straight_pressed > 0) ? joystick.getAxisValue(0) : 0;
    fprintf(stderr, "handle_value: %d\n", handle);

    fprintf(stderr, "%d, %d\n", straight_pressed, handle);

    if (handle < -30000) {
      ++steer_offset;
      // 
      robot->setSteer(+20);

    } else if (handle > 30000) {
      --steer_offset;
      // E
      robot->setSteer(-20);

    } else {
      // i֑J
      robot->setSteer(0);
    }
    robot->setSteerOffset(steer_offset);

    fprintf(stderr, "steer offset: %d [deg]\n", steer_offset);

    delay(DelayMsec);
    usleep(1);
  }
  return steer_offset;
}


int main(int argc, char *argv[]) {

  // !!! RgقȂB{́ANɂ͉ĂȂ΂ȂȂ
  printf("Put Wiimote in discoverable mode (press 1+2) and press RETURN\n");

  WiiJoystick joystick;
  if (! joystick.connect()) {
    printf("WiiJoystick::connect: %s\n", joystick.what());
    exit(1);
  }

  RobotCtrlInterface* robot;
  robot = new RobotCtrl;
  if (! robot->connect()) {
    printf("RobotCtrlInterface::connect: %s\n", robot->what());
    exit(1);
  }

  // steer_offet ̓ǂݏo
  fprintf(stderr, "load steer offset.\n");
  int offset = 0;
  loadSteerOffset(&offset);
  robot->setSteerOffset(offset);
  fprintf(stderr, "offset is %d\n", offset);

  int steer_offset = adjustOffset(robot, joystick, offset);
  fprintf(stderr, "offset is %d\n", steer_offset);

  // steer_offset ̏
  saveSteerOffset(steer_offset);
  fprintf(stderr, "save steer offset.\n");

  // I
  delete robot;
  return 0;
}
