#ifndef STEER_CTRL_H
#define STEER_CTRL_H

/*!
  \file
  \brief ǐ

  \author Satofumi KAMIMURA

  $Id$
*/

#include <memory>

class Angle;


class SteerCtrl {
  SteerCtrl(void);
  SteerCtrl(const SteerCtrl& rhs);
  SteerCtrl& operator = (const SteerCtrl& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  SteerCtrl(const char* table_file);
  ~SteerCtrl(void);
  const char* what(void);

  bool connect(const char* device);
  void setSteer(Angle angle);
  void setSteerOffset(Angle angle);
  int getSteerOffset(void);
  int getSteer(void);
};

#endif /* !STEER_CTRL_H */
