/*
  Ǐ]̌vZ

  Satofumi KAMIMURA
*/

#include "FollowLineCalc.h"
#include "GridTypes.h"
#include "RobotCtrlInterface.h"
#include "MathUtils.h"

#include <stdio.h>


int followLineCalc(RobotCtrlInterface* obj,
		   const CoordinateCtrl* crd,
		   const Position<int>& target, double omega,
		   double velocity_mm) {

  // !!! Simulation Ƌʂ̃\[Xɂׂ
  //double sokudo = 1.0;

  Position<int> robot = obj->getPosition(crd);
  if (target.angle.to_deg() - robot.angle.to_deg() > 180) {
    robot.angle = deg(robot.angle.to_deg() + 360.0);
  }
  if (target.angle.to_deg() - robot.angle.to_deg() < -180) {
    robot.angle = deg(robot.angle.to_deg() - 360);
  }

  int diff_x = robot.x - target.x;
  int diff_y = robot.y - target.y;
  double dist = sqrt((diff_x * diff_x) + (diff_y * diff_y));
  double fai = 0.0;
  double radian = target.angle.to_rad();
  //double kw=30.0, kt=10.0, ke=0.2;
  //double kw=45.0, kt=1.5, ke=0.02;
  //double kw=120.0, kt=2.0, ke=0.015;//11/12 ii kanji
  //double kw=150.0, kt=2.0, ke=0.015;//motto ii ka ji
  double kw=170.0, kt=2.1, ke=0.02;
  if (dist != 0) {
    fai = acos((cos(radian)*diff_x + sin(radian)*diff_y) / dist);
  }

  double eta = dist * sin(fai);
  if(eta < 0.0001) {
    eta = 0.0;
  }
  if(eta > (90/ke)) {
    eta = (90/ke);
  }
  if ((cos(radian)*diff_y - sin(radian)*diff_x) < 0.0) {
    eta = -eta;
  }

  double mukiError = robot.angle.to_deg() - target.angle.to_deg();
  fprintf(stderr, "omega: %f, mukiError: %f, eta: %f\n",
	  omega, mukiError, eta);
  //getchar();
  double target_diff_degree =
    - (omega*kw + velocity_mm/WheelBase*mukiError*kt + eta*ke );

  return static_cast<int>(target_diff_degree);
}


extern int getLengthToLineCalc(RobotCtrlInterface* obj,
			       const CoordinateCtrl* crd,
			       const Position<int>& line) {

  Position<int> position = obj->getPosition(crd);
  int diff_x = position.x - line.x;
  int diff_y = position.y - line.y;
  double radian = line.angle.to_rad();

  return (int)(diff_x * cos(radian) + diff_y * sin(radian));
}
