//二つのurgデータファイルから、初期値を与えて対応点を求めるプログラム
// ./suitei 37145.590982 19042.767989 184.309488 	0100の時のぱらむ
// ./suitei 21280.756242 18330.556409 184.704586	0150

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <unistd.h>
#include <time.h>

#define L_MAX 200//収束しない場合でも何回までループ回すか
#define FILENUM 254
#define FLAGON	1
#define FLAGOFF	0
#define OVER	1
#define NOOVER	0

int fastflag = FLAGON;
int over = NOOVER;
int k;

int main(int argv,char *argc[])
{
	FILE *fpmap,*fpscan,*fpconv;
	clock_t start,end;
	
	double x,y,th;
	double kx,ky,kth;
	double dExt,dEyt,dEth;
	double E;
	double d,dmin,dist;
	double mapx[15000],mapy[15000];
	double scanx[2000],scany[2000];
	double convx[2000],convy[2000];
	double map_taiou_x[2000],map_taiou_y[2000];
	char s[256];
	double R00,R01,R10,R11;
	int i,j;
	int mappoint_num,scan_num,point_num;
	int Loop_count;
	
	start = clock();
	
	kx=0.001;
	ky=0.001;
	kth=0.000000001;
	
	x = 0;
	y = 0;
	th = 0;
	
	if((fpmap = fopen("aroundmap.map","r")) == NULL)
	{
//		printf("I could not open aroundmap.map\n");
	}
	i = 0;
	while(fgets(s,255,fpmap) != NULL)
	{
		sscanf(s,"%lf %lf",&mapx[i],&mapy[i]);
		if( fabs(mapx[i]) > 7000 || fabs(mapy[i]) > 7000)
		{
			continue;       
		}
		for(j=0;j<i;j++)
		{
			if( ((mapx[i]-mapx[j])*(mapx[i]-mapx[j]) + (mapy[i]-mapy[j])*(mapy[i]-mapy[j])) < 2500 )
			{
				over = OVER;
				break;
			}	
		}
		if(over == NOOVER)
		{
			i++;
		}
		over = NOOVER;
	}
	mappoint_num = i;
	fclose(fpmap);
////////////////////////////////////////////////////
if((fpmap = fopen("map.dat","w")) == NULL)
{
//	printf("I could not open taiouten.dat\n");
	return -1;
}
for(k = 0; k < mappoint_num ; k++)
{
	fprintf(fpmap,"%lf %lf\n",mapx[k],mapy[k]);
	fprintf(fpmap,"\n");
}
fclose(fpmap);
/////////////////////////////////////////////////////
fastflag = FLAGOFF;
	
	i = 0;
	if((fpscan = fopen("scandat.dat","r")) == NULL)
	{
//		printf("I could not open scandat.dat");
	}
	while(fgets(s,255,fpscan) != NULL)
	{
		sscanf(s,"%*s %lf %lf",&scanx[i],&scany[i]);
		if( (fabs(scanx[i]) < 1000 && fabs(scany[i]) < 1000) || fabs(scanx[i]) > 5000 || fabs(scany[i]) > 5000)
		{
//			printf("scanx[%d] = %lf scany[%d] = %lf\n",i,scanx[i],i,scany[i]);
//printf("scan dat is nogood\n");
			continue;       
		}
		for(j=0;j<i;j++)
		{
			if( ((scanx[i]-scanx[j])*(scanx[i]-scanx[j]) + (scany[i]-scany[j])*(scany[i]-scany[j])) < 4900 )
			{
				over = OVER;
				break;
			}	
		}
		if(over == NOOVER)
		{
			i++;
		}
		over = NOOVER;
	}
	scan_num = i;
	fclose(fpscan);
////////////////////////////////////////////////////
if((fpmap = fopen("scan.dat","w")) == NULL)
{
//	printf("I could not open scan.dat\n");
	return -1;
}
for(k = 0; k < scan_num ; k++)
{
	fprintf(fpmap,"%lf %lf\n",scanx[k],scany[k]);
	fprintf(fpmap,"\n");
}
fclose(fpmap);
/////////////////////////////////////////////////////
//	printf("mappoint_num = %d scan_num = %d\n",mappoint_num,scan_num);
	
	for(Loop_count=0;Loop_count<=L_MAX;Loop_count++)	//規定回数最急降下法により近づける
	{
//		printf("Loop_count = %d\n",Loop_count);
		R00=cos(th);
		R01=sin(th);
		R10=-sin(th);
		R11=cos(th);

		point_num=0;		//最急降下法に用いる数初期化 スキャンデータ何点に付いてマッチングを行ったか
		dExt=dEyt=dEth=0.0;	//偏微分値を初期化
		E=0.0;			//評価関数を初期化
printf("\n");
if((fpconv = fopen("conv2.dat","w")) == NULL)
{
	return -1;
}
		//対応点探索と表示のループ
		for(j=0;j<=scan_num;j++)	//j番めのスキャン点をオドメトリデータをつかってマップの座標系に落とす
		{
//printf("scan dat is good\n");
			convx[j]=(int)(R00*(scanx[j])+R10*(scany[j])+x);
			convy[j]=(int)(R01*(scanx[j])+R11*(scany[j])+y);
fprintf(fpconv,"%lf %lf\n",convx[j],convy[j]);
			dmin=100000000.0;

			for(i=0;i<=mappoint_num;i++)	//i番目のマップ点と比較し一番距離の短いところを探す
			{
				d=(mapx[i]-convx[j])*(mapx[i]-convx[j])+(mapy[i]-convy[j])*(mapy[i]-convy[j]);
//printf("mapx[i] = %d d = %d\n",mapx[i],d);
				if(d<=dmin)
				{
					dmin=d;
					map_taiou_x[j]=mapx[i];
					map_taiou_y[j]=mapy[i];
				}      
			}

//			if(dmin>490000.0)	//70cm以上離れてたら最急降下法にもちいない
//			{
//				continue;
//			}

//			if(Loop_count>100)
//			{
	kx=0.003;
	ky=0.003;
	kth=0.000000001;
/*				if(dmin>1000000.0)
				{//100cm以上離れてたら最急降下法に用いない
					continue;
				}
/*				if(Loop_count>600)
				{
/*	kx=0.001;
	ky=0.001;
	kth=0.000000001;
					if(dmin>400.0)
					{//2cm以上離れてたら最急降下法に用いない
						continue;
	  				}
				}
			}
*/
			point_num++;
			dist=(map_taiou_x[j] - convx[j])*(map_taiou_x[j] - convx[j])	//距離を・・・dminじゃないの？
			    +(map_taiou_y[j] - convy[j])*(map_taiou_y[j] - convy[j]);
//printf("map_taiou_x[j] = %d map_taiou_y[j] = %d \n",map_taiou_x[j],map_taiou_y[j]);
//printf("convx[j] = %d convy[j] = %d\n",convx[j],convy[j]);	    
//printf("dist = %lf\n",dist);
			E=E+dist;

			dExt += (-2.0*(map_taiou_x[j] - convx[j]));	//xに関して偏微分するとこ〜なる
			dEyt += (-2.0*(map_taiou_y[j] - convy[j]));
			dEth =dEth 
			+ 2.0*( scanx[j]*R01 + scany[j]*R00)
			*(map_taiou_x[j] - scanx[j]*R00 +scany[j]*R01-x) 
			+ 2.0*(-scanx[j]*cos(th) + scany[j]*sin(th))
			*(map_taiou_y[j] - scanx[j]*R01 -scany[j]*R00-y) ;

//				fprintf(fp_scan_mv,"%d %d\n",convx[j],convy[j]);
			if(Loop_count==999)
			{
//				printf("%d %d %d\n",j,convx[j],convy[j]);
			}
//				fprintf(fp_gnu,"%d %d\n",convx[j],convy[j]);
//				fprintf(fp_gnu,"%d %d\n\n\n",map_taiou_x[j],map_taiou_y[j]);      

		}


		//変数の更新
		x += (-kx*dExt);
		y += (-ky*dEyt);
		th -= kth*dEth;
//		printf("x = %lf y = %lf th = %lf\n",x,y,th);
		
/*		if(E/point_num<1600)	//収束条件4cm以内
		{
			fprintf(stderr,"		shuusoku simasita!!\n");
			fprintf(stderr,"count = %d point_num = %d\n",Loop_count,point_num);
//			printf("x = %lf y = %lf th = %lf°\n",x,y,th*180/3.1415);
//			printf("point_num = %d\n",point_num);
			break;
		}
*/	fclose(fpconv);
	}
	end = clock();
	fprintf(stderr,"E/point_num　=　%f\n",E/point_num);
	fprintf(stderr,"マッチング時間は　=　%f\n",(double)(end-start)/CLOCKS_PER_SEC);
}


