/*
	マップデータからオドメトリ状態にあるときの周辺マップを作成するプログラム
	in　x,y,θ
	入力ファイル clearmap.map
	出力ファイル arounbdmap.map
*/
#include <stdio.h>
#include <math.h>

#define DISTANCE 49000000
#define PI 3.141592

int main(int argv,char **argc)
{
	FILE *fpin,*fpout;
	double x,y;
	double mapx,mapy;
	double th;
	double sinth,sinmth,cosmth;
	char s[32];
	
	x = atoi(argc[1]);
	y = atoi(argc[2]);
	th = atoi(argc[3]);
	printf("x = %lf y = %lf th = %lf \n",x,y,th);
	
	sinth = sin(th*PI/180);
	sinmth = sin(-th*PI/180);
	cosmth = cos(-th*PI/180);
	
	fpin = fopen("clearmap.map","r");
	if(fpin == NULL)
	{
		fprintf(stderr,"I could not open allmap.map\n");
		return -1;
	}
	
	fpout = fopen("aroundmap.map","w");
	if(fpout == NULL)
	{
		fprintf(stderr,"I could not opne aroundmap.map\n");
		return -1;
	}
	
	while(fgets(s,31,fpin) != NULL)
	{
		sscanf(s,"%*s %lf %lf",&mapx,&mapy);
		if( ((mapx - x)*(mapx - x) + (mapy - y)*(mapy - y)) < DISTANCE )
		{
			fprintf(fpout,"%lf %lf\n",(mapx - x)*cosmth + (mapy -y)*sinth,(mapx - x)*sinmth + (mapy-y)*cosmth);
		}
	}
	
	fclose(fpin);
	fclose(fpout);
	return 0;
}
