//二つのurgデータファイルから、初期値を与えて対応点を求めるプログラム
// ./suitei 37145.590982 19042.767989 184.309488 	0100の時のぱらむ
// ./suitei 21280.756242 18330.556409 184.704586	0150

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#define L_MAX 100//収束しない場合でも何回までループ回すか
#define MAP_DIST 2500	//マップは使う点から半径５cm以内のものは使わない（まびき
#define SCAN_DIST 4900	//スキャンは同上７cm
#define OVER	1	//データ点の重複フラグ
#define NOOVER	0


int main(void)
{
	FILE *fpmap,*fpscan;	
	int over = NOOVER;
	double x,y,th;
	double kx,ky,kth;
	double dExt,dEyt,dEth;
	double E;
	double d,dmin,dist;
	double mapx[15000],mapy[15000];
	double scanx[2000],scany[2000];
	double convx[2000],convy[2000];
	double map_taiou_x[2000],map_taiou_y[2000];
	char s[256];
	double R00,R01,R10,R11;
	int i,j;
	int mappoint_num,scan_num,point_num;
	int Loop_count;

	kx=0.003;
	ky=0.003;
	kth=0.000000001;
	
	x = 0;
	y = 0;
	th = 0;
	
	if((fpmap = fopen("aroundmap.map","r")) == NULL)
	{
		fprintf(stderr,"I could not open aroundmap.map\n");
	}
	i = 0;
	while(fgets(s,255,fpmap) != NULL)
	{
		sscanf(s,"%lf %lf",&mapx[i],&mapy[i]);
		for(j=0;j<i;j++)
		{
			if( ((mapx[i]-mapx[j])*(mapx[i]-mapx[j]) + (mapy[i]-mapy[j])*(mapy[i]-mapy[j])) < MAP_DIST )
			{
				over = OVER;
				break;
			}	
		}
		if(over == NOOVER)
		{
			i++;
		}
		over = NOOVER;
	}
	mappoint_num = i;
	fclose(fpmap);
	
	i = 0;
	if((fpscan = fopen("scandat.dat","r")) == NULL)
	{
		fprintf(stderr,"I could not open scandat.dat");
	}
	while(fgets(s,255,fpscan) != NULL)
	{
		sscanf(s,"%*s %lf %lf",&scanx[i],&scany[i]);
		if( (fabs(scanx[i]) < 1000 && fabs(scany[i]) < 1000) || fabs(scanx[i]) > 5000 || fabs(scany[i]) > 5000)
		{
			continue;       
		}
		for(j=0;j<i;j++)
		{
			if( ((scanx[i]-scanx[j])*(scanx[i]-scanx[j]) + (scany[i]-scany[j])*(scany[i]-scany[j])) < SCAN_DIST )
			{
				over = OVER;
				break;
			}	
		}
		if(over == NOOVER)
		{
			i++;
		}
		over = NOOVER;
	}
	scan_num = i;
	fclose(fpscan);
	for(Loop_count=0;Loop_count<=L_MAX;Loop_count++)	//規定回数最急降下法により近づける
	{
		R00=cos(th);
		R01=sin(th);
		R10=-sin(th);
		R11=cos(th);

		point_num=0;		//最急降下法に用いる数初期化 スキャンデータ何点に付いてマッチングを行ったか
		dExt=dEyt=dEth=0.0;	//偏微分値を初期化
		E=0.0;			//評価関数を初期化
		//対応点探索と表示のループ
		for(j=0;j<=scan_num;j++)	//j番めのスキャン点をオドメトリデータをつかってマップの座標系に落とす
		{
			convx[j]=(int)(R00*(scanx[j])+R10*(scany[j])+x);
			convy[j]=(int)(R01*(scanx[j])+R11*(scany[j])+y);
			dmin=100000000.0;

			for(i=0;i<=mappoint_num;i++)	//i番目のマップ点と比較し一番距離の短いところを探す
			{
				d=(mapx[i]-convx[j])*(mapx[i]-convx[j])+(mapy[i]-convy[j])*(mapy[i]-convy[j]);
				if(d<=dmin)
				{
					dmin=d;
					map_taiou_x[j]=mapx[i];
					map_taiou_y[j]=mapy[i];
				}      
			}
			point_num++;
			dist=(map_taiou_x[j] - convx[j])*(map_taiou_x[j] - convx[j])	//距離を・・・dminじゃないの？
			    +(map_taiou_y[j] - convy[j])*(map_taiou_y[j] - convy[j]);
			E=E+dist;

			dExt += (-2.0*(map_taiou_x[j] - convx[j]));	//xに関して偏微分するとこ〜なる
			dEyt += (-2.0*(map_taiou_y[j] - convy[j]));
			dEth =dEth 
			+ 2.0*( scanx[j]*R01 + scany[j]*R00)
			*(map_taiou_x[j] - scanx[j]*R00 +scany[j]*R01-x) 
			+ 2.0*(-scanx[j]*cos(th) + scany[j]*sin(th))
			*(map_taiou_y[j] - scanx[j]*R01 -scany[j]*R00-y) ;

		}


		//変数の更新
		x += (-kx*dExt);
		y += (-ky*dEyt);
		th -= kth*dEth;
	}
	return 0;
}


