/*
	マップデータからオドメトリ状態にあるときの周辺マップを作成するプログラム
	in　x,y,θ
	入力ファイル allmap.map
	出力ファイル arounbdmap.map
*/
#include <stdio.h>
#include <math.h>
#include <time.h>

#define DISTANCE 49000000
#define PI 3.141592

int main(int argv,char **argc)
{
	FILE *fpin,*fpout;
	double x,y;
	double mapx,mapy;
	double delx,dely;
	double th;
	double sinth,sinmth,cosmth;
	char s[32];
	clock_t start,end;
	
	start = clock();
	
	x = atoi(argc[1]);
	y = atoi(argc[2]);
	th = atoi(argc[3]);
	
	sinth = sin(th*PI/180);
	sinmth = sin(-th*PI/180);
	cosmth = cos(-th*PI/180);
	
	fpin = fopen("allmap.map","r");
	if(fpin == NULL)
	{
		printf("I could not open allmap.map\n");
		return -1;
	}
	
	fpout = fopen("aroundmap.map","w");
	if(fpout == NULL)
	{
		printf("I could not opne aroundmap.map\n");
		return -1;
	}
	
	while(fgets(s,31,fpin) != NULL)
	{
		sscanf(s,"%*s %lf %lf",&mapx,&mapy);
		if( (pow(mapx - x,2) + pow(mapy - y,2)) < DISTANCE )
		{
			fprintf(fpout,"%lf %lf\n",(mapx - x)*cosmth + (mapy - y)*sinth,(mapx - x)*sinmth + (mapy - y)*cosmth);
		}
	}
	
	fclose(fpin);
	fclose(fpout);
	end = clock();
	fprintf(stderr,"マッチング時間は　=　%f\n",(double)(end-start)/CLOCKS_PER_SEC);
	return 0;
}
