/*
	マップを作るプログラム10/8
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <unistd.h>

#define L_MAX 1000//収束しない場合でも何回までループ回すか
#define FILENUM 254


FILE *fp_map,*fp_scan;//参照データ、入力データ用ファイル
FILE *fp_gnu,*gnu,*fp_scan_mv;//gnuplot用

int im=0,is=0,i=0,j=0,m_num=0,s_num=0,p_num =0;
long Loop_count;
char filename[64];

int map_x[2000],map_y[2000];//参照データ
int scan_nama_x[2000],scan_nama_y[2000];//生の入力データ
int scan_x[2000],scan_y[2000];//入力データを変換したもの
int map_taiou_x[2000],map_taiou_y[2000];//参照データの対応点記録用
int taiou_hantei[2000];

double E,dist;//E:評価関数（距離の２乗和） dist:距離の２乗
double d,dmin;//対応点探索用の距離の２乗
double x_odo,y_odo,th_odo;//オドメトリの数値（初期値）
int xt,yt;//オドメトリの誤差
double th;
int dExt,dEyt;//評価関数の偏微分
double dEth;
double kx,ky,kth;//最急降下法用の係数
double R00,R01,R10,R11;//回転行列

int startflag = 0;	//1行読み飛ばしよう

int dlength;
double dth;

	
int main(int argc, char **argv)
{
	FILE *fp,*fp2,*fp3,*fp_mapdat;
	FILE *log;
	int x,y;
	double odox[256],odoy[256],odoth[256];
	int odoxi[256],odoyi[256],odothi[256];
	int dodox[256],dodoy[256];
	double dodoth[256];
	char s[128];
	int filenum;
	
	if((log = fopen("log.txt","w")) == NULL)	//収束の成否を記録するファイル
	{
		printf("can not open log.txt \n");
		exit(1);
	}
	
	if((fp3 = fopen("odometori.dat","r")) == NULL)	//プラットフォームのオドメトリが入ってるファイル
	{
		printf("can not open scandat_conv_to_makemap.txt \n");
	}
	i = 0;
	while(fgets(s, 256, fp3) != NULL)
	{
		sscanf(s,"%lf %lf %lf \n",&odox[i],&odoy[i],&odoth[i]);
		odoxi[i] = (int)odox[i];
		odoyi[i] = (int)odoy[i];
		odothi[i] = (int)(odoth[i]*10);
//		printf("%lf %lf %lf\n",odox[i],odoy[i],odoth[i]);
		i++;
	}
	fclose(fp3);
	i = 0;
	
	if((fp_mapdat = fopen("mapdat.dat","w"))==NULL)	//修整後のオドメトリの入るファイル
	{
		printf("I could not open mapdat.dat\n");
		exit(1);
	}

	for(filenum = 1 ; filenum <= FILENUM ; filenum++)
	{
	
/*		if((gnu=popen("gnuplot","w"))==NULL)	//gnuplotプロセスオープン
		{
			printf("I could not open gnuplot\n");
			exit(1);
		}
		fprintf(gnu,"set xrange[-5000:10000]\n");	//レンジの設定
		fprintf(gnu,"set yrange[-5000:5000]\n");
		if((fp_gnu=fopen("taioutenn.dat","w"))==NULL)
		{
			printf("I could not open taioutenn.dat");
		}
		if((fp_scan_mv=fopen("scan_mv.dat","w"))==NULL)
		{
			printf("I could not open scan_mv.dat");
		}   
//printf("gnu opend\n");
//printf("gnu setuped\n");
*/
		m_num = s_num = 0;	//mapデータscanデータのカウントの初期化
		
		sprintf(filename,"0%d",filenum-1);	//map用データファイル名生成
		if((fp_map=fopen(filename,"r")) == NULL)	//map用データファイル開く
		{
			printf("I could not open %s\n",filename);
			exit(1);
		}
		startflag =0;
		while(fgets(s,256,fp_map)!=NULL)	//mapデータの取得
		{
//			printf("%s",s);
			if(startflag != 0)	//1行目はオドメトリデータが格納されているため読み飛ばし
			{
				sscanf(s,"%d %d %d",&im,&map_x[im],&map_y[im]);
				m_num++;
			}
			startflag ++;
		}
		fclose(fp_map);
//printf("マップデータロード\n");

		sprintf(filename,"0%d",filenum);	//scanデータファイル名生成
		if((fp_scan=fopen(filename,"r"))==NULL)	//scan用データファイル開く
		{
			printf("I could not open %s\n",filename);
			exit(1);
		}
		startflag = 0;
		while(fgets(s,256,fp_scan)!=NULL)	//scanデータの取得
		{
			if(startflag != 0)
			{
				sscanf(s,"%d %d %d",&is,&scan_nama_x[is],&scan_nama_y[is]);
				s_num++;
			}
			startflag ++;
		}
		fclose(fp_scan);
//printf("スキャンデータロード\n");

//printf("date inputted\n");
		//初期設定
		//オドメトリの値入力
		/*
		printf("\n x no odometory=");
		scanf("%lf",&x_odo);
		printf("\n y no odometory=");
		scanf("%lf",&y_odo);
		printf("\n theta no odometory=");  
		scanf("%lf",&th_odo);
		*/
//printf("odox[%d] = %d odoy[%d] = %d odoth[%d] = %.1lf\n",filenum,odoxi[filenum],filenum,odoyi[filenum],filenum,(double)odothi[filenum]/10.0);
		dlength=(int)sqrt((double)( (odoxi[filenum]-odoxi[filenum-1])*(odoxi[filenum]-odoxi[filenum-1])
		                       +(odoyi[filenum]-odoyi[filenum-1])*(odoyi[filenum]-odoyi[filenum-1]) ));
		if(dlength!=0)	//前回位置から移動があれば
		{	//dthはラジアン
			dth = atan( (double)(odoyi[filenum]-odoyi[filenum-1])
			           /(double)(odoxi[filenum]-odoxi[filenum-1])) -((double)odothi[filenum-1]/10.0)*3.14/180.0;
		}
		else
		{
			dth = 0;
		}
		//変数の初期値設定
		xt=(int)(dlength * cos(dth));
		yt=(int)(dlength * sin(dth));
		th=(double)(odothi[filenum] - odothi[filenum-1])/10.0*3.14/180.0;
		
//printf("dlength = %d dth = %lf\n",dlength,dth);
//printf("init xt = %d yt = %d th = %lf\n",xt,yt,th);
//printf("odometori inputted\n");
		/*
		//最急降下法の更新式の係数を入力
		printf("\n");
		printf("\n x no keisuu=");
		scanf("%lf",&kx);
		printf("\n y no keisuu=");
		scanf("%lf",&ky);
		printf("\n theta no keisuu=");  
		scanf("%lf",&kth);
		*/  
		kx=0.001;
		ky=0.001;
		kth=0.000000001;

		for(Loop_count=0;Loop_count<=L_MAX;Loop_count++)	//規定回数最急降下法により近づける
		{
//printf("%d\n",Loop_count);

			//回転行列
			R00=cos(th);
			R01=sin(th);
			R10=-sin(th);
			R11=cos(th);

			p_num=0;		//最急降下法に用いる数初期化
			dExt=dEyt=dEth=0.0;	//偏微分値を初期化
			E=0.0;			//評価関数を初期化
//			rewind(fp_gnu);		//よくわかりません(ファイルfpのファイル位置指示子を先頭(0)に戻し、エラー指示子と終端指示子をクリアします
//			rewind(fp_scan_mv);
			//対応点探索と表示のループ
			for(j=0;j<=s_num;j++)	//j番めのスキャン点をオドメトリデータをつかってマップの座標系に落とす
			{

				if( (fabs(scan_nama_x[j]) < 1500 && fabs(scan_nama_y[j]) < 1500) || fabs(scan_nama_x[j]) > 5000 || fabs(scan_nama_y[j]) > 5000)
				{
//printf("scan dat is nogood\n");
					continue;       
				}
//printf("scan dat is good\n");
				scan_x[j]=(int)(R00*(scan_nama_x[j])+R10*(scan_nama_y[j])+xt);
				scan_y[j]=(int)(R01*(scan_nama_x[j])+R11*(scan_nama_y[j])+yt);
//printf("scan_nama_x[j] = %d scan_x[j] = %d\n",scan_nama_x[j],scan_x[j]);
				dmin=100000000.0;

				for(i=0;i<=m_num;i++)	//i番目のマップ点と比較し一番距離の短いところを探す
				{
					
					if( (fabs(map_x[i]) < 1000 && fabs(map_y[i]) < 1000) || fabs(map_x[i]) > 5000 || fabs(map_y[i]) > 5000  )
					{
//						printf("map dat is nogood\n");
						continue;
					}
					d=(map_x[i]-scan_x[j])*(map_x[i]-scan_x[j])+(map_y[i]-scan_y[j])*(map_y[i]-scan_y[j]);
//printf("map_x[i] = %d d = %d\n",map_x[i],d);
					if(d<=dmin)
					{
						dmin=d;
						map_taiou_x[j]=map_x[i];
						map_taiou_y[j]=map_y[i];
					}      
				}

				if(dmin>90000.0)	//30cm以上離れてたら最急降下法にもちいない
				{
					continue;
				}

				if(Loop_count>100)
				{
					if(dmin>40000.0)
					{//20cm以上離れてたら最急降下法に用いない
						continue;
					}
					if(Loop_count>400)
					{
						if(dmin>400.0)
						{//2cm以上離れてたら最急降下法に用いない
							continue;
		  				}
					}
				}

				p_num++;
				dist=(map_taiou_x[j] - scan_x[j])*(map_taiou_x[j] - scan_x[j])	//距離を・・・dminじゃないの？
				    +(map_taiou_y[j] - scan_y[j])*(map_taiou_y[j] - scan_y[j]);
//printf("map_taiou_x[j] = %d map_taiou_y[j] = %d \n",map_taiou_x[j],map_taiou_y[j]);
//printf("scan_x[j] = %d scan_y[j] = %d\n",scan_x[j],scan_y[j]);	    
//printf("dist = %lf\n",dist);
				E=E+dist;

				dExt =dExt + (-2.0*(map_taiou_x[j] - scan_x[j]));	//xに関して偏微分するとこ〜なる
				dEyt =dEyt + (-2.0*(map_taiou_y[j] - scan_y[j]));
				dEth =dEth 
				+ 2.0*( scan_nama_x[j]*R01 + scan_nama_y[j]*R00)
				*(map_taiou_x[j] - scan_nama_x[j]*R00 +scan_nama_y[j]*R01-xt) 
				+ 2.0*(-scan_nama_x[j]*cos(th) + scan_nama_y[j]*sin(th))
				*(map_taiou_y[j] - scan_nama_x[j]*R01 -scan_nama_y[j]*R00-yt) ;

//				fprintf(fp_scan_mv,"%d %d\n",scan_x[j],scan_y[j]);
				if(Loop_count==999)
				{
					fprintf(log,"%d miss\n",filenum);	//log.txtに成否を記録
					printf("%d %d %d\n",j,scan_x[j],scan_y[j]);
				}
//				fprintf(fp_gnu,"%d %d\n",scan_x[j],scan_y[j]);
//				fprintf(fp_gnu,"%d %d\n\n\n",map_taiou_x[j],map_taiou_y[j]);      

			}


			//変数の更新
			xt=xt +(int)(-kx*dExt);
			yt=yt +(int)(-ky*dEyt);
			th=th -kth*dEth;
//			printf("count = %d xt = %d yt = %d th =%lf\n",Loop_count,xt,yt,th);
//			printf("E = %lf p_num = %d E/pnum = %lf\n",E,p_num,E/p_num);

			//printf("%lf %d %ld\n",E/p_num,p_num,Loop_count);
//			fprintf(gnu,"plot 'taioutenn.dat' w line, '0%d' u 2:3,'scan_mv.dat' \n",filenum-1);
//			fflush(gnu);
//sleep(1);
			if(E/p_num<169)	//収束条件13mm以内
			{
				printf("		shuusoku simasita!!\n");
				printf("filenum = %d xt = %d yt = %d th = %lf°\n",filenum,xt,yt,th*180/3.1415);
				fprintf(log,"%d syuusoku\n",filenum);	//log.txtに成否を記録
				break;
			}  
			/*
			if(Loop_count>300)
			{  
				printf("shuusoku simasenndesita...orz\n");
				break;
			}
			*/
		}
printf("check\n");
//		fclose(fp_gnu);
//		fclose(fp_scan_mv);
//		pclose(gnu);
//		}
//printf("いろいろくろーず\n");
		if(filenum == 1)	//修正オドメトリの保存
		{
			dodox[filenum] = xt;
			dodoy[filenum] = yt;
			dodoth[filenum] = th*180/3.14;
		}
		else
		{
			dodoth[filenum] = dodoth[filenum - 1] + th * 180/3.14;
			dodox[filenum] = (int)(xt*cos(dodoth[filenum - 1]*3.1415/180.0) - yt*sin(dodoth[filenum - 1]*3.1415/180.0) + dodox[filenum -1]);
			dodoy[filenum] = (int)(xt*sin(dodoth[filenum -1]*3.1415/180.0) + yt*cos(dodoth[filenum - 1]*3.1415/180.0) + dodoy[filenum -1]);
		}
		fprintf(fp_mapdat,"%d %d %d %lf\n",filenum,dodox[filenum-1],dodoy[filenum-1],dodoth[filenum-1]);
//printf("%d %d %d %lf\n",filenum,dodox[filenum-1],dodoy[filenum-1],dodoth[filenum-1]);
	}
	
	dodoth[0] = 0.0;
	dodox[0] = 0;
	dodoy[0] = 0;
fclose(fp_mapdat);
fclose(log);
	//ここからグローバルマップへの落し込

	if((fp2 = fopen("noizymap.map","w")) == NULL)	//最終出力ファイル
	{
		printf("can not downGroval_saikyuu_tom_makemap.dat \n");
	}
	for(i = 0; i <= FILENUM; i++)
	{		
		sprintf(filename,"d0%d",i);	//1回分の出力ファイル名作成
		if((fp3 = fopen(filename,"w")) == NULL)	//1回分の出力ファイル
		{
			printf("can not downGroval_saikyuu_tom_makemap.dat \n");
		}
	
		sprintf(filename,"0%d",i);	//URGデータのファイル名作成
		if((fp = fopen(filename,"r")) == NULL)		//URGデータファイル開く
		{
			printf("can not %s \n",filename);
		}
		
		startflag = 0;
		while(fgets(s, 256, fp) != NULL)	//URGデータを実際に落し込む
		{
			if(startflag != 0)
			{
				sscanf(s,"%*s %d %d",&x,&y);
				if(i == 0)
				{
//					printf("%d %d %d\n",i,(int)(x * cos( dodoth[i] * 3.14 / 180.0) + y * -sin( dodoth[i] * 3.14 / 180.0) + dodox[i]),
//				        	                   (int)(x * sin( dodoth[i] * 3.14 / 180.0) + y * cos( dodoth[i] * 3.14 / 180.0) + dodoy[i]));
				}
				fprintf(fp2,"%d %d %d\n",i,(int)(x * cos( dodoth[i] * 3.14 / 180.0) + y * -sin( dodoth[i] * 3.14 / 180.0) + dodox[i]),
				                           (int)(x * sin( dodoth[i] * 3.14 / 180.0) + y * cos( dodoth[i] * 3.14 / 180.0) + dodoy[i]));
				fprintf(fp3,"%d %d %d\n",i,(int)(x * cos( dodoth[i] * 3.14 / 180.0) + y * -sin( dodoth[i] * 3.14 / 180.0) + dodox[i]),
				                           (int)(x * sin( dodoth[i] * 3.14 / 180.0) + y * cos( dodoth[i] * 3.14 / 180.0) + dodoy[i]));
				//fprintf(fp2,"%d %lf %lf\n",i,x * cos( odoth_delta[i-1] * 3.14 / 180.0) + odox_delta[i] ,y * sin( odoth_delta[i-1] * 3.14 / 180.0) + odoy_delta[i]);
			}
			startflag = 1;
		}
		fclose(fp);
		fclose(fp3);
	}
	
	fclose(fp2);
	return 0; 
	exit(0);
}


