#include <ymbc_usr.h>
#include <stdio.h>
#include "scipBase.h"
#include "scip1.h"
#include "scip2.h"
#include "scipUtil.h"

int main(int argc, char **argv)
{
  tPort *port;
  FILE *output;
  int **scan2;
  int i,j,id;
  int startStep,endStep,stepCluster,scanInterval,scanNum,stepNum;
  double x,y;

  /* $B0z?t$,$"$C$F$$$J$$>l9g$O;H$$J}$rI=<((B */
  if(argc != 3){
    printf("USAGE:\n");
    printf(" %s dev_port_name output_file_name\n",argv[0]);
    printf(" ex) %s /dev/ttyS0 logfile.dat\n",argv[0]);
    exit(EXIT_SUCCESS);
  }

  /* URG $B%;%s%5$H@\B3(B */
  port=scipConnect(argv[1]);
  if(port==NULL){
    perror("Could not connect to the sensor ");
    exit(EXIT_FAILURE);
  }

  /* SCIP2.0 $B%b!<%I$K0\9T(B */
  switchToScip2(port);

  /* $B=PNO%U%!%$%k$r3+$/(B */
  output=fopen(argv[2],"w");
  if(output==NULL){
    perror("Could not open output file");
    exit(EXIT_FAILURE);
  }

  /* $B%G!<%?<hF@%3%^%s%I!J(BMD/MS$B%3%^%s%I!K$r(B5$B2sH/9T(B */
  for(;;){
    printf("Trying #%d\n",i);

    /* $B%9%-%c%s%Q%i%a!<%?$r@_Dj(B */
    /* $B%9%F%C%W(B 44-725 $B$NA4%9%F%C%WJ,$N5wN%%G!<%?$r4V0z$-$J$7$K(B2$B2s!J(B2$B%9%-%c%s!K<hF@(B */
    startStep=44;
    endStep=725;
    stepCluster=1;
    scanInterval=0;
    scanNum=1;

    /* $B?75,B,Dj$7$F%9%-%c%s%G!<%?$r<hF@(B[MD/MS$B%3%^%s%I(B] */
    scan2=scip2MeasureScan(port,startStep,endStep,stepCluster,scanInterval,scanNum,ENC_3BYTE,&stepNum);

    if(scan2!=NULL){  /* $B<hF@$K@.8y$7$?$i%U%!%$%k$K5-O?(B */
      for(j=0; j<scanNum; ++j){
        for(id=0; id<stepNum; ++id){
          /* $B%(%i!<%3!<%IH=Dj!":BI8JQ49(B */
          /* $BJ}8~!J%9%F%C%WHV9f!K$HG[NsHV9f$OF15A$G$O$J$$$3$H$KCm0U(B */
          if(scan2[j][id] >= 20 && scan2[j][id] <= 5600){  /* $B@5>o(B */
            x=scan2[j][id] * cos(step2rad(id2step(startStep,stepCluster,id)));
            y=scan2[j][id] * sin(step2rad(id2step(startStep,stepCluster,id)));
          } else  /* $B%(%i!<%3!<%I(B */
            continue;

          /* $BJ}8~!J%9%F%C%WHV9f!K!"5wN%!"(Bx $B:BI8CM!"(By $B:BI8CM$r%U%!%$%k$K5-O?(B */
          fprintf(output,"%d %d %f %f\n",id2step(startStep,stepCluster,id),scan2[j][id],x,y);
        }
        fprintf(output,"\n");
      }
      /* fprintf(output,"\n"); */

      /* malloc $B$7$?%9%-%c%s$N5wN%%G!<%?G[Ns$r(B free */
      scip2FreeScan(scan2,scanNum);
    } else  /* $B<hF@$K<:GT(B */
      fprintf(stderr,"#%d failed\n",i);

  Spur_set_vel_cm(20);
  Spur_set_pos_GL_cm(0,0,0);
  Spur_line_GL_cm(0,0,0);

  //  if(scan2[j][id] < 200){
  //   Spur_set_pos_GL_cm(0,0,0);
  //  Spur_line_GL_cm(0,0,-1);
  //  delay(0.01);
  // }

  // if(scan2[j][583] > 2000){
  //  if(scan2[j][500] < 1000){
  //    Spur_set_pos_GL_cm(0,0,0);
  //    Spur_line_GL_cm(0,0,0);
  //    delay(0.01);
  // }
  // }

  // if(scan2[j][583] > 500){
  //  Spur_set_pos_GL_cm(0,0,0);
  //  Spur_line_GL_cm(0,0,60);
  //  delay(0.01);
  // }

  /* $B;XDj$5$l$?DL?.%O%s%I%k$rJD$8$k(B */
  closePort(port);

  fclose(output);

  return EXIT_SUCCESS;
}
