/*
  ړ{bg̐

  Satofumi KAMIMURA

  $Id$
*/

#include "RobotCtrl.h"
#include "SteerCtrl.h"
#include "SeniorCarCtrl.h"
#include "MathUtils.h"
#include "FollowLineCalc.h"
#include "ThreadCreator.h"
#include "GetTicks.h"
#include "Delay.h"
#include <string>
#include <limits>


struct RobotCtrl::pImpl {
  enum {
    WaitDelay = 100,
    DelayTicks = 500,		// iJnɑǂ̑Ȃ [msec]
  };
  std::string error_message;
  SeniorCarCtrl senior;

  class ThreadArgs {
  public:
    SteerCtrl steer;
    double straight_vel;
    Position<int> robot_position;
    const CoordinateCtrl* target_crd;
    Position<int> target_position;
    RobotCtrlInterface* run;

    ThreadArgs(RobotCtrlInterface* obj)
      : steer("angle_table.txt"),
	straight_vel(0.0), target_crd(NULL), run(obj) {
    }
  };
  ThreadArgs thread_args;
  ThreadCreator thread;
  size_t move_ticks;

  pImpl(RobotCtrlInterface* obj)
    : error_message("no error."), thread_args(obj),
      thread(followLine_thread, &thread_args), move_ticks(0) {
  }

  static int followLine_thread(void *args) {
    ThreadArgs* info = static_cast<ThreadArgs*>(args);

    int steer_degree = info->steer.getSteer();
    //double velocity_mm = info->straight_vel * 1000000 / 3600;
    double velocity_mm = info->run->getVelocity();
    //TMY modify - to +
    double omega = velocity_mm * steer_degree * D2R / WheelBase;
    int target_diff_degree = followLineCalc(info->run, info->target_crd,
					    info->target_position, omega,
					    velocity_mm);
    int target_degree = steer_degree + target_diff_degree;
    info->run->setSteer(target_degree);

    delay(WaitDelay);

    return 0;
  }
};


RobotCtrl::RobotCtrl(void) : pimpl(new pImpl(this)) {
}


RobotCtrl::~RobotCtrl(void) {
}


const char* RobotCtrl::what(void) {
  return pimpl->error_message.c_str();
}


bool RobotCtrl::updateEvent(void) {
  // !!! dummy
  return true;
}


bool RobotCtrl::connect(void) {

  if (! pimpl->senior.connect()) {
    pimpl->error_message = pimpl->senior.what();
    return false;
  }
  if (! pimpl->thread_args.steer.connect("/dev/ttyUSB1")) {
    pimpl->error_message = pimpl->thread_args.steer.what();
    return false;
  }
  return true;
}


void RobotCtrl::startFollowLine(void) {
  pimpl->thread.run();
}


#define R2D (180.0/3.14159265358979323846)

void RobotCtrl::follow_line(const CoordinateCtrl* crd,
			    const Position<int>& position) {

  pimpl->thread_args.target_crd = crd;
  pimpl->thread_args.target_position = position;
}


int RobotCtrl::getLength_toLine(const CoordinateCtrl* crd,
				const Position<int>& line) {

  return getLengthToLineCalc(this, crd, line);
}


void RobotCtrl::setSteerOffset(int offset_degree) {
  pimpl->thread_args.steer.setSteerOffset(deg(offset_degree));
}


void RobotCtrl::setSteer(int degree) {
  size_t now_ticks = GetTicks();
  if (pimpl->move_ticks > (now_ticks - pImpl::DelayTicks)) {
    fprintf(stderr, "return !\n");
    //return;
  }
//  fprintf(stderr, "set steer: %d\n", degree);
  pimpl->thread_args.steer.setSteer(deg(degree));
}


void RobotCtrl::setVelocity(int velocity_km) {
  if (velocity_km > 0) {
    pimpl->move_ticks = GetTicks();
  } else {
    pimpl->move_ticks = std::numeric_limits<size_t>::max();
  }
  pimpl->thread_args.straight_vel = velocity_km;
  pimpl->senior.setVelocity(velocity_km);
}


void RobotCtrl::stop(void) {
  pimpl->senior.setVelocity(0);
}


int RobotCtrl::getVelocity(void) {
  return pimpl->senior.getVelocity();
}


Position<int> RobotCtrl::getPosition(const CoordinateCtrl* crd) {
  int x = 0, y = 0;
  double degree = 0.0;
  pimpl->senior.getPosition(&x, &y, &degree);

  return Position<int>(x, y, deg(degree));
}


CoordinateCtrl* RobotCtrl::getCoordinate(void) {
  // dummy
  return NULL;
}
