/*!
  @file
  @brief  SCIP1  SCIP2 ޥɤưåץץ
  @author aokaze (HARA Yoshitaka) <bluewind@roboken.esys.tsukuba.ac.jp>
  @author YoS (YOSHIDA Tomoaki) <yoshida@furo.org>
  @par    Publisher:
          HOKUYO AUTOMATIC CO.,LTD.
  @since  2006
  @date   2007/03/30
*/

#include "scipBase.h"
#include "scip1.h"
#include "scip2.h"
#include "scipUtil.h"

int main(int argc, char **argv)
{
  tPort *port;
  int *scan;
  int **scan2;
  int startStep,endStep,stepCluster,scanInterval,scanNum,stepNum;

  // äƤʤϻȤɽ
  if(argc!=2){
    printf("USAGE:\n");
    printf(" %s dev_port_name\n",argv[0]);
    printf(" ex) %s /dev/ttyS0\n",argv[0]);
    exit(EXIT_FAILURE);
  }

  // URG 󥵤³
  port=scipConnect(argv[1]);
  if(port==NULL){
    perror("Could not connect to the sensor ");
    exit(EXIT_FAILURE);
  }

  // SCIP1 ưǧ
  if(port->protocol==1){
    // ̿®٤ѹ[Sޥ]
    if(scip1SetComSpeed(port,115200)!=0){
      fprintf(stderr,"Could not change speed\n");
      exit(EXIT_FAILURE);
    }
    // 󥵤ΥСɽ[Vޥ]
    scip1ShowVersion(port);

    // 졼ȯ[Lޥ]ʥ졼
    scip1SwitchLaser(port,0);

    // ΥǡΥѥ᡼
    // ƥå 44-725 εΥǡƥå׼
    startStep=44;
    endStep=725;
    stepCluster=1;

    // ¬Ѥߥǡ[Gޥ]
    // 졼ΤἺԤ
    scan=scip1GetScan(port,startStep,endStep,stepCluster,&stepNum);
    // malloc εΥǡ free
    scip1FreeScan(scan);

    // 졼ȯ[Lޥ]ʥ졼
    scip1SwitchLaser(port,1);

    // ¬Ѥߥǡ[Gޥ]
    // ٤ϥ졼Τ
    scan=scip1GetScan(port,startStep,endStep,stepCluster,&stepNum);
    // malloc εΥǡ free
    scip1FreeScan(scan);

    // SCIP2.0 ⡼ɤ˰ܹ
    switchToScip2(port);
  }

  // SCIP2 ưǧ

  // 󥵥ꥻåȡѥ᡼[RSޥ]
  scip2SensorReset(port);

  // ̿®٤ѹ[SSޥ]
  if(scip2SetComSpeed(port,115200)!=0){
    fprintf(stderr,"Could not change speed\n");
    exit(EXIT_FAILURE);
  }

  // 󥵤ΥСɽ[VVޥ]
  scip2ShowVersion(port);

  // 󥵤Υѥ᡼ɽ[PPޥ]
  scip2ShowParameter(port);

  // 󥵤Υơɽ[IIޥ]
  scip2ShowStatus(port);

  // 󥵤ӥۥȤλɽ[TMޥ]
  scip2ShowTime(port);

  // ž®ѹ[CRޥ]10®
  scip2SetScanSpeed(port,10);

  // ΥǡΥѥ᡼
  // ƥå 44-725 ƥåʬεΥǡְʤ33˼
  startStep=44;
  endStep=725;
  stepCluster=1;
  scanInterval=0;
  scanNum=3;

  // ¬ꤷƥǡ[MD/MSޥ]
  scan2=scip2MeasureScan(port,startStep,endStep,stepCluster,scanInterval,scanNum,ENC_3BYTE,&stepNum);
  // malloc εΥǡ free
  scip2FreeScan(scan2,scanNum);

  // ΥǡΥѥ᡼
  // ƥå 44-725 εΥǡƥå׼
  startStep=44;
  endStep=725;
  stepCluster=1;

  // ¬Ѥߥǡ[GD/GSޥ]
  // 졼ΤἺԤ
  scan=scip2GetScan(port,startStep,endStep,stepCluster,ENC_3BYTE,&stepNum);
  // malloc εΥǡ free
  scip1FreeScan(scan);

  // ¬ꤷƥǡݻʥ졼[BMޥ]
  scip2StartStoringScan(port);

  // ¬Ѥߥǡ[GD/GSޥ]
  // ٤ϥ졼Τ
  scan=scip2GetScan(port,startStep,endStep,stepCluster,ENC_3BYTE,&stepNum);
  // malloc εΥǡ free
  scip1FreeScan(scan);

  // ¬MD/MS,BMޥɡˤߡʥ졼[QTޥ]
  scip2StopStoringScan(port);

  // ꤵ줿̿ϥɥĤ
  closePort(port);

  printf("Exit success\n");
  return EXIT_SUCCESS;
}
