/*
  Wii ɂ郍{bgvO
*/

#include "WiiJoystick.h"
#include <stdio.h>
#include <stdlib.h>
#include <GL/glut.h>
#include <math.h>
#include <ctype.h>


#define PI2 (3.14159265358979323846 * 2.0)
#define D2R (3.14159265358979323846/180.0)
#define R2D (180.0/3.14159265358979323846)

#define W 16                       /* nʂ̂̕Q̂P */
#define D 20                       /* nʂ̒̂Q̂P */

#define syarinHaba 50
#define syarinHankei 100
#define syarinToreddo 1000
#define syarinZengo 600
static double robopos_x=0, robopos_y=0, robopos_t=0, robopos_h=0; //roboẗʒupƃXeAOp
static double maeAng=0, migiAng=0, hidariAng=0;

static WiiJoystick* Joystick = NULL;

/*
 * nʂ`
 */
void myGround(double height)
{
  static GLfloat ground[][4] = {
    { 0.6, 0.6, 0.6, 1.0 },
    { 0.3, 0.3, 0.3, 1.0 }
  };

  int i, j;

  glBegin(GL_QUADS);
  glNormal3d(0.0, 0.0, 1.0);
  for (j = -D; j < D; ++j) {
    for (i = -W; i < W; ++i) {
      glMaterialfv(GL_FRONT, GL_DIFFUSE, ground[(i + j) & 1]);
      glVertex3d((GLdouble)i*250, (GLdouble)j*250,height);
      glVertex3d((GLdouble)i*250, (GLdouble)(j + 1)*250,height);
      glVertex3d((GLdouble)(i + 1)*250, (GLdouble)(j + 1)*250,height);
      glVertex3d((GLdouble)(i + 1)*250, (GLdouble)j*250,height);
    }
  }
  glEnd();
}

/*
 * ~`
 *   radius: a
 *   height: 
 *   sides: ʂ̐iقǊ炩ɂȂj
 *
 */
void myCylinder(double radius, double height, int sides)
{
  double step = PI2 / (double)sides;
  int i;

  /*  */
  glNormal3d(0.0, 0.0, 1.0);
  glBegin(GL_TRIANGLE_FAN);
  for (i = 0; i < sides; i++) {
    double t = step * (double)i;
    glVertex3d(radius * sin(t), radius * cos(t), height);
  }
  glEnd();

  glPushMatrix();
  glTranslated(0,radius*0.75,0);
  glNormal3d(0.0, 0.0, -1.0);
  glBegin(GL_TRIANGLE_FAN);
  for (i = 0; i < sides/2; i++) {
    double t = step*2 * (double)i;
    glVertex3d(radius*0.15 * sin(t), radius*0.15 * cos(t), height+1);
  }
  glEnd();
  glPopMatrix();

  /*  */
  glNormal3d(0.0, 0.0, -1.0);
  glBegin(GL_TRIANGLE_FAN);
  for (i = sides; --i >= 0;) {
    double t = step * (double)i;
    glVertex3d(radius * sin(t), radius * cos(t), 0.0);
  }
  glEnd();

  glPushMatrix();
  glTranslated(0,radius*0.75,0);
  glNormal3d(0.0, 0.0, 1.0);
  glBegin(GL_TRIANGLE_FAN);
  for (i = 0; i < sides/2; i++) {
    double t = step*2 * (double)i;
    glVertex3d(radius*0.15 * sin(t), radius*0.15 * cos(t), -1);
  }
  glEnd();
  glPopMatrix();

  /*  */

  glBegin(GL_QUAD_STRIP);
  for (i = 0; i <= sides; i++) {
    double t = step * (double)i;
    double x = sin(t);
    double y = cos(t);
    glNormal3d(x, y, 0.0);
    glVertex3f(radius * x, radius * y, height);
    glVertex3f(radius * x, radius * y, 0.0);
  }
  glEnd();
}


void drawRobot(void)
{
  glPushMatrix();
  glTranslated(0,0, syarinHankei);
  glRotated(-90.0, 1.0, 0.0, 0.0);

  glPushMatrix();
  glTranslated(0,0, syarinToreddo/2-syarinHaba/2);
  glRotated(hidariAng, 0.0, 0.0, 1.0);
  myCylinder(syarinHankei,syarinHaba,19);
  glPopMatrix();
  glPushMatrix();
  glTranslated(0,0, -syarinToreddo/2-syarinHaba/2);
  glRotated(migiAng, 0.0, 0.0, 1.0);
  myCylinder(syarinHankei,syarinHaba,19);
  glPopMatrix();
  glPushMatrix();
  glTranslated(syarinZengo,0, -syarinHaba/2);
  glRotated(robopos_h, 0.0, -1.0, 0.0);
  glRotated(maeAng, 0.0, 0.0, 1.0);
  myCylinder(syarinHankei,syarinHaba,19);
  glPopMatrix();
  glPopMatrix();
}

/*
 * ʕ\
 */
void display(void)
{
  static GLfloat lightpos[] = { 3.0, 4.0, 5.0, 1.0 }; /* ̈ʒu */
  static GLfloat yellow[] = { 0.8, 0.8, 0.2, 1.0 };   /* Ԃ̐F */
  //static GLdouble px = 0.0, pz = 0.0;                 /* Ԃ̈ʒu */
  //static GLdouble r = 0.0;                            /* Ԃ̕ */

  /* ʃNA */
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  /* fr[ϊs̏ */
  glLoadIdentity();

  /* ̈ʒuݒ */
  glLightfv(GL_LIGHT0, GL_POSITION, lightpos);

  /* _̈ړî̕Ɉڂj*/
  glTranslated(-100.0, -200.0, -2500.0);
  glRotated(90.0, 0.0, 0.0, 1.0);
  glRotated(60.0, 0.0, 1.0, 0.0);
  glRotated(-20.0, 0.0, 0.0, 1.0);

  /* V[̕` */
  myGround(0.0);
  glPushMatrix();
  glTranslated(robopos_x, robopos_y, 0.0);
  glRotated(robopos_t, 0.0, 0.0, 1.0);
  glMaterialfv(GL_FRONT, GL_DIFFUSE, yellow);
  drawRobot();
  //glTranslated(robopos_x, robopos_y, pz);
  //glMaterialfv(GL_FRONT, GL_DIFFUSE, yellow);
  //myCylinder(10.0,20.0,20);
  glPopMatrix();

  glutSwapBuffers();
}

void resize(int w, int h)
{
  /* EBhEŜr[|[gɂ */
  //glViewport(0, 0, w, h);

  /* ϊs̎w */
  glMatrixMode(GL_PROJECTION);

  /* ϊs̏ */
  glLoadIdentity();
  gluPerspective(30.0, (double)w / (double)h, 1.0, 10000.0);//Ō̂Qϐ́A`悷鋗͈

  /* fr[ϊs̎w */
  glMatrixMode(GL_MODELVIEW);
}

/*
 * L[ꂽƂ̏
 */
void key_func(unsigned char key, int x, int y)
{
  switch(toupper(key)){
  case 0x1b:	/* drbL[ */
  case 'Q':	/* pL[ */
		/* vOI */
    exit(0);
    break;
  }
}


static void updateState(double sokudo) {

  double omega = 0.0;
  omega = tan(robopos_h*D2R)/syarinZengo * sokudo;
  omega = omega*R2D;
  robopos_t += omega;
  robopos_x += sokudo * cos(robopos_t*D2R);
  robopos_y += sokudo * sin(robopos_t*D2R);
  if (robopos_h==0){
    hidariAng += sokudo / syarinHankei *R2D ;
    migiAng += sokudo / syarinHankei *R2D ;
    maeAng += sokudo / syarinHankei *R2D ;
  }
  if (robopos_h!=0){
    hidariAng += (1-(syarinToreddo/2*tan(robopos_h*D2R)/syarinZengo))* sokudo / syarinHankei *R2D ;
    migiAng += (1+(syarinToreddo/2*tan(robopos_h*D2R)/syarinZengo))*sokudo / syarinHankei *R2D ;
    maeAng += (tan(robopos_h*D2R)/sin(robopos_h*D2R)) *sokudo / syarinHankei *R2D ;
  }
  glutPostRedisplay();
}


/*
 *	L[ꂽƂ̏
 */
void skey_func(int key, int x, int y)
{
  double sokudo=0;
  switch(key){
  case GLUT_KEY_UP:	/* L[ */
    sokudo=10;
    break;
  case GLUT_KEY_DOWN:	/* L[ */
    sokudo=-10;
    break;
  case GLUT_KEY_LEFT:	/* L[ */
    if(robopos_h<50)
      robopos_h+=2;
    break;
  case GLUT_KEY_RIGHT:	/* EL[ */
    if(robopos_h>-50)
      robopos_h-=2;
    break;
  }

  if (sokudo!=0) {
    updateState(sokudo);
  }
}


static void idle_func(void)
{
  /* Wii Rg[̏XV */
  int handle = Joystick->getAxisValue(0);
  if ((handle < 0) && (robopos_h < 50)) {
    robopos_h += 2;
  } else if ((handle > 0) && (robopos_h > -50)) {
    robopos_h -= 2;
  }

  double sokudo = 0.0;
  if (Joystick->isButtonPressed(WiiJoystick::Button_B)) {
    sokudo = 10.0;
  }
  if (Joystick->isButtonPressed(WiiJoystick::Button_A)) {
    sokudo = 0.0;
  }

  if ((sokudo != 0.0) || (handle != 0)) {
    updateState(sokudo);
  }
  SDL_Delay(1);
}


void init(void)
{
  /* ݒ */
  glClearColor(1.0, 1.0, 1.0, 0.0);
  glEnable(GL_DEPTH_TEST);
  glDisable(GL_CULL_FACE);
  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
}


int main(int argc, char *argv[])
{
  printf("Put Wiimote in discoverable mode (press 1+2) and press RETURN\n");
  getchar();

  Joystick = new WiiJoystick;
  if (! Joystick->connect()) {
    printf("WiiJoysticks::connect: %s\n", Joystick->what());
    exit(1);
  }

  glutInit(&argc, argv);
  glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH);
  glutInitWindowSize(450,450);
  glutCreateWindow(argv[0]);
  glutDisplayFunc(display);
  glutReshapeFunc(resize);
  glutKeyboardFunc(key_func);
  glutSpecialFunc(skey_func);
  glutIdleFunc(idle_func);
  init();
  glutMainLoop();

  return 0;
}
