
#include <pthread.h>
#include "scipBase.h"
#include "scip1.h"
#include "scip2.h"
#include "scipUtil.h"
#include "URG_Ctrl.h"
#include "HoistTask.h"
#include "localize3.h"
#include "aroundmap.h"

#define URGLOCK pthread_mutex_lock(&URGport_name->muurg)
#define URGUNLOCK pthread_mutex_unlock(&URGport_name->muurg)

struct URGport_name
{
  tPort *port;
  char *filename;
  int timeflag;
  int tag;
  pthread_mutex_t muurg;
};

struct URGport_name URGport_name0;
struct URGport_name URGport_name1;
struct URGport_name URGport_name2;

int init_gnuplot(FILE **fp);
void connectCheck(tPort **port,char *dev);
void makefilename(int Topflag,int filenum,struct URGport_name *URGport_name,char name[],char log[],char log2[]);

void init_URGthread()
{
	//URGのポート変数を作成
	tPort *port0;
	tPort *port1;
	tPort *port2;

	int err;	//スレッドのクリエイト失敗で非０
	pthread_t thread_urg0,thread_urg1,thread_urg2;	//スレッドの資源

	pthread_mutex_init(&URGport_name0.muurg,NULL);
	pthread_mutex_init(&URGport_name1.muurg,NULL);
	pthread_mutex_init(&URGport_name2.muurg,NULL);
	
	//各ポートをそれぞれのURGに接続、接続できたかチェック
	connectCheck(&port0,"/dev/ttyACM0");
	connectCheck(&port1,"/dev/ttyACM1");
	connectCheck(&port2,"/dev/ttyACM2");
	
	//各URGをスキップ２に変更（いらない？）
	switchToScip2(port0);
	switchToScip2(port1);
	switchToScip2(port2);

	//URGの状態のフラグの初期化
	URGport_name0.port = port0;
	URGport_name0.filename = "log";
	URGport_name0.timeflag = OFF;
	URGport_name0.tag = OFF;
	URGport_name1.port = port1;
	URGport_name1.filename = "up";
	URGport_name1.timeflag = OFF;
	URGport_name1.tag = OFF;
	URGport_name2.port = port2;
	URGport_name2.filename = "down";
	URGport_name2.timeflag = OFF;
	URGport_name2.tag = OFF;

	err = pthread_create(&thread_urg0,NULL,getURG,&URGport_name0);
	if(err != 0)
	{
		printf("URG0's thread can not create.\n");
	}
	err = pthread_create(&thread_urg1,NULL,getURG,&URGport_name1);
	if(err != 0)
	{
		printf("URG1's thread can not create.\n");
	}
	err = pthread_create(&thread_urg2,NULL,getURG,&URGport_name2);
	if(err != 0)
	{
		printf("URG2's thread can not create.\n");
	}
}

void *getURG(void *arg)
{
	//const int STARTSTEP = 0;
	const int TOPSTARTSTEP = 0;
	//const int  ENDSTEP = 725;
	const int TOPENDSTEP = 1127;
	const int STEPCLUSTER = 1;
	const int SCANINTERVAL = 0;
	const int SCANNUM = 1;
	const int TOPON = 1;	//一番したかどうか

	int i;			//ステップナンバー用
	char name[64];	    //１スキャン毎のデータを格納するファイル名
	char log[64];	      //水平、上、下向きの生データを保存するファイル名
	char log2[64];		//上記のxyデータを保存するファイル名
	FILE *fpn; //オドメトリとURGデータを1スキャン分ずつ保存するファイル用
	FILE *fp; //水平用、上向き用、下向き用を１２０秒分ずつ保存するファイル　生データ
	FILE *fp2;			//上記をxy変換したもの
	FILE *fpFodo;
	FILE *fpTodo;
	struct URGport_name *URGport_name;
	int stepNum;			//URGのステップナンバー保存用
	int **scan;
	int Topflag = 0;
	int filenum = 0; //fpnのファイル番号　＝　スキャン番号　fp等のファイル名は　この数字をまとめる時間で割ることによって作られる

	struct pos NTPos = {0,0,0};
	struct pos NFPos = {0,0,0};
	struct pos OTPos = {0,0,0};
	struct pos OFPos = {0,0,0};

	double unowtime = 0;
	double uoldtime = 0;

	struct pos oldposition;

	FILE *gnu;	//gnuplotの描画用の保存するファイル用

	URGport_name = (struct URGport_name *)arg;
	
	if(strcmp("log",URGport_name->filename)==0)
	{
		Topflag = TOPON;
		
		//gnuplotの初期化
		init_gnuplot(&gnu);
		printf("TOPON\n");
	}

	while(1)
	{
		unowtime = gettime();
		URGLOCK;
		if(unowtime - uoldtime > 1)
		{
			URGport_name->timeflag = ON;
			uoldtime = unowtime;
		}
		if(URGport_name->timeflag == ON)
		{
			//ファイル名作成
			makefilename(Topflag,filenum,URGport_name,name,log,log2);
/*
			if(Topflag == TOPON)
			{
				sprintf(name,"0%d",filenum);			//1スキャン毎の（オドメトリ、URG）データ保存用ファイル
			}
			sprintf(log,"%s%d.txt",URGport_name->filename,filenum/120);		//水平面の保存ファイル　120秒分が1つのファイルになる
			sprintf(log2,"%s%d_2.txt",URGport_name->filename,filenum/120);
			
			if(URGport_name->tag == ON)
			{
				if(Topflag == TOPON)
				{
					sprintf(name,"TAG0%s",name);
				}
				sprintf(log,"TAG%s",log);		//水平面の保存ファイル　120秒分が1つのファイルになる
				sprintf(log2,"TAG%s",log2);
			}
*/			
			if(Topflag == TOPON)
			{
				if((fpn = fopen(name,"w")) == NULL)	//こいつだけはアペンドじゃなくてライトモードで開いてもよい
				{
					printf("can not open %s",name);
				}
			}
			if((fp = fopen(log,"a")) == NULL)
			{
				printf("can not open %s",log);
			}
			if((fp2 = fopen(log2,"a")) == NULL)
			{
				printf("can not open %s",log2);
			}
			
			unowtime = gettime();
			
			if(Topflag == TOPON)
			{
				POSLOCK;
				oldposition.x = robopos_x;	//オドメトリ値確定
				oldposition.y = robopos_y;
				oldposition.th = robopos_t;
				POSUNLOCK;
			}
			scan=scip2MeasureScan(URGport_name->port,TOPSTARTSTEP,TOPENDSTEP,STEPCLUSTER,SCANINTERVAL,SCANNUM,ENC_3BYTE,&stepNum);
			if(scan == NULL)	//デバッグ用
			{
				printf("can not get data　%s",URGport_name->filename);
				sleep(5);
			}
			POSLOCK;
			if(Topflag == TOPON)
			{
				fprintf(fpn,"%lf %lf %lf %lf\n",oldposition.x,oldposition.y,oldposition.th,unowtime);
			}
			fprintf(fp,"%lf %lf %lf %lf\n",oldposition.x,oldposition.y,oldposition.th,unowtime);
			fprintf(fp2,"%lf %lf %lf %lf\n",oldposition.x,oldposition.y,oldposition.th,unowtime);
			POSUNLOCK;
			for(i=TOPSTARTSTEP;i<TOPENDSTEP;i++)	//URGデータを保存
			{
				if(Topflag == TOPON)
				{
						fprintf(fpn,"%d %d %d \n",i,(int)(scan[0][i]*cos(((i-560)*0.25)*D2R)),(int)(scan[0][i]*sin(((i-560)*0.25)*D2R)));
				}
				fprintf(fp,"%d %d\n",i,scan[0][i]);
				fprintf(fp2,"%d %d %d \n",i,(int)(scan[0][i]*cos(((i-560)*0.25)*D2R)),(int)(scan[0][i]*sin(((i-560)*0.25)*D2R)));
			}
			fclose(fp);
			fclose(fp2);

			if(Topflag == TOPON)
			{
				fclose(fpn);
				if(modeflag == MATCH)
				{
					//マッチング対象のスキャンデータファイルからオドメトリを抜き出す
					NFPos = getodometori(filenum);
					
				        fpFodo=fopen("Fodo.dat","a");
				        fprintf(fpFodo,"%lf %lf\n",NFPos.x,NFPos.y);
				        fclose(fpFodo);
	        
					//スキャンデータを位置情報を使ってグローバル座標上に展開する
					DownToGlobal(filenum,NFPos,'b');
					
					//ひとつ前のオドメトリとの差分から初期値にするのに正しいオドメトリをつくる
					NFPos = MakeRightPos(NFPos,OFPos,OTPos);
					
					//次回の変数作成のために古い今の位置を保存
					OFPos = getodometori(filenum);

					//マッチングに利用するマップの作成
					aroundmap(NFPos.x,NFPos.y,NFPos.th);

					//マッチングによる位置姿勢の修正
					NTPos = localize(filenum,NFPos.x,NFPos.y,NFPos.th);
					//もしオドメトリの到達点から２m以上離れていたらオドメトリの値に戻す
					//マッチング点数の数による評価も必要だと考える
					if(pow(NTPos.x - NFPos.x,2) + pow(NTPos.y - NFPos.y,2) > 2250000)
					{
						NTPos = NFPos;
					}
					
					fpTodo = fopen("Todo.dat","a");
					if(fpTodo == NULL)
					{
						printf("could not open Todo.dat\n");
						exit(-1);
					}
					fprintf(fpTodo,"%lf %lf\n",NTPos.x,NTPos.y);
					fclose(fpTodo);
		
					//スキャンデータを位置姿勢情報を使ってグローバル座標上に展開する
					DownToGlobal(filenum,NTPos,'l');
					//printf("NTP %10lf %10lf %10lf ¥n", NTPos.x,NTPos.y,NTPos.th);
					
					//修整後の位置姿勢情報を保存
					OTPos = NTPos;
					if(filenum%2 == 0)
					{
					        fprintf(gnu,"plot \"clearmap2.dat\" u 2:3, \"b%s\" u 2:3, \"l%s\" u 2:3, \"Fodo.dat\" u 1:2, \"Todo.dat\" u 1:2 \n",name,name);
					        fflush(gnu);
					}

				}
			}
			URGport_name->timeflag = OFF;
			if(URGport_name->tag == OFF)
			{
				filenum++;
			}
		}
		else//timeflagが立っていなければ（前回の保存から1秒立っていなければ
		{
			usleep(10000);	//10msスリープ（負荷軽減用）
		}
		URGUNLOCK;
//		fprintf(stderr,"%s¥n",URGport_name->filename);
	}

	return NULL;
}

void hoist_dataAvoid(int avoid_flag){

  switch(avoid_flag)
  {
    case 1:
      URGport_name0.tag = ON;
      URGport_name1.tag = ON;
      URGport_name2.tag = ON;
      break;
    case 0:
      URGport_name0.tag = OFF;
      URGport_name1.tag = OFF;
      URGport_name2.tag = OFF;
      break;
  }
}

int init_gnuplot(FILE **fp)
{
		*fp = popen("gnuplot","w");	//Top-URGのデータを見る用のgnuplot
		if(*fp == NULL)
		{
			fprintf(stderr,"could not open gnuplot\n");
			return -1;
		}
		fprintf(*fp,"set xrange[-5000:50000]\n");
		fprintf(*fp,"set yrange[-5000:30000]\n");
		
		return 0;
}

void connectCheck(tPort **port,char *dev)
{
	*port = scipConnect(dev);
	if(*port == NULL)
	{
		fprintf(stderr,"Could not connect to the %s \n",dev);
		exit(EXIT_FAILURE);
	}
}

void makefilename(int Topflag,int filenum,struct URGport_name *URGport_name,char name[],char log[],char log2[])
{
	const int TOPON = 1;
	
	if(Topflag == TOPON)
	{
		sprintf(name,"0%d",filenum);			//1スキャン毎の（オドメトリ、URG）データ保存用ファイル
	}
	sprintf(log,"%s%d.txt",URGport_name->filename,filenum/120);		//水平面の保存ファイル　120秒分が1つのファイルになる
	sprintf(log2,"%s%d_2.txt",URGport_name->filename,filenum/120);
	
	if(URGport_name->tag == ON)
	{
		if(Topflag == TOPON)
		{
			sprintf(name,"TAG0%s",name);
		}
		sprintf(log,"TAG%s",log);		//水平面の保存ファイル　120秒分が1つのファイルになる
		sprintf(log2,"TAG%s",log2);
	}
	
			
}
