/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import net.percederberg.grammatica.parser.ParseException;
import net.percederberg.grammatica.parser.ParserCreationException;
import net.percederberg.grammatica.parser.ReaderBuffer;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.TokenMatch;
import net.percederberg.grammatica.parser.TokenNFA;
import net.percederberg.grammatica.parser.TokenPattern;
import net.percederberg.grammatica.parser.TokenStringDFA;
import net.percederberg.grammatica.parser.re.Matcher;
import net.percederberg.grammatica.parser.re.RegExp;

public class Tokenizer {
    protected boolean ignoreCase = false;
    private boolean useTokenList = false;
    private StringDFAMatcher stringDfaMatcher = new StringDFAMatcher();
    private NFAMatcher nfaMatcher = new NFAMatcher();
    private RegExpMatcher regExpMatcher = new RegExpMatcher();
    private ReaderBuffer buffer = null;
    private TokenMatch lastMatch = new TokenMatch();
    private Token previousToken = null;

    public Tokenizer(Reader input) {
        this(input, false);
    }

    public Tokenizer(Reader input, boolean ignoreCase) {
        this.buffer = new ReaderBuffer(input);
        this.ignoreCase = ignoreCase;
    }

    public boolean getUseTokenList() {
        return this.useTokenList;
    }

    public void setUseTokenList(boolean useTokenList) {
        this.useTokenList = useTokenList;
    }

    public String getPatternDescription(int id) {
        TokenPattern pattern = this.stringDfaMatcher.getPattern(id);
        if (pattern == null) {
            pattern = this.nfaMatcher.getPattern(id);
        }
        if (pattern == null) {
            pattern = this.regExpMatcher.getPattern(id);
        }
        return pattern == null ? null : pattern.toShortString();
    }

    public int getCurrentLine() {
        return this.buffer.lineNumber();
    }

    public int getCurrentColumn() {
        return this.buffer.columnNumber();
    }

    public void addPattern(TokenPattern pattern) throws ParserCreationException {
        switch (pattern.getType()) {
            case 1: {
                try {
                    this.stringDfaMatcher.addPattern(pattern);
                    break;
                }
                catch (Exception e) {
                    throw new ParserCreationException(2, pattern.getName(), "error adding string token: " + e.getMessage());
                }
            }
            case 2: {
                try {
                    this.nfaMatcher.addPattern(pattern);
                    break;
                }
                catch (Exception ignore) {
                    try {
                        this.regExpMatcher.addPattern(pattern);
                        break;
                    }
                    catch (Exception e) {
                        throw new ParserCreationException(2, pattern.getName(), "regular expression contains error(s): " + e.getMessage());
                    }
                }
            }
            default: {
                throw new ParserCreationException(2, pattern.getName(), "pattern type " + pattern.getType() + " is undefined");
            }
        }
    }

    public void reset(Reader input) {
        this.buffer.dispose();
        this.buffer = new ReaderBuffer(input);
        this.previousToken = null;
        this.lastMatch.clear();
    }

    public Token next() throws ParseException {
        Token token = null;
        do {
            if ((token = this.nextToken()) == null) {
                this.previousToken = null;
                return null;
            }
            if (this.useTokenList) {
                token.setPreviousToken(this.previousToken);
                this.previousToken = token;
            }
            if (token.getPattern().isIgnore()) {
                token = null;
                continue;
            }
            if (!token.getPattern().isError()) continue;
            throw new ParseException(5, token.getPattern().getErrorMessage(), token.getStartLine(), token.getStartColumn());
        } while (token == null);
        return token;
    }

    private Token nextToken() throws ParseException {
        try {
            this.lastMatch.clear();
            this.stringDfaMatcher.match(this.buffer, this.lastMatch);
            this.nfaMatcher.match(this.buffer, this.lastMatch);
            this.regExpMatcher.match(this.buffer, this.lastMatch);
            if (this.lastMatch.length() > 0) {
                int line = this.buffer.lineNumber();
                int column = this.buffer.columnNumber();
                String str = this.buffer.read(this.lastMatch.length());
                return this.newToken(this.lastMatch.pattern(), str, line, column);
            }
            if (this.buffer.peek(0) < 0) {
                return null;
            }
            int line = this.buffer.lineNumber();
            int column = this.buffer.columnNumber();
            throw new ParseException(3, this.buffer.read(1), line, column);
        }
        catch (IOException e) {
            throw new ParseException(1, e.getMessage(), -1, -1);
        }
    }

    protected Token newToken(TokenPattern pattern, String image, int line, int column) {
        return new Token(pattern, image, line, column);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.stringDfaMatcher);
        buffer.append(this.nfaMatcher);
        buffer.append(this.regExpMatcher);
        return buffer.toString();
    }

    class JavaRE
    extends RE {
        Pattern pattern;
        java.util.regex.Matcher matcher;

        public JavaRE(String regex) throws Exception {
            this.matcher = null;
            this.pattern = Tokenizer.this.ignoreCase ? Pattern.compile(regex, 2) : Pattern.compile(regex);
        }

        public int match(ReaderBuffer buffer) throws IOException {
            boolean match;
            int c;
            int minSize = 1024;
            if (this.matcher == null) {
                this.matcher = this.pattern.matcher(buffer);
            } else {
                this.matcher.reset(buffer);
            }
            this.matcher.useTransparentBounds(true);
            do {
                c = buffer.peek(minSize);
                this.matcher.region(buffer.position(), buffer.length());
                match = this.matcher.lookingAt();
                if (!this.matcher.hitEnd()) continue;
                minSize *= 2;
            } while (c >= 0 && this.matcher.hitEnd());
            return match ? this.matcher.end() - this.matcher.start() : 0;
        }
    }

    class GrammaticaRE
    extends RE {
        private RegExp regExp;
        private Matcher matcher;

        public GrammaticaRE(String regex) throws Exception {
            this.matcher = null;
            this.regExp = new RegExp(regex, Tokenizer.this.ignoreCase);
        }

        public int match(ReaderBuffer buffer) throws IOException {
            if (this.matcher == null) {
                this.matcher = this.regExp.matcher(buffer);
            } else {
                this.matcher.reset(buffer);
            }
            return this.matcher.matchFromBeginning() ? this.matcher.length() : 0;
        }
    }

    abstract class RE {
        RE() {
        }

        public abstract int match(ReaderBuffer var1) throws IOException;
    }

    class RegExpMatcher
    extends TokenMatcher {
        private RE[] regExps;

        RegExpMatcher() {
            this.regExps = new RE[0];
        }

        public void addPattern(TokenPattern pattern) throws Exception {
            RE[] temp = this.regExps;
            JavaRE re = new JavaRE(pattern.getPattern());
            this.regExps = new RE[temp.length + 1];
            System.arraycopy(temp, 0, this.regExps, 0, temp.length);
            this.regExps[temp.length] = re;
            pattern.setDebugInfo("native Java regexp");
            super.addPattern(pattern);
        }

        public void match(ReaderBuffer buffer, TokenMatch match) throws IOException {
            for (int i = 0; i < this.regExps.length; ++i) {
                int length = this.regExps[i].match(buffer);
                if (length <= 0) continue;
                match.update(length, this.patterns[i]);
            }
        }
    }

    class NFAMatcher
    extends TokenMatcher {
        private TokenNFA automaton;

        NFAMatcher() {
            this.automaton = new TokenNFA();
        }

        public void addPattern(TokenPattern pattern) throws Exception {
            if (pattern.getType() == 1) {
                this.automaton.addTextMatch(pattern.getPattern(), Tokenizer.this.ignoreCase, pattern);
            } else {
                this.automaton.addRegExpMatch(pattern.getPattern(), Tokenizer.this.ignoreCase, pattern);
            }
            super.addPattern(pattern);
        }

        public void match(ReaderBuffer buffer, TokenMatch match) throws IOException {
            this.automaton.match(buffer, match);
        }
    }

    class StringDFAMatcher
    extends TokenMatcher {
        private TokenStringDFA automaton;

        StringDFAMatcher() {
            this.automaton = new TokenStringDFA();
        }

        public void addPattern(TokenPattern pattern) throws Exception {
            this.automaton.addMatch(pattern.getPattern(), Tokenizer.this.ignoreCase, pattern);
            super.addPattern(pattern);
        }

        public void match(ReaderBuffer buffer, TokenMatch match) throws IOException {
            TokenPattern res = this.automaton.match(buffer, Tokenizer.this.ignoreCase);
            if (res != null) {
                match.update(res.getPattern().length(), res);
            }
        }
    }

    abstract class TokenMatcher {
        protected TokenPattern[] patterns = new TokenPattern[0];

        TokenMatcher() {
        }

        public abstract void match(ReaderBuffer var1, TokenMatch var2) throws IOException;

        public TokenPattern getPattern(int id) {
            for (int i = 0; i < this.patterns.length; ++i) {
                if (this.patterns[i].getId() != id) continue;
                return this.patterns[i];
            }
            return null;
        }

        public void addPattern(TokenPattern pattern) throws Exception {
            TokenPattern[] temp = this.patterns;
            this.patterns = new TokenPattern[temp.length + 1];
            System.arraycopy(temp, 0, this.patterns, 0, temp.length);
            this.patterns[temp.length] = pattern;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < this.patterns.length; ++i) {
                buffer.append(this.patterns[i]);
                buffer.append("\n\n");
            }
            return buffer.toString();
        }
    }
}

