/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.repository;

import com.clustercontrol.FacilityNotFoundException;
import com.clustercontrol.repository.bean.ScopeInfo;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import java.util.ArrayList;
import java.util.Collections;
import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.ReadCsvFile;
import jp.co.intellilink.hinemos.util.StringListComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportScope {
    private static Log log = LogFactory.getLog(ImportScope.class);
    private ArrayList<ArrayList<String>> scopeInfos = null;

    public void importScope() {
        log.info((Object)Messages.getMsg("Scope.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.scopeInfos = ReadCsvFile.readCsvFile(Config.getConfig("Import.Dir") + "/SCOPE.csv");
        Collections.sort(this.scopeInfos, new StringListComparator(0));
        Collections.sort(this.scopeInfos, new StringListComparator(3));
        for (ArrayList<String> arrayList : this.scopeInfos) {
            String string = arrayList.get(0);
            if (string.matches("(INTERNAL|REGISTERED|UNREGISTERED)")) continue;
            ScopeInfo scopeInfo = this.createScopeInfo(arrayList);
            String string2 = "";
            if (arrayList.size() >= 4) {
                string2 = arrayList.get(3);
            }
            this.registerScopeInfo(string2, scopeInfo);
        }
        log.info((Object)Messages.getMsg("Scope.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    public ScopeInfo createScopeInfo(ArrayList<String> arrayList) {
        Object object;
        Object[] objectArray;
        ScopeInfo scopeInfo = new ScopeInfo();
        String string = CheckString.checkLength(arrayList.get(0), 64);
        if (!string.equals(arrayList.get(0))) {
            objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"facility.id"), "64"};
            log.error((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
            System.exit(20);
        }
        scopeInfo.setFacilityId(string);
        objectArray = CheckString.checkLength(arrayList.get(1), 256);
        if (!objectArray.equals(arrayList.get(1))) {
            object = new String[]{com.clustercontrol.util.Messages.getString((String)"facility.name"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", (Object[])object));
        }
        scopeInfo.setFacilityName((String)objectArray);
        if (arrayList.size() >= 3) {
            object = CheckString.checkLength(arrayList.get(2), 1024);
            if (!((String)object).equals(arrayList.get(2))) {
                Object[] objectArray2 = new String[]{com.clustercontrol.util.Messages.getString((String)"description"), "1024"};
                log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray2));
            }
            scopeInfo.setDescription((String)object);
        }
        return scopeInfo;
    }

    protected void registerScopeInfo(String string, ScopeInfo scopeInfo) {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        String string2 = scopeInfo.getFacilityId();
        try {
            ScopeInfo scopeInfo2 = this.getScope(string2);
            if (scopeInfo2 instanceof ScopeInfo) {
                Object[] objectArray = new Object[]{string2};
                log.info((Object)(Messages.getMsg("FacilityID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                repositoryController.modifyScope(scopeInfo);
            } else {
                Object[] objectArray = new Object[]{string2};
                log.info((Object)(Messages.getMsg("FacilityID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                repositoryController.addScope(string, scopeInfo);
            }
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ScopeInfo getScope(String string) {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        ScopeInfo scopeInfo = null;
        try {
            scopeInfo = repositoryController.getScopeProperty(string);
        }
        catch (FacilityNotFoundException facilityNotFoundException) {
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return scopeInfo;
    }
}

