/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.monitor;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.sql.bean.SqlCheckInfo;
import com.clustercontrol.sql.ejb.session.MonitorSqlController;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitorString;
import jp.co.intellilink.hinemos.export.conf.monitor.JdbcDriverUtil;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.IntegerListComparator;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMonitorSqlString
extends ExportMonitorString {
    private static Log log = LogFactory.getLog(ExportMonitorSqlString.class);
    private List<List<String>> driverList = JdbcDriverUtil.getJdbcDriver();

    public void exportSql() {
        log.info((Object)Messages.getMsg("Sql.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        ArrayList arrayList3 = this.getSnmpList();
        if (arrayList3 instanceof ArrayList) {
            for (Object object2 : arrayList3) {
                if (object2.getMonitorType() != 2) continue;
                Object[] objectArray = new Object[]{object2.getMonitorId()};
                log.info((Object)Messages.getMsg("MonitorID", objectArray));
                arrayList.add(this.createCsvFormat((MonitorInfo)object2));
                arrayList2.addAll(this.createMonitorJudgement((MonitorInfo)object2));
            }
            Collections.sort(arrayList, new StringListComparator(0));
            Collections.sort(arrayList2, new IntegerListComparator(1));
            Collections.sort(arrayList2, new StringListComparator(0));
        }
        Object object = "";
        if (Config.getConfig("file.timestamp").equalsIgnoreCase("on")) {
            Object object2;
            object2 = new SimpleDateFormat("yyyyMMdd_HHmmss");
            object = "_" + ((DateFormat)object2).format(new Date());
        }
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/SQL_STR" + (String)object + ".csv", arrayList);
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/SQL_STR_RULE" + (String)object + ".csv", arrayList2);
        log.info((Object)Messages.getMsg("Sql.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    @Override
    public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SqlCheckInfo sqlCheckInfo = monitorInfo.getSqlCheckInfo();
        if (sqlCheckInfo == null) {
            sqlCheckInfo = new SqlCheckInfo();
        }
        if (sqlCheckInfo.getConnectionUrl() != null) {
            arrayList.add(sqlCheckInfo.getConnectionUrl());
        } else {
            arrayList.add("");
        }
        if (sqlCheckInfo.getJdbcDriver() != null) {
            for (int i = 0; i < this.driverList.size(); ++i) {
                List<String> list = this.driverList.get(i);
                String string = list.get(1);
                if (!string.equals(sqlCheckInfo.getJdbcDriver())) continue;
                arrayList.add(list.get(0));
                break;
            }
        } else {
            arrayList.add("");
        }
        if (sqlCheckInfo.getUser() != null) {
            arrayList.add(sqlCheckInfo.getUser().toString());
        } else {
            arrayList.add("");
        }
        if (sqlCheckInfo.getPassword() != null) {
            arrayList.add(sqlCheckInfo.getPassword());
        } else {
            arrayList.add("");
        }
        if (sqlCheckInfo.getQuery() != null) {
            arrayList.add(sqlCheckInfo.getQuery());
        } else {
            arrayList.add("");
        }
        return arrayList;
    }

    protected ArrayList getSnmpList() {
        MonitorSqlController monitorSqlController = EjbConnectionManager.getConnectionManager().getMonitorSqlController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSqlController.getSqlList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

