/*  Resources.Designer.cs $

 	   This file is part of the HandBrake source code.
 	   Homepage: <http://handbrake.fr/>.
 	   It may be used under the terms of the GNU General Public License. */

; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "Handbrake{"
!define PRODUCT_VERSION "0.9.4"
!define PRODUCT_VERSION_NUMBER "0.9.4jp"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\Handbrake.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

SetCompressor lzma

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "handbrakepineapple.ico"
!define MUI_UNICON "handbrakepineapple.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "doc\COPYING"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\Handbrake.exe"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
;!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "Japanese"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "HandBrake-${PRODUCT_VERSION_NUMBER}-Win_GUI.exe"

!include WordFunc.nsh
!insertmacro VersionCompare
!include LogicLib.nsh

; Check to see if .NET Framework 2.0 or above is Installed.
Function .onInit
  Call GetDotNETVersion
  Pop $0
  ${If} $0 == "not found"
    MessageBox MB_OK|MB_ICONSTOP ".NET runtime library is not installed. $\r$\n You can download .Net Framework 2.0 redistributable from the microsoft website. $\r$\n Alternatively you can use google for a direct download URL"
    Abort
  ${EndIf}

  StrCpy $0 $0 "" 1 # skip "v"

  ${VersionCompare} $0 "2.0" $1
  ${If} $1 == 2
    MessageBox MB_OK|MB_ICONSTOP ".NET runtime library v2.0 or newer is required. You have $0. $\r$\n You can download .Net Framework 2.0 redistributable from the Microsoft website. $\r$\n Alternatively you can use google for a direct download URL"
    Abort
  ${EndIf}
FunctionEnd

Function GetDotNETVersion
  Push $0
  Push $1

  System::Call "mscoree::GetCORVersion(w .r0, i ${NSIS_MAX_STRLEN}, *i) i .r1 ?u"
  StrCmp $1 "error" 0 +2
    StrCpy $0 "not found"

  Pop $1
  Exch $0
FunctionEnd


InstallDir "$PROGRAMFILES\Handbrake"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show

Section "Handbrake" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite ifnewer
  File "Handbrake.exe"
  CreateDirectory "$SMPROGRAMS\Handbrake"
  CreateShortCut "$SMPROGRAMS\Handbrake\Handbrake.lnk" "$INSTDIR\Handbrake.exe"
  CreateShortCut "$DESKTOP\Handbrake.lnk" "$INSTDIR\Handbrake.exe"
  File "Interop.QTOLibrary.dll"
  File "Interop.QTOControlLib.dll"
  File "AxInterop.QTOControlLib.dll"
  File "Growl.Connector.dll"
  File "Growl.CoreLibrary.dll"
  File "libgcc_s_sjlj-1.dll"
  File "HandBrakeCLI.exe"
  File "Handbrake.exe.config"
  File "handbrakepineapple.ico"

  SetOutPath "$INSTDIR\doc"
  SetOverwrite ifnewer
  File "doc\AUTHORS"
  File "doc\COPYING"
  File "doc\CREDITS"
  File "doc\NEWS"
  File "doc\THANKS"
  File "doc\TRANSLATIONS"
SectionEnd

Section -AdditionalIcons
  CreateShortCut "$SMPROGRAMS\Handbrake\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\Handbrake.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\Handbrake.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\uninst.exe"
  
  Delete "$INSTDIR\Interop.QTOLibrary.dll"
  Delete "$INSTDIR\Interop.QTOControlLib.dll"
  Delete "$INSTDIR\AxInterop.QTOControlLib.dll"
  Delete "$INSTDIR\HandBrakeCLI.exe"
  Delete "$INSTDIR\handbrakepineapple.ico"
  Delete "$INSTDIR\Handbrake.exe"
  Delete "$INSTDIR\Handbrake.exe.config"
  Delete "$INSTDIR\Growl.Connector.dll"
  Delete "$INSTDIR\Growl.CoreLibrary.dll"
  Delete "$INSTDIR\libgcc_s_sjlj-1.dll"
  Delete "$INSTDIR\doc\AUTHORS"
  Delete "$INSTDIR\doc\COPYING"
  Delete "$INSTDIR\doc\CREDITS"
  Delete "$INSTDIR\doc\NEWS"
  Delete "$INSTDIR\doc\THANKS"
  Delete "$INSTDIR\doc\TRANSLATIONS"
  RMDir  "$INSTDIR"
  Delete "$SMPROGRAMS\Handbrake\Uninstall.lnk"
  Delete "$DESKTOP\Handbrake.lnk"
  Delete "$SMPROGRAMS\Handbrake\Handbrake.lnk"
  RMDir  "$SMPROGRAMS\Handbrake"
  RMDir  "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd