/*
 * Copyright [yyyy] [name of copyright owner]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// reference
var Config			= window.h5glib.Config;
var Debug			= window.h5glib.Debug;
var Command			= window.h5glib.Command;
var Task			= window.h5glib.Task;
var SoundTask		= window.h5glib.SoundTask;
var ReadyTask		= window.h5glib.ReadyTask;
var ImageAnimator	= window.h5glib.ImageAnimator;
var Message			= window.h5glib.Message;
var MessageHandler	= window.h5glib.MessageHandler;
var MessageManager	= window.h5glib.MessageManager;
var SceneStatus		= window.h5glib.SceneStatus;
var Scene			= window.h5glib.Scene;

var Element			= window.h5glib.Element;
var SceneManager	= window.h5glib.SceneManager;
var AppStatus		= window.h5glib.AppStatus;
var Application		= window.h5glib.Application;

/**
 *
 */
/*
function setUpPage()
{
	inform("setUpPage()");
	setUpPageStatus = "complete";
}
*/
/**
 *
 */
function setUp()
{
//	inform( arguments.callee.name );
}

/**
 *
 */
function tearDown()
{
//	inform( arguments.callee.name );
}

/**
 *
 */
//function testDebug_alert()

/**
 *
 */
//function testDebug_alertError()

/**
 *
 */
//function testDebug_print()

/**
 *
 */
//function testDebug_intercept()

/**
 *
 */
//function testDebug_setInterceptor()

/**
 *
 */
function testCommand()
{
	inform( arguments.callee.name );

	// Command
	var command = new Command();

	assertNotNull( command.tbl );
}

/**
 *
 */
function testCommand_clear()
{
	inform( arguments.callee.name );

	// Command
	var command = new Command();
	command.tbl.aaa = 1;

	// before clear
	assertEquals( command.tbl.aaa, 1 );

	// after clear
	command.clear();
	assertEquals( command.tbl.aaa, 0 );
}

/**
 *
 */
function testElement()
{
	inform( arguments.callee.name );

	// Element
	var element = new Element();

	assertNull( element.prev );
	assertNull( element.next );
	assertNull( element.child );
}

/**
 *
 */
function testElement_append()
{
	inform( arguments.callee.name );

	// Element
	var e1 = new Element();
	var e2 = new Element();
	var e3 = new Element();

	// append
	assertTrue( e1.append( e2 ) );
	assertTrue( e1.append( e3 ) );

	assertEquals( e1.prev, null );
	assertEquals( e1.next, e2 );
	assertEquals( e2.prev, e1 );
	assertEquals( e2.next, e3 );
	assertEquals( e3.prev, e2 );
	assertEquals( e3.next, null );
}

/**
 *
 */
function testElement_link()
{
	inform( arguments.callee.name );

	// Element
	var e1 = new Element();
	var e2 = new Element();
	var e3 = new Element();

	// link 2 element
	e2.link( e1 );
	assertEquals( e1.prev, null );
	assertEquals( e1.next, e2 );
	assertEquals( e2.prev, e1 );
	assertEquals( e2.next, null );

	// link 3 element
	e3.link( e2 );
	assertEquals( e2.prev, e1 );
	assertEquals( e2.next, e3 );
	assertEquals( e3.prev, e2 );
	assertEquals( e3.next, null );
}

/**
 *
 */
function testElement_unlink()
{
	inform( arguments.callee.name );

	// Element
	var e1 = new Element();
	var e2 = new Element();
	var e3 = new Element();

	e2.link( e1 );
	e3.link( e2 );

	// unlink middle
	e2.unlink();
	assertEquals( e1.prev, null );
	assertEquals( e1.next, e3 );
	assertEquals( e2.prev, null );
	assertEquals( e2.next, null );
	assertEquals( e3.prev, e1 );
	assertEquals( e3.next, null );

	// unlink tail
	e3.unlink();
	assertEquals( e1.prev, null );
	assertEquals( e1.next, null );
	assertEquals( e3.prev, null );
	assertEquals( e3.next, null );
}

/**
 *
 */
function testTask()
{
	inform( arguments.callee.name );

	// Task
	var task = new Task();

	assertEquals( task.status, 0 );
	assertNull( task.command );
}

/**
 *
 */
function testTask_setStatus()
{
	inform( arguments.callee.name );

	// Task
	var t1	= new Task();
	t1.interfaces =
	[
		{ update : function() {}, prop : "ppp" }
	];

	t1.setStatus( 0 );
	assertEquals( t1.update, t1.interfaces[0].update );
	assertEquals( t1.prop, t1.interfaces[0].prop );
}

/**
 *
 */
function testTask_update()
{
	inform( arguments.callee.name );

	// Task
	var t1	= new Task();

	var ret	= t1.update( null );
	assertFalse( ret );
}

/**
 *
 */
function testTask_draw()
{
	inform( arguments.callee.name );

	// Task
	var t1	= new Task();

	var ret	= t1.draw( null );
}

/**
 *
 */
function testTask_updateChildren()
{
	inform( arguments.callee.name );

	// Task
	var parent	= new Task();
	var child	= new Task();
	parent.child = child;

	var ret	= parent.updateChildren( null );
	assertFalse( ret );
}

/**
 *
 */
function testTask_drawChildren()
{
	inform( arguments.callee.name );

	// Task
	var parent	= new Task();
	var child	= new Task();
	parent.child = child;

	var ret	= parent.drawChildren( null );
}

/**
 *
 */
function testSoundTask()
{
	inform( arguments.callee.name );

	// SoundTask
	var sound = new SoundTask( null );
	assertFalse( sound.loop );
}

/**
 *
 */
function testSoundTask_prepare()
{
	inform( arguments.callee.name );

	// SoundTask
	var sound = new SoundTask( null );

	var ad = null;
	sound.prepare( ad );
	assertEquals( sound.audio, ad );
	assertTrue( sound.play );
	assertFalse( sound.loop );
}

/**
 *
 */
function testSoundTask_prepareLoop()
{
	inform( arguments.callee.name );

	// SoundTask
	var sound = new SoundTask( null );

	var ad = null;
	sound.prepareLoop( ad );
	assertEquals( sound.audio, ad );
	assertTrue( sound.play );
	assertTrue( sound.loop );
}

/**
 *
 */
function testSoundTask_cancel()
{
	inform( arguments.callee.name );

	// SoundTask
	var sound = new SoundTask( null );

	var ad = null;
	sound.cancel( ad );
	assertEquals( sound.audio, ad );
	assertFalse( sound.play );
	assertFalse( sound.loop );
}

/**
 *
 */
function testSoundTask_update()
{
	inform( arguments.callee.name );

	// SoundTask
	var sound = new SoundTask( null );

	var ret = sound.update( null );
	assertFalse( ret );
}

/**
 *
 */
function testReadyTask()
{
	inform( arguments.callee.name );

	// ReadyTask
	var ready = new ReadyTask( null );
}

/**
 *
 */
//function testReadyTask_draw()

/**
 *
 */
function testImageAnimator()
{
	inform( arguments.callee.name );

	var image	= {};
	var anim	= { fw : 0, fh : 0, frames : {} };

	// ImageAnimator
	var animator = new ImageAnimator( image, anim );

	assertEquals( animator.image, image );
	assertEquals( animator.anim, anim );
}

/**
 *
 */
function testImageAnimator_start()
{
	inform( arguments.callee.name );

	var image	= {};
	var anim	= { fw : 0, fh : 0, frames : {} };

	// ImageAnimator
	var animator = new ImageAnimator( image, anim );

	// start
	animator.start();
	assertEquals( animator.count, 1 );
}

/**
 *
 */
function testImageAnimator_proceed()
{
	inform( arguments.callee.name );

	var image	= {};
	var anim	= { fw : 0, fh : 0, frames : {} };

	// ImageAnimator
	var animator = new ImageAnimator( image, anim );

	// proceed
	animator.proceed();
	assertEquals( animator.count, 1 );
}

/**
 *
 */
function testImageAnimator_isActive()
{
	inform( arguments.callee.name );

	var image	= {};
	var anim	= { fw : 0, fh : 0, frameCount : 10, frames : {} };

	// ImageAnimator
	var animator = new ImageAnimator( image, anim );

	// proceed
	var ret = animator.isActive();
	assertTrue( ret );
}

/**
 *
 */
function testMessage()
{
	inform( arguments.callee.name );

	var type = 1;

	// Message
	var message = new Message( type );

	assertEquals( message.type, type );
}

/**
 *
 */
function testMessageHandler()
{
	inform( arguments.callee.name );

	var type	= 1;
	var object	= new function()
	{
		this.func = function( scene, message ) {};
	}();

	// MessageHandler
	var mh = new MessageHandler( type, object, object.func );

	assertEquals( mh.type, type );
	assertEquals( mh.object, object );
	assertEquals( mh.func, object.func );
}

/**
 *
 */
function testMessageManager()
{
	inform( arguments.callee.name );

	// MessageManager
	var mm = new MessageManager();
}

/**
 *
 */
function testMessageManager_addHandler()
{
	inform( arguments.callee.name );

	// MessageManager
	var mm = new MessageManager();

	var type = 1;
	// MessageHandler
	var mh = new MessageHandler( type, null, null );

	// add
	mm.addHandler( mh );
	assertEquals( mm.handlers[ type ].array[0], mh );
}

/**
 *
 */
function testMessageManager_removeHandler()
{
	inform( arguments.callee.name );

	// MessageManager
	var mm = new MessageManager();

	var type = 1;
	// MessageHandler
	var mh = new MessageHandler( type, null, null );

	// add
	mm.addHandler( mh );
	// remove
	mm.removeHandler( mh );
	assertEquals( mm.handlers[ type ].array.length, 0 );
}

/**
 *
 */
function testMessageManager_getHandlerArray()
{
	inform( arguments.callee.name );

	// MessageManager
	var mm = new MessageManager();

	var type = 1;
	// MessageHandler
	var mh = new MessageHandler( type, null, null );

	// add
	mm.addHandler( mh );

	// get
	assertNotNull( mm.getHandlerArray( new Message( type ) ) );
	assertNull( mm.getHandlerArray( new Message( type + 1 ) ) );
}

/**
 *
 */
function testMessageManager_postMessage()
{
	inform( arguments.callee.name );

	// MessageManager
	var mm = new MessageManager();

	var type = 1;

	// post
	mm.postMessage( new Message( type ) );
	assertEquals( mm.queue.length, 1 );
}

/**
 *
 */
function testMessageManager_postBreakMessage()
{
	inform( arguments.callee.name );

	// MessageManager
	var mm = new MessageManager();

	var type = 1;

	// post
	mm.postBreakMessage( new Message( type ) );
	assertEquals( mm.breakQueue.length, 1 );
}

/**
 *
 */
function testMessageManager_handleMessages()
{
	inform( arguments.callee.name );

	var tmp = 0;

	// MessageManager
	var mm = new MessageManager();

	var type = 1;
	var object	= new function()
	{
		this.func = function( scene, message ) { tmp++; };
	}();

	// MessageHandler
	var mh = new MessageHandler( type, object, object.func );
	// add
	mm.addHandler( mh );

	// post
	mm.postMessage( new Message( type ) );
	mm.postBreakMessage( new Message( type ) );

	// handle
	mm.handleMessages( null );
	assertEquals( tmp, 2 );
}

/**
 *
 */
function testScene()
{
	inform( arguments.callee.name );

	// Scene
	var scene = new Scene();
	assertNull( scene.app );
}

/**
 *
 */
function testScene_setFocus()
{
	inform( arguments.callee.name );

	// Scene
	var scene = new Scene();

	// Task
	var task = new Task();

	// set
	scene.setFocus( task );
	assertEquals( scene.focus, task );
}

/**
 *
 */
function testScene_getFocus()
{
	inform( arguments.callee.name );

	// Scene
	var scene = new Scene();

	// Task
	var task = new Task();

	// set
	scene.setFocus( task );
	assertEquals( scene.getFocus(), task );
}

/**
 *
 */
//function testScene_setUsage()

/**
 *
 */
//function testScene_holdCanvas()

/**
 *
 */
function testScene_updateChildren()
{
	inform( arguments.callee.name );

	// Task
	var parent	= new Scene();
	var child	= new Task();
	parent.child = child;

	var ret	= parent.updateChildren( null );
	assertFalse( ret );
}

/**
 *
 */
function testScene_loopReady()
{
	inform( arguments.callee.name );

	// Task
	var parent	= new Scene();

	// loop
	var ret	= parent.loopReady();
	assertEquals( parent.ticks, 1 );
}

/**
 *
 */
function testScene_loopRunning()
{
	inform( arguments.callee.name );

	// Task
	var parent	= new Scene();
	var child	= new Task();
	parent.child = child;

	// loop
	var ret	= parent.loopRunning();
	assertEquals( parent.ticks, 1 );
}

/**
 *
 */
//function testScene_drawReady()

/**
 *
 */
//function testScene_drawRunning()

/**
 *
 */
//function testScene_handleSysEvent()

/**
 *
 */
function testSceneManager()
{
	inform( arguments.callee.name );

	// SceneManager
	var sm	= new SceneManager();
}

/**
 *
 */
function testSceneManager_add()
{
	inform( arguments.callee.name );

	// SceneManager
	var sm	= new SceneManager();

	// Scene
	var s1	= new Scene();
	s1.name = "aaa";

	// add
	sm.add( s1 );
	assertEquals( sm.scenes[ s1.name ], s1 );
}

/**
 *
 */
function testSceneManager_push()
{
	inform( arguments.callee.name );

	// SceneManager
	var sm	= new SceneManager();

	// Scene
	var s1	= new Scene();
	s1.name = "aaa";

	// add
	sm.add( s1 );

	// push
	assertEquals( sm.push( s1.name ), s1 );
	assertEquals( sm.push( "bbb" ), null );
}

/**
 *
 */
function testSceneManager_pop()
{
	inform( arguments.callee.name );

	// SceneManager
	var sm	= new SceneManager();

	// Scene
	var s1	= new Scene();
	s1.name = "aaa";
	var s2	= new Scene();
	s2.name = "bbb";

	// add
	sm.add( s1 );
	sm.add( s2 );

	// push
	sm.push( s1.name );
	sm.push( s2.name );

	// pop
	assertEquals( sm.pop(), s2 );
	assertEquals( sm.pop(), null );
}

/**
 *
 */
//function testSceneManager_init()

/**
 *
 */
function testSceneManager_loop()
{
	inform( arguments.callee.name );

	// SceneManager
	var sm	= new SceneManager();
	// Scene
	var s1	= new Scene();
	s1.setStatus( SceneStatus.RUNNING );
	// add
	sm.add( s1 );
	// push
	sm.push( s1.name );

	// loop
	sm.loop();
}

/**
 *
 */
//function testSceneManager_handleSysEvent()

/**
 *
 */
function testApplication()
{
	inform( arguments.callee.name );

	// Application
	var app	= new Application();
}

/**
 *
 */
function testApplication_runLoop()
{
	inform( arguments.callee.name );

	// Application
	var app	= new Application();

	// Scene
	var s1	= new Scene();
	s1.setStatus( SceneStatus.RUNNING );
	// add
	app.sceneManager.add( s1 );
	// push
	app.sceneManager.push( s1.name );

	// runLoop
	app.runLoop();

	// kill
	app.kill();
	assertEquals( app.status, AppStatus.ERROR );
}

/**
 *
 */
function testApplication_kill()
{
	inform( arguments.callee.name );

	// Application
	var app	= new Application();

	// kill
	app.kill();
	assertEquals( app.status, AppStatus.ERROR );
}

/**
 *
 */
//function testApplication_loadScript()

/**
 *
 */
//function testApplication_getDomElement()

/**
 *
 */
function testApplication_createXMLHttpRequest()
{
	inform( arguments.callee.name );

	// Application
	var app	= new Application();

	// createXMLHttpRequest
	var req = app.createXMLHttpRequest();
	assertNotNull( req );
}
/**
 *
 */
//function testApplication_loadResource()

/**
 *
 */
//function testApplication_handleSysEvent()

/**
 *
 */
//function testApplication_preventSysEvent()

/**
 *
 */
//function testApplication_addSysEventHandler()

/**
 *
 */
//function testApplication_init()

