#include "stdafx.h"
#include "GVOTexture.h"
#include "GVOImage.h"




GVOTexture::GVOTexture() :
	m_texID()
{
	::glGenTextures( 1, &m_texID );
}


GVOTexture::~GVOTexture()
{
	if ( m_texID ) {
		unbind();
		::glDeleteTextures( 1, &m_texID );
	}
}


void GVOTexture::setImage( const GVOImage * image )
{
	m_image = image;
	if ( m_image ) {
		bind();

		::glPixelStorei( GL_UNPACK_ALIGNMENT, 1 );
		::glTexImage2D( GL_TEXTURE_2D, 0, GL_RGB,
			m_image->width(), m_image->height(),
			0, GL_BGR_EXT,
			GL_UNSIGNED_BYTE, m_image->imageBits() );

		unbind();
	}
}


void GVOTexture::bind()
{
	::glEnable( GL_TEXTURE_2D );
	::glBindTexture( GL_TEXTURE_2D, m_texID );

	::glTexEnvi( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE );

	::glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
	::glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
}


void GVOTexture::unbind()
{
	::glBindTexture( GL_TEXTURE_2D, 0 );
	::glDisable( GL_TEXTURE_2D );
}
