// ************************************************************
#include "stdafx.h"

#define	GSGETFILEDLL_NAME		_T("\\gsgetfile.dll")
#define	GSGETFILESTDDLL_NAME	_T("\\gsgetfile.dll.std")

#define	MUI_EN_NAME			_T("\\*.*.0409.mui")

#define	REG_KEY_SETTINGS	_T("Software\\goripon\\GSFinder-W03\\Settings")

#define	TXT_OLD_NAME		_T("\\ShellNew\\shellnew.txt")
#define	TXT_NEW_NAME		_T("\\ShellNew\\eLXg hLg.txt")
#define	XLSX_OLD_NAME		_T("\\ShellNew\\shellnew.xlsx")
#define	XLSX_NEW_NAME		_T("\\ShellNew\\Excel 2007 ubN.xlsx")
#define	DOCX_OLD_NAME		_T("\\ShellNew\\shellnew.docx")
#define	DOCX_NEW_NAME		_T("\\ShellNew\\Word 2007 .docx")

#define	LINK_NAME			_T("\\GSFinder+W03.lnk")

HINSTANCE g_hinstModule;

BOOL IsSmartphone;
BOOL IsJapanese;
LCID LocaleID;



// ************************************************************
BOOL APIENTRY DllMain(HANDLE hModule, DWORD ul_reason_for_call, LPVOID lpReserved)
{
	TCHAR szTemp[MAX_PATH * 2];

	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		g_hinstModule = (HINSTANCE)hModule;
		if (SystemParametersInfo(SPI_GETPLATFORMTYPE, MAX_PATH, szTemp, 0))
			IsSmartphone = (_tcsicmp(szTemp, _T("Smartphone")) == 0);
		else
			IsSmartphone = FALSE;
		LocaleID = GetUserDefaultLCID();
		IsJapanese = (LocaleID == 0x411);
		break;
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}
	return TRUE;
}


// **************************************************************************
SETUP_API codeINSTALL_INIT Install_Init(HWND hwndParent,BOOL fFirstCall, BOOL fPreviouslyInstalled, LPCTSTR pszInstallDir)
{
	return codeINSTALL_INIT_CONTINUE;
}


// **************************************************************************
SETUP_API codeINSTALL_EXIT Install_Exit(HWND hwndParent, LPCTSTR pszInstallDir, WORD cFailedDirs, WORD cFailedFiles, WORD cFailedRegKeys, WORD cFailedRegVals, WORD cFailedShortcuts)
{
	//̔

	//gsGetFile.dll̃t@CύX
	TCHAR szDllPath[MAX_PATH * 2];
	TCHAR szStdDllPath[MAX_PATH * 2];
	_tcscpy(szDllPath, pszInstallDir);
	_tcscat(szDllPath, GSGETFILEDLL_NAME);
	_tcscpy(szStdDllPath, pszInstallDir);
	_tcscat(szStdDllPath, GSGETFILESTDDLL_NAME);
	if (IsSmartphone)
	{
		DeleteFile(szDllPath);
		MoveFile(szStdDllPath, szDllPath);
	}
	DeleteFile(szStdDllPath);

	//Smartphone/StandardŉpMUIⓚpŗLɂȂdlւ̑Ώ
	//({Smartphone/StandardȂMUI폜)
	if (IsJapanese && IsSmartphone)
	{
		TCHAR szTemp[MAX_PATH * 2];
		_tcscpy(szTemp, pszInstallDir);
		_tcscat(szTemp, MUI_EN_NAME);
		DeleteFile(szTemp);
	}

	//ShellNewt@C̕ύX
	TCHAR szOld[MAX_PATH * 2];
	TCHAR szNew[MAX_PATH * 2];
	_tcscpy(szOld, pszInstallDir);
	_tcscat(szOld, TXT_OLD_NAME);
	_tcscpy(szNew, pszInstallDir);
	_tcscat(szNew, TXT_NEW_NAME);
	MoveFile(szOld, szNew);
	_tcscpy(szOld, pszInstallDir);
	_tcscat(szOld, XLSX_OLD_NAME);
	_tcscpy(szNew, pszInstallDir);
	_tcscat(szNew, XLSX_NEW_NAME);
	MoveFile(szOld, szNew);
	_tcscpy(szOld, pszInstallDir);
	_tcscat(szOld, DOCX_OLD_NAME);
	_tcscpy(szNew, pszInstallDir);
	_tcscat(szNew, DOCX_NEW_NAME);
	MoveFile(szOld, szNew);

	//SendTo/ShellNewpX̍XV(tH_ۂ̎̂)
	HKEY hKey;
	DWORD dwDisposition;
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_SETTINGS, 0, _T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
		DWORD dwDataSize;
		TCHAR szTemp[MAX_PATH * 2];
		WIN32_FIND_DATA wfd;
		HANDLE hfind;
		//m_szSendAppPath
		dwDataSize = sizeof(szTemp);
		if (RegQueryValueEx(hKey, _T("SendAppPath"), 0, NULL, (LPBYTE)szTemp, &dwDataSize) == ERROR_SUCCESS)
		{
			_tcscat(szTemp, _T("\\*.*"));
			hfind = FindFirstFile(szTemp, &wfd);
			if (hfind != INVALID_HANDLE_VALUE)
				FindClose(hfind);
			else
			{
				_tcscpy(szTemp, pszInstallDir);
				_tcscat(szTemp, _T("\\SendTo"));
				RegSetValueEx(hKey, _T("SendAppPath"), 0, REG_SZ, (LPBYTE)szTemp, ((_tcslen(szTemp)+1) * sizeof(TCHAR)));
			}
		}
		//m_szShellNewPath
		dwDataSize = sizeof(szTemp);
		if (RegQueryValueEx(hKey, _T("ShellNewPath"), 0, NULL, (LPBYTE)szTemp, &dwDataSize) == ERROR_SUCCESS)
		{
			_tcscat(szTemp, _T("\\*.*"));
			hfind = FindFirstFile(szTemp, &wfd);
			if (hfind != INVALID_HANDLE_VALUE)
				FindClose(hfind);
			else
			{
				_tcscpy(szTemp, pszInstallDir);
				_tcscat(szTemp, _T("\\ShellNew"));
				RegSetValueEx(hKey, _T("ShellNewPath"), 0, REG_SZ, (LPBYTE)szTemp, ((_tcslen(szTemp)+1) * sizeof(TCHAR)));
			}
		}
	}

	return codeINSTALL_EXIT_DONE;
}


// **************************************************************************
SETUP_API codeUNINSTALL_INIT Uninstall_Init(HWND hwndParent, LPCTSTR pszInstallDir)
{
	TCHAR szTemp[MAX_PATH*2];

	//N폜
	SHGetSpecialFolderPath(hwndParent, szTemp, CSIDL_PROGRAMS, FALSE);
	_tcscpy(_tcsrchr(szTemp, _T('\\')), LINK_NAME);
	DeleteFile(szTemp);

	//ShellNewt@C̕A
	TCHAR szOld[MAX_PATH*2];
	TCHAR szNew[MAX_PATH*2];
	_tcscpy(szOld, pszInstallDir);
	_tcscat(szOld, TXT_OLD_NAME);
	_tcscpy(szNew, pszInstallDir);
	_tcscat(szNew, TXT_NEW_NAME);
	MoveFile(szNew, szOld);
	_tcscpy(szOld, pszInstallDir);
	_tcscat(szOld, XLSX_OLD_NAME);
	_tcscpy(szNew, pszInstallDir);
	_tcscat(szNew, XLSX_NEW_NAME);
	MoveFile(szNew, szOld);
	_tcscpy(szOld, pszInstallDir);
	_tcscat(szOld, DOCX_OLD_NAME);
	_tcscpy(szNew, pszInstallDir);
	_tcscat(szNew, DOCX_NEW_NAME);
	MoveFile(szNew, szOld);

	return codeUNINSTALL_INIT_CONTINUE;
}


// **************************************************************************
SETUP_API codeUNINSTALL_EXIT Uninstall_Exit(HWND hwndParent)
{
	return codeUNINSTALL_EXIT_DONE;
}
