////////////////////////////////////////////////////////////////
//DeleteDlg.cpp
//폜_CAO֌W - DeleteDlg, DeleteMsg

///////////////////////////////////////////////////////////////
//INCLUDE
#include "GSFinder.h"
#include "DeleteDlg.h"

////////////////////////////////////////////////////////////////
typedef struct _tagDeleteThread
{
	int m_nCount;
	BOOL* m_pbCancel;
	LISTITEMINFO* m_lpliinfo;
	LPCTSTR m_lpszFolder;
	HWND m_hWnd; 
} DELETETHREAD;

/////////////////////////////////////////////////////////////////////////////
CDeleteFileDlg::CDeleteFileDlg()
{
	m_nCount = 0;
	m_bCancel = FALSE;
	m_lpliinfo = NULL;
	m_lpszFolder = NULL;
	m_hWnd = NULL;
	m_bTimerReset = TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//t@C폜
BOOL DeleteFileWithMessage(LPCTSTR lpszPath, int* lpRetCode, HWND hDlg, BOOL* pbDone)
{
	CDeleteFileDlg* pdfd = (CDeleteFileDlg*)GetWindowLong(hDlg, GWL_USERDATA);

	if (pbDone)
		*pbDone = FALSE;

	//\
	LPTSTR lpszFileName = _tcsrchr(lpszPath, _T('\\'));
	if (!lpszFileName)
		lpszFileName = (LPTSTR)lpszPath;
	else
		++lpszFileName;
	SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), lpszFileName);

	//mFbZ[W\
	if (*lpRetCode == RETCODE_YES || *lpRetCode == RETCODE_NO)
	{
		TCHAR szMsg[128];
		DWORD dwAttr = GetFileAttributes(lpszPath);
		if (dwAttr & FILE_ATTRIBUTE_SYSTEM)
		{
			_stprintf(szMsg, GetResourceString(IDS_FMT_DEL_SYSTEM), lpszFileName);
			SendMessage(hDlg, WM_SHOWMSG, (WPARAM)szMsg, 0);
			*lpRetCode = pdfd->m_nRetCode;
		}
		else if (dwAttr & FILE_ATTRIBUTE_READONLY)
		{
			_stprintf(szMsg, GetResourceString(IDS_FMT_DEL_READONLY), lpszFileName);
			SendMessage(hDlg, WM_SHOWMSG, (WPARAM)szMsg, 0);
			*lpRetCode = pdfd->m_nRetCode;
		}
	}

	//̏ꍇ폜Ȃ
	if (*lpRetCode == RETCODE_NO || *lpRetCode == RETCODE_ALL_NO)
	{
		return TRUE;
	}

	//ۂ̍폜
	SetFileAttributes(lpszPath, FILE_ATTRIBUTE_NORMAL);
	if (!DeleteFile(lpszPath))
	{
		return FALSE;
	}

	TCHAR szTemp[32];
	pdfd->m_nExecCount += 1;
	_stprintf(szTemp, _T("%d/%d"), pdfd->m_nExecCount, pdfd->m_nFileCount);
	SetWindowText(GetDlgItem(hDlg, IDC_PROG_TEXT), szTemp);
	SendMessage(GetDlgItem(hDlg, IDC_PROGRESS), PBM_SETPOS, pdfd->m_nExecCount, 0);

	if (pbDone)
		*pbDone = TRUE;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL DeleteFolder(LPCTSTR lpszPath, BOOL* lpCancelMode, int* lpRetCode, HWND hDlg, BOOL* pbDone)
{
	CDeleteFileDlg* pdfd = (CDeleteFileDlg*)GetWindowLong(hDlg, GWL_USERDATA);

	if (pbDone)
		*pbDone = FALSE;

	//\
	LPTSTR lpszFileName = _tcsrchr(lpszPath, _T('\\'));
	if (!lpszFileName)
	{
		lpszFileName = (LPTSTR)lpszPath;
	}
	else
	{
		++lpszFileName;
	}
	SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), lpszFileName);

	//폜mF
	if (*lpRetCode == RETCODE_YES || *lpRetCode == RETCODE_NO)
	{
		TCHAR szMsg[128];
		_stprintf(szMsg, GetResourceString(IDS_FMT_DEL_FOLDER), lpszFileName);

		SendMessage(hDlg, WM_SHOWMSG, (WPARAM)szMsg, 0);
		*lpRetCode = pdfd->m_nRetCode;
	}
	//̏ꍇ폜Ȃ
	if (*lpRetCode == RETCODE_NO || *lpRetCode == RETCODE_ALL_NO)
	{
		return TRUE;
	}

	//폜tH_̃t@C
	TCHAR szTemp[MAX_PATH+4];
	_stprintf(szTemp, _T("%s\\*.*"), lpszPath);
	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do{
			int nRetCode = RETCODE_ALL_YES;
			if (*lpCancelMode)
			{
				FindClose(hFind);
				return TRUE;
			}
			if (finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			{
				//tH_
				LPTSTR lpszFolderPath = new TCHAR[_tcslen(lpszPath)+_tcslen(finddata.cFileName)+2];
				_stprintf(lpszFolderPath, _T("%s\\%s"), lpszPath, finddata.cFileName);
				if (!DeleteFolder(lpszFolderPath, lpCancelMode, &nRetCode, hDlg, NULL))
				{
					FindClose(hFind);
					delete[] lpszFolderPath;
					return FALSE;
				}
				delete[] lpszFolderPath;
			}
			else
			{
				//t@C
				LPTSTR lpszFilePath = new TCHAR[_tcslen(lpszPath)+_tcslen(finddata.cFileName)+2];
				_stprintf(lpszFilePath, _T("%s\\%s"), lpszPath, finddata.cFileName);
				if (!DeleteFileWithMessage(lpszFilePath, &nRetCode, hDlg, NULL))
				{
					FindClose(hFind);
					delete[] lpszFilePath;
					return FALSE;
				}
				delete[] lpszFilePath;
			}
		}while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}

	pdfd->m_nExecCount += 1;
	_stprintf(szTemp, _T("%d/%d"), pdfd->m_nExecCount, pdfd->m_nFileCount);
	SetWindowText(GetDlgItem(hDlg, IDC_PROG_TEXT), szTemp);
	SendMessage(GetDlgItem(hDlg, IDC_PROGRESS), PBM_SETPOS, pdfd->m_nExecCount, 0);

	BOOL bRet = RemoveDirectory(lpszPath);

	if (pbDone)
		*pbDone = bRet;

	return bRet;
}

/////////////////////////////////////////////////////////////////////////////
//폜̃[J[Xbh
DWORD WINAPI DeleteFileThread(LPVOID pParam)
{
	DELETETHREAD* pdt = (DELETETHREAD*)pParam;

	int nRetCode = RETCODE_YES;
	
	if (pdt->m_nCount < 2)
		nRetCode = RETCODE_ALL_YES;

	for (int i=0; i<pdt->m_nCount; i++)
	{
		if (*pdt->m_pbCancel)
		{
			SetWindowText(GetDlgItem(pdt->m_hWnd, IDC_FILE_NAME), GetResourceString(IDS_MSG_CANCELED));
			SendMessage(pdt->m_hWnd, WM_DLGCLOSE, 0, 0);
			ExitThread(0);
			return 0;
		}

		//\
		TCHAR szTemp[MAX_PATH+4];
		TCHAR szPath[MAX_PATH];
		LPTSTR lpszTemp = _tcsrchr(pdt->m_lpliinfo[i].szPath, _T('\\'));
		if (lpszTemp)
			_tcscpy(szPath, ++lpszTemp);
		else
			_tcscpy(szPath, _T("\\"));

		_stprintf(szTemp, GetResourceString(IDS_FMT_DELFROM), szPath);
		SetWindowText(GetDlgItem(pdt->m_hWnd, IDC_FOLDER), szTemp);

		memset(&szPath, 0, sizeof(szPath));
		_stprintf(szPath, _T("%s\\%s"), pdt->m_lpliinfo[i].szPath, pdt->m_lpliinfo[i].szName);

		//ۂ̍폜
		if (pdt->m_lpliinfo[i].nItem == LIST_ITEM_FOLDER)
		{
			if (_tcsicmp(g_MainWnd.m_szWindowsPath, szPath) == 0)
			{
				MessageBox(pdt->m_hWnd, GetResourceString(IDS_MSG_PASTEERROR3), NULL, MB_OK|MB_ICONSTOP);
				SetWindowText(GetDlgItem(pdt->m_hWnd, IDC_FILE_NAME), GetResourceString(IDS_MSG_PASTEERROR3));
				SendMessage(pdt->m_hWnd, WM_DLGCLOSE, 0, 0);
				ExitThread(0);
				return 0;
			}

			//tH_̍폜
			if (!DeleteFolder(szPath, pdt->m_pbCancel, &nRetCode, pdt->m_hWnd, &pdt->m_lpliinfo[i].bDone))
			{
				SendMessage(pdt->m_hWnd, WM_SHOWERRMSG, (WPARAM)pdt->m_lpliinfo[i].szName, 0);
				SetWindowText(GetDlgItem(pdt->m_hWnd, IDC_FILE_NAME), GetResourceString(IDS_MSG_CANCELED));
				SendMessage(pdt->m_hWnd, WM_DLGCLOSE, 0, 0);
				ExitThread(0);
				return 0;
			}
		}
		else if (pdt->m_lpliinfo[i].nItem == LIST_ITEM_FILE)
		{
			//t@C̍폜
			if (!DeleteFileWithMessage(szPath, &nRetCode, pdt->m_hWnd, &pdt->m_lpliinfo[i].bDone))
			{
				SendMessage(pdt->m_hWnd, WM_SHOWERRMSG, (WPARAM)pdt->m_lpliinfo[i].szName, 0);
				SetWindowText(GetDlgItem(pdt->m_hWnd, IDC_FILE_NAME), GetResourceString(IDS_MSG_CANCELED));
				SendMessage(pdt->m_hWnd, WM_DLGCLOSE, 0, 0);
				ExitThread(0);
				return 0;
			}
		}
		if (nRetCode == RETCODE_ALL_NO)
		{
			SetWindowText(GetDlgItem(pdt->m_hWnd, IDC_FILE_NAME), GetResourceString(IDS_MSG_CANCELED));
			SendMessage(pdt->m_hWnd, WM_DLGCLOSE, 0, 0);
			ExitThread(0);
			return 0;
		}
	} // End of for
	
	SetWindowText(GetDlgItem(pdt->m_hWnd, IDC_FILE_NAME), GetResourceString(IDS_MSG_DONE));
	SendMessage(pdt->m_hWnd, WM_DLGCLOSE, 0, 0);
	ExitThread(0);
	return 0;
}
////////////////////////////////////////////////////////////////
void CDeleteFileDlg::OnInitDialog(HWND hDlg)
{
	TCHAR szTemp[32];

	m_nExecCount = 0;
	m_bCancel = FALSE;
	m_hWnd = hDlg;
	CenterWindow(hDlg);

	SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), GetResourceString(IDS_MSG_PREP_DEL));
	m_nFileCount = GetFileAndFolderCount(m_lpszFolder, m_lpliinfo, m_nCount);
	SendMessage(GetDlgItem(hDlg, IDC_PROGRESS), PBM_SETRANGE, 0, MAKELPARAM(0, m_nFileCount));	
	_stprintf(szTemp, _T("0/%d"), m_nFileCount);
	SetWindowText(GetDlgItem(hDlg, IDC_PROG_TEXT), szTemp);

	CenterWindow(hDlg);
	ShowWindow(hDlg, SW_SHOW);

	static DELETETHREAD DeleteThread;
	DeleteThread.m_nCount = m_nCount;
	DeleteThread.m_pbCancel = &m_bCancel;
	DeleteThread.m_lpliinfo = m_lpliinfo;
	DeleteThread.m_lpszFolder = m_lpszFolder;
	DeleteThread.m_hWnd = m_hWnd;

	m_hThread = CreateThread(NULL, 0, DeleteFileThread, (LPVOID)&DeleteThread, 0, &m_dwThreadID);
}
////////////////////////////////////////////////////////////////
LRESULT CALLBACK DeleteFileDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	CDeleteFileDlg* pdfd = (CDeleteFileDlg*)GetWindowLong(hDlg, GWL_USERDATA);

	switch (message)
	{
	case WM_INITDIALOG:
		//DialogBoxParamœnꂽCDeleteFileDlg̃CX^XUSERDATAɊi[
		SetWindowLong(hDlg, GWL_USERDATA, lParam);
		pdfd = (CDeleteFileDlg*)lParam;
		//
		pdfd->OnInitDialog(hDlg);
		SetTimer(hDlg, ID_TIMER_RESETTIME, TIMER_RESETTIME_INT, NULL);
		return TRUE;

	case WM_COMMAND:
		{
			int wmId    = LOWORD(wParam); 
			int wmEvent = HIWORD(wParam); 
			switch (wmId)
			{
			case IDC_CANCELMODE:
				{
					pdfd->m_bCancel = TRUE;
					EnableWindow(GetDlgItem(hDlg, IDC_CANCELMODE), FALSE);
					SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), GetResourceString(IDS_MSG_CANCELING));
				}
				return TRUE;

			default:
				break;
			}
		}
		break;

	case WM_DLGCLOSE:
		CloseHandle(pdfd->m_hThread);
		KillTimer(hDlg, ID_TIMER_RESETTIME);
		EndDialog(hDlg, 0);
		return TRUE;

	case WM_SHOWMSG:
		pdfd->ShowDeleteMessage((LPTSTR)wParam);
		return TRUE;

	case WM_SHOWERRMSG:
		pdfd->ShowErrorMessage((LPTSTR)wParam);
		return TRUE;

	case WM_TIMER:
		if (wParam == ID_TIMER_RESETTIME && pdfd->m_bTimerReset)
			SystemIdleTimerReset();
		return TRUE;

	default:
		break;
	}

	return FALSE;
}

////////////////////////////////////////////////////////////////
LRESULT CALLBACK DeleteMsgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	CDeleteFileDlg* pdfd = (CDeleteFileDlg*)GetWindowLong(hDlg, GWL_USERDATA);

	switch (message)
	{
	case WM_INITDIALOG:
		//DialogBoxParamœnꂽCDeleteFileDlg̃CX^XUSERDATAɊi[
		SetWindowLong(hDlg, GWL_USERDATA, lParam);
		pdfd = (CDeleteFileDlg*)lParam;
		//
		CenterWindow(hDlg);
		pdfd->m_nRetCode = RETCODE_YES;
		SetWindowText(GetDlgItem(hDlg, IDC_DELETE_MSG), pdfd->m_szDeleteMsg);
		if (pdfd->m_bFirst)
		{
			ShowWindow(GetDlgItem(hDlg, IDC_BTN_ALL_YES), SW_HIDE);
			ShowWindow(GetDlgItem(hDlg, IDC_BTN_ALL_NO), SW_HIDE);
			RECT rc, rcby, rcbay;
			GetWindowRect(hDlg, &rc);
			GetWindowRect(GetDlgItem(hDlg, IDC_BTN_YES), &rcby);
			GetWindowRect(GetDlgItem(hDlg, IDC_BTN_ALL_YES), &rcbay);
			SetWindowPos(hDlg, HWND_TOP, 0, 0, RECT_WIDTH(&rc), RECT_HEIGHT(&rc)-(RECT_HEIGHT(&rcbay)+(rcbay.top-rcby.bottom)), SWP_NOMOVE|SWP_NOZORDER);
			CenterWindow(hDlg);
		}
		return TRUE;

	case WM_COMMAND:
		{
			int wmId    = LOWORD(wParam);
			int wmEvent = HIWORD(wParam);
			switch (wmId)
			{
			case IDC_BTN_YES:
				pdfd->m_nRetCode = RETCODE_YES;
				EndDialog(hDlg, IDOK);
				return TRUE;

			case IDC_BTN_NO:
				pdfd->m_nRetCode = RETCODE_NO;
				EndDialog(hDlg, IDCANCEL);
				return TRUE;

			case IDC_BTN_ALL_YES:
				pdfd->m_nRetCode = RETCODE_ALL_YES;
				EndDialog(hDlg, IDOK);
				return TRUE;

			case IDC_BTN_ALL_NO:
				pdfd->m_nRetCode = RETCODE_ALL_NO;
				EndDialog(hDlg, IDCANCEL);
				return TRUE;

			default:
				break;
			}
		}
		break;

	case WM_CLOSE:
		pdfd->m_nRetCode = RETCODE_NO;
		EndDialog(hDlg, IDCANCEL);
		return TRUE;

	default:
		break;
	}

	return FALSE;
}
////////////////////////////////////////////////////////////////
void CDeleteFileDlg::ShowErrorMessage(LPTSTR lspzFileName)
{
	TCHAR szTemp[MAX_PATH];

	m_bTimerReset = FALSE;
	_stprintf(szTemp, GetResourceString(IDS_FMT_DELERROR), lspzFileName);
	m_bTimerReset = TRUE;
	MessageBox(m_hWnd, szTemp, NULL, MB_OK|MB_ICONSTOP);
}
////////////////////////////////////////////////////////////////
int CDeleteFileDlg::ShowDeleteMessage(LPTSTR lpszMsg)
{
	_tcscpy(m_szDeleteMsg, lpszMsg);
	m_bTimerReset = FALSE;
	DialogBoxParam(g_hInst, (LPCTSTR)IDD_DELETEMSG_DLG, m_hWnd, (DLGPROC)DeleteMsgProc, LPARAM(this));
	m_bTimerReset = TRUE;

	return m_nRetCode;
}
////////////////////////////////////////////////////////////////
int CDeleteFileDlg::ShowDeleteFileDlg(LPCTSTR lpszFolder, LISTITEMINFO* lpliinfo, int nCount)
{
	m_lpszFolder = lpszFolder;
	m_lpliinfo = lpliinfo;
	m_nCount = nCount;

	//ŏ̊mF
	m_bFirst = TRUE;
	if (m_nCount > 1)
		_stprintf(m_szDeleteMsg, GetResourceString(IDS_FMT_DELOBJECTS), m_nCount);
	else
	{
		LPCTSTR lpszFileName = _tcsrchr(m_lpliinfo[0].szName, _T('\\'));
		if (m_lpliinfo[0].nItem == LIST_ITEM_FOLDER)
			_stprintf(m_szDeleteMsg, GetResourceString(IDS_FMT_DEL_FOLDER), lpszFileName? ++lpszFileName: m_lpliinfo[0].szName);
		else
			_stprintf(m_szDeleteMsg, GetResourceString(IDS_FMT_DEL_FILE), lpszFileName? ++lpszFileName: m_lpliinfo[0].szName);
	}
	int nRet = DialogBoxParam(g_hInst, (LPCTSTR)IDD_DELETEMSG_DLG, g_MainWnd.m_hWnd, (DLGPROC)DeleteMsgProc, LPARAM(this));
	
	if (nRet == IDOK)
	{
		m_bFirst = FALSE;
		DisableUpdateNotify();
		DialogBoxParam(g_hInst, (LPCTSTR)IDD_FILEDELETE_DLG, g_MainWnd.m_hWnd, (DLGPROC)DeleteFileDlgProc, LPARAM(this));
		EnableUpdateNotify();
	}

	return nRet;
}
