////////////////////////////////////////////////////////////////
//CopyDlg.cpp
//Rs[_CAO֌W - CopyDlg, OverWriteDlg, FolderOverWriteDlg

///////////////////////////////////////////////////////////////
//INCLUDE
#include "GSFinder.h"
#include "CopyDlg.h"

#define ID_THREAD_COPY 1

////////////////////////////////////////////////////////////////
typedef struct _tagCopyThread
{
	int m_nCount;
	BOOL* m_pbCancel;
	BOOL m_bFileMove;
	LISTITEMINFO* m_lpliinfo;
	LPCTSTR m_lpszFolderFrom;
	LPCTSTR m_lpszFolderTo;
	HWND m_hWnd; 
} COPYTHREAD;

////////////////////////////////////////////////////////////////
CCopyFileDlg::CCopyFileDlg()
{
	m_nCount = 0;
	m_bCancel = FALSE;
	m_bFileMove = FALSE;
	m_lpliinfo = NULL;
	m_lpszFolderFrom = NULL;
	m_lpszFolderTo = NULL;
	m_hWnd = NULL; 
	m_bTimerReset = TRUE;
}

////////////////////////////////////////////////////////////////
BOOL CopyFileWithMessage(LPCTSTR lpszPathFrom, LPCTSTR lpszPathTo, int* lpOverWrite, HWND hDlg, BOOL bFileMove)
{
	CCopyFileDlg* pcfd = (CCopyFileDlg*)GetWindowLong(hDlg, GWL_USERDATA);

	//\
	LPTSTR lpszFileName = _tcsrchr(lpszPathFrom, _T('\\'));
	if (!lpszFileName)
		lpszFileName = (LPTSTR)lpszPathFrom;
	else
		++lpszFileName;
	SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), lpszFileName);

	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(lpszPathTo, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		FindClose(hFind);
		//t@C
		if (*lpOverWrite == RETCODE_YES || *lpOverWrite == RETCODE_NO)
		{
			SendMessage(hDlg, WM_SHOWOWMSG, (WPARAM)lpszPathTo, (LPARAM)lpszPathFrom);
			*lpOverWrite = pcfd->m_nRetCode;
		}
		if (*lpOverWrite == RETCODE_YES || *lpOverWrite == RETCODE_ALL_YES)
		{
			if (bFileMove)
			{
				SetFileAttributes(lpszPathTo, FILE_ATTRIBUTE_NORMAL);
				if (!DeleteFile(lpszPathTo))
					return FALSE;
				if (!MoveFile(lpszPathFrom, lpszPathTo))
					return FALSE;
			}
			else
			{
				SetFileAttributes(lpszPathTo, FILE_ATTRIBUTE_NORMAL);
				if (!CopyFile(lpszPathFrom, lpszPathTo, FALSE))
					return FALSE;
			}
		}
	}
	else
	{
		if (bFileMove)
		{
			if (!MoveFile(lpszPathFrom, lpszPathTo))
				return FALSE;
		}
		else
		{
			if (!CopyFile(lpszPathFrom, lpszPathTo, FALSE))
				return FALSE;
		}
	}

	TCHAR szTemp[32];
	pcfd->m_nExecCount += 1;
	_stprintf(szTemp, _T("%d/%d"), pcfd->m_nExecCount, pcfd->m_nFileCount);
	::SetWindowText(GetDlgItem(hDlg, IDC_PROG_TEXT), szTemp);
	SendMessage(GetDlgItem(hDlg, IDC_PROGRESS), PBM_SETPOS, pcfd->m_nExecCount, 0);

	return TRUE;
}

////////////////////////////////////////////////////////////////
BOOL CopyFolder(LPCTSTR lpszPathFrom, LPCTSTR lpszPathTo, BOOL* lpCancelMode, int* lpOverWrite, HWND hDlg, BOOL bFileMove)
{
	CCopyFileDlg* pcfd = (CCopyFileDlg*)GetWindowLong(hDlg, GWL_USERDATA);

	//\
	LPTSTR lpszFileName = _tcsrchr(lpszPathFrom, _T('\\'));
	if (!lpszFileName)
		lpszFileName = (LPTSTR)lpszPathFrom;
	else
		++lpszFileName;
	SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), lpszFileName);

	//VtH_쐬
	if (!CreateDirectory(lpszPathTo, NULL))
	{
		//ɃtH_̏㏑mFLq
		if (*lpOverWrite == RETCODE_YES || *lpOverWrite == RETCODE_NO)
		{
			SendMessage(hDlg, WM_SHOWFOLDEROWMSG, (WPARAM)lpszPathTo, 0);
			int nRet = pcfd->m_nRetCode;
			if (nRet == IDCANCEL)
				return TRUE;
		}
		if (*lpOverWrite == RETCODE_ALL_NO)
			return TRUE;
	}

	//ړtH_̃t@C
	TCHAR szTemp[MAX_PATH+4];
	_stprintf(szTemp, _T("%s\\*.*"), lpszPathFrom);
	WIN32_FIND_DATA finddata;
	HANDLE hFind = FindFirstFile(szTemp, &finddata);
	if (hFind != INVALID_HANDLE_VALUE)
	{
		do{
			if (*lpCancelMode)
			{
				FindClose(hFind);
				return TRUE;
			}		
			if (finddata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			{
				//tH_
				LPTSTR lpszFrom = new TCHAR[_tcslen(lpszPathFrom)+_tcslen(finddata.cFileName)+2];
				LPTSTR lpszTo = new TCHAR[_tcslen(lpszPathTo)+_tcslen(finddata.cFileName)+2];
				_stprintf(lpszFrom, _T("%s\\%s"), lpszPathFrom, finddata.cFileName);
				_stprintf(lpszTo, _T("%s\\%s"), lpszPathTo, finddata.cFileName);
				if (!CopyFolder(lpszFrom, lpszTo, lpCancelMode, lpOverWrite, hDlg, bFileMove))
				{
					FindClose(hFind);
					delete[] lpszFrom;
					delete[] lpszTo;
					return FALSE;
				}
				delete[] lpszFrom;
				delete[] lpszTo;
			}
			else
			{
				//t@C
				LPTSTR lpszFrom = new TCHAR[_tcslen(lpszPathFrom)+_tcslen(finddata.cFileName)+2];
				LPTSTR lpszTo = new TCHAR[_tcslen(lpszPathTo)+_tcslen(finddata.cFileName)+2];
				_stprintf(lpszFrom, _T("%s\\%s"), lpszPathFrom, finddata.cFileName);
				_stprintf(lpszTo, _T("%s\\%s"), lpszPathTo, finddata.cFileName);
				if (!CopyFileWithMessage(lpszFrom, lpszTo, lpOverWrite, hDlg, bFileMove))
				{
					FindClose(hFind);
					delete[] lpszFrom;
					delete[] lpszTo;
					return FALSE;
				}
				delete[] lpszFrom;
				delete[] lpszTo;
			}
		}while (FindNextFile(hFind, &finddata));
		FindClose(hFind);
	}
	if (bFileMove)
		RemoveDirectory(lpszPathFrom);

	pcfd->m_nExecCount += 1;
	_stprintf(szTemp, _T("%d/%d"), pcfd->m_nExecCount, pcfd->m_nFileCount);
	::SetWindowText(GetDlgItem(hDlg, IDC_PROG_TEXT), szTemp);
	SendMessage(GetDlgItem(hDlg, IDC_PROGRESS), PBM_SETPOS, pcfd->m_nExecCount, 0);

	return TRUE;
}

////////////////////////////////////////////////////////////////
DWORD WINAPI CopyFileThread(LPVOID pParam)
{
	COPYTHREAD* pct = (COPYTHREAD*)pParam;

	int nOverWrite = RETCODE_YES;

	//Rs[Jn
	UINT nFileCount = 0;
	for (int i=0; i<pct->m_nCount; i++)
	{
		//LZ`FbN
		if (*pct->m_pbCancel)
		{
			::SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FILE_NAME), GetResourceString(IDS_MSG_CANCELED));
			::SendMessage(pct->m_hWnd, WM_DLGCLOSE, 0, 0);
			ExitThread(0);
			return 0;
		}

		//wtH_ւ̈ړ̍ڂ𖳎(SđIRs[ŃnOAbvւ̑Ώ)
		if (pct->m_lpliinfo[i].nItem == LIST_ITEM_UPPER)
			continue;

		//\̍XV
		TCHAR szTemp[MAX_PATH+4];
		TCHAR szFrom[MAX_PATH];
		TCHAR szTo[MAX_PATH];
		LPTSTR lpszTemp = _tcsrchr(pct->m_lpliinfo[i].szPath, _T('\\'));
		if (lpszTemp)
			_tcscpy(szFrom, ++lpszTemp);
		else
			_tcscpy(szFrom, _T("\\"));

		lpszTemp = _tcsrchr(pct->m_lpszFolderTo, _T('\\'));
		if (lpszTemp)
			_tcscpy(szTo, ++lpszTemp);
		else
			_tcscpy(szTo, _T("\\"));
		
		_stprintf(szTemp, GetResourceString(IDS_FMT_FROMTO), szFrom, szTo);
		SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FOLDER), szTemp);

		// t@C̐ݒ
		_stprintf(szFrom, _T("%s\\%s"), pct->m_lpliinfo[i].szPath, pct->m_lpliinfo[i].szName);
		if (_tcscmp(pct->m_lpliinfo[i].szPath, pct->m_lpszFolderTo) == 0)
		{
			// Rs[ƃRs[悪
			_stprintf(szTo, GetResourceString(IDS_FMT_COPY_NAME1), pct->m_lpszFolderTo, pct->m_lpliinfo[i].szName);
			if (GetFileAttributes(szTo) != 0xFFFFFFFF)
			{
				for (int n = 2; n < 512; n++)
				{
					_stprintf(szTo, GetResourceString(IDS_FMT_COPY_NAME2), pct->m_lpszFolderTo, n, pct->m_lpliinfo[i].szName);
					if (GetFileAttributes(szTo) == 0xFFFFFFFF)
						break;
				}
			}
		}
		else
			_stprintf(szTo, _T("%s\\%s"), pct->m_lpszFolderTo, pct->m_lpliinfo[i].szName);

		//ۂ̃Rs[
		if (pct->m_lpliinfo[i].nItem == LIST_ITEM_FOLDER)
		{
			//tH_̃Rs[
			if (!CopyFolder(szFrom, szTo, pct->m_pbCancel, &nOverWrite, pct->m_hWnd, pct->m_bFileMove))
			{
				SendMessage(pct->m_hWnd, WM_SHOWERRMSG, (WPARAM)pct->m_lpliinfo[i].szName, 0);
				::SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FILE_NAME), GetResourceString(IDS_MSG_CANCELED));
				::SendMessage(pct->m_hWnd, WM_DLGCLOSE, 0, 0);
				ExitThread(0);
				return 0;
			}
		}
		else if (pct->m_lpliinfo[i].nItem == LIST_ITEM_FILE)
		{
			//t@C̃Rs[
			if (!CopyFileWithMessage(szFrom, szTo, &nOverWrite, pct->m_hWnd, pct->m_bFileMove))
			{
				SendMessage(pct->m_hWnd, WM_SHOWERRMSG, (WPARAM)pct->m_lpliinfo[i].szName, 0);
				::SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FILE_NAME), GetResourceString(IDS_MSG_CANCELED));
				::SendMessage(pct->m_hWnd, WM_DLGCLOSE, 0, 0);
				ExitThread(0);
				return 0;
			}
		}

		if (nOverWrite == RETCODE_ALL_NO)
		{
			::SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FILE_NAME), GetResourceString(IDS_MSG_CANCELED));
			::SendMessage(pct->m_hWnd, WM_DLGCLOSE, 0, 0);
			ExitThread(0);
			return 0;
		}
	}
	::SetWindowText(GetDlgItem(pct->m_hWnd, IDC_FILE_NAME), GetResourceString(IDS_MSG_DONE));
	::SendMessage(pct->m_hWnd, WM_DLGCLOSE, 0, 0);
	ExitThread(0);

	return 0;
}

////////////////////////////////////////////////////////////////
void CCopyFileDlg::OnInitDialog(HWND hDlg)
{
	TCHAR szTemp[32];
	m_bCancel = FALSE;
	m_nExecCount = 0;
	m_hWnd = hDlg;

	CenterWindow(hDlg);

	if (m_bFileMove)
	{
		SetWindowText(hDlg, GetResourceString(IDS_MSG_MOVING));
		SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), GetResourceString(IDS_MSG_PREP_MOVE));
	}
	else
	{
		SetWindowText(hDlg, GetResourceString(IDS_MSG_COPYING));
		SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), GetResourceString(IDS_MSG_PREP_COPY));
	}

	m_nFileCount = GetFileAndFolderCount(m_lpszFolderFrom, m_lpliinfo, m_nCount);
	SendMessage(GetDlgItem(hDlg, IDC_PROGRESS), PBM_SETRANGE, 0, MAKELPARAM(0, m_nFileCount));
	_stprintf(szTemp, _T("0/%d"), m_nFileCount);
	SetWindowText(GetDlgItem(hDlg, IDC_PROG_TEXT), szTemp);

	ShowWindow(hDlg, SW_SHOW);

	static COPYTHREAD CopyThread;
	CopyThread.m_nCount = m_nCount;
	CopyThread.m_pbCancel = &m_bCancel;
	CopyThread.m_bFileMove = m_bFileMove;
	CopyThread.m_lpliinfo = m_lpliinfo;
	CopyThread.m_lpszFolderFrom = m_lpszFolderFrom;
	CopyThread.m_lpszFolderTo = m_lpszFolderTo;
	CopyThread.m_hWnd = m_hWnd;

	m_hThread = CreateThread(NULL, 0, CopyFileThread, (LPVOID)&CopyThread, 0, &m_dwThreadID);
}

////////////////////////////////////////////////////////////////
LRESULT CALLBACK CopyFileDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	CCopyFileDlg* pcfd = (CCopyFileDlg*)GetWindowLong(hDlg, GWL_USERDATA);

	switch (message)
	{
	case WM_INITDIALOG:
		//DialogBoxParamœnꂽCCopyFileDlg̃CX^XUSERDATAɊi[
		SetWindowLong(hDlg, GWL_USERDATA, lParam);
		pcfd = (CCopyFileDlg*)lParam;
		//
		pcfd->OnInitDialog(hDlg);
		SetTimer(hDlg, ID_TIMER_RESETTIME, TIMER_RESETTIME_INT, NULL);
		return TRUE;

	case WM_COMMAND:
		{
			int wmId    = LOWORD(wParam);
			int wmEvent = HIWORD(wParam); 
			switch (wmId)
			{
			case IDC_CANCELMODE:
				{
					pcfd->m_bCancel = TRUE;
					EnableWindow(GetDlgItem(hDlg, IDC_CANCELMODE), FALSE);
					SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), GetResourceString(IDS_MSG_CANCELING));
				}
				return TRUE;

			default:
				break;
			}
		}
		break;

	case WM_DLGCLOSE:
		CloseHandle(pcfd->m_hThread);
		KillTimer(hDlg, ID_TIMER_RESETTIME);
		EndDialog(hDlg, 0);
		return TRUE;

	case WM_SHOWOWMSG:
		pcfd->ShowOverWriteMessage((LPTSTR)wParam, (LPTSTR)lParam);
		return TRUE;

	case WM_SHOWERRMSG:
		pcfd->ShowErrorMessage((LPTSTR)wParam);
		return TRUE;

	case WM_SHOWFOLDEROWMSG:
		pcfd->ShowFolderOverWriteMessage((LPTSTR)wParam);
		return TRUE;

	case WM_TIMER:
		if (wParam == ID_TIMER_RESETTIME && pcfd->m_bTimerReset)
			SystemIdleTimerReset();
		return TRUE;

	default:
		break;
	}

	return FALSE;
}
////////////////////////////////////////////////////////////////
int CCopyFileDlg::ShowCopyFileDlg(LPCTSTR lpszFolderFrom, LPCTSTR lpszFolderTo, LISTITEMINFO* lpliinfo, int nCount, BOOL bFileMove)
{
	m_lpszFolderFrom = lpszFolderFrom;
	m_lpszFolderTo = lpszFolderTo;
	m_lpliinfo = lpliinfo;
	m_nCount = nCount;
	m_bFileMove = bFileMove;

	//t@Cړ
	if (m_bFileMove)
	{
		//Xgɐݒ肳ĂpXSă`FbN
		for (int i = 0; i < m_nCount; i++)
		{
			if (_tcscmp(m_lpliinfo[i].szPath, m_lpszFolderTo) == 0)
			{
				MessageBox(g_MainWnd.m_hWnd, GetResourceString(IDS_MSG_CANNOTMOVE), NULL, MB_OK|MB_ICONSTOP);
				return IDCANCEL;
			}
		}
	}

	//TutH_`FbNs
	for (int i = 0; i < m_nCount; i++)
	{
		if (m_lpliinfo[i].nItem == LIST_ITEM_FOLDER)
		{
			TCHAR szFrom[MAX_PATH];
			TCHAR szTo[MAX_PATH];

			_stprintf(szFrom, _T("%s\\%s"), m_lpliinfo[i].szPath, m_lpliinfo[i].szName);
			if (_tcsicmp(g_MainWnd.m_szWindowsPath, szFrom) == 0)
			{
				MessageBox(g_MainWnd.m_hWnd, GetResourceString(IDS_MSG_PASTEERROR3), NULL, MB_OK|MB_ICONSTOP);
				return IDCANCEL;
			}

			_stprintf(szFrom, _T("%s\\%s\\"), m_lpliinfo[i].szPath, m_lpliinfo[i].szName);
			_stprintf(szTo, _T("%s\\"), m_lpszFolderTo);
			_tcsupr(szFrom);
			_tcsupr(szTo);
			if (_tcsncmp(szFrom, szTo, _tcslen(szFrom)) == 0)
			{
				MessageBox(g_MainWnd.m_hWnd,
					GetResourceString(m_bFileMove? IDS_MSG_CANNOTMOVE: IDS_MSG_CANNOTCOPY),
					NULL, MB_OK|MB_ICONSTOP);

				return IDCANCEL;
			}
		}
	}

	DisableUpdateNotify();
	DialogBoxParam(g_hInst, (LPCTSTR)IDD_FILECOPY_DLG, g_MainWnd.m_hWnd, (DLGPROC)CopyFileDlgProc, LPARAM(this));
	EnableUpdateNotify();

	return IDOK;
}
////////////////////////////////////////////////////////////////
LRESULT CALLBACK OverWriteDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	CCopyFileDlg* pcfd = (CCopyFileDlg*)GetWindowLong(hDlg, GWL_USERDATA);

	switch (message)
	{
	case WM_INITDIALOG:
		{
			//DialogBoxParamœnꂽCCopyFileDlg̃CX^XUSERDATAɊi[
			SetWindowLong(hDlg, GWL_USERDATA, lParam);
			pcfd = (CCopyFileDlg*)lParam;
			//
			TCHAR szOldFilePath[MAX_PATH];
			TCHAR szNewFilePath[MAX_PATH];
			_tcscpy(szOldFilePath, pcfd->m_lpszwParam);
			_tcscpy(szNewFilePath, pcfd->m_lpszlParam);

			pcfd->m_nRetCode = RETCODE_NO;

			LPTSTR lpszFileName = _tcsrchr(szOldFilePath, _T('\\'));
			if (lpszFileName)
				lpszFileName++;
			else
				lpszFileName = szOldFilePath;

			TCHAR szTemp[MAX_PATH];
			DWORD dwAttr = GetFileAttributes(szOldFilePath);
			if ((dwAttr&FILE_ATTRIBUTE_SYSTEM)==FILE_ATTRIBUTE_SYSTEM)
				_stprintf(szTemp, GetResourceString(IDS_FMT_OW_SYSTEM), lpszFileName);
			else if ((dwAttr&FILE_ATTRIBUTE_READONLY)==FILE_ATTRIBUTE_READONLY)
				_stprintf(szTemp, GetResourceString(IDS_FMT_OW_READONLY), lpszFileName);
			else
				_stprintf(szTemp, GetResourceString(IDS_FMT_OW_FILE), lpszFileName);
			SetWindowText(GetDlgItem(hDlg, IDC_FILE_NAME), szTemp);

			//Old
			TCHAR szSize[64];
			SHFILEINFO shfi;
			SHGetFileInfo(szOldFilePath, NULL, &shfi, sizeof(shfi), SHGFI_LARGEICON | SHGFI_ICON);
			SendMessage(GetDlgItem(hDlg, IDC_OLD_ICON), STM_SETIMAGE, IMAGE_ICON, (LPARAM)shfi.hIcon);

			HANDLE hFile = CreateFile(szOldFilePath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, NULL, NULL);
			_stprintf(szSize, _T("%d"), GetFileSize(hFile, NULL));
			SetFormatInteger(szSize, 64);
			_stprintf(szTemp, GetResourceString(IDS_FMT_SIZEBYTE), szSize);
			SetWindowText(GetDlgItem(hDlg, IDC_OLD_SIZE), szTemp);

			TCHAR szTime[64];
			SYSTEMTIME st;
			FILETIME ft;
			GetFileTime(hFile, NULL, NULL, &ft);
			FileTimeToLocalFileTime(&ft, &ft);
			FileTimeToSystemTime(&ft, &st);
			SetFormatDateTime(&st, szTime, sizeof(szTime)/sizeof(TCHAR));
			_stprintf(szTemp, GetResourceString(IDS_FMT_UPDATETIME), szTime);
			SetWindowText(GetDlgItem(hDlg, IDC_OLD_TIME), szTemp);
			CloseHandle(hFile);

			//New
			SHGetFileInfo(szNewFilePath, NULL, &shfi, sizeof(shfi), SHGFI_LARGEICON | SHGFI_ICON);
			SendMessage(GetDlgItem(hDlg, IDC_NEW_ICON), STM_SETIMAGE, IMAGE_ICON, (LPARAM)shfi.hIcon);

			hFile = CreateFile(szNewFilePath, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, NULL, NULL); 
			_stprintf(szSize, _T("%d"), GetFileSize(hFile, NULL));
			SetFormatInteger(szSize, 64);
			_stprintf(szTemp, GetResourceString(IDS_FMT_SIZEBYTE), szSize);
			SetWindowText(GetDlgItem(hDlg, IDC_NEW_SIZE), szTemp);

			GetFileTime(hFile, NULL, NULL, &ft);
			FileTimeToLocalFileTime(&ft, &ft);
			FileTimeToSystemTime(&ft, &st);
			SetFormatDateTime(&st, szTime, sizeof(szTime)/sizeof(TCHAR));
			_stprintf(szTemp, GetResourceString(IDS_FMT_UPDATETIME), szTime);
			SetWindowText(GetDlgItem(hDlg, IDC_NEW_TIME), szTemp);

			CloseHandle(hFile);

			CenterWindow(hDlg);
			ShowWindow(hDlg, SW_SHOW);
			SetForegroundWindow(hDlg);
		}
		return TRUE;

	case WM_COMMAND:
		{
			int wmId    = LOWORD(wParam); 
			int wmEvent = HIWORD(wParam); 
			switch (wmId)
			{
			case IDC_BTN_YES:
				pcfd->m_nRetCode = RETCODE_YES;
				EndDialog(hDlg, IDOK);
				return TRUE;

			case IDC_BTN_NO:
				pcfd->m_nRetCode = RETCODE_NO;
				EndDialog(hDlg, IDCANCEL);
				return TRUE;

			case IDC_BTN_ALL_YES:
				pcfd->m_nRetCode = RETCODE_ALL_YES;
				EndDialog(hDlg, IDOK);
				return TRUE;

			case IDC_BTN_ALL_NO:
				pcfd->m_nRetCode = RETCODE_ALL_NO;
				EndDialog(hDlg, IDCANCEL);
				return TRUE;

			default:
				break;
			}
		}
	case WM_CLOSE:
		pcfd->m_nRetCode = RETCODE_NO;
		EndDialog(hDlg, IDCANCEL);
		return TRUE;

	default:
		break;
	}

	return FALSE;
}

////////////////////////////////////////////////////////////////
int CCopyFileDlg::ShowOverWriteMessage(LPTSTR lpszwParam, LPTSTR lpszlParam)
{
	m_lpszwParam = lpszwParam;
	m_lpszlParam = lpszlParam;
	m_bTimerReset = FALSE;
	DialogBoxParam(g_hInst, (LPCTSTR)IDD_OVERWRITE_DLG, m_hWnd, (DLGPROC)OverWriteDlgProc, LPARAM(this));
	m_bTimerReset = TRUE;

	return m_nRetCode;
}

////////////////////////////////////////////////////////////////
void CCopyFileDlg::ShowErrorMessage(LPTSTR lspzFileName)
{
	TCHAR szTemp[128];
	_stprintf(szTemp, GetResourceString(IDS_FMT_COPYERROR), lspzFileName);
	MessageBox(m_hWnd, szTemp, NULL, MB_OK|MB_ICONSTOP);
}


////////////////////////////////////////////////////////////////
LRESULT CALLBACK FolderOverWriteDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	CCopyFileDlg* pcfd = (CCopyFileDlg*)GetWindowLong(hDlg, GWL_USERDATA);

	switch (message)
	{
	case WM_INITDIALOG:
		{
			//DialogBoxParamœnꂽCCopyFileDlg̃CX^XUSERDATAɊi[
			SetWindowLong(hDlg, GWL_USERDATA, lParam);
			pcfd = (CCopyFileDlg*)lParam;
			//
			TCHAR szChild[MAX_PATH] = {0};
			TCHAR szParent[MAX_PATH] = {0};

			LPTSTR lpszTemp = _tcsrchr(pcfd->m_lpszwParam, _T('\\'));
			if (lpszTemp)
			{
				_tcsncpy(szParent, pcfd->m_lpszwParam, lpszTemp - pcfd->m_lpszwParam);
				_tcscpy(szChild, ++lpszTemp);
			}
			else
			{
				_tcscpy(szParent, pcfd->m_lpszwParam);
				_tcscpy(szChild, GetRootName());
			}

			lpszTemp = _tcsrchr(szParent, _T('\\'));
			if (lpszTemp)
				_tcscpy(szParent, ++lpszTemp);
			else
				_tcscpy(szParent, GetRootName());

			TCHAR szTemp[MAX_PATH];
			_stprintf(szTemp, GetResourceString(IDS_FMT_OW_FOLDER), szParent, szChild);
			SetWindowText(GetDlgItem(hDlg, IDC_FOLDER_TEXT), szTemp);

			CenterWindow(hDlg);
			ShowWindow(hDlg, SW_SHOW);
			SetForegroundWindow(hDlg);
		}
		return TRUE;

	case WM_COMMAND:
		{
			int wmId    = LOWORD(wParam); 
			int wmEvent = HIWORD(wParam); 
			switch (wmId)
			{
			case IDYES:
				pcfd->m_nRetCode = IDOK;
				EndDialog(hDlg, IDOK);
				return TRUE;

			case IDNO:
				pcfd->m_nRetCode = IDCANCEL;
				EndDialog(hDlg, IDCANCEL);
				return TRUE;

			default:
				break;
			}
		}
		break;

	case WM_CLOSE:
		pcfd->m_nRetCode = IDCANCEL;
		EndDialog(hDlg, IDCANCEL);
		return TRUE;

	default:
		break;
	}

	return FALSE;
}

////////////////////////////////////////////////////////////////
int CCopyFileDlg::ShowFolderOverWriteMessage(LPTSTR lpszwParam)
{
	m_lpszwParam = lpszwParam;
	m_bTimerReset = FALSE;
	DialogBoxParam(g_hInst, (LPCTSTR)IDD_FOLDER_OVERWRITE_DLG, m_hWnd, (DLGPROC)FolderOverWriteDlgProc, LPARAM(this));
	m_bTimerReset = TRUE;

	return m_nRetCode;
}