///////////////////////////////////////////////////////////////
//CommandBandsPPC.cpp
//j[o[/AhXo[/c[o[̊Ǘ - CCmdBands

///////////////////////////////////////////////////////////////
//INCLUDE
#include "GSFinder.h"
#include "CommandBandsPPC.h"
#include "ListView.h"

///////////////////////////////////////////////////////////////
LRESULT CALLBACK CmbEditProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	SHRGINFO shrg;

	switch (message)
	{
	case WM_SETFOCUS:
		g_MainWnd.m_CmdBands.SetEnableItemSelected3();
		g_MainWnd.m_CmdBands.SetEnableEditPasteBef();
		break;

	case WM_KILLFOCUS:
		g_MainWnd.m_CmdBands.SetEnableEditPasteAft();
		break;

	case WM_KEYDOWN:
		switch (wParam)
		{
		case VK_RETURN:
			//AhXo[ł̃ReLXgj[Ή
			if (!SendMessage(g_MainWnd.m_CmdBands.m_hComboBox, CB_GETDROPPEDSTATE, 0, 0))
			{
				SHRGINFO shrg;
				RECT rc;

				SetFocus(g_MainWnd.m_CmdBands.m_hEditBox);
				GetClientRect(g_MainWnd.m_CmdBands.m_hAddressbar, &rc);
				shrg.cbSize = sizeof(shrg);
				shrg.hwndClient = g_MainWnd.m_CmdBands.m_hAddressbar;
				shrg.ptDown.x = rc.left + (int)(16 * g_MainWnd.m_fpHighResolutionScale);
				shrg.ptDown.y = rc.top + RECT_HEIGHT(&rc) / 2;
				shrg.dwFlags = SHRG_NOTIFYPARENT;
				if (SHRecognizeGesture(&shrg))
					return 0;
				g_MainWnd.m_ListView.OnViewUpdate();
				SetFocus(g_MainWnd.m_ListView.m_hWnd);
			}
			return 0;

		case VK_UP:
			//v_EXgł̏㉺[v
			if (g_MainWnd.m_bEdgeLoop)
			{
				if (SendMessage(g_MainWnd.m_CmdBands.m_hComboBox, CB_GETDROPPEDSTATE, 0, 0))
				{
					if (SendMessage(g_MainWnd.m_CmdBands.m_hComboBox, CB_GETCURSEL, 0, 0) == 0)
					{
						int count = SendMessage(g_MainWnd.m_CmdBands.m_hComboBox, CB_GETCOUNT, 0, 0);
						if (count != CB_ERR)
						{
							SendMessage(g_MainWnd.m_CmdBands.m_hComboBox, CB_SETCURSEL, count-1, 0);
							return 0;
						}
					}
				}
			}
			break;

		case VK_DOWN:
			//v_EXgł̏㉺[v
			if (g_MainWnd.m_bEdgeLoop)
			{
				if (SendMessage(g_MainWnd.m_CmdBands.m_hComboBox, CB_GETDROPPEDSTATE, 0, 0))
				{
					int count = SendMessage(g_MainWnd.m_CmdBands.m_hComboBox, CB_GETCOUNT, 0, 0);
					if (count != CB_ERR)
					{
						if (SendMessage(g_MainWnd.m_CmdBands.m_hComboBox, CB_GETCURSEL, 0, 0) == (count-1))
						{
							SendMessage(g_MainWnd.m_CmdBands.m_hComboBox, CB_SETCURSEL, 0, 0);
							return 0;
						}
					}
				}
			}
			break;

		default:
			break;
		}
		break;

	case WM_MOUSEWHEEL:
		//EMEONEXN[zC[Ή
		if (GET_WHEEL_DELTA_WPARAM(wParam) < 0)
		{
			keybd_event(VK_DOWN, 0x3D, 0, 0);
			keybd_event(VK_DOWN, 0x3D, KEYEVENTF_KEYUP, 0);
		}
		else if (GET_WHEEL_DELTA_WPARAM(wParam) > 0)
		{
			keybd_event(VK_UP, 0x3E, 0, 0);
			keybd_event(VK_UP, 0x3E, KEYEVENTF_KEYUP, 0);
		}
		return 0;

	case WM_CHAR:
		switch (wParam)
		{
		case VK_RETURN:
			//(v_EXg̗]vȊJ})
			SendMessage(g_MainWnd.m_CmdBands.m_hComboBox, CB_GETDROPPEDSTATE, 0, 0);
			return 0;

		case VK_LBUTTON:
			//CTRL+AɂSI̗L(̂VK_LBUTTONɉ̂Łcc)
			SendMessage(g_MainWnd.m_CmdBands.m_hEditBox, EM_SETSEL, 0, -1);
			return 0;

		default:
			break;
		}
		break;

	case WM_LBUTTONDOWN:
		//AhXo[ł̃ReLXgj[Ή
		SetFocus(g_MainWnd.m_CmdBands.m_hEditBox);
		shrg.cbSize = sizeof(shrg);
		shrg.hwndClient = g_MainWnd.m_CmdBands.m_hAddressbar;
		shrg.ptDown.x = GET_X_LPARAM(lParam);
		shrg.ptDown.y = GET_Y_LPARAM(lParam);
		shrg.dwFlags = SHRG_NOTIFYPARENT;
		if (SHRecognizeGesture(&shrg))
			return 0;
		break;

	default:
		break;
	}

	return CallWindowProc((WNDPROC)GetWindowLong(hWnd, GWL_USERDATA), hWnd, message, wParam, lParam);
}

///////////////////////////////////////////////////////////////
CCmdBands::CCmdBands()
{
	m_Settings.bShowToolBar = TRUE;
	m_Settings.bShowAddressBar = TRUE;
}

///////////////////////////////////////////////////////////////
CCmdBands::~CCmdBands()
{
}

///////////////////////////////////////////////////////////////
//R}hoh̍쐬
void CCmdBands::Init(HWND hwndParent)
{
	GetSettings();

	CreateMenuBar(hwndParent, g_MainWnd.m_bNumberShortcut, g_MainWnd.m_bSwapMenu);
	CreateToolBar(hwndParent);
	CreateAddressBar(hwndParent);

	ShowWindow(m_hAddressbar, m_Settings.bShowAddressBar? SW_SHOW: SW_HIDE);
	ShowWindow(m_hToolbar, m_Settings.bShowToolBar? SW_SHOW: SW_HIDE);
	
	SetCheckViewToolBar();
	SetCheckViewAddressBar();

	GetRecent();
}

///////////////////////////////////////////////////////////////
void CCmdBands::Destroy()
{
	SaveSettings();
	SaveRecent();
	//DestroyWindow(m_hWnd);	//(eEChEDestroyWindowőp)
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetFolderName(LPCTSTR lpszPath)
{
	TCHAR szPath[MAX_PATH];
	_tcscpy(szPath, GetRootName());
	if (_tcslen(lpszPath))
		_tcscpy(szPath, lpszPath);

	int nIndex = SendMessage(m_hComboBox, CB_FINDSTRINGEXACT, 0, (LPARAM)szPath);
	if (nIndex != CB_ERR)
		SendMessage(m_hComboBox, CB_DELETESTRING, nIndex, 0);

	SendMessage(m_hComboBox, CB_INSERTSTRING, 0, (LPARAM)szPath);
	SendMessage(m_hComboBox, CB_SETCURSEL, 0, 0);
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetCheckListStyle(DWORD dwStyle, DWORD dwExStyle)
{
	CheckMenuItem(m_hMenuMain, ID_VIEW_LARGEICON, (dwStyle == LVS_ICON)? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
	CheckMenuItem(m_hMenuMain, ID_VIEW_SMALLICON, (dwStyle == LVS_SMALLICON)? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
	CheckMenuItem(m_hMenuMain, ID_VIEW_LIST, (dwStyle == LVS_LIST)? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
	CheckMenuItem(m_hMenuMain, ID_VIEW_REPORT, (dwStyle == LVS_REPORT && !dwExStyle)? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
	CheckMenuItem(m_hMenuMain, ID_VIEW_REPORTLINE, (dwStyle == LVS_REPORT && dwExStyle)? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetCheckSort(int nSort, BOOL bRaise)
{
	CheckMenuItem(m_hMenuMain, ID_VIEW_SORT_NAME, (nSort == LIST_SORT_NAME)? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
	CheckMenuItem(m_hMenuMain, ID_VIEW_SORT_EXT, (nSort == LIST_SORT_EXT)? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
	CheckMenuItem(m_hMenuMain, ID_VIEW_SORT_SIZE, (nSort == LIST_SORT_SIZE)? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
	CheckMenuItem(m_hMenuMain, ID_VIEW_SORT_TIME, (nSort == LIST_SORT_TIME)? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
	CheckMenuItem(m_hMenuMain, ID_VIEW_SORT_NOT_RAISE, bRaise? (MF_BYCOMMAND|MF_UNCHECKED): (MF_BYCOMMAND|MF_CHECKED));
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetCheckKeyOn(BOOL bCtrlOn, BOOL bShiftOn)
{
	//Rg[
	SendMessage(m_hWnd, TB_SETSTATE, ID_EDIT_CONTROL_ON, bCtrlOn? (TBSTATE_CHECKED|TBSTATE_ENABLED): (TBSTATE_ENABLED));
	CheckMenuItem(m_hMenuMain, ID_EDIT_CONTROL_ON, bCtrlOn? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
	//Vtg
	CheckMenuItem(m_hMenuMain, ID_EDIT_SHIFT_ON, bShiftOn? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetCheckViewStatusWnd(BOOL bShowStatusWnd)
{
	CheckMenuItem(m_hMenuMain, ID_VIEW_STATUSBAR, bShowStatusWnd? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetCheckViewFolder(BOOL bShowFolder)
{
	CheckMenuItem(m_hMenuMain, ID_VIEW_FOLDER, bShowFolder? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
	SendMessage(m_hWnd, TB_SETSTATE, ID_VIEW_FOLDER, bShowFolder? (TBSTATE_CHECKED|TBSTATE_ENABLED): TBSTATE_ENABLED);
	EnableMenuItem(m_hMenuMain, ID_VIEW_SIDE, bShowFolder? (MF_BYCOMMAND|MF_ENABLED): (MF_BYCOMMAND|MF_GRAYED));
	SetEnableFocusMove(bShowFolder);
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetCheckViewSide(BOOL bViewSide)
{
	CheckMenuItem(m_hMenuMain, ID_VIEW_SIDE, bViewSide? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetCheckDragDrop(BOOL bDragDrop)
{
	CheckMenuItem(m_hMenuMain, ID_EDIT_DRAGDROP, bDragDrop? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetCheckViewHighRes(BOOL bHighRes)
{
	CheckMenuItem(m_hMenuMain, ID_VIEW_HIGHRES, bHighRes? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
	SetEnableViewHighRes(g_MainWnd.m_bHighDpiHardware);
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetCheckViewToolBar()
{
	CheckMenuItem(m_hMenuMain, ID_VIEW_TOOLBAR, m_Settings.bShowToolBar? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
	SendMessage(m_hWnd, TB_SETSTATE, ID_VIEW_TOOLBAR, m_Settings.bShowToolBar? (TBSTATE_CHECKED|TBSTATE_ENABLED): TBSTATE_ENABLED);
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetCheckViewAddressBar()
{
	CheckMenuItem(m_hMenuMain, ID_VIEW_ADDRESSBAR, m_Settings.bShowAddressBar? (MF_BYCOMMAND|MF_CHECKED): (MF_BYCOMMAND|MF_UNCHECKED));
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetEnableUpperFolder(BOOL bEnable)
{
	EnableMenuItem(m_hMenuMain, ID_VIEW_UPFOLDER, bEnable? (MF_BYCOMMAND|MF_ENABLED): (MF_BYCOMMAND|MF_GRAYED));
	SendMessage(m_hWnd, TB_SETSTATE, ID_VIEW_UPFOLDER, bEnable? TBSTATE_ENABLED: TBSTATE_INDETERMINATE);
	SendMessage(m_hToolbar, TB_SETSTATE, ID_VIEW_UPFOLDER, bEnable? TBSTATE_ENABLED: TBSTATE_INDETERMINATE);
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetEnableFront(BOOL bEnable)
{
	EnableMenuItem(m_hMenuMain, ID_GO_FRONT, bEnable? (MF_BYCOMMAND|MF_ENABLED): (MF_BYCOMMAND|MF_GRAYED));
	SendMessage(m_hToolbar, TB_SETSTATE, ID_GO_FRONT, bEnable? TBSTATE_ENABLED: TBSTATE_INDETERMINATE);
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetEnableBack(BOOL bEnable)
{
	EnableMenuItem(m_hMenuMain, ID_GO_BACK, bEnable? (MF_BYCOMMAND|MF_ENABLED): (MF_BYCOMMAND|MF_GRAYED));
	SendMessage(m_hToolbar, TB_SETSTATE, ID_GO_BACK, bEnable? TBSTATE_ENABLED: TBSTATE_INDETERMINATE);
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetEnableCompressSelected(HMENU hMenu, HMENU hMenu2, int nPos, int nPos2, DWORD nCompDLL)
{
	HMENU hSubMenu = hMenu2;
	HMENU hSubMenu2 = hMenu2;
	if (nPos != -1)
		hSubMenu = GetSubMenu(hMenu2, nPos);
	if (nPos2 != -1)
		hSubMenu2 = GetSubMenu(hMenu2, nPos2);

	if (g_MainWnd.m_Compress.IsCompress(nCompDLL))
	{
		EnableMenuItem(hMenu, ID_FILE_COMPRESS, MF_BYCOMMAND|MF_ENABLED);
		EnableMenuItem(hSubMenu2, ID_FILE_COMPRESS, MF_BYCOMMAND|MF_ENABLED);
	}
	else
	{
		EnableMenuItem(hMenu, ID_FILE_COMPRESS, MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hSubMenu2, ID_FILE_COMPRESS, MF_BYCOMMAND|MF_GRAYED);
	}

	if (g_MainWnd.m_Compress.IsUnCompress())
	{
		EnableMenuItem(hMenu, ID_FILE_UNCOMPRESS, MF_BYCOMMAND|MF_ENABLED);
		EnableMenuItem(hSubMenu, ID_FILE_UNCOMPRESS, MF_BYCOMMAND|MF_ENABLED);
	}
	else
	{
		EnableMenuItem(hMenu, ID_FILE_UNCOMPRESS, MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hSubMenu, ID_FILE_UNCOMPRESS, MF_BYCOMMAND|MF_GRAYED);
	}
}
///////////////////////////////////////////////////////////////
void CCmdBands::SetEnableSearchSelected(HMENU hMenu, LPTSTR lpszPath)
{
	if (IsSearchFolder(lpszPath))
	{
		EnableMenuItem(hMenu, ID_FILE_CREATE_SHORTCUT, MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hMenu, ID_FILE_CREATE_NEWSHORTCUT, MF_BYCOMMAND|MF_GRAYED);
		for (int i=0; i<MAX_OPENAPP; i++)
			EnableMenuItem(hMenu, ID_FILE_SHELL_NEW_MENU+i, MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hMenu, ID_FILE_CREATEFOLDER, MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hMenu, ID_EDIT_PASTE_SHORTCUT, MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hMenu, ID_FILE_COMPRESS, MF_BYCOMMAND|MF_GRAYED);
	}
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetEnableItemSelected()
{
	UINT uEnableM, uEnableT, uEnableS;

	BOOL bFocus = (GetFocus() == g_MainWnd.m_ListView.m_hWnd);
	if (bFocus && g_MainWnd.m_ListView.GetValidAndSelectedCount())
	{
		uEnableM = MF_ENABLED;
		uEnableT = TBSTATE_ENABLED;
		uEnableS = g_MainWnd.m_ListView.IsSelectionFile()? MF_ENABLED: MF_GRAYED;
		SetEnableCompressSelected(m_hMenuFile, GetSubMenu(m_hMenuFile, 0), 0, 8, g_MainWnd.m_ListView.m_Settings.nCompDLL);
	}
	else if (bFocus && ListView_GetSelectedCount(g_MainWnd.m_ListView.m_hWnd))
	{
		uEnableM = MF_ENABLED;
		uEnableT = TBSTATE_ENABLED;
		uEnableS = MF_GRAYED;
		EnableMenuItem(m_hMenuFile, ID_FILE_COMPRESS, MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(m_hMenuFile, ID_FILE_UNCOMPRESS, MF_BYCOMMAND|MF_GRAYED);
	}
	else
	{
		uEnableM = MF_GRAYED;
		uEnableT = TBSTATE_INDETERMINATE;
		uEnableS = MF_GRAYED;
		EnableMenuItem(m_hMenuFile, ID_FILE_COMPRESS, MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(m_hMenuFile, ID_FILE_UNCOMPRESS, MF_BYCOMMAND|MF_GRAYED);
	}

	//t@C/Cj[
	EnableMenuItem(m_hMenuFile, ID_FILE_OPEN, MF_BYCOMMAND|uEnableM);
	EnableMenuItem(m_hMenuFile, ID_FILE_OPEN_PARAM, MF_BYCOMMAND|uEnableM);
	EnableMenuItem(m_hMenuFile, ID_FILE_CREATE_SHORTCUT, MF_BYCOMMAND|uEnableM);
	EnableMenuItem(m_hMenuFile, ID_FILE_DELETE, MF_BYCOMMAND|uEnableM);
	EnableMenuItem(m_hMenuFile, ID_FILE_RENAME, MF_BYCOMMAND|uEnableM);
	EnableMenuItem(m_hMenuFile, ID_FILE_PROPERTY, MF_BYCOMMAND|uEnableM);
	EnableMenuItem(m_hMenuMain, ID_EDIT_CUT, MF_BYCOMMAND|uEnableM);
	EnableMenuItem(m_hMenuMain, ID_EDIT_COPY, MF_BYCOMMAND|uEnableM);
	EnableMenuItem(m_hMenuMain, ID_EDIT_COPY_FILE_NAME, MF_BYCOMMAND|uEnableM);
	EnableMenuItem(m_hMenuMain, ID_EDIT_COPY_FILE_PATH, MF_BYCOMMAND|uEnableM);
	EnableMenuItem(m_hMenuFile, ID_FILE_COPY_FOLDER, MF_BYCOMMAND|uEnableM);
	EnableMenuItem(m_hMenuFile, ID_FILE_MOVE_FOLDER, MF_BYCOMMAND|uEnableM);
	EnableMenuItem(m_hMenuFile, ID_FILE_SHORTCUT_FOLDER, MF_BYCOMMAND|uEnableM);
	EnableMenuItem(m_hMenuMain, ID_EDIT_SELECT_SWITCH, MF_BYCOMMAND|MF_ENABLED);		//Œ
	EnableMenuItem(m_hMenuMain, ID_EDIT_SHIFT_ON, MF_BYCOMMAND|MF_ENABLED);				//Œ
	EnableMenuItem(m_hMenuMain, ID_EDIT_CONTROL_ON, MF_BYCOMMAND|MF_ENABLED);			//Œ
	EnableMenuItem(m_hMenuFile, ID_FILE_CREATE_NEWSHORTCUT, MF_BYCOMMAND|MF_ENABLED);	//Œ
	for (int i=0; i<MAX_OPENAPP; i++)
		EnableMenuItem(m_hMenuFile, ID_FILE_SHELL_NEW_MENU+i, MF_BYCOMMAND|MF_ENABLED);	//Œ

	//c[o[
	SendMessage(m_hToolbar, TB_SETSTATE, ID_FILE_DELETE, uEnableT);
	SendMessage(m_hToolbar, TB_SETSTATE, ID_FILE_PROPERTY, uEnableT);
	SendMessage(m_hToolbar, TB_SETSTATE, ID_EDIT_CUT, uEnableT);
	SendMessage(m_hToolbar, TB_SETSTATE, ID_EDIT_COPY, uEnableT);

	//郁j[
	EnableMenuItem(m_hMenuFile, ID_FILE_IR_SEND, MF_BYCOMMAND|uEnableS);
	EnableMenuItem(m_hMenuFile, ID_FILE_TO_APP, MF_BYCOMMAND|uEnableS);
	EnableMenuItem(m_hMenuFile, ID_FILE_MAIL_SEND, MF_BYCOMMAND|uEnableS);
	for (int i=0; i<g_MainWnd.m_ListView.m_nOpenAppInfoCount; i++)
		EnableMenuItem(m_hMenuFile, ID_FILE_OPEN_APP + i, MF_BYCOMMAND|uEnableS);

	//ʃtH_ǂ
	SetEnableSearchSelected(m_hMenuFile, g_MainWnd.m_ListView.m_szCurrentFolder);
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetEnableItemSelected2()
{
	//j[L
	EnableMenuItem(m_hMenuFile, ID_FILE_OPEN, MF_BYCOMMAND|MF_ENABLED);
	EnableMenuItem(m_hMenuFile, ID_FILE_CREATE_SHORTCUT, MF_BYCOMMAND|MF_ENABLED);
	EnableMenuItem(m_hMenuFile, ID_FILE_DELETE, MF_BYCOMMAND|MF_ENABLED);
	EnableMenuItem(m_hMenuFile, ID_FILE_RENAME, MF_BYCOMMAND|MF_ENABLED);
	EnableMenuItem(m_hMenuFile, ID_FILE_PROPERTY, MF_BYCOMMAND|MF_ENABLED);
	EnableMenuItem(m_hMenuMain, ID_EDIT_CUT, MF_BYCOMMAND|MF_ENABLED);
	EnableMenuItem(m_hMenuMain, ID_EDIT_COPY, MF_BYCOMMAND|MF_ENABLED);
	EnableMenuItem(m_hMenuMain, ID_EDIT_COPY_FILE_NAME, MF_BYCOMMAND|MF_ENABLED);
	EnableMenuItem(m_hMenuMain, ID_EDIT_COPY_FILE_PATH, MF_BYCOMMAND|MF_ENABLED);
	EnableMenuItem(m_hMenuFile, ID_FILE_COPY_FOLDER, MF_BYCOMMAND|MF_ENABLED);
	EnableMenuItem(m_hMenuFile, ID_FILE_MOVE_FOLDER, MF_BYCOMMAND|MF_ENABLED);
	EnableMenuItem(m_hMenuFile, ID_FILE_SHORTCUT_FOLDER, MF_BYCOMMAND|MF_ENABLED);
	SetEnableCompressSelected(m_hMenuFile, GetSubMenu(m_hMenuFile, 0), 0, 8, g_MainWnd.m_ListView.m_Settings.nCompDLL);
	EnableMenuItem(m_hMenuMain, ID_EDIT_SELECT_SWITCH, MF_BYCOMMAND|MF_ENABLED);
	EnableMenuItem(m_hMenuMain, ID_EDIT_SHIFT_ON, MF_BYCOMMAND|MF_ENABLED);
	EnableMenuItem(m_hMenuMain, ID_EDIT_CONTROL_ON, MF_BYCOMMAND|MF_ENABLED);
	EnableMenuItem(m_hMenuFile, ID_FILE_CREATE_NEWSHORTCUT, MF_BYCOMMAND|MF_ENABLED);
	for (int i = 0; i < MAX_OPENAPP; i++)
		EnableMenuItem(m_hMenuFile, ID_FILE_SHELL_NEW_MENU + i, MF_BYCOMMAND|MF_ENABLED);

	//c[o[L
	SendMessage(m_hToolbar, TB_SETSTATE, ID_FILE_DELETE, TBSTATE_ENABLED);
	SendMessage(m_hToolbar, TB_SETSTATE, ID_FILE_PROPERTY, TBSTATE_ENABLED);
	SendMessage(m_hToolbar, TB_SETSTATE, ID_EDIT_CUT, TBSTATE_ENABLED);
	SendMessage(m_hToolbar, TB_SETSTATE, ID_EDIT_COPY, TBSTATE_ENABLED);

	//郁j[
	EnableMenuItem(m_hMenuFile, ID_FILE_IR_SEND, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuFile, ID_FILE_TO_APP, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuFile, ID_FILE_MAIL_SEND, MF_BYCOMMAND|MF_GRAYED);
	for (int i = 0; i < g_MainWnd.m_ListView.m_nOpenAppInfoCount; i++)
		EnableMenuItem(m_hMenuFile, ID_FILE_OPEN_APP + i, MF_BYCOMMAND|MF_GRAYED);
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetEnableItemSelected3()
{
	//j[L
	EnableMenuItem(m_hMenuMain, ID_EDIT_CUT, MF_BYCOMMAND|MF_ENABLED);
	EnableMenuItem(m_hMenuMain, ID_EDIT_COPY, MF_BYCOMMAND|MF_ENABLED);

	//j[𖳌
	EnableMenuItem(m_hMenuFile, ID_FILE_OPEN, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuFile, ID_FILE_CREATE_SHORTCUT, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuFile, ID_FILE_DELETE, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuFile, ID_FILE_RENAME, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuFile, ID_FILE_PROPERTY, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuFile, ID_FILE_IR_SEND, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuFile, ID_FILE_COPY_FOLDER, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuFile, ID_FILE_MOVE_FOLDER, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuFile, ID_FILE_SHORTCUT_FOLDER, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuFile, ID_FILE_TO_APP, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuFile, ID_FILE_MAIL_SEND, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuMain, ID_EDIT_COPY_FILE_NAME, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuMain, ID_EDIT_COPY_FILE_PATH, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuFile, ID_FILE_COMPRESS, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuFile, ID_FILE_UNCOMPRESS, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuMain, ID_EDIT_SELECT_SWITCH, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuMain, ID_EDIT_SHIFT_ON, MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(m_hMenuMain, ID_EDIT_CONTROL_ON, MF_BYCOMMAND|MF_GRAYED);
	for (int i = 0; i < g_MainWnd.m_ListView.m_nOpenAppInfoCount; i++)
		EnableMenuItem(m_hMenuFile, ID_FILE_OPEN_APP + i, MF_BYCOMMAND|MF_GRAYED);

	//c[o[L
	SendMessage(m_hToolbar, TB_SETSTATE, ID_EDIT_CUT, TBSTATE_ENABLED);
	SendMessage(m_hToolbar, TB_SETSTATE, ID_EDIT_COPY, TBSTATE_ENABLED);

	//c[o[𖳌
	SendMessage(m_hToolbar, TB_SETSTATE, ID_FILE_DELETE, TBSTATE_INDETERMINATE);
	SendMessage(m_hToolbar, TB_SETSTATE, ID_FILE_PROPERTY, TBSTATE_INDETERMINATE);
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetEnableViewHighRes(BOOL bHighRes)
{
	EnableMenuItem(m_hMenuMain, ID_VIEW_HIGHRES, bHighRes? (MF_BYCOMMAND|MF_ENABLED): (MF_BYCOMMAND|MF_GRAYED));
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetEnableFocusMove(BOOL bShowFolder)
{
	EnableMenuItem(m_hMenuMain, ID_FOCUS_MOVE, bShowFolder? (MF_BYCOMMAND|MF_ENABLED): (MF_BYCOMMAND|MF_GRAYED));
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetModeFocusMove(BOOL bFocus)
{
	MENUITEMINFO mii;
	memset(&mii, 0, sizeof(MENUITEMINFO));
	mii.cbSize = sizeof(MENUITEMINFO);
	mii.fMask = MIIM_TYPE;
	mii.fType = MFT_STRING;
	TCHAR *lpszItemName = new TCHAR[1024];
	_stprintf(lpszItemName, GetResourceString(g_MainWnd.m_bNumberShortcut? IDS_FOCUS_MOVE1: IDS_FOCUS_MOVE), GetResourceString(bFocus? IDS_FILE: IDS_FOLDER));
	mii.dwTypeData = lpszItemName;
	SetMenuItemInfo(m_hMenuMain, ID_FOCUS_MOVE, FALSE, &mii);
	delete lpszItemName;
}

///////////////////////////////////////////////////////////////
void CCmdBands::SaveSettings()
{
	HKEY hKey;
	DWORD dwDisposition;

	//L[ݒ
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_CMDBANDS,
		0, _T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
		//m_Settings.bShowToolBar
		RegSetValueEx(hKey, _T("ShowToolBar"), 0, REG_DWORD, (LPBYTE)&m_Settings.bShowToolBar, sizeof(m_Settings.bShowToolBar));

		//m_Settings.bShowAddressBar
		RegSetValueEx(hKey, _T("ShowAddressBar"), 0, REG_DWORD, (LPBYTE)&m_Settings.bShowAddressBar, sizeof(m_Settings.bShowAddressBar));

		RegCloseKey(hKey);
	}
}

///////////////////////////////////////////////////////////////
void CCmdBands::GetSettings()
{
	HKEY hKey;
	DWORD dwDisposition;

	//L[擾
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_CMDBANDS,
		0, _T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
		DWORD dwDataSize;
		DWORD dwValue;

		//m_Settings.bShowToolBar
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ShowToolBar"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bShowToolBar = dwValue;

		//m_Settings.bShowAddressBar
		dwDataSize = sizeof(DWORD);
		dwValue = 0;
		if (RegQueryValueEx(hKey, _T("ShowAddressBar"), 0, NULL, (LPBYTE)&dwValue, &dwDataSize) == ERROR_SUCCESS)
			m_Settings.bShowAddressBar = dwValue;

		RegCloseKey(hKey);
	}
}

///////////////////////////////////////////////////////////////
void CCmdBands::CreateMenuBar(HWND hwndParent, BOOL bNumShortcut, BOOL bSwapMenu)
{
    SHMENUBARINFO mbi;
	memset(&mbi, 0, sizeof(SHMENUBARINFO));
	mbi.cbSize = sizeof(SHMENUBARINFO);
	mbi.hwndParent = hwndParent;
	mbi.nToolBarId = bNumShortcut? (bSwapMenu? IDR_MAINFRAME1_SWAP: IDR_MAINFRAME1): (bSwapMenu? IDR_MAINFRAME_SWAP: IDR_MAINFRAME);
	mbi.hInstRes = g_hInst;
	mbi.nBmpId = 0;
	mbi.cBmpImages = 0;

	if (!SHCreateMenuBar(&mbi))
	{
		MessageBox(g_MainWnd.m_hWnd, _T("SHCreateMenuBar Failed"), _T("Error"), MB_OK);
	}
	m_hWnd = mbi.hwndMB;

	m_hMenuMain = (HMENU)SendMessage(m_hWnd, SHCMBM_GETSUBMENU, 0, g_MainWnd.m_bSwapMenu? ID_MENU_LEFT: ID_MENU_RIGHT);
	m_hMenuFile = (HMENU)SendMessage(m_hWnd, SHCMBM_GETSUBMENU, 0, g_MainWnd.m_bSwapMenu? ID_MENU_RIGHT: ID_MENU_LEFT);
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetTypeMenuBar(BOOL bNumShortcut, BOOL bSwapMenu)
{
	HWND hwp = GetParent(m_hWnd);
	SendMessage(m_hWnd, WM_CLOSE, 0, 0);
	CreateMenuBar(hwp, bNumShortcut, bSwapMenu);
}

///////////////////////////////////////////////////////////////
void CCmdBands::CreateToolBar(HWND hwndParent)
{
	m_hToolbar= CommandBar_Create(g_hInst, hwndParent, 0);
	int nNum = 9;
		
	CommandBar_AddBitmap(m_hToolbar, g_hInst, IDR_TOOLBAR, nNum, 0, 0);

	//iBitmap, idCommand, fsState, fsStyle, dwData, iString	
	TBBUTTON tbbMain[] = {
		{0, ID_GO_BACK, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 0},
		{1, ID_GO_FRONT, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 1},
		{2, ID_VIEW_UPFOLDER, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 2},
		{0, NULL, TBSTATE_ENABLED, TBSTYLE_SEP, 0, 0},
		{3, ID_FILE_DELETE, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 3},				
		{4, ID_FILE_PROPERTY, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 4},
		{5, ID_EDIT_CUT, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 5},
		{6, ID_EDIT_COPY, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 6},
		{7, ID_EDIT_PASTE, TBSTATE_INDETERMINATE, TBSTYLE_BUTTON, 0, 7},
		{8, ID_VIEW_STYLE, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 8},
		{9, IDC_BTN_GOTOFOLDER, TBSTATE_ENABLED, TBSTYLE_BUTTON, 0, 9},
	};
	CommandBar_AddButtons(m_hToolbar, sizeof(tbbMain) / sizeof(TBBUTTON), tbbMain);

	SetWindowLong(m_hToolbar, GWL_STYLE, GetWindowLong(m_hToolbar, GWL_STYLE)|CCS_NOPARENTALIGN);
}
///////////////////////////////////////////////////////////////
void CCmdBands::CreateAddressBar(HWND hwndParent)
{
	m_hAddressbar= CommandBar_Create(g_hInst, hwndParent, 0);

	m_hComboBox = CommandBar_InsertComboBox(m_hAddressbar, g_hInst, GetSystemMetrics(SM_CXSCREEN) - 2, CBS_AUTOHSCROLL|CBS_DROPDOWN|WS_VSCROLL, 0, NULL);
	SendMessage(m_hComboBox, CB_SETEXTENDEDUI, TRUE, 0);

	//ReLXgj[Ή
	m_hEditBox = GetWindow(m_hComboBox, GW_CHILD);
	SetWindowLong(m_hEditBox, GWL_USERDATA, GetWindowLong(m_hEditBox, GWL_WNDPROC));
	SetWindowLong(m_hEditBox, GWL_WNDPROC, (DWORD)CmbEditProc);

	MoveWindow(m_hAddressbar, 0, 0, GetSystemMetrics(SM_CXSCREEN), (int)(22 * g_MainWnd.m_fpHighResolutionScale), TRUE);
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetEnableEditPasteBef()
{
	SetEnableEditPaste(FALSE);

	//Nbv{[hI[v
	if (OpenClipboard(NULL))
	{
		//Nbv{[hɃf[^ꍇ͗L
		HANDLE hClipText = GetClipboardData(CF_UNICODETEXT);
		if (hClipText)
			SetEnableEditPaste(TRUE, FALSE);

		//Nbv{[hN[Y
		CloseClipboard();
	}
}
///////////////////////////////////////////////////////////////
void CCmdBands::SetEnableEditPasteAft()
{
	//Rs[t@Cɂăj[̗L/ݒ
	SetEnableEditPaste(g_MainWnd.m_ListView.m_lpliinfo? TRUE: FALSE);
}

///////////////////////////////////////////////////////////////
void CCmdBands::SetEnableEditPaste(BOOL bEnable, BOOL bShortCut)
{
	EnableMenuItem(m_hMenuMain, ID_EDIT_PASTE, bEnable? (MF_BYCOMMAND|MF_ENABLED): (MF_BYCOMMAND|MF_GRAYED));
	if (bShortCut)
		EnableMenuItem(m_hMenuMain, ID_EDIT_PASTE_SHORTCUT, bEnable? (MF_BYCOMMAND|MF_ENABLED): (MF_BYCOMMAND|MF_GRAYED));
	SendMessage(m_hToolbar, TB_SETSTATE, ID_EDIT_PASTE, bEnable? TBSTATE_ENABLED: TBSTATE_INDETERMINATE);
}
///////////////////////////////////////////////////////////////
void CCmdBands::SaveRecent()
{
	HKEY hKey = 0;
	DWORD dwDisposition;
	if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_RECENT, 0, 
		_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
	{
		TCHAR szName[32];
		TCHAR szData[MAX_PATH];
		for (int i = 0; i < 8; i++)
		{
			_stprintf(szName, _T("Recent%d"), i + 1);
			if (SendMessage(m_hComboBox, CB_GETLBTEXT, i, (LPARAM)szData) != CB_ERR)
				RegSetValueEx(hKey, szName, 0, REG_SZ, (LPBYTE)szData, (_tcslen(szData) + 1) * sizeof(TCHAR));
		}
		RegCloseKey(hKey);
	}
}
///////////////////////////////////////////////////////////////
void CCmdBands::GetRecent()
{
	if (m_hComboBox)
	{
		HKEY hKey = 0;
		DWORD dwDisposition;
		if (RegCreateKeyEx(HKEY_CURRENT_USER, REG_KEY_RECENT, 0, 
			_T(""), REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dwDisposition) == ERROR_SUCCESS)
		{
			DWORD dwDataSize;
			BYTE bData[MAX_PATH * sizeof(TCHAR)];

			TCHAR szName[32];
			for (int i = 8 ; i > 0; i--)
			{
				dwDataSize = sizeof(bData);
				_stprintf(szName, _T("Recent%d"), i);
				if (RegQueryValueEx(hKey, szName, 0, NULL, bData, &dwDataSize) == ERROR_SUCCESS)
				{
					if (_tcslen((LPTSTR)bData))
						SendMessage(m_hComboBox, CB_INSERTSTRING, 0, (LPARAM)bData);
				}
			}
			RegCloseKey(hKey);
		}
	}
}
///////////////////////////////////////////////////////////////
void CCmdBands::OnViewToolBar()
{
	m_Settings.bShowToolBar = !m_Settings.bShowToolBar;
	ShowWindow(m_hToolbar, m_Settings.bShowToolBar? SW_SHOW: SW_HIDE);
	SetCheckViewToolBar();

	g_MainWnd.RecalcLayout();
}
///////////////////////////////////////////////////////////////
void CCmdBands::OnViewAddressBar()
{
	m_Settings.bShowAddressBar = !m_Settings.bShowAddressBar;
	ShowWindow(m_hAddressbar, m_Settings.bShowAddressBar? SW_SHOW: SW_HIDE);
	SetCheckViewAddressBar();

	g_MainWnd.RecalcLayout();
}

///////////////////////////////////////////////////////////////
void CCmdBands::OnTapAndHold(NMRGINFO* pnmri)
{
	OnRClick(pnmri->ptAction.x, pnmri->ptAction.y);
}

////////////////////////////////////////////////////////////////
void CCmdBands::OnRClick(int cx, int cy)
{
	TCHAR szPath[MAX_PATH];

	//ENbNj[쐬
	HMENU hMenu = GetSubMenu(g_MainWnd.m_ListView.m_hMenuPopup, ID_POPUP_ADDRESSBAR);
	UINT uEnable = IsClipboardFormatAvailable(CF_UNICODETEXT)? (MF_BYCOMMAND|MF_ENABLED): (MF_BYCOMMAND|MF_GRAYED);
	EnableMenuItem(hMenu, ID_EDIT_PASTE, uEnable);
	GetWindowText(m_hComboBox, szPath, MAX_PATH);

	//ENbNj[\
	TrackPopupMenu(hMenu, TPM_LEFTALIGN|TPM_TOPALIGN, cx, cy, 0, g_MainWnd.m_hWnd, NULL);
}

////////////////////////////////////////////////////////////////
void CCmdBands::OnEditClearFilePath()
{
	SetWindowText(m_hComboBox, _T(""));
}