#pragma once
#include <QtGui>
#include <QtNetwork>
#include "../definition.h"

#define AddressIndex 1
#define NameIndex 0
class MemberList:virtual public QTableWidget{
    Q_OBJECT
public:
    MemberList(QWidget *parent=NULL);
public slots:
    void remove_selected();
    void remove_all_contents();
    QList<AddressAndPort> addressPortList() const;
    QString name(const AddressAndPort&,bool) const;
    int isInMember(const AddressAndPort &peer,bool matchIPOnly)const;
    friend QDataStream &operator<<(QDataStream &out,const MemberList &value){
        QList<NameAndAddrPort> AddressList;
        for(int row=0;row<value.rowCount();row++){
            QStringList AddrAndPort=value.item(row,AddressIndex)->text().split(":");
            AddressList<<NameAndAddrPort(value.item(row,NameIndex)->text(),AddressAndPort(QHostAddress(AddrAndPort[0]),(AddrAndPort.count()==2)? AddrAndPort[1].toUShort():default_port));
        }
        out<<AddressList;
        return out;
    }

    friend QDataStream &operator>>(QDataStream &in, MemberList &value){
        QList<NameAndAddrPort> AddressList;
        in>>AddressList;
        value.remove_all_contents();
        foreach(NameAndAddrPort addressList,AddressList){
            QTableWidgetItem *name=new QTableWidgetItem(addressList.first),
            *AddressPort=new QTableWidgetItem(QString("%1:%2").
                                              arg(addressList.second.first.toString()).
                                              arg(addressList.second.second));
            value.insertRow(value.rowCount());
            value.setItem(value.rowCount()-1,NameIndex,name);
            value.setItem(value.rowCount()-1,AddressIndex,AddressPort);
        }
        return in;
    }

private:
    void keyReleaseEvent(QKeyEvent *);
};
