#include "jasmine_mainwindow.h"
#include "about.h"
#include "settingdialog.h"
#include "mainwindow_lang.h"
#include "../validator/ipaddressvalidator.h"
#include "../definition.h"
#include "../app_version.h"
#include <QtCore>
#include <QtGui>
#include <QDataStream>
#include <QPair>

#ifdef _OPENMP
#include <omp.h>
#endif

using namespace structures;
using namespace network;
mainWindow::mainWindow(){
	setupUi(this);

	this->settingdialog		= new SettingDialog(this);
	this->memberList		= new MemberList(this);
	this->sendTextEditor	= new RtfEditor(this);

	this->memberListPanel->addWidget(memberList);
	this->sendPanel->insertWidget(0,this->sendTextEditor,this->receivePanel->stretch(0));

	this->sendTextEditor->setFocus();

	QWidget::setTabOrder(this->sendTextEditor,this->sendButton);
	QWidget::setTabOrder(this->sendButton,this->sendFileButton);
	QWidget::setTabOrder(this->sendFileButton,this->addButton);
	QWidget::setTabOrder(this->addButton,this->removeButton);
	QWidget::setTabOrder(this->removeButton,this->editButton);
	QWidget::setTabOrder(this->editButton,this->receiveText);

	//I'll reimpletemt the format of this memberlist file...
	connect(this->sendFileButton,SIGNAL(clicked()),SLOT(on_sendFileAction_triggered()));
	memberFilters<<tr("Jasmine memberlist file(%1)").arg("*.jsm")<<tr("All file(%1)").arg("*");
	logFilters<<tr("Text file(%1)").arg("*.txt")<<tr("All file(%1)").arg("*");

	/*//These behaviors are not implemented.
	this->sendButton->setEnabled(false);
	this->sendFileButton->setEnabled(false);
	this->sendFileAction->setEnabled(false);
	this->runServerAction->setEnabled(false);*/

	this->mainServer=new tcpServer(default_buffer_size,this);

	connect(this->receiveText,SIGNAL(anchorClicked(const QUrl &)),SLOT(linkClicked(const QUrl &)));
	connect(this->receiveText,SIGNAL(highlighted(const QUrl &)),SLOT(selectedLink(const QUrl &)));
	connect(this->sendTextEditor,SIGNAL(invalidLink(const QString &)),SLOT(invalidLink(const QString &)));
	connect(this->sendTextEditor,SIGNAL(sendTriggered()),this->sendButton,SLOT(click()));

	connect(this->mainServer,SIGNAL(pending(const serverSocket &)),SLOT(tcpserver_pending(const serverSocket &)));
}
mainWindow::~mainWindow(){}
void mainWindow::closeEvent(QCloseEvent *event){
	this->saveMember(default_memberlist);
	this->saveConfig(default_setting);
	event->accept();
}
void mainWindow::showEvent(QShowEvent *event){
	if(rev==0)
		this->status->showMessage("<font color=\"#ff0000\">Don't forget almost all features are not implemented!</font>",default_status_interval);
	event->accept();
}
bool mainWindow::isInMember(const AddressAndPort &peer,bool matchIPOnly){
	QList<AddressAndPort> iplist=this->memberList->addressPortList();
	foreach(AddressAndPort addressPort,iplist){
		if(matchIPOnly&&peer.first==addressPort.first) return true;
		else if(peer==addressPort) return true;
	}
	return false;
}

//Client behavior
void mainWindow::on_sendButton_clicked(){
	QList<AddressAndPort> addressList=this->memberList->addressPortList();
	QVector<tcpClient *> clients(addressList.size());
	foreach(tcpClient *client,clients) client=new tcpClient(default_buffer_size,this->setting.name(),this);
#ifdef _OMP
#pragma omp parallel for
#endif
	for(int index=0;index<addressList.size();index++) (*clients[index])<<this->sendTextEditor->html();
}
void mainWindow::on_sendFileAction_triggered(){
	//TODO:Send files
}

void mainWindow::on_runServerAction_triggered(bool checked){
	if(checked){
		if(this->mainServer->isListening()) this->mainServer->close();
		if(this->mainServer->listen(this->setting.bindingAddr(),this->setting.port())){
			this->status->showMessage(server_running.arg(this->mainServer->serverAddress().toString()).arg(this->mainServer->serverPort()),default_status_interval);
			this->serverSettingAction->setEnabled(false);
		}
		else this->mainServer->close();
	}else{
		if(!this->mainServer->isListening()) return;
		this->mainServer->close();
		this->status->showMessage(server_stopped,default_status_interval);
		this->serverSettingAction->setEnabled(true);
	}
}
void mainWindow::settingDialog_accepted(){
	if(!this->mainServer->isListening()){
		if(!this->settingdialog->IPAddress().isNull())
			this->setting.setIPAddr(this->settingdialog->IPAddress());
		else
			QMessageBox::warning(this,invalid_IP_title,invalid_IP_body);
		this->setting.setPort(this->settingdialog->port());
	}
	this->setting.setName(this->settingdialog->nickName());
	this->setting.setNoloadMemberList(this->settingdialog->noloadMemberlist());
}
void mainWindow::configAndShowSettingDialog(const SettingDialog::tab tab){
	this->settingdialog->setTabEnabled(SettingDialog::server,!this->mainServer->isListening());
	this->settingdialog->setAddressAndPort(AddressAndPort(this->setting.bindingAddr(),this->setting.port()));
	this->settingdialog->setNickName(this->setting.name());
	this->settingdialog->setNoloadMemberlist(this->setting.noloadMemberList());
	this->settingdialog->setTab(tab);
	connect(settingdialog,SIGNAL(accepted()),SLOT(settingDialog_accepted()));
	settingdialog->exec();
}
void mainWindow::on_serverSettingAction_triggered(){configAndShowSettingDialog(SettingDialog::server);}
void mainWindow::on_clientSettingAction_triggered(){configAndShowSettingDialog(SettingDialog::client);}
void mainWindow::on_miscAction_triggered(){configAndShowSettingDialog(SettingDialog::misc);}
void mainWindow::on_saveConfigAction_triggered(){
	QFileDialog dialog(this,Qt::Dialog);
	dialog.setWindowTitle(save_setting_title);
	dialog.setNameFilter("Jasmine setting file (*.jst)");
	dialog.setAcceptMode(QFileDialog::AcceptSave);

	connect(&dialog,SIGNAL(fileSelected(const QString &)),SLOT(saveConfig(const QString &)));
	dialog.exec();
}

void mainWindow::on_openConfigAction_triggered(){
	QFileDialog dialog(this,Qt::Dialog);
	dialog.setWindowTitle(open_setting_title);
	dialog.setNameFilter("Jasmine setting file (*.jst)");
	dialog.setAcceptMode(QFileDialog::AcceptOpen);

	connect(&dialog,SIGNAL(fileSelected(const QString &)),SLOT(openConfig(const QString &)));
	dialog.exec();
}

void mainWindow::on_openMemberListAction_triggered(){
	QFileDialog *dialog=new QFileDialog(this,open_memberlist_title,"",this->memberFilters.join(";;"));
	dialog->setAcceptMode(QFileDialog::AcceptOpen);
	connect(dialog,SIGNAL(fileSelected(const QString &)),SLOT(openMember(const QString &)));
	dialog->exec();
	delete dialog;
}

void mainWindow::on_saveMemberListAction_triggered(){
	QFileDialog dialog(this,Qt::Dialog);
	dialog.setWindowTitle(save_memberlist_title);
	dialog.setNameFilters(this->memberFilters);
	dialog.setAcceptMode(QFileDialog::AcceptSave);

	connect(&dialog,SIGNAL(fileSelected(const QString &)),SLOT(saveMember(const QString &)));
	dialog.exec();
}

void mainWindow::on_saveLogAction_triggered(){
	QFileDialog dialog(this,Qt::Dialog);
	dialog.setWindowTitle(save_log_title);
	dialog.setNameFilters(this->logFilters);
	dialog.setAcceptMode(QFileDialog::AcceptSave);

	connect(&dialog,SIGNAL(fileSelected(const QString &)),SLOT(saveLog(const QString &)));
	dialog.exec();
}
void mainWindow::on_aboutAction_triggered(){
	about aboutDialog(this);
	aboutDialog.exec();
}

void mainWindow::on_actionExit_triggered(){qApp->exit(0);}
void mainWindow::on_clearAction_triggered(){this->receiveText->clear();}
void mainWindow::on_addButton_clicked(){
	QTableWidgetItem *name=new QTableWidgetItem(),*address=new QTableWidgetItem();
	this->memberList->insertRow(this->memberList->rowCount());
	name->setText(edithere);
	address->setText(edithere);
	this->memberList->setItem(this->memberList->rowCount()-1,0,name);
	this->memberList->setItem(this->memberList->rowCount()-1,1,address);
	this->memberList->setCurrentItem(name);
	this->memberList->editItem(name);
}

void mainWindow::on_removeButton_clicked(){this->memberList->remove_selected();}
void mainWindow::saveConfig(const QString &file){
	QFile filestream(file);
	if(!filestream.open(QFile::WriteOnly)){
		QMessageBox::critical(this,write_error_title,write_error_body.arg(filestream.fileName()).arg(filestream.errorString()));
		return;
	}
	QDataStream datastream(&filestream);
	datastream<<setting;
	filestream.close();
}
void mainWindow::saveMember(const QString &file){
	QFile filestream(file);
	if(!filestream.open(QFile::WriteOnly)){
		QMessageBox::critical(this,write_error_title,
							  write_error_body.arg(file).arg(filestream.errorString()));
		return;
	}
	QDataStream datastream(&filestream);
	datastream.setVersion(QDataStream::Qt_4_6);
	datastream<<(*this->memberList);
	filestream.close();
}
void mainWindow::saveLog(const QString &file){
	QFile filestream(file);
	if(!filestream.open(QFile::WriteOnly)){
		QMessageBox::critical(this,write_error_title,write_error_body.arg(file).arg(filestream.errorString()));
		return;
	}
	filestream.write(this->receiveText->toPlainText().toUtf8());
	filestream.close();
}

void mainWindow::openConfig(const QString &file){
	QFile filestream(file);
	if(!filestream.exists()){
		QMessageBox::critical(this, file_not_found_dialog_title,file_not_found_dialog_body.arg(filestream.fileName()));
		return;
	}
	if(!filestream.open(QFile::ReadOnly)){
		QMessageBox::critical(this,read_error_title,read_error_body.arg(filestream.fileName()).arg(filestream.errorString()));
		return;
	}
	QDataStream datastream(&filestream);
	datastream>>setting;
	filestream.close();
	QMessageBox::information(this,loadingSettingSucceeded_title,loadingSettingSucceeded_body.arg(filestream.fileName()));
}
void mainWindow::openMember(const QString &file){
	 /*
	  Does QFileDialog have a bug??
	  If you select file by double clicking, fileSelected signal will be emitted twice.
	  */
	if(this->sender()!=NULL&&this->sender()==this->beforesender) return;
	this->beforesender=this->sender();
	if(this->memberList->rowCount()>0&&
	   QMessageBox::warning(this,overwrite_memberlist_body,overwrite_memberlist_body
							 ,QMessageBox::Yes|QMessageBox::No)==QMessageBox::No)return;
	QFile filestream(file);
	if(!filestream.exists()){
		QMessageBox::critical(this,file_not_found_dialog_title,file_not_found_dialog_body.arg(filestream.fileName()));
		return;
	}
	if(!filestream.open(QFile::ReadOnly)){
		QMessageBox::critical(this,read_error_title,read_error_body.arg(filestream.fileName()).arg(filestream.errorString()));
		return;
	}
	QDataStream datastream(&filestream);
	datastream.setVersion(QDataStream::Qt_4_6);
	datastream>>(*this->memberList);
	filestream.close();
}
void mainWindow::linkClicked(const QUrl &link){if(!link.scheme().isEmpty()) QDesktopServices::openUrl(link);}
void mainWindow::invalidLink(const QString &link){this->status->showMessage(invalid_link.arg(link),default_status_interval);}
void mainWindow::selectedLink(const QUrl &link){
	if(link.scheme().isEmpty()||!link.isValid()){
		this->status->clearMessage();
		return;
	}
	this->status->showMessage(link.toString(QUrl::None));
}
settings mainWindow::app_setting() const{return this->setting;}

//Implementations for main server.
bool mainWindow::tcpserver_pending(const serverSocket &socket){
	if(!this->isInMember(AddressAndPort(socket.peerAddress(),0),true)) return false;
	connect(&socket,
			SIGNAL(msg_received(const serverSocket &,const QString &)),
			SLOT(tcpserver_msg_received(const serverSocket &,const QString &)));
	return true;
}
void mainWindow::tcpserver_msg_received(const serverSocket &socket,const QString &msg){
	this->receiveText->append(socket.header_data().senderName()+tr(" says:")+"<br />");
	this->receiveText->append(msg);
	this->receiveText->append("<br />");
}
