#include "header.h"
#include "../ported_rmd6/rmd6.h"
using namespace structures;
using namespace enc_hash;
header::header():rmd6_hash(5){}
header::header(const QString &senderName,const QString &msg):
		sendername(senderName),data_size(msg.size()){
	rmd6 gen;
	this->rmd6_hash=gen.compute_hash(msg.toUtf8());
}
header::header(const QString &senderName,const QFileInfo &fileinfo):
		filename(fileinfo.completeBaseName()),sendername(senderName),
		data_size(fileinfo.size()),rmd6_hash(5){
	rmd6 gen;
	QFile dev(fileinfo.absoluteFilePath());
	if(!dev.open(QFile::ReadOnly)) return;
	this->rmd6_hash=gen.compute_hash(dev);
}

QString header::senderName()const{return this->sendername;}
QString header::fileName()const{return this->filename;}
quint64 header::datasize()const{return this->data_size;}
QVector<quint32> header::ripemd160()const {return this->rmd6_hash;}

void header::senderName(const QString &sendername){this->sendername=sendername;}
void header::fileName(const QString &filename){this->filename=filename;}
void header::datasize(const quint64 size){this->data_size=size;}
bool header::operator==(const header &head) const{
	return (this->sendername==head.senderName()&&
			this->filename==head.fileName()&&
			this->data_size==head.datasize()&&
			this->rmd6_hash==head.ripemd160());
}
bool header::operator!=(const header &head) const{
	return (this->sendername!=head.senderName()||
			this->filename  !=head.fileName()||
			this->data_size !=head.datasize()||
			this->rmd6_hash !=head.ripemd160());
}
