#include "editdelegate.h"
MemberListEditDelegate::MemberListEditDelegate(QObject *parent):QItemDelegate(parent){}
QWidget *MemberListEditDelegate::createEditor(QWidget *parent,const QStyleOptionViewItem &option,const QModelIndex &index)const{
    QLineEdit *editor=qobject_cast<QLineEdit *>(QItemDelegate::createEditor(parent,option,index));
    editor->setValidator(new IPAddressValidator(false,editor));
    connect(editor,SIGNAL(editingFinished()),SLOT(edit_finished()));
    return editor;
}
void MemberListEditDelegate::edit_finished(){
    QLineEdit *editor=qobject_cast<QLineEdit *>(this->sender());
    emit this->commitData(editor);
    emit this->closeEditor(editor);
}
