#include "tcpnetwork.h"
#include <cstring>
#include "../structures/header.h"

using namespace network;
using namespace enc_hash;
using namespace structures;
using namespace std;


void tcpSocket::disconnectFromHostImplementation(){
    this->canceled=true;
    QTcpSocket::disconnectFromHost();
}
bool tcpSocket::check_canceled_then_abort(){
    if(this->canceled){
        this->setErrorString(tr("The process has been canceled by user."));
        emit this->error(QAbstractSocket::UnknownSocketError);
        this->abort();
        return true;
    }
    return false;
}
void tcpSocket::cancel(){this->canceled=true;}
QString tcpSocket::path_to_save() const{return this->where_to_save;}
header tcpSocket::header_data() const{return this->head_data;}

/* Threaded TCP socket implementation. */
QString threadedTcpSocket::senderName(){
    QString senderName;
    this->locks[threadedTcpSocket::SenderName].lockForRead();;
        senderName=this->_senderName;
    this->locks[threadedTcpSocket::SenderName].unlock();
    return senderName;
}
quint64 threadedTcpSocket::buffersize(){
    quint64 size;
    this->locks[threadedTcpSocket::BufferSize].lockForRead();
        size=this->_buffersize;
    this->locks[threadedTcpSocket::BufferSize].unlock();
    return size;
}
AddressAndPort threadedTcpSocket::peerAddr(){
    this->locks[threadedTcpSocket::AddrAndPort].lockForRead();
    AddressAndPort r=this->_addrPort;
    this->locks[threadedTcpSocket::AddrAndPort].unlock();
    return r;
}
void threadedTcpSocket::to(const AddressAndPort &to){
    this->locks[threadedTcpSocket::AddrAndPort].lockForWrite();
        this->_addrPort=to;
    this->locks[threadedTcpSocket::AddrAndPort].unlock();
}

int threadedTcpSocket::socketDescriptor(){
    int desc;
    this->locks[threadedTcpSocket::Descriptor].lockForRead();
        desc=this->_descriptor;
    this->locks[threadedTcpSocket::Descriptor].unlock();
    return desc;
}

void threadedTcpSocket::senderName(const QString &name){
    this->locks[threadedTcpSocket::SenderName].lockForWrite();
        this->_senderName=name;
    this->locks[threadedTcpSocket::SenderName].unlock();
}
void threadedTcpSocket::buffersize(const quint64 size){
    this->locks[threadedTcpSocket::BufferSize].lockForWrite();;
        this->_buffersize=size;
    this->locks[threadedTcpSocket::BufferSize].unlock();
}
void threadedTcpSocket::socketDescriptor(const int descriptor){
    this->locks[threadedTcpSocket::Descriptor].lockForWrite();
        this->_descriptor=descriptor;
    this->locks[threadedTcpSocket::Descriptor].unlock();
}
QIODevice::OpenMode threadedTcpSocket::readWriteMode(){
    QIODevice::OpenMode mode;
    this->locks[threadedTcpSocket::RWMode].lockForRead();
        mode=this->open_mode;
    this->locks[threadedTcpSocket::RWMode].unlock();
    return mode;
}
void threadedTcpSocket::readWriteMode(const QIODevice::OpenMode openMode){
    this->locks[threadedTcpSocket::RWMode].lockForWrite();
        this->open_mode=openMode;
    this->locks[threadedTcpSocket::RWMode].unlock();
}
header threadedTcpSocket::head_data(){
    this->locks[threadedTcpSocket::HeaderData].lockForRead();
        header head=this->_header;
    this->locks[threadedTcpSocket::HeaderData].unlock();
    return head;
}

void threadedTcpSocket::run(){
#ifdef DEBUG
    qDebug()<<"threadedTcpSocket has been created and running.";
#endif
    this->locks[threadedTcpSocket::BufferSize].lockForRead();
    this->locks[threadedTcpSocket::SenderName].lockForRead();
    tcpSocket *socket=
            (this->mode==threadedTcpSocket::Client)?
            new tcpSocket(this->_senderName,this->_buffersize):
            new tcpSocket(this->_buffersize);
    this->locks[threadedTcpSocket::BufferSize].unlock();
    this->locks[threadedTcpSocket::SenderName].unlock();
    /*Common signals*/
    connect(socket,SIGNAL(error(QAbstractSocket::SocketError)),
            SLOT(error_occured(QAbstractSocket::SocketError)),
            Qt::BlockingQueuedConnection);
    connect(socket,SIGNAL(connected()),SLOT(host_connected()),Qt::BlockingQueuedConnection);
    connect(socket,SIGNAL(connected()),SIGNAL(connected()));
    connect(socket,SIGNAL(disconnected()),SIGNAL(disconnected()));
    connect(socket,SIGNAL(disconnected()),SLOT(host_disconnected()),
            Qt::BlockingQueuedConnection);
    connect(socket,SIGNAL(hostFound()),SIGNAL(hostFound()));
    connect(socket,SIGNAL(proxyAuthenticationRequired(const QNetworkProxy &,QAuthenticator*)),
            SIGNAL(proxyAuthenticationRequired(const QNetworkProxy &,QAuthenticator*)));
    connect(socket,SIGNAL(stateChanged(QAbstractSocket::SocketState)),
            SIGNAL(stateChanged(QAbstractSocket::SocketState)));

    int descriptor;
    this->locks[threadedTcpSocket::Mode].lockForRead();
    switch(this->mode){
    case threadedTcpSocket::Client:
        connect(socket,SIGNAL(sentData()),SIGNAL(sentData()));
        connect(socket,SIGNAL(sentData()),SLOT(quit()));
        connect(socket,SIGNAL(file_header_sent()),SIGNAL(file_header_sent()));
        connect(socket,SIGNAL(sending_file_progress(quint64)),SIGNAL(sending_file_progress(quint64)));
        this->locks[threadedTcpSocket::AddrAndPort].lockForRead();
            socket->connectToHost(this->_addrPort.first,this->_addrPort.second);
        this->locks[threadedTcpSocket::AddrAndPort].unlock();
        break;
    case threadedTcpSocket::Session:
        this->locks[threadedTcpSocket::Descriptor].lockForRead();
            descriptor=this->_descriptor;
        this->locks[threadedTcpSocket::Descriptor].unlock();
        connect(socket,SIGNAL(msg_received(const QString &)),SIGNAL(msg_received(const QString &)));
        connect(socket,SIGNAL(msg_received(const QString &)),SLOT(quit()));

        connect(socket,SIGNAL(file_receive_progress(const quint64)),SIGNAL(file_receive_progress(const quint64)));
        connect(socket,SIGNAL(file_saved()),SIGNAL(file_saved()));
        connect(socket,SIGNAL(file_saved()),SLOT(quit()));
        connect(socket,SIGNAL(header_received()),SLOT(header_received()));
        if(!socket->setSocketDescriptor(descriptor)){
            this->_error=socket->errorString();
            emit this->error(socket->error());
        }
        this->_addrPort.first=socket->peerAddress();
        this->_addrPort.second=socket->peerPort();
        break;
    }
    this->locks[threadedTcpSocket::Mode].unlock();
    if(this->exec()==0){
        socket->disconnectFromHost();
        return;
    }
    //Cleanup
    socket->abort();
}
void threadedTcpSocket::host_connected(){
    tcpSocket *socket=qobject_cast<tcpSocket *>(this->sender());
#ifdef DEBUG
    qDebug()<<"Client:"<<socket->peerAddress().toString()<<"has been connected properly.";
#endif
    this->locks[threadedTcpSocket::Msg].lockForRead();
        bool r=this->_msg.isNull();
    this->locks[threadedTcpSocket::Msg].unlock();
    if(r){
        this->locks[threadedTcpSocket::File].lockForRead();
        (*socket)<<this->_file;
        this->locks[threadedTcpSocket::File].unlock();
    }else{
        this->locks[threadedTcpSocket::Msg].lockForRead();
        (*socket)<<this->_msg;
        this->locks[threadedTcpSocket::Msg].unlock();
    }
}
void threadedTcpSocket::host_disconnected(){
    tcpSocket *socket=qobject_cast<tcpSocket *>(this->sender());
    socket->close();
#ifdef DEBUG
    qDebug()<<"Socket("<<((this->mode==threadedTcpSocket::Session)?"Session":"Client")<<"):Connection closed successful.";
#endif
    socket->deleteLater();
}

void threadedTcpSocket::error_occured(const QAbstractSocket::SocketError error){
    tcpSocket *socket=(tcpSocket*)this->sender();
    this->locks[threadedTcpSocket::Error].lockForWrite();
        this->_error=socket->errorString();
    this->locks[threadedTcpSocket::Error].unlock();
    this->exit(1);
    emit this->error(error);
}
QString threadedTcpSocket::errorString(){
    this->locks[threadedTcpSocket::Error].lockForRead();
        QString str=this->_error;
    this->locks[threadedTcpSocket::Error].unlock();
    return str;
}
