﻿using System;
using System.Collections;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Threading;
using System.Net.Sockets;
using System.Net;
using UpdateChecker;

using nslookupLib;
using ProgressControlLib;
using Server;
using Client;
using Jasmine.Setting;
using Jasmine.Properties;

namespace Jasmine
{
	public partial class MainForm : Form
	{
		const int port = 10063;
		bool EnterPressed = false, Ctrl = false,wisp = false,NowLoading=false;
		DataTransProgDlg SendDlg,RecDlg;
		WaitForm wf;
		DlWIndowSettings ds;
		ClientSettings cl;
		Servercfg sc;
		Settings st;
		TcpServer server=null;
		OperatingSystem os = Environment.OSVersion;
		public MainForm()
		{
			Application.ThreadException += delegate(object o, ThreadExceptionEventArgs a)
			{
				OutPutException(a.Exception);
			};
			wf = new WaitForm();
			ds = new DlWIndowSettings();
			cl = new ClientSettings();
			sc = new Servercfg();
			st = new Settings();
			InitializeComponent();
			this.Text = Application.ProductName;
			NowLoading = true;
			if (!wf.Visible)
			{
				wf.Show();
			}
			//OSの違い関係の設定
			switch (os.Platform)
			{
				case PlatformID.Unix:
					RecText.Clear(); MsgEditor.Clear();
					RecText.ForeColor = Color.Black;
					FileTranceportBtn.Enabled = false;
					VisMenu.Enabled = false;
					DlWindowCfgMenu.Enabled = false;
					SaveLog.Enabled = false;
					CheckUpdateBtn.Enabled = false;
					MsgEditor.MaxLen = 10000;
					this.Text += " UnixMode";
					break;
				default:
					SendDlg = new DataTransProgDlg(ProgressControlLib.type.Send);
					RecDlg = new DataTransProgDlg(ProgressControlLib.type.Receive);
					if (st.AutoUpdateCheck)
					{
						CheckUpdate();
					}
					break;
			}
			MsgEditor.TextChanged+=new EventHandler(MsgEditor_TextChanged);
			MsgEditor.Editor_KeyDown+=new KeyEventHandler(MsgEditor_KeyDown);
			MsgEditor.Editor_KeyPress+=new KeyPressEventHandler(MsgEditor_KeyPress);
			MemberList.MList.SelectedIndexChanged+=new EventHandler(MemberList_SelectedIndexChanged);
			if (File.Exists(Path.Combine(Application.StartupPath, "MemberList.mml")))
			{
				MemberList.SaveOrOpenMemberList(
					Path.Combine(Application.StartupPath, "MemberList.mml"),
					MemberListView.MemberListView.OpenOrSave.Open);
			}
			if (st.AutoCheck)
			{
				CheckIPAddr(new Nslookup.GotAddressEventHandler(nl_GotIPAddress));
			}
			NowLoading = false;
			if (wf.Visible)
			{
				wf.Close();
			}
		}
		#region システムメッセージの反映
		private void Add_System_Msg(Color Color, String str)
		{
			switch (os.Platform)
			{
				case PlatformID.Unix:
					RecText.AppendText(str + "\r\n\r\n");
					break;
				default:
					RecText.SelectionStart = RecText.TextLength;
					RecText.SelectionColor = Color;
					RecText.SelectedText = str+"\r\n";
					RecText.SelectionStart = RecText.TextLength;
					break;
			}
		}
		#endregion
		#region 例外処理メゾッド
		private void OutPutException(Exception e)
		{
			StringBuilder sb = new StringBuilder();
			sb.AppendLine(e.ToString());
			if (e.Data.Count > 0)
			{
				sb.AppendLine("追加情報：");
				foreach (DictionaryEntry de in e.Data)
				{
					sb.AppendLine(de.Key + "：" + de.Value);
				}
			}
			switch (os.Platform)
			{
				case PlatformID.Unix:
					RecText.AppendText(sb.ToString()+"\r\n");
					break;
				default:
					RecText.SelectionStart = RecText.TextLength;
					RecText.SelectionColor =
						Color.FromArgb(255, 100, 100);
					RecText.SelectedText = sb.ToString()+"\r\n";
					RecText.SelectionStart = RecText.TextLength;
					break;
			}
		}
		#endregion
		#region 受信・送信メッセージの反映
		private void AddMsg(String Name,String Sentence,Color NameColor, bool wisp,FontStyle f)
		{
			//OSの判別
			switch (os.Platform)
			{
				case PlatformID.Unix:
					//RichTextBoxをパイプとしてテキストへ変換
					RichTextBox rt = new RichTextBox();
					rt.Rtf = Sentence;
					Sentence = rt.Text;
					rt.Dispose();
					//追加するときに出来る限りrtfモードに近くする。
					RecText.SelectionStart = RecText.TextLength;
					RecText.SelectionFont = new Font(RecText.SelectionFont.FontFamily,
						RecText.SelectionFont.Size,f);
					RecText.SelectionColor = NameColor;
					RecText.SelectedText = (wisp ? "[内緒話]" : String.Empty) + Name + "の発言：\r\n";
					RecText.DeselectAll();
					RecText.SelectionStart = RecText.TextLength;
					RecText.SelectionFont = new Font(
						RecText.SelectionFont.FontFamily, RecText.SelectionFont.Size, FontStyle.Regular
						);
					RecText.SelectionColor = RecText.ForeColor;
					RecText.SelectedText = Sentence;
					RecText.AppendText("\r\n");
					RecText.Refresh();
					break;
				default:
					RecText.SelectionStart = RecText.TextLength;
					RecText.SelectionFont = new Font(RecText.SelectionFont.FontFamily,
						RecText.SelectionFont.Size,f);
					RecText.SelectionColor = NameColor;
					RecText.SelectedText = (wisp ? "[内緒話]" : String.Empty) + Name + "の発言：\r\n";
					RecText.DeselectAll();
					RecText.SelectionStart = RecText.TextLength;
					RecText.SelectedRtf = Sentence;
					RecText.AppendText("\r\n");
					RecText.Refresh();
					break;
			}
		}
		#endregion

		void CheckIPAddr(Nslookup.GotAddressEventHandler e)
		{
			WFShow();
			Nslookup nl = new Nslookup(this);
			nl.GotAddress += e;
			nl.GotException+=new Nslookup.GotExceptionEventHandler(nl_GotException);
			nl.GetIPAddr(new Uri(st.CheckIPUri));
		}

		void nl_GotException(object sender, Nslookup.ExceptionEventArgs e)
		{
			OutPutException(e.exception);
		}

		void nl_GotAddress(object sender, Nslookup.IPAddressEventArgs e)
		{
			WFClose();
			IPAddressDlg dlg = new IPAddressDlg();
			dlg.IPAddress.Items.Add(e.IPAddress);
			dlg.ShowDialog();
		}

		void nl_GotIPAddress(object sender, Nslookup.IPAddressEventArgs e)
		{
			WFClose();
			if (!st.IPAddress.Equals(e.IPAddress))
			{
				StringBuilder sb = new StringBuilder();
				sb.AppendLine("IPアドレスの変更を検知しました。");
				sb.AppendLine("以下のアドレスをメンバリスト全員にアナウンスして下さい。");
				sb.AppendLine();
				sb.AppendLine(e.IPAddress);
				sb.AppendLine();
				sb.AppendLine("IPアドレスをクリップボードにコピーするにはOKボタンを、コピーしない場合はCancelボタンを押して下さい。");
				DialogResult dr=MessageBox.Show(sb.ToString(), "IPアドレスが変わりました。",
						MessageBoxButtons.OKCancel, MessageBoxIcon.Information);
				if (dr == DialogResult.OK)
				{
					Clipboard.SetText(e.IPAddress);
				}
				st.IPAddress = e.IPAddress;
				st.Save();
			}
		}
		private void WFClose()
		{
			if (NowLoading) return;
			if (wf.Visible) wf.Close();
		}
		private void WFShow()
		{
			if (NowLoading) return;
			if (!wf.Visible) wf.Show();
		}
		private void CConfigMenu_Click(object sender, EventArgs e)
		{
			ClientConfig cc = new ClientConfig();
			cc.Boldchk.Checked = 
				(cl.NameStyle == FontStyle.Bold||cl.NameStyle==(FontStyle.Bold|FontStyle.Italic));
			cc.ItalChk.Checked = 
				(cl.NameStyle == FontStyle.Italic || cl.NameStyle == (FontStyle.Bold|FontStyle.Italic));
			cc.ColorPickerBtn.ForeColor = cl.NameColor;
			cc.SendBufferSize.Value = cl.SendingSize;
			if (cc.ShowDialog() == DialogResult.OK)
			{
				cl.NameColor = cc.ColorPickerBtn.ForeColor;
				cl.NameStyle = (
					(cc.Boldchk.Checked && cc.ItalChk.Checked) ? FontStyle.Bold | FontStyle.Italic :
					(cc.Boldchk.Checked && !cc.ItalChk.Checked) ? FontStyle.Bold :
					(!cc.Boldchk.Checked && cc.ItalChk.Checked) ? FontStyle.Italic : FontStyle.Regular);
				cl.SendingSize = (int)cc.SendBufferSize.Value;
				cl.Save();
			}
		}
		
		private void ServerConfig_Click(object sender, EventArgs e)
		{
			ServerConfigInterface sci = new ServerConfigInterface();
			if (sci.ShowDialog() == DialogResult.OK)
			{
				sc.IsOnlyMember = sci.IsOnlyMemberChk.Checked;
				sc.KeyPath = sci.KeyFile;
				sc.RecSize = (int)sci.ReceivingSize.Value;
				sc.Save();
			}
			sci.Dispose();
		}
		
		private void RemovaLog_Click(object sender, EventArgs e)
		{
			RecText.Clear();
			RecText.ClearUndo();
		}
		
		private void SaveLog_Click(object sender, EventArgs e)
		{
			SaveFileDialog sd = new SaveFileDialog();
			sd.Filter = "リッチテキスト文章(*.rtf)|*.rtf|プレーンテキスト文章(*.txt)|*.txt";
			sd.FilterIndex = 1;
			if (sd.ShowDialog() == DialogResult.OK)
			{
				switch(sd.FilterIndex){
					case 1:
						RecText.SaveFile(sd.FileName, RichTextBoxStreamType.RichText);
					break;
					case 2:
						RecText.SaveFile(sd.FileName, RichTextBoxStreamType.PlainText);
						break;
				}
			}
			sd.Dispose();
		}
		
		private void ExitSoft_Click(object sender, EventArgs e)
		{
			Application.ExitThread();
			Application.Exit();
		}
		
		private void InitConfig_Click(object sender, EventArgs e)
		{
			if (MessageBox.Show("設定を初期化すると\"全て\"の設定が初期化されます。\r\n継続しますか？",
				"初期化に関する警告", 
				MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation) == DialogResult.Yes)
			{
				sc.Reset();
				cl.Reset();
				st.Reset();
				ds.Reset();

				st.Save();
				sc.Save();
				cl.Save();
				ds.Save();
				MessageBox.Show("初期化後、アプリケーションを再起動します。");
				Application.Restart();
			}
		}
		private void RunServerBtn_CheckedChanged(object sender, EventArgs e)
		{
			ToolStripButton but = (ToolStripButton)sender;
			if (but.Checked)
			{
				server = new TcpServer(this);
				server.ServerRunningStatus += new ServerRunningEventHandler(server_ServerRunningStatus);
				server.MsgReceived += new MsgReceivedEventHandler(server_MsgReceived);
				server.FileInCue += new FileInCueEventHandler(server_FileInCue);
				server.FileProgressChanged += new FileProgressChangedEventHandler(server_FileProgressChanged);
				server.FileReceiveCompleted += new FileReceiveCompletedEventHandler(server_FileReceiveCompleted);
				server.UserCanceled += new UserCanceledEventHandler(server_UserCanceled);
				server.GotException += new GotExceptionEventHandler(server_GotException);
				server.Run(new ServerArgs(port,sc.RecSize,sc.KeyPath));
			}
			else
			{
				server.Stop();
				server = null;
			}
		}

		void server_GotException(object sender, TcpServer.GotExceptionEventArgs e)
		{
			OutPutException(e.Exception);
		}

		void server_UserCanceled(object sender, TcpServer.UserCancelEventArgs e)
		{
			if (ds.CloseDown && RecDlg.FileTransProgress.item.Count < 1)
			{
				RecDlg.Close();
			}
		}

		void server_FileReceiveCompleted(object sender, TcpServer.FileReceiveCompletedEventArgs e)
		{
			StringBuilder sb = new StringBuilder();
			sb.AppendLine("ファイルを受信しました。");
			sb.AppendLine("ファイル名：" + e.FileName);
			sb.AppendLine("From:" + e.HostInfo.Address.ToString());
			Add_System_Msg(Color.FromArgb(128, 255, 128), sb.ToString());
		}

		void server_FileProgressChanged(object sender, TcpServer.FileProgressChangedEventArgs e)
		{
			Item i = (Item)RecDlg.FileTransProgress.item[e.FileName+e.HostInfo.Address.ToString()];
			i.Position = Convert.ToInt32(e.Position);
			i.Speed = e.Speed;
			if (i.Position >= i.FileSize)
			{
				i.RemoveList(e.HostInfo.Address.ToString());
			}
			if (ds.CloseDown && RecDlg.FileTransProgress.item.Count < 1)
			{
				RecDlg.Close();
			}
		}
		string server_FileInCue(object sender, TcpServer.FileInCueEventArgs e)
		{
			Item i = new Item(new string[] { e.HostInfo.Address.ToString() },
				e.FileName, Convert.ToInt32(e.FileSize), type.Receive);
			if (!RecDlg.Visible)
			{
				RecDlg.Show();
			}
			return Item.WaitForAgree(RecDlg.FileTransProgress,i,e.HostInfo);
		}

		void server_MsgReceived(object sender, TcpServer.MsgReceivedEventArgs e)
		{
			String Addr = e.HostInfo.Address.ToString();
			ListViewItem i = MemberList.MList.FindItemWithText(Addr, true, 0);
			String Name = (i != null) ? i.SubItems[0].Text + "(" + Addr + ")" :
				(sc.IsOnlyMember) ? Addr : String.Empty;
			if (String.IsNullOrEmpty(Name)) return;
			AddMsg(Name, e.Body, e.Color, e.Wisp, e.NameStyle);
		}

		void server_ServerRunningStatus(object sender, TcpServer.ServerRunningEventArgs e)
		{
			switch (e.Status)
			{
				case ServerStatus.ServerWorked:
					ServerConfig.Enabled = false;
					IsServerWorking.Text = "稼働中です("+port.ToString()+")";
					break;
				case ServerStatus.ServerStopped:
					ServerConfig.Enabled = true;
					IsServerWorking.Text = "稼動していません。";
					break;
			}
		}
		
		private void MemberList_SelectedIndexChanged(object sender, EventArgs e)
		{
			PMBtn.Enabled = (MemberList.MList.SelectedItems.Count > 0
				&& !MsgEditor.Text.Equals(String.Empty)&&server!=null) ? true : false;
		}
		
		private void MsgEditor_TextChanged(object sender, EventArgs e)
		{
			SendBtn.Enabled = (!MsgEditor.Text.Equals(String.Empty) && server != null);
			PMBtn.Enabled = (!MsgEditor.Text.Equals(String.Empty) &&
				MemberList.MList.SelectedItems.Count > 0 &&
				server != null);
		}
		String FilePath;
		private void FileTranceportBtn_Click(object sender, EventArgs e)
		{
			SendFileInterface fs = new SendFileInterface();
			fs.AddressList.BeginUpdate();
			foreach (ListViewItem li in MemberList.MList.Items)
			{
				fs.AddressList.Items.Add(new ListViewItem(new string[] { li.Text, 
					li.SubItems[1].Text,li.SubItems[2].Text }));
			}
			fs.AddressList.EndUpdate();
			if (fs.ShowDialog() == DialogResult.OK)
			{
				FilePath = fs.FilePath.Text;
				ListViewItem[] item = new ListViewItem[fs.AddressList.SelectedItems.Count];
				if (String.IsNullOrEmpty(FilePath))
				{
					MessageBox.Show("ファイルが指定されていませんよ？","ファイルをちゃんと指定しましょう。",
						MessageBoxButtons.OK,MessageBoxIcon.Exclamation);
					return;
				}
				if (fs.AddressList.SelectedItems.Count<1)
				{
					MessageBox.Show("あて先が指定されていませんよ？", "宛先がない手紙は戻ってきます。",
						MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
					return;
				}
				((ToolStripButton)sender).Enabled = false;
				FileInfo fi = new FileInfo(FilePath);
				ClientArgumentArray ca = new ClientArgumentArray(fi.FullName, true, false,
					new byte[] { cl.NameColor.R, cl.NameColor.G, cl.NameColor.B }, cl.NameStyle);
				foreach (ListViewItem host in fs.AddressList.SelectedItems)
				{
					ListViewItem rsa = MemberList.MList.FindItemWithText(host.SubItems[1].Text,true,0);
					ca.Add(new AddressStruct(host.SubItems[1].Text,
						((rsa==null)?string.Empty:rsa.SubItems[2].Text),port,cl.SendingSize));
				}
				ClientClass cc = new ClientClass(this);
				cc.UserCanceled+=new ClientEventHandler.UserCanceledEventHandler(cc_UserCanceled);
				cc.FileDataSendProgressChanged+=new ClientEventHandler.FileSendProgressChangedEventHandler(cc_FileDataSendProgressChanged);
				cc.DataSendCompletedOnece += new ClientEventHandler.DataSendCompletedOneceEventHandler(cc_DataSendCompletedOnece);
				cc.DataSendCompleted += new ClientEventHandler.DataSendCompletedEventHandler(cc_DataSendCompleted);
				cc.GotException += new ClientEventHandler.GotExceptionEventHandler(cc_GotException);
				cc.Send(ca);
				if (ds.OpenUp&&!SendDlg.Visible)
				{
					SendDlg.Show();
				}
				ArrayList al=new ArrayList();
				foreach(AddressStruct host in ca.Addresses)
				{
					al.Add(host.Host);
				}
				SendDlg.FileTransProgress.AddItem(new Item((string[])al.ToArray(typeof(string)),
					ca.FilePath_or_Sentence,(int)fi.Length,type.Send));
			}
		}

		void cc_GotException(object sender, ClientEventArgs.GotExceptionEventArgs e)
		{
			for (long i = 0; i < e.Info.Addresses.LongLength&&(e.ex is SocketException); i++)
			{
				e.ex.Data.Add("Address" + i.ToString(), e.Info.Addresses[i].Host);
			}
			OutPutException(e.ex);
		}

		void cc_DataSendCompleted(object sender, ClientArgumentArray e)
		{
			if (SendDlg.Visible)
			{
				SendDlg.Close();
			}
			StringBuilder sb = new StringBuilder();
			sb.AppendLine("ファイルの送信作業が完了しました。");
			sb.AppendLine("ファイル名："+e.FilePath_or_Sentence);
			sb.AppendLine("宛先:");
			foreach (AddressStruct s in e.Addresses)
			{
				sb.AppendLine(s.Host);
			}
			FileTranceportBtn.Enabled = true;
			Add_System_Msg(Color.FromArgb(128, 255, 128), sb.ToString());
		}

		void cc_DataSendCompletedOnece(object sender, AddressStruct e)
		{
			((Item)SendDlg.FileTransProgress.item[e.filename]).RemoveList(e.Host);
			StringBuilder sb = new StringBuilder();
			sb.AppendLine("ファイルを送信しました。");
			sb.AppendLine("宛先" + e.Host);
			Add_System_Msg(Color.FromArgb(128, 255, 128),sb.ToString());
		}

		void cc_UserCanceled(object sender, AddressStruct e)
		{
			((Item)SendDlg.FileTransProgress.item[FilePath]).RemoveList(e.Host);
			if (ds.CloseUp && SendDlg.FileTransProgress.item.Count < 1)
			{
				SendDlg.Close();
			}
			if (SendDlg.FileTransProgress.item.Count < 1)
			{
				FileTranceportBtn.Enabled = true;
			}
			StringBuilder sb = new StringBuilder();
			sb.AppendLine("ユーザの判断により、ファイルの送受信はキャンセルされました。");
			sb.AppendLine("または、以下の理由が考えられます。");
			sb.AppendLine("・使用者がUnix");
			sb.AppendLine("・同名のファイルが現在受信中である。（ファイル名を変更して再試行して下さい。）\r\n");
			sb.AppendLine("Host:" + e.Host);
			Add_System_Msg(Color.FromArgb(128, 128, 255), sb.ToString());
		}

		void cc_FileDataSendProgressChanged(object sender, ClientEventArgs.FileDataSendProgressChanged e)
		{
			Item i = (Item)SendDlg.FileTransProgress.item[e.FileName];
			i.Position = (int)e.Position;
			i.Speed = e.Speed;
		}
		private void SendBtn_Click(object sender, EventArgs e)
		{
			if (MemberList.MList.Items.Count > 0)
			{
				((Button)sender).Enabled = false;
				MsgEditor.Enabled = false;
				wisp = (sender.Equals(PMBtn));
				ClientArgumentArray ca = new ClientArgumentArray(MsgEditor.Rtf, false, wisp,
					new byte[] { cl.NameColor.R, cl.NameColor.G, cl.NameColor.B }, cl.NameStyle);
				if (wisp)
				{
					foreach (ListViewItem li in MemberList.MList.SelectedItems)
					{
						ca.Add(
							new AddressStruct(li.SubItems[1].Text, li.SubItems[2].Text, port, cl.SendingSize)
							);
					}
				}
				else
				{
					foreach (ListViewItem li in MemberList.MList.Items)
					{
						ca.Add(
							new AddressStruct(li.SubItems[1].Text, li.SubItems[2].Text, port, cl.SendingSize)
							);
					}
				}
				ClientClass cli = new ClientClass(this);
				cli.DataSendCompleted += new ClientEventHandler.DataSendCompletedEventHandler(cli_DataSendCompleted);
				cli.GotException += new ClientEventHandler.GotExceptionEventHandler(cli_GotException);
				cli.Send(ca);
				return;
			}
			Add_System_Msg(Color.FromArgb(0, 0, 255), "メンバ数0で送信しようとでも？");
		}

		void cli_GotException(object sender, ClientEventArgs.GotExceptionEventArgs e)
		{
			for (long i = 0; i < e.Info.Addresses.LongLength&&e.ex is SocketException; i++)
			{
				e.ex.Data.Add("Address" + i.ToString(), e.Info.Addresses[i].Host);
			}
			OutPutException(e.ex);
		}

		void cli_DataSendCompleted(object sender, ClientArgumentArray e)
		{
			StringBuilder sb = new StringBuilder(), Name = new StringBuilder();
			for (long i = 0; i < e.Addresses.LongLength; i++)
			{
				AddressStruct a = e.Addresses[i];
				ListViewItem li=MemberList.MList.FindItemWithText(a.Host, true, 0);
				string name = (li == null) ? a.Host : li.SubItems[0].Text;
				sb.Append((i < (e.Addresses.LongLength - 1)) ? name + "," : name);
			}
			Name.Append("自分" + (wisp ? "(To:" + sb.ToString() + ")" : String.Empty));
			AddMsg(Name.ToString(), MsgEditor.Rtf, cl.NameColor, wisp, cl.NameStyle);
			ClearForcus();
		}

		void ClearForcus()
		{
			MsgEditor.Enabled = true;
			MsgEditor.Clear();
			MsgEditor.ClearUndo();
			MsgEditor.Focus();
		}
		
		private void RecText_TextChanged(object sender, EventArgs e)
		{
			RecText.ScrollToCaret();
		}
		private void MsgEditor_KeyDown(object sender, KeyEventArgs e)
		{
			e.Handled = ((e.KeyCode == Keys.Enter && e.Control) || (e.KeyCode == Keys.Enter && !e.Control && !e.Shift));
			if (e.KeyCode == Keys.Enter && e.Control)
			{
				EnterPressed = true;
				Ctrl = true;
			}
			else if(e.KeyCode==Keys.Enter&&!e.Control&&!e.Shift)
			{
				EnterPressed = true;
			}
		}
		
		private void MsgEditor_KeyPress(object sender, KeyPressEventArgs e)
		{
			e.Handled = true;
			if (EnterPressed && Ctrl)
			{
				SendBtn.PerformClick();
			}
			else if (EnterPressed && !Ctrl)
			{
				PMBtn.PerformClick();
			}
			EnterPressed = false;
			Ctrl = false;
			e.Handled = false;
		}
		
		private void ShowVersionBtn_Click(object sender, EventArgs e)
		{
			VersionForm vf = new VersionForm();
			vf.ShowDialog();
			vf.Dispose();
		}
		
		private void ShowIPAddrMenuItem_Click(object sender, EventArgs e)
		{
			CheckIPAddr(new Nslookup.GotAddressEventHandler(nl_GotAddress));
		}

		private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
		{
			if (MemberList.MList.Items.Count > 0)
			{
				MemberList.SaveOrOpenMemberList(
					Path.Combine(Application.StartupPath, "MemberList.mml"),
					MemberListView.MemberListView.OpenOrSave.Save);
			}
			else
			{
				File.Delete(Path.Combine(Application.StartupPath, "MemberList.mml"));
			}
		}

		private void MemberAddBtn_Click(object sender, EventArgs e)
		{
			MemberList.AddOrEditList(false);
		}

		private void SendingProgressItem_Click(object sender, EventArgs e)
		{
			SendDlg.Show();
		}

		private void ReceivingProgressItem_Click(object sender, EventArgs e)
		{
			RecDlg.Show();
		}

		private void DlWindowCfgMenu_Click(object sender, EventArgs e)
		{
			VisSetting.Settings vs = new VisSetting.Settings();
			vs.CloseRec = ds.CloseDown;
			vs.CloseSend = ds.CloseUp;
			vs.OpenSend = ds.OpenUp;
			VisSetting s = new VisSetting(vs);
			if (s.ShowDialog(this) == DialogResult.OK)
			{
				ds.CloseDown = s.CloseWhenDownloadComplete.Checked;
				ds.CloseUp = s.CloseWhenSendComplete.Checked;
				ds.OpenUp = s.AlwaysOpenSendDialog.Checked;
			}
			ds.Save();
		}

		private void OtherConfigMenu_Click(object sender, EventArgs e)
		{
			OtherSettingUI osu = new OtherSettingUI();
			osu.ScriptUri.Text = st.CheckIPUri;
			osu.AutoCheck.Checked = st.AutoCheck;
			osu.AutoUpdateCheck.Checked = st.AutoUpdateCheck;
			if (osu.ShowDialog() == DialogResult.OK)
			{
				if (!st.CheckIPUri.Equals(osu.ScriptUri.Text))
				{
					st.CheckIPUri = osu.ScriptUri.Text;
					CheckIPAddr(new Nslookup.GotAddressEventHandler(nl_GotIPAddress));
				}
				st.AutoCheck = osu.AutoCheck.Checked;
				st.AutoUpdateCheck = osu.AutoUpdateCheck.Checked;
				st.Save();
			}
		}

		private void CheckUpdateBtn_Click(object sender, EventArgs e)
		{
			ToolStripButton sd = (ToolStripButton)sender;
			sd.Enabled = false;
			CheckUpdate();
			sd.Enabled = true;
		}
		private void CheckUpdate()
		{
			Updater up = new Updater("http://hysoftware.net/softwares/xml/local.xml", 0);
			up.FileDownloading += new DownloadProgressChangedEventHandler(up_FileDownloading);
			WFShow();
			wf.UpdateProgress.Show();
			Version av;
			if ((av=up.CheckUpdate(new Version(Application.ProductVersion))).CompareTo(new Version(0,0,0,0))>0)
			{
				if (MessageBox.Show("新しいバージョン：" + av.ToString() +
					"\r\nが使用できます。アップデートしますか？", "アップデートの通知", MessageBoxButtons.YesNo,
					MessageBoxIcon.Question) != DialogResult.Yes) goto close;
				up.RunUpdate();
				return;
			}
			if (!NowLoading) MessageBox.Show("新しい更新はありません。", "更新ナシ", MessageBoxButtons.OK,
				  MessageBoxIcon.Information);
			close:
			wf.UpdateProgress.Hide();
			WFClose();
		}

		void up_FileDownloading(object sender, DownloadProgressChangedEventArgs e)
		{
			wf.UpdateProgress.Show();
			wf.UpdateProgress.Maximum = (int)e.TotalBytesToReceive;
			wf.UpdateProgress.Value = (int)e.BytesReceived;
			if (wf.UpdateProgress.Value >= wf.UpdateProgress.Maximum)
			{
				wf.UpdateProgress.Hide();
				WFClose();
			}
		}
	}
}