unit PopupMenuUtil;

interface

uses
	Windows, Messages, SysUtils, Classes, Controls,
	StdCtrls, ExtCtrls, ComCtrls, ActnList, Menus,
    IniFiles,	GikoSystem, MojuUtils, Giko;

    procedure ReadSetting(ActionList: TActionList; PopupMenu: TPopupMenu);
    function GetActionItem(ActionList: TActionList; ActionName: string): TCustomAction;
    function GetMenuItem(Section: string; PopupMenu: TPopupMenu; ActionList: TActionList; MenuName: string): TMenuItem;
    function checkActionName(Section: string ; ActionName: string): Boolean;
const
    //! ݒt@C
	INI_FILENAME: string = 'popupmenu.ini';
    //! uEU^uZNV
    BROWSER_TAB: string = 'BrowserTab';
    //! ZNV̈ꗗ
    SECTIONS : array[0..0] of string =( 'BrowserTab' ) ;

    //! uEU^u|bvAbvɐݒ\ȃj[
    ACK_BROWSER: array[0..7]	of string = (
                                            'ItemReloadAction',
                                            'FavoriteAddAction',
                                            'BrowserTabCloseAction',
                                            'NotSelectTabCloseAction',
                                            'LeftTabCloseAction',
                                            'RightTabCloseAction',
                                            'ActiveLogDeleteAction',
                                            'AllTabCloseAction');

implementation
procedure ReadSetting(ActionList: TActionList; PopupMenu: TPopupMenu);
const
    // ANV
    // ACe
    ROUNDITEM = 'RoundItem';
    // Xbhꗗp
    SAMPETHREAD='SameBoardThreadItem';
var
    ini : TMemIniFile;
    mkeys, skeys : TStringList;
    i, j, idx: Integer;
    value, subValue : String;
    item, subItem : TMenuItem;
begin
    if (FileExists(GikoSys.Setting.GetConfigDir + INI_FILENAME)) Then begin
        ini := TMemIniFile.Create(GikoSys.Setting.GetConfigDir + INI_FILENAME);
        mkeys := TStringList.Create;
        mkeys.Sorted := true;
        skeys := TStringList.Create;
        skeys.Sorted := true;
        try
            for idx := 0 to Length(SECTIONS) - 1 do begin
                ini.ReadSection(SECTIONS[idx], mkeys);
                // mainKw subKw̕
                for i := mkeys.Count - 1 downto 0 do begin
                    if (Pos('sub', mkeys[i]) = 1) then begin
                        skeys.Add(mkeys[i]);
                        mkeys.Delete(i);
                    end;
                end;
                // Kw̏
                PopupMenu.Items.Clear;
                for i := 0 to mkeys.Count - 1 do begin
                    value := ini.ReadString(SECTIONS[idx], mkeys[i], '-');
                    item := GetMenuItem(SECTIONS[idx], PopupMenu, ActionList, value);
                    if (item <> nil) then begin
                        PopupMenu.Items.Add(item);
                        // ANVݒ肳Ă̂ɂ͑w͂Ȃ
                        if (item.Action = nil) then begin
                            // Kw̏()
                            for j := 0 to skeys.Count - 1 do begin
                                if (Pos('sub.' + mkeys[i], skeys[j]) = 1) then begin
                                    subValue := ini.ReadString(SECTIONS[idx], skeys[j], '-');
                                    subItem := GetMenuItem(SECTIONS[idx], PopupMenu, ActionList, subValue);
                                    if (subItem <> nil) then begin
                                        item.Add(subItem);
                                    end;
                                end;
                            end;
                        end;
                    end;
                end;
                // ̃ZNV̏ÎŃNA
                mkeys.Clear;
                skeys.Clear;
            end;
        finally
            skeys.Free;
            mkeys.Free;
            ini.Free;
        end;
    end;
end;
//! j[Ԃ
function GetMenuItem(Section: string; PopupMenu: TPopupMenu; ActionList: TActionList; MenuName: string): TMenuItem;
var
    Action: TCustomAction;
begin
    Result := nil;
    // _uNH[gŎn܂Ƃ̓x
    if (Pos('"', MenuName)=1) then begin
        Result := TMenuItem.Create(PopupMenu);
        Result.Caption := Copy(MenuName, 2, Length(MenuName));
    end else if (MenuName = '-' ) then begin
        // ؂
        Result := TMenuItem.Create(PopupMenu);
        Result.Caption := '-';
    end else begin
        if (BROWSER_TAB = Section) then begin
            // uEU^u̓Ή
            if (MenuName = 'RoundItem' ) then begin
                try
                    // 񃁃j[p_~[
                    Result := TMenuItem.Create(PopupMenu);
                    Result.Name := 'RoundItem';
                    Result.Caption := GikoForm.ItemReservPMenu.Caption;
                    Result.Hint    := GikoForm.ItemReservPMenu.Hint;
                except
                    // ɎgĂƂ̓G[ɂȂ
                    Result.Free;
                    Result := nil;
                end;
            end else if (MenuName = 'BoardThreadItem' ) then begin
                try
                    // Xbh\p_~[
                    Result := TMenuItem.Create(PopupMenu);
                    Result.Name := 'BoardThreadItem';
                    Result.Caption := 'ŕ\ĂXbh';
                except
                    // ɎgĂƂ̓G[ɂȂ
                    Result.Free;
                    Result := nil;
                end;
            end;
        end;
        // j[܂炸ɁAꂽANVȂAction쐬
        if (Result = nil) and (checkActionName(Section, MenuName)) then begin
            Action := GetActionItem(ActionList, MenuName);
            if Action <> nil then begin
                Result := TMenuItem.Create(PopupMenu);
                Result.Action := Action;
            end;
        end;
    end;
end;
//ActionNameActionԂ܂
function GetActionItem(ActionList: TActionList; ActionName: string): TCustomAction;
var
	i: Integer;
begin
	for i := 0 to ActionList.ActionCount - 1 do begin
		if ActionList.Actions[i].Name = ActionName then begin
			Result := TCustomAction(ActionList.Actions[i]);
			Exit;
		end;
	end;
	Result := nil;
end;

function checkActionName(Section: string ; ActionName: string): Boolean;
var
    i : Integer;
begin
    Result := False;
    if (BROWSER_TAB = Section) then begin
        for i :=0 to  Length(ACK_BROWSER) - 1 do begin
            if (ACK_BROWSER[i] = ActionName) then begin
                Result := True;
                Break;
            end;
        end;
    end;
end;
end.
