VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "TestGeosOperations"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private testHelper

Sub Class_Initialize()
    Set testHelper = New GeosTestHelper
    
    setup "testCentroid": testCentroid
    setup "testBuffer": testBuffer
    setup "testConvexHull": testConvexHull
    report
End Sub

Sub testCentroid()
    Dim geoms
    geoms = testHelper.createGeoms()
    Dim results
    results = Array( _
        "POINT (150.0000000000000000 350.0000000000000000)", _
        "POINT (50.0000000000000000 50.0000000000000000)", _
        "POINT (110.0000000000000000 126.6666666666666700)", _
        "POINT (50.0000000000000000 50.0000000000000000)", _
        "POINT (150.0000000000000000 350.0000000000000000)", _
        "POINT (150.0000000000000000 400.0000000000000000)", _
        "POINT (150.0000000000000000 375.0000000000000000)", _
        "POINT (0.0000000000000002 0.0000000000000001)", _
        "POINT (-0.0000000000000002 0.0000000000000002)", _
        "POINT (-0.0000000000000000 -0.0000000000000000)", _
        "POINT (-0.0000000000000000 5.0000000000000000)", _
        "POINT (8.5510137343037833 15.6700508986182890)" _
    )
    
    Dim i
    For i = LBound(geoms) To UBound(geoms)
        Dim geom
        Set geom = geoms(i).getCentroid()
        Dim writer
        Set writer = geos.WktWriter.new_WktWriter()
        assertEqual writer.write(geom), results(i), "testCentroid(" + CStr(i) + ")"
    Next
End Sub

Sub testBuffer()
    Dim geoms
    geoms = testHelper.createGeoms()
    Dim results
    results = Array("", "", "", "", "", "", "", "", "", "", "", "") ' for initialize
    results(0) = _
        "POLYGON ((140.0000000000000000 349.9999999999999400, 140.1921471959676900 351.9509032201612500, 140.7612046748871300 353.8268343236508700, 141.6853038769745300 355.5557023301959700, 142.9289321881345000 357.0710678118654200, 144.4442976698039400 358.3146961230254400, 146.1731656763490700 359.2387953251128500, 148.0490967798386900 359.8078528040322800, 149.9999999999999700 360.0000000000000000, 151.9509032201612500 359.8078528040323400, 153.8268343236508700 359.2387953251129000, 155.5557023301960000 358.3146961230254400, 157.0710678118654500 357.0710678118654800, 158.3146961230254400 355.5557023301960300, 159.2387953251128500 353.8268343236509300, 159.8078528040323100 351.9509032201613100, 160.0000000000000000 350.0000000000000000, 159.8078528040323100 348.0490967798386900, 159.2387953251128700 346.1731656763491300, 158.3146961230254400 344.4442976698039700, 157.0710678118654800 342.9289321881345200, 155.5557023301960300 341.6853038769745600, 153.8268343236509000 340.7612046748871500," _
        + " 151.9509032201613100 340.1921471959677200, 150.0000000000000300 340.0000000000000000, 148.0490967798387500 340.1921471959676600, 146.1731656763491300 340.7612046748871500, 144.4442976698040000 341.6853038769745600, 142.9289321881345500 342.9289321881345200, 141.6853038769745600 344.4442976698039700, 140.7612046748871500 346.1731656763490700, 140.1921471959676900 348.0490967798386900, 140.0000000000000000 349.9999999999999400))"
    results(1) = _
        "POLYGON ((-10.0000000000000000 0.0000000000000012, -10.0000000000000000 100.0000000000000000, -9.8078528040323043 101.9509032201612800, -9.2387953251128678 103.8268343236509000, -8.3146961230254526 105.5557023301960300, -7.0710678118654746 107.0710678118654800, -5.5557023301960200 108.3146961230254600, -3.8268343236508970 109.2387953251128700, -1.9509032201612819 109.8078528040323100, 0.0000000000000000 110.0000000000000000, 100.0000000000000000 110.0000000000000000, 101.9509032201612800 109.8078528040323100, 103.8268343236509000 109.2387953251128700, 105.5557023301960300 108.3146961230254600, 107.0710678118654800 107.0710678118654800, 108.3146961230254600 105.5557023301960300, 109.2387953251128700 103.8268343236509000, 109.8078528040323100 101.9509032201612800, 110.0000000000000000 100.0000000000000000, 110.0000000000000000 0.0000000000000000, 109.8078528040323100 -1.9509032201612824, 109.2387953251128700 -3.8268343236508979, 108.3146961230254600 -5.5557023301960218," _
        + " 107.0710678118654800 -7.0710678118654746, 105.5557023301960300 -8.3146961230254526, 103.8268343236509000 -9.2387953251128678, 101.9509032201612800 -9.8078528040323043, 100.0000000000000000 -10.0000000000000000, 0.0000000000000028 -10.0000000000000000, 0.0000000000000000 -10.0000000000000000, -0.2636355702920707 -9.9740341627070670, -1.9509032201612777 -9.8078528040323061, -1.9509032201612866 -9.8078528040323025, -1.9509032201612952 -9.8078528040323025, -2.7195138806188379 -9.5746973091972567, -3.8268343236508908 -9.2387953251128714, -3.8268343236509019 -9.2387953251128661, -3.8268343236509117 -9.2387953251128625, -4.3727926415072558 -8.9469745244536831, -5.5557023301960120 -8.3146961230254597, -5.5557023301960289 -8.3146961230254455, -5.5557023301960360 -8.3146961230254419, -6.2156195560843335 -7.7731160520364293, -7.0710678118654684 -7.0710678118654826, -7.0710678118654746 -7.0710678118654746, -7.0710678118654826 -7.0710678118654684, -7.4895965704289287 -6.5610890439959491," _
        + " -8.3146961230254437 -5.5557023301960360, -8.3146961230254526 -5.5557023301960182, -8.3146961230254561 -5.5557023301960147, -8.5385013985309968 -5.1369921098608780, -9.2387953251128625 -3.8268343236509113, -9.2387953251128661 -3.8268343236508979, -9.2387953251128696 -3.8268343236508922, -9.4674344907501400 -3.0731120052845418, -9.8078528040323008 -1.9509032201613032, -9.8078528040323025 -1.9509032201612937, -9.8078528040323061 -1.9509032201612793, -9.9916266130197560 -0.0850164247318053, -10.0000000000000000 0.0000000000000000, -10.0000000000000000 0.0000000000000012), (10.0000000000000000 10.0000000000000000, 90.0000000000000000 10.0000000000000000, 90.0000000000000000 90.0000000000000000, 10.0000000000000000 90.0000000000000000, 10.0000000000000000 10.0000000000000000))"
    results(2) = _
        "POLYGON ((50.0000000000000000 60.0000000000000000, 50.0000000000000000 160.0000000000000000, 50.1921471959676920 161.9509032201612800, 50.7612046748871320 163.8268343236509000, 51.6853038769745440 165.5557023301960300, 52.9289321881345240 167.0710678118654800, 54.4442976698039800 168.3146961230254400, 56.1731656763491000 169.2387953251128700, 58.0490967798387200 169.8078528040323100, 60.0000000000000000 170.0000000000000000, 160.0000000000000000 170.0000000000000000, 161.9509032201612800 169.8078528040323100, 163.8268343236509000 169.2387953251128700, 165.5557023301960300 168.3146961230254400, 167.0710678118654800 167.0710678118654800, 168.3146961230254400 165.5557023301960300, 169.2387953251128700 163.8268343236509000, 169.8078528040323100 161.9509032201612800, 170.0000000000000000 160.0000000000000000, 170.0000000000000000 60.0000000000000000, 170.0000000000000000 59.9999999999999860, 169.8078528040323100 58.0490967798387060, 169.2387953251128700 56.1731656763490930," _
        + " 168.3146961230254400 54.4442976698039730, 167.0710678118654800 52.9289321881345170, 165.5557023301960300 51.6853038769745440, 163.8268343236509000 50.7612046748871320, 161.9509032201612800 50.1921471959676920, 160.0000000000000000 50.0000000000000000, 158.0490967798387200 50.1921471959676920, 156.1731656763491000 50.7612046748871250, 154.4442976698040000 51.6853038769745440, 152.9289321881345200 52.9289321881345170, 151.6853038769745600 54.4442976698039660, 150.7612046748871300 56.1731656763490860, 150.1921471959676900 58.0490967798386990, 150.0000000000000000 60.0000000000000000, 150.0000000000000000 150.0000000000000000, 70.0000000000000000 150.0000000000000000, 70.0000000000000000 60.0000000000000000, 70.0000000000000000 59.9999999999999860, 69.8078528040323080 58.0490967798387060, 69.2387953251128610 56.1731656763490930, 68.3146961230254420 54.4442976698039730, 67.0710678118654760 52.9289321881345170, 65.5557023301960130 51.6853038769745440, 63.8268343236509000 50.7612046748871320," _
        + " 61.9509032201612800 50.1921471959676920, 60.0000000000000000 50.0000000000000000, 58.0490967798387200 50.1921471959676920, 56.1731656763491070 50.7612046748871250, 54.4442976698039870 51.6853038769745440, 52.9289321881345320 52.9289321881345170, 51.6853038769745580 54.4442976698039660, 50.7612046748871390 56.1731656763490860, 50.1921471959676990 58.0490967798386990, 50.0000000000000000 60.0000000000000000))"
    results(3) = _
        "POLYGON ((-10.0000000000000000 0.0000000000000012, -10.0000000000000000 100.0000000000000000, -9.8078528040323043 101.9509032201612800, -9.2387953251128678 103.8268343236509000, -8.3146961230254526 105.5557023301960300, -7.0710678118654746 107.0710678118654800, -5.5557023301960200 108.3146961230254600, -3.8268343236508970 109.2387953251128700, -1.9509032201612819 109.8078528040323100, 0.0000000000000000 110.0000000000000000, 100.0000000000000000 110.0000000000000000, 101.9509032201612800 109.8078528040323100, 103.8268343236509000 109.2387953251128700, 105.5557023301960300 108.3146961230254600, 107.0710678118654800 107.0710678118654800, 108.3146961230254600 105.5557023301960300, 109.2387953251128700 103.8268343236509000, 109.8078528040323100 101.9509032201612800, 110.0000000000000000 100.0000000000000000, 110.0000000000000000 0.0000000000000000, 109.8078528040323100 -1.9509032201612824, 109.2387953251128700 -3.8268343236508979, 108.3146961230254600 -5.5557023301960218," _
        + " 107.0710678118654800 -7.0710678118654746, 105.5557023301960300 -8.3146961230254526, 103.8268343236509000 -9.2387953251128678, 101.9509032201612800 -9.8078528040323043, 100.0000000000000000 -10.0000000000000000, 0.0000000000000028 -10.0000000000000000, 0.0000000000000000 -10.0000000000000000, -0.2636355702920707 -9.9740341627070670, -1.9509032201612777 -9.8078528040323061, -1.9509032201612866 -9.8078528040323025, -1.9509032201612952 -9.8078528040323025, -2.7195138806188379 -9.5746973091972567, -3.8268343236508908 -9.2387953251128714, -3.8268343236509019 -9.2387953251128661, -3.8268343236509117 -9.2387953251128625, -4.3727926415072558 -8.9469745244536831, -5.5557023301960120 -8.3146961230254597, -5.5557023301960289 -8.3146961230254455, -5.5557023301960360 -8.3146961230254419, -6.2156195560843335 -7.7731160520364293, -7.0710678118654684 -7.0710678118654826, -7.0710678118654746 -7.0710678118654746, -7.0710678118654826 -7.0710678118654684, -7.4895965704289287 -6.5610890439959491," _
        + " -8.3146961230254437 -5.5557023301960360, -8.3146961230254526 -5.5557023301960182, -8.3146961230254561 -5.5557023301960147, -8.5385013985309968 -5.1369921098608780, -9.2387953251128625 -3.8268343236509113, -9.2387953251128661 -3.8268343236508979, -9.2387953251128696 -3.8268343236508922, -9.4674344907501400 -3.0731120052845418, -9.8078528040323008 -1.9509032201613032, -9.8078528040323025 -1.9509032201612937, -9.8078528040323061 -1.9509032201612793, -9.9916266130197560 -0.0850164247318053, -10.0000000000000000 0.0000000000000000, -10.0000000000000000 0.0000000000000012), (10.0000000000000000 10.0000000000000000, 90.0000000000000000 10.0000000000000000, 90.0000000000000000 90.0000000000000000, 10.0000000000000000 90.0000000000000000, 10.0000000000000000 10.0000000000000000))"
    results(4) = _
        "POLYGON ((-10.0000000000000000 200.0000000000000000, -10.0000000000000000 500.0000000000000000, -9.8078528040323043 501.9509032201613100, -9.2387953251128678 503.8268343236508700, -8.3146961230254526 505.5557023301960300, -7.0710678118654746 507.0710678118654800, -5.5557023301960200 508.3146961230254400, -3.8268343236508970 509.2387953251128500, -1.9509032201612819 509.8078528040322800, 0.0000000000000000 510.0000000000000000, 300.0000000000000000 510.0000000000000000, 301.9509032201613100 509.8078528040322800, 303.8268343236508700 509.2387953251128500, 305.5557023301960300 508.3146961230254400, 307.0710678118654800 507.0710678118654800, 308.3146961230254400 505.5557023301960300, 309.2387953251128500 503.8268343236508700, 309.8078528040322800 501.9509032201613100, 310.0000000000000000 500.0000000000000000, 310.0000000000000000 200.0000000000000000, 309.8078528040322800 198.0490967798387200, 309.2387953251128500 196.1731656763491000, 308.3146961230254400 194.4442976698039700," _
        + " 307.0710678118654800 192.9289321881345200, 305.5557023301960300 191.6853038769745600, 303.8268343236508700 190.7612046748871300, 301.9509032201613100 190.1921471959676900, 300.0000000000000000 190.0000000000000000, 0.0000000000000000 190.0000000000000000, -0.0000000000000640 190.0000000000000000, -1.9509032201613388 190.1921471959677200, -3.8268343236509446 190.7612046748871500, -5.5557023301960582 191.6853038769745600, -7.0710678118654977 192.9289321881345500, -8.3146961230254668 194.4442976698040000, -9.2387953251128732 196.1731656763491300, -9.8078528040323061 198.0490967798387200, -10.0000000000000000 200.0000000000000000), (110.0000000000000000 310.0000000000000000, 190.0000000000000000 310.0000000000000000, 190.0000000000000000 390.0000000000000000, 110.0000000000000000 390.0000000000000000, 110.0000000000000000 310.0000000000000000))"
    results(5) = _
        "POLYGON ((-10.0000000000000000 250.0000000000000000, -10.0000000000000000 550.0000000000000000, -9.8078528040323043 551.9509032201613100, -9.2387953251128678 553.8268343236509300, -8.3146961230254526 555.5557023301960300, -7.0710678118654746 557.0710678118655300, -5.5557023301960200 558.3146961230254400, -3.8268343236508970 559.2387953251128500, -1.9509032201612819 559.8078528040323400, 0.0000000000000000 560.0000000000000000, 300.0000000000000000 560.0000000000000000, 301.9509032201613100 559.8078528040323400, 303.8268343236508700 559.2387953251128500, 305.5557023301960300 558.3146961230254400, 307.0710678118654800 557.0710678118654200, 308.3146961230254400 555.5557023301960300, 309.2387953251128500 553.8268343236509300, 309.8078528040322800 551.9509032201613100, 310.0000000000000000 550.0000000000000000, 310.0000000000000000 250.0000000000000000, 309.8078528040322800 248.0490967798387200, 309.2387953251128500 246.1731656763491000, 308.3146961230254400 244.4442976698039700," _
        + " 307.0710678118654800 242.9289321881345200, 305.5557023301960300 241.6853038769745600, 303.8268343236508700 240.7612046748871300, 301.9509032201613100 240.1921471959676900, 300.0000000000000000 240.0000000000000000, 0.0000000000000000 240.0000000000000000, -0.0000000000000640 240.0000000000000000, -1.9509032201613388 240.1921471959677200, -3.8268343236509446 240.7612046748871500, -5.5557023301960582 241.6853038769745600, -7.0710678118654977 242.9289321881345500, -8.3146961230254668 244.4442976698040000, -9.2387953251128732 246.1731656763491300, -9.8078528040323061 248.0490967798387200, -10.0000000000000000 250.0000000000000000), (110.0000000000000000 360.0000000000000000, 190.0000000000000000 360.0000000000000000, 190.0000000000000000 440.0000000000000000, 110.0000000000000000 440.0000000000000000, 110.0000000000000000 360.0000000000000000))"
    results(6) = _
        "MULTIPOLYGON (((-10.0000000000000000 0.0000000000000000, -10.0000000000000000 0.0000000000000012, -10.0000000000000000 100.0000000000000000, -9.8078528040323043 101.9509032201612800, -9.2387953251128678 103.8268343236509000, -8.3146961230254526 105.5557023301960300, -7.0710678118654746 107.0710678118654800, -5.5557023301960200 108.3146961230254600, -3.8268343236508970 109.2387953251128700, -1.9509032201612819 109.8078528040323100, 0.0000000000000000 110.0000000000000000, 50.0000000000000000 110.0000000000000000, 50.0000000000000000 160.0000000000000000, 50.1921471959676920 161.9509032201612800, 50.7612046748871320 163.8268343236509000, 51.6853038769745440 165.5557023301960300, 52.9289321881345240 167.0710678118654800, 54.4442976698039800 168.3146961230254400, 56.1731656763491000 169.2387953251128700, 58.0490967798387200 169.8078528040323100, 60.0000000000000000 170.0000000000000000, 160.0000000000000000 170.0000000000000000, 161.9509032201612800 169.8078528040323100," _
        + " 163.8268343236509000 169.2387953251128700, 165.5557023301960300 168.3146961230254400, 167.0710678118654800 167.0710678118654800, 168.3146961230254400 165.5557023301960300, 169.2387953251128700 163.8268343236509000, 169.8078528040323100 161.9509032201612800, 170.0000000000000000 160.0000000000000000, 170.0000000000000000 60.0000000000000000, 170.0000000000000000 59.9999999999999860, 169.8078528040323100 58.0490967798387060, 169.2387953251128700 56.1731656763490930, 168.3146961230254400 54.4442976698039730, 167.0710678118654800 52.9289321881345170, 165.5557023301960300 51.6853038769745440, 163.8268343236509000 50.7612046748871320, 161.9509032201612800 50.1921471959676920, 160.0000000000000000 50.0000000000000000, 158.0490967798387200 50.1921471959676920, 156.1731656763491000 50.7612046748871250, 154.4442976698040000 51.6853038769745440, 152.9289321881345200 52.9289321881345170, 151.6853038769745600 54.4442976698039660, 150.7612046748871300 56.1731656763490860," _
        + " 150.1921471959676900 58.0490967798386990, 150.0000000000000000 60.0000000000000000, 150.0000000000000000 150.0000000000000000, 70.0000000000000000 150.0000000000000000, 70.0000000000000000 110.0000000000000000, 100.0000000000000000 110.0000000000000000, 101.9509032201612800 109.8078528040323100, 103.8268343236509000 109.2387953251128700, 105.5557023301960300 108.3146961230254600, 107.0710678118654800 107.0710678118654800, 108.3146961230254600 105.5557023301960300, 109.2387953251128700 103.8268343236509000, 109.8078528040323100 101.9509032201612800, 110.0000000000000000 100.0000000000000000, 110.0000000000000000 0.0000000000000000, 109.8078528040323100 -1.9509032201612824, 109.2387953251128700 -3.8268343236508979, 108.3146961230254600 -5.5557023301960218, 107.0710678118654800 -7.0710678118654746, 105.5557023301960300 -8.3146961230254526, 103.8268343236509000 -9.2387953251128678, 101.9509032201612800 -9.8078528040323043, 100.0000000000000000 -10.0000000000000000," _
        + " 0.0000000000000028 -10.0000000000000000, 0.0000000000000000 -10.0000000000000000, -0.0000000000000196 -10.0000000000000000, -1.0757640096988681 -9.8940464930036285, -1.9509032201612777 -9.8078528040323061, -1.9509032201612866 -9.8078528040323025, -1.9509032201612952 -9.8078528040323025, -2.7195138806188379 -9.5746973091972567, -3.8268343236508908 -9.2387953251128714, -3.8268343236509019 -9.2387953251128661, -3.8268343236509117 -9.2387953251128625, -4.3727926415072558 -8.9469745244536831, -5.5557023301960120 -8.3146961230254597, -5.5557023301960289 -8.3146961230254455, -5.5557023301960360 -8.3146961230254419, -6.2156195560843335 -7.7731160520364293, -7.0710678118654684 -7.0710678118654826, -7.0710678118654746 -7.0710678118654746, -7.0710678118654826 -7.0710678118654684, -7.4895965704289287 -6.5610890439959491, -8.3146961230254437 -5.5557023301960360, -8.3146961230254526 -5.5557023301960182, -8.3146961230254561 -5.5557023301960147, -8.5385013985309968 -5.1369921098608780," _
        + " -9.2387953251128625 -3.8268343236509113, -9.2387953251128661 -3.8268343236508979, -9.2387953251128696 -3.8268343236508922, -9.4674344907501400 -3.0731120052845418, -9.8078528040323008 -1.9509032201613032, -9.8078528040323025 -1.9509032201612937, -9.8078528040323061 -1.9509032201612793, -9.9916266130197560 -0.0850164247318053, -10.0000000000000000 0.0000000000000000), (10.0000000000000000 10.0000000000000000, 90.0000000000000000 10.0000000000000000, 90.0000000000000000 90.0000000000000000, 70.0000000000000000 90.0000000000000000, 70.0000000000000000 60.0000000000000000, 70.0000000000000000 59.9999999999999860, 69.8078528040323080 58.0490967798387060, 69.2387953251128610 56.1731656763490930, 68.3146961230254420 54.4442976698039730, 67.0710678118654760 52.9289321881345170, 65.5557023301960130 51.6853038769745440, 63.8268343236509000 50.7612046748871320, 61.9509032201612800 50.1921471959676920, 60.0000000000000000 50.0000000000000000, 58.0490967798387200 50.1921471959676920," _
        + " 56.1731656763491070 50.7612046748871250, 54.4442976698039870 51.6853038769745440, 52.9289321881345320 52.9289321881345170, 51.6853038769745580 54.4442976698039660, 50.7612046748871390 56.1731656763490860, 50.1921471959676990 58.0490967798386990, 50.0000000000000000 60.0000000000000000, 50.0000000000000000 90.0000000000000000, 10.0000000000000000 90.0000000000000000, 10.0000000000000000 10.0000000000000000)), ((-10.0000000000000000 200.0000000000000000, -10.0000000000000000 250.0000000000000000, -10.0000000000000000 500.0000000000000000, -10.0000000000000000 550.0000000000000000, -9.8078528040323043 551.9509032201613100, -9.2387953251128678 553.8268343236509300, -8.3146961230254526 555.5557023301960300, -7.0710678118654746 557.0710678118655300, -5.5557023301960200 558.3146961230254400, -3.8268343236508970 559.2387953251128500, -1.9509032201612819 559.8078528040323400, 0.0000000000000000 560.0000000000000000, 300.0000000000000000 560.0000000000000000," _
        + " 301.9509032201613100 559.8078528040323400, 303.8268343236508700 559.2387953251128500, 305.5557023301960300 558.3146961230254400, 307.0710678118654800 557.0710678118654200, 308.3146961230254400 555.5557023301960300, 309.2387953251128500 553.8268343236509300, 309.8078528040322800 551.9509032201613100, 310.0000000000000000 550.0000000000000000, 310.0000000000000000 500.0000000000000000, 310.0000000000000000 250.0000000000000000, 310.0000000000000000 200.0000000000000000, 309.8078528040322800 198.0490967798387200, 309.2387953251128500 196.1731656763491000, 308.3146961230254400 194.4442976698039700, 307.0710678118654800 192.9289321881345200, 305.5557023301960300 191.6853038769745600, 303.8268343236508700 190.7612046748871300, 301.9509032201613100 190.1921471959676900, 300.0000000000000000 190.0000000000000000, 0.0000000000000000 190.0000000000000000, -0.0000000000000640 190.0000000000000000, -1.9509032201613388 190.1921471959677200, -3.8268343236509446 190.7612046748871500," _
        + " -5.5557023301960582 191.6853038769745600, -7.0710678118654977 192.9289321881345500, -8.3146961230254668 194.4442976698040000, -9.2387953251128732 196.1731656763491300, -9.8078528040323061 198.0490967798387200, -10.0000000000000000 200.0000000000000000), (110.0000000000000000 360.0000000000000000, 149.9999999999999700 360.0000000000000000, 190.0000000000000000 360.0000000000000000, 190.0000000000000000 390.0000000000000000, 110.0000000000000000 390.0000000000000000, 110.0000000000000000 360.0000000000000000)))"
    results(7) = _
        "POLYGON ((-14.9950656036573160 -0.3141075907812337, -14.9950656036573160 0.3141075907813203, -14.9851992457986740 0.6280601884278876, -14.9457532881721510 1.2550357308317843, -14.9161931526031810 1.5677493010067369, -14.8374569125237630 2.1910108182238575, -14.7883196595948160 2.5012512233309598, -14.6706038730309080 3.1183389868940914, -14.6020834250306190 3.4248818497897422, -14.4458526624125750 4.0333604962166074, -14.3582194382451860 4.3349960322670693, -14.1640902710180080 4.9324641743276931, -14.0576901189834940 5.2280019658763459, -13.8264286862810510 5.8121016697712404, -13.7016815191698900 6.1003753641732139, -13.4342005042137610 6.6688014552208621, -13.2915986421029830 6.9486733679040729, -12.9889536702587340 7.4991825280123248, -12.8290598975494900 7.7695481323987314, -12.4924453702556700 8.2999677534163254, -12.3158907146203300 8.5597600399837077, -11.9466350956316130 9.0679967979921656, -11.7541163376358230 9.3161904852732462, -11.3536769101835220 9.8002386019799896," _
        + " -11.1459538334116320 10.0358541828799850, -10.7159109489725180 10.4938033415089350, -10.4938033415089010 10.7159109489725490, -10.0358541828799270 11.1459538334116850, -9.8002386019799310 11.3536769101835730, -9.3161904852731698 11.7541163376358830, -9.0679967979920875 11.9466350956316740, -8.5597600399836544 12.3158907146203680, -8.2999677534162721 12.4924453702557050, -7.7695481323986657 12.8290598975495310, -7.4991825280122608 12.9889536702587700, -6.9486733679040125 13.2915986421030110, -6.6688014552207990 13.4342005042137910, -6.1003753641731482 13.7016815191699180, -5.8121016697711747 13.8264286862810760, -5.2280019658762695 14.0576901189835260, -4.9324641743276159 14.1640902710180360, -4.3349960322670062 14.3582194382452040, -4.0333604962165435 14.4458526624125910, -3.4248818497896689 14.6020834250306350, -3.1183389868940190 14.6706038730309240, -2.5012512233309079 14.7883196595948260, -2.1910108182238055 14.8374569125237700, -1.5677493010066250 14.9161931526031920," _
        + " -1.2550357308316711 14.9457532881721600, -0.6280601884278352 14.9851992457986720, -0.3141075907812689 14.9950656036573150, 0.3141075907813134 14.9950656036573160, 0.6280601884278796 14.9851992457986740, 1.2550357308317122 14.9457532881721580, 1.5677493010066668 14.9161931526031890, 2.1910108182238561 14.8374569125237630, 2.5012512233309572 14.7883196595948160, 3.1183389868940905 14.6706038730309080, 3.4248818497897404 14.6020834250306190, 4.0333604962165541 14.4458526624125910, 4.3349960322670169 14.3582194382452040, 4.9324641743276940 14.1640902710180100, 5.2280019658763459 14.0576901189834980, 5.8121016697712218 13.8264286862810570, 6.1003753641731944 13.7016815191698970, 6.6688014552208479 13.4342005042137680, 6.9486733679040604 13.2915986421029880, 7.4991825280122821 12.9889536702587570, 7.7695481323986879 12.8290598975495160, 8.2999677534163254 12.4924453702556700, 8.5597600399837077 12.3158907146203300, 9.0679967979921301 11.9466350956316420, 9.3161904852732107 11.7541163376358500," _
        + " 9.8002386019799825 11.3536769101835270, 10.0358541828799770 11.1459538334116390, 10.4938033415089220 10.7159109489725300, 10.7159109489725350 10.4938033415089170, 11.1459538334116490 10.0358541828799660, 11.3536769101835390 9.8002386019799719, 11.7541163376358670 9.3161904852731929, 11.9466350956316580 9.0679967979921106, 12.3158907146203550 8.5597600399836740, 12.4924453702556930 8.2999677534162917, 12.8290598975495200 7.7695481323986808, 12.9889536702587630 7.4991825280122750, 13.2915986421030080 6.9486733679040249, 13.4342005042137860 6.6688014552208115, 13.7016815191699010 6.1003753641731864, 13.8264286862810600 5.8121016697712138, 14.0576901189835210 5.2280019658762811, 14.1640902710180310 4.9324641743276283, 14.3582194382451950 4.3349960322670409, 14.4458526624125840 4.0333604962165781, 14.6020834250306350 3.4248818497896769, 14.6706038730309240 3.1183389868940266, 14.7883196595948190 2.5012512233309465, 14.8374569125237650 2.1910108182238446, 14.9161931526031900 1.5677493010066605," _
        + " 14.9457532881721600 1.2550357308317064, 14.9851992457986720 0.6280601884278432, 14.9950656036573150 0.3141075907812767, 14.9950656036573150 -0.3141075907813262, 14.9851992457986700 -0.6280601884279280, 14.9457532881721490 -1.2550357308318028, 14.9161931526031780 -1.5677493010067551, 14.8374569125237490 -2.1910108182239427, 14.7883196595948000 -2.5012512233310424, 14.6706038730309010 -3.1183389868941243, 14.6020834250306120 -3.4248818497897728, 14.4458526624125610 -4.0333604962166634, 14.3582194382451700 -4.3349960322671288, 14.1640902710179920 -4.9324641743277358, 14.0576901189834800 -5.2280019658763859, 13.8264286862810410 -5.8121016697712617, 13.7016815191698810 -6.1003753641732335, 13.4342005042137340 -6.6688014552209189, 13.2915986421029510 -6.9486733679041333, 12.9889536702587090 -7.4991825280123656, 12.8290598975494670 -7.7695481323987705, 12.4924453702556340 -8.2999677534163787, 12.3158907146202950 -8.5597600399837575, 11.9466350956316010 -9.0679967979921834," _
        + " 11.7541163376358070 -9.3161904852732675, 11.3536769101834660 -9.8002386019800536, 11.1459538334115770 -10.0358541828800460, 10.7159109489724860 -10.4938033415089680, 10.4938033415088710 -10.7159109489725800, 10.0358541828799050 -11.1459538334117050, 9.8002386019799097 -11.3536769101835930, 9.3161904852731432 -11.7541163376359070, 9.0679967979920590 -11.9466350956316950, 8.5597600399835905 -12.3158907146204120, 8.2999677534162082 -12.4924453702557480, 7.7695481323986328 -12.8290598975495480, 7.4991825280122235 -12.9889536702587910, 6.9486733679039743 -13.2915986421030330, 6.6688014552207626 -13.4342005042138110, 6.1003753641730931 -13.7016815191699410, 5.8121016697711205 -13.8264286862810980, 5.2280019658762296 -14.0576901189835370, 4.9324641743275741 -14.1640902710180470, 4.3349960322669716 -14.3582194382452140, 4.0333604962165097 -14.4458526624126020, 3.4248818497896059 -14.6020834250306530, 3.1183389868939568 -14.6706038730309380, 2.5012512233308808 -14.7883196595948280," _
        + " 2.1910108182237762 -14.8374569125237730, 1.5677493010065828 -14.9161931526031970, 1.2550357308316300 -14.9457532881721630, 0.6280601884277636 -14.9851992457986750, 0.3141075907811984 -14.9950656036573160, -0.3141075907813534 -14.9950656036573150, -0.6280601884279229 -14.9851992457986720, -1.2550357308317934 -14.9457532881721490, -1.5677493010067458 -14.9161931526031800, -2.1910108182239059 -14.8374569125237560, -2.5012512233310060 -14.7883196595948090, -3.1183389868941118 -14.6706038730309040, -3.4248818497897648 -14.6020834250306140, -4.0333604962166163 -14.4458526624125730, -4.3349960322670782 -14.3582194382451840, -4.9324641743277269 -14.1640902710179950, -5.2280019658763770 -14.0576901189834840, -5.8121016697712520 -13.8264286862810440, -6.1003753641732263 -13.7016815191698830, -6.6688014552208932 -13.4342005042137470, -6.9486733679041039 -13.2915986421029670, -7.4991825280123576 -12.9889536702587150, -7.7695481323987625 -12.8290598975494700, -8.2999677534163503 -12.4924453702556520," _
        + " -8.5597600399837344 -12.3158907146203130, -9.0679967979921816 -11.9466350956316030, -9.3161904852732622 -11.7541163376358120, -9.8002386019800056 -11.3536769101835110, -10.0358541828800000 -11.1459538334116210, -10.4938033415089680 -10.7159109489724820, -10.7159109489725810 -10.4938033415088690, -11.1459538334116890 -10.0358541828799210, -11.3536769101835750 -9.8002386019799275, -11.7541163376358800 -9.3161904852731752, -11.9466350956316700 -9.0679967979920910, -12.3158907146203980 -8.5597600399836082, -12.4924453702557340 -8.2999677534162259, -12.8290598975495450 -7.7695481323986435, -12.9889536702587860 -7.4991825280122359, -13.2915986421030170 -6.9486733679040045, -13.4342005042137950 -6.6688014552207910, -13.7016815191699380 -6.1003753641731020, -13.8264286862810960 -5.8121016697711294, -14.0576901189835280 -5.2280019658762589, -14.1640902710180380 -4.9324641743276061, -14.3582194382452110 -4.3349960322669894, -14.4458526624125980 -4.0333604962165257," _
        + " -14.6020834250306490 -3.4248818497896130, -14.6706038730309340 -3.1183389868939639, -14.7883196595948260 -2.5012512233308986, -14.8374569125237720 -2.1910108182237962, -14.9161931526031960 -1.5677493010066135, -14.9457532881721630 -1.2550357308316589, -14.9851992457986750 -0.6280601884277989, -14.9950656036573160 -0.3141075907812337))"
    results(8) = _
        "POLYGON ((-13.9978060329073970 -0.2094624748266045, -13.9978060329073950 0.2094624748266889, -13.9899129466204800 0.5862055920025697, -13.9723091710683090 1.0056810332548318, -13.9486610626131340 1.3809373174647748, -13.9131748095786600 1.8020582537397334, -13.8738650072355010 2.1743467398682563, -13.8199333198798020 2.5981893751580385, -13.7651169614795710 2.9660408106328200, -13.6918816367286350 3.3936470893355333, -13.6217750573947250 3.7556097325960867, -13.5280664950561210 4.1879672781986219, -13.4429463734285120 4.5426126280570056, -13.3272628147087370 4.9806278220575830, -13.2274650810198080 5.3265562553399510, -13.0879482319261640 5.7710177916185499, -12.9738667422375400 6.1068640868384030, -12.8082754908518410 6.5583938485882607, -12.6803604726844450 6.8828325738519487, -12.4860455048912550 7.3418201699763186, -12.3448017803829830 7.6535709138571768, -12.1186855141924110 8.1200877988898483, -11.9646705077957790 8.4179202236271458, -11.7032390472997270 8.8916092271572076," _
        + " -11.5370605858822160 9.1743479242371997, -11.2363774530640650 9.6542845978244500, -11.0586913670931730 9.9208137267807857, -10.7144465907463000 10.4053377449800630, -10.5259541260263050 10.6546054371063280, -10.1335665546816960 11.1411241625366360, -9.9350116048568289 11.3721466721315850, -9.4898062292295364 11.8569198901936450, -9.2819723999756292 12.0687854769560520, -8.7794563174207489 12.5467111407040800, -8.5631638339116236 12.7385836679551690, -7.9994214052444379 13.2030195472396450, -7.7755238750978668 13.3741417817725790, -7.1477396542304596 13.8168157925036010, -6.9171206987088816 13.9665123930369910, -6.2242137310627568 14.3775906467337030, -5.9877834978238340 14.5052708291751160, -5.2310967209111192 14.8736585172804930, -4.9897882920707488 14.9788183862813580, -4.1737264480282601 15.2927525470066940, -3.9284921577117395 15.3749770846070390, -3.0609555812582574 15.6229213059541010, -2.8127632571725756 15.6818860094688350, -1.9052082437959865 15.8536545301842760," _
        + " -1.6550373876560236 15.8891266928670380, -0.7220331923269177 15.9770682384900770, -0.4708711142096648 15.9889078679204460, 0.4708711142097127 15.9889078679204420, 0.7220331923269657 15.9770682384900710, 1.6550373876561006 15.8891266928670250, 1.9052082437960645 15.8536545301842620, 2.8127632571726640 15.6818860094688160, 3.0609555812583449 15.6229213059540800, 3.9284921577117862 15.3749770846070250, 4.1737264480283063 15.2927525470066800, 4.9897882920707826 14.9788183862813450, 5.2310967209111530 14.8736585172804790, 5.9877834978238864 14.5052708291750850, 6.2242137310628074 14.3775906467336720, 6.9171206987089455 13.9665123930369500, 7.1477396542305236 13.8168157925035580, 7.7755238750979068 13.3741417817725510, 7.9994214052444779 13.2030195472396150, 8.5631638339116591 12.7385836679551400, 8.7794563174207827 12.5467111407040480, 9.2819723999756629 12.0687854769560160, 9.4898062292295684 11.8569198901936110, 9.9350116048568538 11.3721466721315560, 10.1335665546817210 11.1411241625366100," _
        + " 10.5259541260263450 10.6546054371062770, 10.7144465907463410 10.4053377449800100, 11.0586913670931950 9.9208137267807537, 11.2363774530640870 9.6542845978244163, 11.5370605858822340 9.1743479242371677, 11.7032390472997460 8.8916092271571721, 11.9646705077958020 8.4179202236271049, 12.1186855141924340 8.1200877988898057, 12.3448017803830050 7.6535709138571342, 12.4860455048912740 7.3418201699762751, 12.6803604726844630 6.8828325738519034, 12.8082754908518570 6.5583938485882154, 12.9738667422375520 6.1068640868383675, 13.0879482319261750 5.7710177916185117, 13.2274650810198190 5.3265562553399128, 13.3272628147087460 4.9806278220575457, 13.4429463734285230 4.5426126280569576, 13.5280664950561320 4.1879672781985740, 13.6217750573947300 3.7556097325960591, 13.6918816367286400 3.3936470893355035, 13.7651169614795780 2.9660408106327787, 13.8199333198798090 2.5981893751579981, 13.8738650072355050 2.1743467398682150, 13.9131748095786620 1.8020582537396930, 13.9486610626131360 1.3809373174647297," _
        + " 13.9723091710683110 1.0056810332547848, 13.9899129466204820 0.5862055920025263, 13.9978060329073950 0.2094624748266465, 13.9978060329073950 -0.2094624748266701, 13.9899129466204780 -0.5862055920025923, 13.9723091710683070 -1.0056810332548776, 13.9486610626131300 -1.3809373174648205, 13.9131748095786540 -1.8020582537397756, 13.8738650072354960 -2.1743467398682954, 13.8199333198797940 -2.5981893751580794, 13.7651169614795630 -2.9660408106328582, 13.6918816367286260 -3.3936470893355826, 13.6217750573947130 -3.7556097325961408, 13.5280664950561110 -4.1879672781986637, 13.4429463734285020 -4.5426126280570447, 13.3272628147087280 -4.9806278220576088, 13.2274650810198010 -5.3265562553399741, 13.0879482319261480 -5.7710177916185987, 12.9738667422375220 -6.1068640868384563, 12.8082754908518270 -6.5583938485882953, 12.6803604726844340 -6.8828325738519798, 12.4860455048912340 -7.3418201699763692, 12.3448017803829620 -7.6535709138572248, 12.1186855141923960 -8.1200877988898768," _
        + " 11.9646705077957630 -8.4179202236271777, 11.7032390472996980 -8.8916092271572555, 11.5370605858821880 -9.1743479242372459, 11.2363774530640370 -9.6542845978244927, 11.0586913670931470 -9.9208137267808283, 10.7144465907462810 -10.4053377449800890, 10.5259541260262830 -10.6546054371063570, 10.1335665546816620 -11.1411241625366770, 9.9350116048567969 -11.3721466721316240, 9.4898062292294831 -11.8569198901937010, 9.2819723999755759 -12.0687854769561030, 8.7794563174207294 -12.5467111407040960, 8.5631638339116005 -12.7385836679551860, 7.9994214052443882 -13.2030195472396840, 7.7755238750978179 -13.3741417817726160, 7.1477396542304321 -13.8168157925036180, 6.9171206987088540 -13.9665123930370070, 6.2242137310626875 -14.3775906467337380, 5.9877834978237630 -14.5052708291751490, 5.2310967209110570 -14.8736585172805180, 4.9897882920706875 -14.9788183862813820, 4.1737264480281953 -15.2927525470067170, 3.9284921577116760 -15.3749770846070600, 3.0609555812582285 -15.6229213059541080," _
        + " 2.8127632571725445 -15.6818860094688400, 1.9052082437959421 -15.8536545301842790, 1.6550373876559801 -15.8891266928670410, 0.7220331923268358 -15.9770682384900770, 0.4708711142095837 -15.9889078679204460, -0.4708711142097903 -15.9889078679204390, -0.7220331923270460 -15.9770682384900660, -1.6550373876561599 -15.8891266928670150, -1.9052082437961220 -15.8536545301842510, -2.8127632571727186 -15.6818860094688050, -3.0609555812583986 -15.6229213059540690, -3.9284921577118315 -15.3749770846070070, -4.1737264480283534 -15.2927525470066610, -4.9897882920708492 -14.9788183862813150, -5.2310967209112178 -14.8736585172804490, -5.9877834978239459 -14.5052708291750570, -6.2242137310628660 -14.3775906467336420, -6.9171206987089651 -13.9665123930369360, -7.1477396542305449 -13.8168157925035440, -7.7755238750979725 -13.3741417817724990, -7.9994214052445418 -13.2030195472395630, -8.5631638339116876 -12.7385836679551120, -8.7794563174208129 -12.5467111407040230, -9.2819723999757109 -12.0687854769559700," _
        + " -9.4898062292296181 -11.8569198901935610, -9.9350116048568875 -11.3721466721315170, -10.1335665546817510 -11.1411241625365700, -10.5259541260263670 -10.6546054371062480, -10.7144465907463630 -10.4053377449799810, -11.0586913670932270 -9.9208137267807111, -11.2363774530641150 -9.6542845978243736, -11.5370605858822550 -9.1743479242371304, -11.7032390472997660 -8.8916092271571365, -11.9646705077958200 -8.4179202236270676, -12.1186855141924530 -8.1200877988897666, -12.3448017803830300 -7.6535709138570844, -12.4860455048912970 -7.3418201699762262, -12.6803604726844770 -6.8828325738518696, -12.8082754908518690 -6.5583938485881799, -12.9738667422375680 -6.1068640868383275, -13.0879482319261910 -5.7710177916184708, -13.2274650810198370 -5.3265562553398542, -13.3272628147087620 -4.9806278220574880, -13.4429463734285300 -4.5426126280569328, -13.5280664950561370 -4.1879672781985482, -13.6217750573947430 -3.7556097325960112, -13.6918816367286510 -3.3936470893354542," _
        + " -13.7651169614795850 -2.9660408106327285, -13.8199333198798140 -2.5981893751579488, -13.8738650072355090 -2.1743467398681817, -13.9131748095786650 -1.8020582537396588, -13.9486610626131390 -1.3809373174646844, -13.9723091710683120 -1.0056810332547386, -13.9899129466204840 -0.5862055920024827, -13.9978060329073970 -0.2094624748266045))"
    results(9) = _
        "POLYGON ((-15.0000000000000000 -5.0000000000000000, -15.0000000000000000 5.0000000000000000, -15.0000000000000000 5.0000000000000009, -14.8078528040323040 6.9509032201612859, -14.2387953251128680 8.8268343236508997, -13.3146961230254530 10.5557023301960220, -12.0710678118654760 12.0710678118654760, -10.5557023301960200 13.3146961230254540, -8.8268343236508962 14.2387953251128680, -6.9509032201612815 14.8078528040323040, -5.0000000000000000 15.0000000000000000, 5.0000000000000000 15.0000000000000000, 5.0000000000000009 15.0000000000000000, 6.9509032201612833 14.8078528040323040, 8.8268343236508979 14.2387953251128680, 10.5557023301960240 13.3146961230254530, 12.0710678118654760 12.0710678118654760, 13.3146961230254530 10.5557023301960220, 14.2387953251128680 8.8268343236508979, 14.8078528040323040 6.9509032201612824, 15.0000000000000000 5.0000000000000000, 15.0000000000000000 -5.0000000000000000, 14.8078528040323040 -6.9509032201612824, 14.2387953251128680 -8.8268343236508979," _
        + " 13.3146961230254530 -10.5557023301960220, 12.0710678118654760 -12.0710678118654760, 10.5557023301960240 -13.3146961230254530, 8.8268343236508979 -14.2387953251128680, 6.9509032201612833 -14.8078528040323040, 5.0000000000000000 -15.0000000000000000, -5.0000000000000000 -15.0000000000000000, -5.0000000000000639 -15.0000000000000000, -6.9509032201613383 -14.8078528040322940, -8.8268343236509441 -14.2387953251128480, -10.5557023301960590 -13.3146961230254280, -12.0710678118654970 -12.0710678118654520, -13.3146961230254670 -10.5557023301960000, -14.2387953251128730 -8.8268343236508837, -14.8078528040323060 -6.9509032201612753, -15.0000000000000000 -5.0000000000000000))"
    results(10) = _
        "POLYGON ((-15.0000000000000000 -5.0000000000000000, -15.0000000000000000 15.0000000000000000, -15.0000000000000000 15.0000000000000020, -14.8078528040323040 16.9509032201612870, -14.2387953251128680 18.8268343236509000, -13.3146961230254530 20.5557023301960200, -12.0710678118654760 22.0710678118654760, -10.5557023301960200 23.3146961230254560, -8.8268343236508962 24.2387953251128680, -6.9509032201612815 24.8078528040323040, -5.0000000000000000 25.0000000000000000, 5.0000000000000000 25.0000000000000000, 5.0000000000000009 25.0000000000000000, 6.9509032201612833 24.8078528040323040, 8.8268343236508979 24.2387953251128680, 10.5557023301960240 23.3146961230254530, 12.0710678118654760 22.0710678118654760, 13.3146961230254530 20.5557023301960200, 14.2387953251128680 18.8268343236509000, 14.8078528040323040 16.9509032201612830, 15.0000000000000000 15.0000000000000000, 15.0000000000000000 -5.0000000000000000, 14.8078528040323040 -6.9509032201612824, 14.2387953251128680 -8.8268343236508979," _
        + " 13.3146961230254530 -10.5557023301960220, 12.0710678118654760 -12.0710678118654760, 10.5557023301960240 -13.3146961230254530, 8.8268343236508979 -14.2387953251128680, 6.9509032201612833 -14.8078528040323040, 5.0000000000000000 -15.0000000000000000, -5.0000000000000000 -15.0000000000000000, -5.0000000000000639 -15.0000000000000000, -6.9509032201613383 -14.8078528040322940, -8.8268343236509441 -14.2387953251128480, -10.5557023301960590 -13.3146961230254280, -12.0710678118654970 -12.0710678118654520, -13.3146961230254670 -10.5557023301960000, -14.2387953251128730 -8.8268343236508837, -14.8078528040323060 -6.9509032201612753, -15.0000000000000000 -5.0000000000000000))"
    results(11) = _
        "POLYGON ((-4.9103744697600717 20.4695697964951080, -4.6265911438397591 22.4092633143693900, -3.9698452019385542 24.2563227847574440, -2.9653750222963513 25.9397667480551420, -1.6517818306034355 27.3949013968392060, -0.0795462765450168 28.5658067226057780, 1.6909115092562979 29.4074854903369170, 3.5915538269763281 29.8875924570076070, 5.5493400582376058 29.9876773811357820, 5.6278572670691434 29.9839766599764910, 5.9404410084800183 29.9643336045873770, 6.0189194666375911 29.9581667505497610, 6.3295917178667622 29.9288702731470690, 6.4080120619651151 29.9202388078100870, 6.7160404911374041 29.8814868828436180, 6.7943833721300617 29.8703929358921770, 7.0990668285800007 29.8224434320268090, 7.1773129165333476 29.8088897407263360, 7.4779888532593635 29.7520554974644290, 7.5561188421220180 29.7360454059854260, 7.8521697243958748 29.6706884354204090, 7.9301643367621706 29.6522258940133910, 8.2210229143039797 29.5787509122483740, 8.2988629061703705 29.5578404762691700," _
        + " 8.5840162756186249 29.4766879811174930, 8.6616824411318660 29.4533348099032960, 8.9406748746620632 29.3649739222275020, 9.0181480508579579 29.3391837778238620, 9.2905826126437105 29.2441050542940030, 9.3678436841752841 29.2158843000331530, 9.6333826967564828 29.1145927067962660, 9.7104126006104234 29.0839483057270340, 9.9687770563317084 28.9769565175726380, 10.0455567865318580 28.9438960307424580, 10.2965248242413310 28.8317181910290120, 10.3730354365381460 28.7962497756183000, 10.6164400202622660 28.6793958207788830, 10.6926626368070130 28.6415282280884290, 10.9283885816910900 28.5204988489090570, 11.0043043956936800 28.4802414222007270, 11.2322848876917870 28.3555237040574820, 11.3078751680610700 28.3128863762489330, 11.5280879190573310 28.1849501332928510, 11.6033340150227030 28.1399434245067180, 11.8157971853363580 28.0092382193844500, 11.8906805310495760 27.9618732343526870, 12.0954485381516010 27.8288260558393250, 12.1699506572676110 27.7791144811632440," _
        + " 12.3671099741412470 27.6441280372757700, 12.4412124843769560 27.5920821385425730, 12.6308775145774630 27.4555337120658720, 12.7045621322472930 27.4011663308222890, 12.8868712321622280 27.2634071374508340, 12.9601197766893320 27.2067316880346790, 13.1352314796513490 27.0680866739418490, 13.2080258780534090 27.0091171401722010, 13.3761153602672940 26.8698851552653440, 13.4484376516157480 26.8086360869922870, 13.6096934667481250 26.6690903717772620, 13.6815258065997650 26.6055768812919060, 13.8361469044984380 26.4659658086311750, 13.9074715692982590 26.4002035669369160, 14.0556646047481450 26.2607515845158090, 14.1264639962023550 26.1927568174617700, 14.2684409258494010 26.0536655420355350, 14.3386975752675600 25.9834550263130560, 14.4746735347063190 25.8449044464575940, 14.5443701073114550 25.7724955054608490, 14.6745615557304860 25.6346452552539970, 14.7436808549361940 25.5600557548056990, 14.8683039714141620 25.4230464264451680, 14.9368289430676240 25.3462947703884430," _
        + " 15.0560982564523800 25.2102492390159580, 15.1240119930421970 25.1313543646734840, 15.2381392261114570 24.9963791035365830, 15.3054249709393450 24.9153604770380670, 15.4146180790690420 24.7815468455051470, 15.4812592303842800 24.6984244569843770, 15.5857216150722180 24.5658499478089710, 15.6517017301678930 24.4806443064715250, 15.7516316083214180 24.3493737420907800, 15.8169344075914130 24.2621058711536970, 15.9125243183881010 24.1321925416932680, 15.9771336893438410 24.0428839731978850, 16.0685701215833060 23.9143707113044610, 16.1324701228292750 23.8230434808036970, 16.2199332469519670 23.6959636704462040, 16.2831081121190200 23.6026403115676400, 16.3667716023927740 23.4770188295994300, 16.4292057440282380 23.3817223684854310, 16.5092366777428770 23.2575764590880140, 16.5709146911565170 23.1603304087144050, 16.6474735129953690 23.0376704918732220, 16.7083801800602880 22.9384988462478180, 16.7816207210942990 22.8173292621981110, 16.8417410140017690 22.7162564904405290," _
        + " 16.9118105559487260 22.5965761826218490, 16.9711296409160680 22.4936272229261360, 17.0381690174452630 22.3754303623765690, 17.0966722583758680 22.2706306158580740, 17.1608159862670110 22.1539071702642650, 17.2184889483615850 22.0472824946922830, 17.2798653822779260 21.9320187454586130, 17.3366938355960580 21.8235954488763860, 17.3954253410840600 21.7097744596465110, 17.4513952640552250 21.5995792938800970, 17.5075984041521660 21.4871813339333290, 17.5626959870353720 21.3752414879909980, 17.6164817185509010 21.2642444138712640, 17.6706933668420160 21.1505875072350060, 17.7221672429814740 21.0409671058719890, 17.7754795807674670 20.9256211816828350, 17.8247419573017470 20.8173514781224110, 17.8771418305609940 20.7003449962611940, 17.9242880732093750 20.5933985289760170, 17.9757625530572330 20.4747603590413370, 18.0208832441590130 20.3691084256178740, 18.0714196300378020 20.2488678398029340, 18.1146007729376630 20.1444807156312710, 18.1641865957503650 20.0226673815014240," _
        + " 18.2055098156268760 19.9195145139147410, 18.2541328408136780 19.7961584870874570, 18.2936755809398800 19.6942086672228420, 18.3413238114968810 19.5693403839519140, 18.3791595241430910 19.4685618984353610, 18.4258212035823730 19.3422121681012520, 18.4620195349622160 19.2425729324875300, 18.5076831502125930 19.1147729299955810, 18.5423101190292240 19.0162406057442370, 18.5869644032769160 18.8870218638327570, 18.6200825725636360 18.7895639604425640, 18.6637165080321770 18.6589583619025770, 18.6953851500898050 18.5625423256949950, 18.7379879707585320 18.4305820955036420, 18.7682632250880060 18.3351753864040500, 18.8098244193483880 18.2018930837735730, 18.8387594435497760 18.1074632413252770, 18.8792687567990360 17.9728917516695010, 18.9069138704722800 17.8794064513958910, 18.9463613076435170 17.7435789782162560, 18.9727641293746920 17.6510060793448100, 19.0111399574030530 17.5139561360378910, 19.0363455349606490 17.4222637214992840, 19.0736402851847980 17.2840251230878650," _
        + " 19.0976912190791950 17.1931815326219460, 19.1338956895775670 17.0537883874116790, 19.1568322501631130 16.9637622445207970, 19.1919375080243530 16.8232489456844830, 19.2137977463376400 16.7340091791108880, 19.2477951298646590 16.5924103962024640, 19.2686149824063730 16.5039262565328320, 19.3014961032535020 16.3612769269331930, 19.3213094909285270 16.2735179988721090, 19.3530662361712020 16.1298533191688240, 19.3719051576045090 16.0427895299729360, 19.4025296917410370 15.8981449472760290, 19.4204243111900610 15.8117465717801500, 19.4499090780748820 15.6661577749760320, 19.4668878081547090 15.5803954376104610, 19.4952255328627900 15.4338983485562530, 19.5113151123006150 15.3487430226972870, 19.5384988029224050 15.2013737873576280, 19.5537243695492440 15.1167967923323800, 19.5797473189158460 14.9685917718609590, 19.5941324781007250 14.8845647678777500, 19.6189882654387660 14.7355605296457310, 19.6325551541602050 14.6520555109072530, 19.6562376466760860 14.5022888194808190," _
        + " 19.6690069934207230 14.4192781056948980, 19.6915103478137890 14.2687859137641500, 19.7035015284816880 14.1862421402526330, 19.7248201923859630 14.0350615795140690, 19.7360512823736020 13.9529576860968060, 19.7561799957277660 13.8011260580916260, 19.7666678183519020 13.7194352768955150, 19.7856016146971290 13.5669900438060210, 19.7953617861115560 13.4856858861426880, 19.8130959938169120 13.3326646615490580, 19.8221429645666230 13.2517209039780060, 19.8386732079817140 13.0981614435777070, 19.8470203013280870 13.0175521132683690, 19.8623425018627020 12.8634923055604900, 19.8700019490058750 12.7831916650397750, 19.8841123261362970 12.6286695219766240, 19.8910952984494430 12.5486520533562530, 19.9039903706512650 12.3937057009644660, 19.9103070090348380 12.3139460897111860, 19.9219835946419370 12.1586137586847030, 19.9276430360947890 12.0790868770077160, 19.9380982540843910 11.9234068932749330, 19.9431086555816680 11.8440877831797150, 19.9523399262851770 11.6880985584471250," _
        + " 19.9567084860427890 11.6089624145124030, 19.9647135317822910 11.4527024367870940, 19.9684465079802960 11.3737245887041890, 19.9752233536305330 11.2172324127974950, 19.9783260806587220 11.1383883077153140, 19.9838730541344420 10.9817025457299970, 19.9863499564155380 10.9029677304352400, 19.9906656890840250 10.7461270422385340, 19.9925202925213910 10.6674771452100130, 19.9956037195401990 10.5105202288948690, 19.9968386606294960 10.4319309422496200, 19.9986890212091420 10.2748965245865430, 19.9993060538448080 10.1963435859522380, 19.9999228914365050 10.0392704128340320, 19.9999228914365050 10.0392704128340160, 19.8154384545737300 8.0876276658361625, 19.2537522224629920 6.2094763151694643, 18.3364494820070330 4.4769926639606306, 17.0987816630922750 2.9567550873375925, 15.5883116459075030 1.7071854628109175, 13.8630859461317810 0.7763040502844447, 11.9894040198897740 0.1998841003972611, 10.0392704128340320 0.0000771085634952, 8.0876276658361785 0.1845615454262664," _
        + " 6.2094763151694794 0.7462477775370040, 4.4769926639606430 1.6635505179929595, 2.9567550873376023 2.9012183369077151, 1.7071854628109246 4.4116883540924858, 0.7763040502844518 6.1369140538682041, 0.1998841003972647 8.0105959801102102, 0.0000771085634952 9.9607295871659680, -0.0003854827636063 10.0785250791770250, -0.0013100135817629 10.1569871693435840, -0.0028489305257864 10.2353232728173200, -0.0049992781425850 10.3134703745929120, -0.0077569111363205 10.3913654337257100, -0.0111164866743112 10.4689453747775760, -0.0150714544478075 10.5461470793401430, -0.0196140444524358 10.6229073776629510, -0.0247352524453730 10.6991630404167640, -0.0304248230273945 10.7748507706131530, -0.0366712302907328 10.8499071957234550, -0.0434616559648921 10.9242688600350120, -0.0507819649836831 10.9978722172844710, -0.0586166783888482 11.0706536236241910, -0.0669489434765769 11.1425493309795250, -0.0757605010840268 11.2134954808618140, -0.0850316499044404 11.2834280987154260," _
        + " -0.0947412077101664 11.3522830888866830, -0.1048664693528146 11.4199962303081220, -0.1153831614023232 11.4865031730190450, -0.1195673616875290 11.5115864088718510, -0.8624638366794510 11.9548547159611670, -2.3175984854635079 13.2684479076540820, -3.4885038112300748 14.8406834617125030, -4.3301825789612103 16.6111412475138210, -4.8102895456318997 18.5117835652338520, -4.9103744697600717 20.4695697964951080))"
    
    Dim i
    For i = LBound(geoms) To UBound(geoms)
        Dim geom
        Set geom = geoms(i).buffer(10, 8)
        Dim writer
        Set writer = geos.WktWriter.new_WktWriter()
        assertEqual writer.write(geom), results(i), "testBuffer(" + CStr(i) + ")"
    Next
End Sub

Sub testConvexHull()
    Dim geoms
    geoms = testHelper.createGeoms()
    Dim results
    results = Array( _
        "POINT (150.0000000000000000 350.0000000000000000)", _
        "POLYGON ((0.0000000000000000 0.0000000000000000, 0.0000000000000000 100.0000000000000000, 100.0000000000000000 100.0000000000000000, 100.0000000000000000 0.0000000000000000, 0.0000000000000000 0.0000000000000000))", _
        "POLYGON ((60.0000000000000000 60.0000000000000000, 60.0000000000000000 160.0000000000000000, 160.0000000000000000 160.0000000000000000, 160.0000000000000000 60.0000000000000000, 60.0000000000000000 60.0000000000000000))", _
        "POLYGON ((0.0000000000000000 0.0000000000000000, 0.0000000000000000 100.0000000000000000, 100.0000000000000000 100.0000000000000000, 100.0000000000000000 0.0000000000000000, 0.0000000000000000 0.0000000000000000))", _
        "POLYGON ((0.0000000000000000 200.0000000000000000, 0.0000000000000000 500.0000000000000000, 300.0000000000000000 500.0000000000000000, 300.0000000000000000 200.0000000000000000, 0.0000000000000000 200.0000000000000000))", _
        "POLYGON ((0.0000000000000000 250.0000000000000000, 0.0000000000000000 550.0000000000000000, 300.0000000000000000 550.0000000000000000, 300.0000000000000000 250.0000000000000000, 0.0000000000000000 250.0000000000000000))", _
        "POLYGON ((0.0000000000000000 0.0000000000000000, 0.0000000000000000 550.0000000000000000, 300.0000000000000000 550.0000000000000000, 300.0000000000000000 200.0000000000000000, 100.0000000000000000 0.0000000000000000, 0.0000000000000000 0.0000000000000000))", _
        "POLYGON ((-0.0000000000000000 -5.0000000000000000, -0.3100000000000000 -4.9900000000000002, -0.6300000000000000 -4.9600000000000000, -0.9400000000000000 -4.9100000000000001, -1.2400000000000000 -4.8399999999999999, -1.5500000000000000 -4.7599999999999998, -1.8400000000000001 -4.6500000000000004, -2.1299999999999999 -4.5199999999999996, -2.4100000000000001 -4.3799999999999999, -2.6800000000000002 -4.2199999999999998, -2.9399999999999999 -4.0499999999999998, -3.1899999999999999 -3.8500000000000001, -3.4199999999999999 -3.6400000000000001, -3.6400000000000001 -3.4199999999999999, -3.8500000000000001 -3.1899999999999999, -4.0499999999999998 -2.9399999999999999, -4.2199999999999998 -2.6800000000000002, -4.3799999999999999 -2.4100000000000001, -4.5199999999999996 -2.1299999999999999, -4.6500000000000004 -1.8400000000000001, -4.7599999999999998 -1.5500000000000000, -4.8399999999999999 -1.2400000000000000, -4.9100000000000001 -0.9400000000000000, -4.9600000000000000 -0.6300000000000000," _
        + " -4.9900000000000002 -0.3100000000000000, -5.0000000000000000 0.0000000000000000, -4.9900000000000002 0.3100000000000000, -4.9600000000000000 0.6300000000000000, -4.9100000000000001 0.9400000000000000, -4.8399999999999999 1.2400000000000000, -4.7599999999999998 1.5500000000000000, -4.6500000000000004 1.8400000000000001, -4.5199999999999996 2.1299999999999999, -4.3799999999999999 2.4100000000000001, -4.2199999999999998 2.6800000000000002, -4.0499999999999998 2.9399999999999999, -3.8500000000000001 3.1899999999999999, -3.6400000000000001 3.4199999999999999, -3.4199999999999999 3.6400000000000001, -3.1899999999999999 3.8500000000000001, -2.9399999999999999 4.0499999999999998, -2.6800000000000002 4.2199999999999998, -2.4100000000000001 4.3799999999999999, -2.1299999999999999 4.5199999999999996, -1.8400000000000001 4.6500000000000004, -1.5500000000000000 4.7599999999999998, -1.2400000000000000 4.8399999999999999, -0.9400000000000000 4.9100000000000001, -0.6300000000000000 4.9600000000000000," _
        + " -0.3100000000000000 4.9900000000000002, 0.0000000000000000 5.0000000000000000, 0.3100000000000000 4.9900000000000002, 0.6300000000000000 4.9600000000000000, 0.9400000000000000 4.9100000000000001, 1.2400000000000000 4.8399999999999999, 1.5500000000000000 4.7599999999999998, 1.8400000000000001 4.6500000000000004, 2.1299999999999999 4.5199999999999996, 2.4100000000000001 4.3799999999999999, 2.6800000000000002 4.2199999999999998, 2.9399999999999999 4.0499999999999998, 3.1899999999999999 3.8500000000000001, 3.4199999999999999 3.6400000000000001, 3.6400000000000001 3.4199999999999999, 3.8500000000000001 3.1899999999999999, 4.0499999999999998 2.9399999999999999, 4.2199999999999998 2.6800000000000002, 4.3799999999999999 2.4100000000000001, 4.5199999999999996 2.1299999999999999, 4.6500000000000004 1.8400000000000001, 4.7599999999999998 1.5500000000000000, 4.8399999999999999 1.2400000000000000, 4.9100000000000001 0.9400000000000000, 4.9600000000000000 0.6300000000000000," _
        + " 4.9900000000000002 0.3100000000000000, 5.0000000000000000 0.0000000000000000, 4.9900000000000002 -0.3100000000000000, 4.9600000000000000 -0.6300000000000000, 4.9100000000000001 -0.9400000000000000, 4.8399999999999999 -1.2400000000000000, 4.7599999999999998 -1.5500000000000000, 4.6500000000000004 -1.8400000000000001, 4.5199999999999996 -2.1299999999999999, 4.3799999999999999 -2.4100000000000001, 4.2199999999999998 -2.6800000000000002, 4.0499999999999998 -2.9399999999999999, 3.8500000000000001 -3.1899999999999999, 3.6400000000000001 -3.4199999999999999, 3.4199999999999999 -3.6400000000000001, 3.1899999999999999 -3.8500000000000001, 2.9399999999999999 -4.0499999999999998, 2.6800000000000002 -4.2199999999999998, 2.4100000000000001 -4.3799999999999999, 2.1299999999999999 -4.5199999999999996, 1.8400000000000001 -4.6500000000000004, 1.5500000000000000 -4.7599999999999998, 1.2400000000000000 -4.8399999999999999, 0.9400000000000000 -4.9100000000000001, 0.6300000000000000 -4.9600000000000000," _
        + " 0.3100000000000000 -4.9900000000000002, -0.0000000000000000 -5.0000000000000000))", _
        "POLYGON ((-0.0000000000000000 -6.0000000000000000, -0.2500000000000000 -5.9900000000000002, -0.5000000000000000 -5.9500000000000002, -0.7500000000000000 -5.8899999999999997, -0.9900000000000000 -5.8099999999999996, -1.2400000000000000 -5.7100000000000000, -1.4700000000000000 -5.5800000000000001, -1.7000000000000000 -5.4299999999999997, -1.9299999999999999 -5.2599999999999998, -2.1400000000000001 -5.0700000000000003, -2.3500000000000001 -4.8499999999999996, -2.5499999999999998 -4.6200000000000001, -2.7400000000000002 -4.3700000000000001, -2.9199999999999999 -4.1100000000000003, -3.2400000000000002 -3.5299999999999998, -3.3799999999999999 -3.2100000000000000, -3.5099999999999998 -2.8900000000000001, -3.6200000000000001 -2.5499999999999998, -3.7200000000000002 -2.2100000000000000, -3.7999999999999998 -1.8500000000000001, -3.8700000000000001 -1.4900000000000000, -3.9300000000000002 -1.1200000000000001, -3.9700000000000002 -0.7500000000000000, -3.9900000000000002 -0.3800000000000000," _
        + " -4.0000000000000000 0.0000000000000000, -3.9900000000000002 0.3800000000000000, -3.9700000000000002 0.7500000000000000, -3.9300000000000002 1.1200000000000001, -3.8700000000000001 1.4900000000000000, -3.7999999999999998 1.8500000000000001, -3.7200000000000002 2.2100000000000000, -3.6200000000000001 2.5499999999999998, -3.5099999999999998 2.8900000000000001, -3.3799999999999999 3.2100000000000000, -3.2400000000000002 3.5299999999999998, -2.9199999999999999 4.1100000000000003, -2.7400000000000002 4.3700000000000001, -2.5499999999999998 4.6200000000000001, -2.3500000000000001 4.8499999999999996, -2.1400000000000001 5.0700000000000003, -1.9299999999999999 5.2599999999999998, -1.7000000000000000 5.4299999999999997, -1.4700000000000000 5.5800000000000001, -1.2400000000000000 5.7100000000000000, -0.9900000000000000 5.8099999999999996, -0.7500000000000000 5.8899999999999997, -0.5000000000000000 5.9500000000000002, -0.2500000000000000 5.9900000000000002, 0.0000000000000000 6.0000000000000000," _
        + " 0.2500000000000000 5.9900000000000002, 0.5000000000000000 5.9500000000000002, 0.7500000000000000 5.8899999999999997, 0.9900000000000000 5.8099999999999996, 1.2400000000000000 5.7100000000000000, 1.4700000000000000 5.5800000000000001, 1.7000000000000000 5.4299999999999997, 1.9299999999999999 5.2599999999999998, 2.1400000000000001 5.0700000000000003, 2.3500000000000001 4.8499999999999996, 2.5499999999999998 4.6200000000000001, 2.7400000000000002 4.3700000000000001, 2.9199999999999999 4.1100000000000003, 3.2400000000000002 3.5299999999999998, 3.3799999999999999 3.2100000000000000, 3.5099999999999998 2.8900000000000001, 3.6200000000000001 2.5499999999999998, 3.7200000000000002 2.2100000000000000, 3.7999999999999998 1.8500000000000001, 3.8700000000000001 1.4900000000000000, 3.9300000000000002 1.1200000000000001, 3.9700000000000002 0.7500000000000000, 3.9900000000000002 0.3800000000000000, 4.0000000000000000 0.0000000000000000, 3.9900000000000002 -0.3800000000000000," _
        + " 3.9700000000000002 -0.7500000000000000, 3.9300000000000002 -1.1200000000000001, 3.8700000000000001 -1.4900000000000000, 3.7999999999999998 -1.8500000000000001, 3.7200000000000002 -2.2100000000000000, 3.6200000000000001 -2.5499999999999998, 3.5099999999999998 -2.8900000000000001, 3.3799999999999999 -3.2100000000000000, 3.2400000000000002 -3.5299999999999998, 2.9199999999999999 -4.1100000000000003, 2.7400000000000002 -4.3700000000000001, 2.5499999999999998 -4.6200000000000001, 2.3500000000000001 -4.8499999999999996, 2.1400000000000001 -5.0700000000000003, 1.9299999999999999 -5.2599999999999998, 1.7000000000000000 -5.4299999999999997, 1.4700000000000000 -5.5800000000000001, 1.2400000000000000 -5.7100000000000000, 0.9900000000000000 -5.8099999999999996, 0.7500000000000000 -5.8899999999999997, 0.5000000000000000 -5.9500000000000002, 0.2500000000000000 -5.9900000000000002, -0.0000000000000000 -6.0000000000000000))", _
        "POLYGON ((-5.0000000000000000 -5.0000000000000000, -5.0000000000000000 5.0000000000000000, 5.0000000000000000 5.0000000000000000, 5.0000000000000000 -5.0000000000000000, -5.0000000000000000 -5.0000000000000000))", _
        "POLYGON ((-5.0000000000000000 -5.0000000000000000, -5.0000000000000000 15.0000000000000000, 5.0000000000000000 15.0000000000000000, 5.0000000000000000 -5.0000000000000000, -5.0000000000000000 -5.0000000000000000))", _
        "POLYGON ((10.0000000000000000 10.0000000000000000, 5.0000000000000000 20.0000000000000000, 6.0000000000000000 20.0000000000000000, 7.0000000000000000 19.5000000000000000, 8.0000000000000000 18.5000000000000000, 9.0000000000000000 16.5000000000000000, 9.5000000000000000 15.0000000000000000, 10.0000000000000000 13.0000000000000000, 10.0000000000000000 10.0000000000000000))" _
    )
    
    Dim i
    For i = LBound(geoms) To UBound(geoms)
        Dim geom
        Set geom = geoms(i).convexHull()
        Dim writer
        Set writer = geos.WktWriter.new_WktWriter()
        assertEqual writer.write(geom), results(i), "testConvexHull(" + CStr(i) + ")"
    Next
End Sub
