<?xml version="1.0" encoding="UTF-8"?>
<!--
 Copyright (C) MX4J.
 All rights reserved.

 This software is distributed under the terms of the MX4J License version 1.0.
 See the terms of the MX4J License in the documentation provided with this software.

 Author: Carlos Quiroz (tibu@users.sourceforge.net)
 Contribution: Lachezar Dobrev (l.dobrev@lsnsoft.com)
 Revision: $Revision: 1.6 $
																																					-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output encoding="UTF-8" indent="yes" method="html"/>
  <xsl:param name="head.title">mbean.title</xsl:param>
  <xsl:include href="common.xsl"/>
  <xsl:include href="mbean_attributes.xsl"/>
  <xsl:param name="request.objectname"/>
  <xsl:template match="Parameter" name="parameters">
    <xsl:for-each select="Parameter">
      <xsl:sort data-type="number" order="ascending" select="@id"/>
      <xsl:variable name="type.id" select="concat('type', position()-1)"/>
      <xsl:variable name="name.id" select="concat('value', position()-1)"/>
      <xsl:variable name="type" select="@type"/>
      <xsl:variable name="cellcolor">
        <xsl:if test="(position() mod 2)=1">#CCCCCC</xsl:if>
        <xsl:if test="(position() mod 2)=0">#FFFFFF</xsl:if>
      </xsl:variable>
      <tr>
        <td align="center" bgcolor="{$cellcolor}" width="3%">
          <xsl:value-of select="@id"/>
        </td>
        <td align="left" bgcolor="{$cellcolor}" width="10%">
          <xsl:value-of select="@name"/>
        </td>
        <td align="left" bgcolor="{$cellcolor}" width="57%">
          <xsl:value-of select="@description"/>
        </td>
        <td align="left" bgcolor="{$cellcolor}">
          <xsl:choose>
            <xsl:when test="starts-with( @type, 'java.lang.' )">
            <xsl:value-of select="substring-after( @type, 'java.lang.' )"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="@type"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td align="right" bgcolor="{$cellcolor}">
          <xsl:choose>
            <xsl:when test="@type='java.lang.String' or @type='java.lang.Double' or @type='java.lang.Short' or @type='java.lang.Integer' or @type='java.lang.Long' or @type='java.lang.Float' or @type='java.lang.Byte' or @type='java.lang.Boolean' or @type='java.lang.Character' or @type='javax.management.ObjectName' or @type='int' or @type='short' or @type='boolean' or @type='byte' or @type='double' or @type='long' or @type='char' or @type='float'">
              <xsl:attribute name="valid">true</xsl:attribute>
              <xsl:call-template name="raw-input">
                <xsl:with-param name="name" select="$name.id"/>
                <xsl:with-param name="type" select="$type"/>
                <xsl:with-param name="value"/>
                <xsl:with-param name="strinit">false</xsl:with-param>
              </xsl:call-template>
            </xsl:when>
            <xsl:when test="@strinit='true'">
              <xsl:attribute name="valid">true</xsl:attribute>
              <xsl:call-template name="raw-input">
                <xsl:with-param name="name" select="$name.id"/>
                <xsl:with-param name="type" select="$type"/>
                <xsl:with-param name="value"/>
                <xsl:with-param name="strinit">true</xsl:with-param>
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="valid">false</xsl:attribute>
              <xsl:call-template name="str">
                <xsl:with-param name="id">mbean.parameters.unknown</xsl:with-param>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
          <input name="{$type.id}" type="hidden" value="{$type}"/>
        </td>
      </tr>
    </xsl:for-each>
  </xsl:template>
  <xsl:template name="operations">
    <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
      <tr>
        <td>
          <img border="0" height="15" src="images/bkgd_onglet_left.gif"/>
        </td>
        <td align="left" bgcolor="#993399" nowrap="nowrap">
          <span class="Titre2">
             <font color="#FFFFFF">
              <b>
                <xsl:call-template name="str">
						      <xsl:with-param name="id">mbean.operations.title</xsl:with-param>
					      </xsl:call-template>
              </b>
            </font>
          </span>
        </td>
        <td>
          <img border="0" src="images/bkgd_onglet_tit2.gif"/>
        </td>
        <td bgcolor="#FFFFFF" width="100%"/>
      </tr>
    </table>
    <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
      <tr align="left" valign="top">
        <td bgcolor="#993399" class="Titre3black" width="15%">
          <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160; <font color="#FFFFFF">
            <b>
              <xsl:call-template name="str">
                <xsl:with-param name="id">mbean.operations.name</xsl:with-param>
              </xsl:call-template>
            </b>
          </font>
        </td>
        <td bgcolor="#993399" class="Titre3black" width="20%">
          <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160; <font color="#FFFFFF">
            <b>
              <xsl:call-template name="str">
                <xsl:with-param name="id">mbean.operations.returntype</xsl:with-param>
              </xsl:call-template>
            </b>
          </font>
        </td>
        <td bgcolor="#993399" class="Titre3black" colspan="2">
          <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160; <font color="#FFFFFF">
            <b>
              <xsl:call-template name="str">
                <xsl:with-param name="id">mbean.operations.description</xsl:with-param>
              </xsl:call-template>
            </b>
          </font>
        </td>
      </tr>
      <xsl:variable name="invoke.str">
        <xsl:call-template name="str">
          <xsl:with-param name="id">mbean.operations.invoke</xsl:with-param>
        </xsl:call-template>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="Operation">
          <xsl:for-each select="Operation">
            <xsl:variable name="name">
              <xsl:value-of select="@name"/>
            </xsl:variable>
            <xsl:variable name="cellcolor">
              <xsl:if test="(position() mod 2)=1">#CCCCCC</xsl:if>
              <xsl:if test="(position() mod 2)=0">#FFFFFF</xsl:if>
            </xsl:variable>
            <xsl:variable name="hasParameters">
              <xsl:if test="count(./Parameter)&gt;0">true</xsl:if>
              <xsl:if test="count(./Parameter)=0">false</xsl:if>
            </xsl:variable>
            <tr>
              <form action="invoke">
                <input name="operation" type="hidden" value="{$name}"/>
                <input name="objectname" type="hidden" value="{$request.objectname}"/>
                <td align="left" bgcolor="{$cellcolor}" width="15%">
                  <xsl:value-of select="@name"/>
                </td>
                <td align="left" bgcolor="{$cellcolor}" width="20%">
                  <xsl:value-of select="@return"/>
                </td>
                <td align="left" bgcolor="{$cellcolor}">
                  <xsl:value-of select="@description"/>
                </td>
                <xsl:if test="$hasParameters='false'">
                  <td align="right" bgcolor="{$cellcolor}">
                    <input class="buttons" type="submit" value="{$invoke.str}"/>
                  </td>
                </xsl:if>
                <xsl:if test="$hasParameters='true'">
                  <td bgcolor="{$cellcolor}"/>
                  <tr>
                    <td colspan="4" height="10"/>
                  </tr>
                  <tr>
                    <td/>
                    <td colspan="3">
                      <table border="0" cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                          <td colspan="4" height="10"/>
                        </tr>
                        <tr>
                          <td>
                            <img border="0" height="15" src="images/bkgd_onglet_left.gif"/>
                          </td>
                          <td align="left" bgcolor="#993399" nowrap="nowrap">
                            <span class="Titre2">
                               <font color="#FFFFFF">
                                <b>
                                <xsl:call-template name="str">
	              	    				      <xsl:with-param name="id">mbean.operations.parameter</xsl:with-param>
	              			    	      </xsl:call-template>
                                </b>
                              </font>
                            </span>
                          </td>
                          <td>
                            <img border="0" src="images/bkgd_onglet_tit2.gif"/>
                          </td>
                          <td bgcolor="#FFFFFF" width="100%"/>
                        </tr>
                      </table>         
                    </td>
                  </tr>
                  <tr>
                    <td/>
                    <td colspan="3">
                      <table border="0" cellpadding="2" cellspacing="0" width="100%">
                        <tr>
                          <td bgcolor="#993399" class="Titre3black" width="3%">
                            <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160;<font color="#FFFFFF">
                              <b>
                                <xsl:call-template name="str">
                                  <xsl:with-param name="id">mbean.operations.parameterid</xsl:with-param>
                                </xsl:call-template>
                              </b>
                            </font>
                          </td>
                          <td bgcolor="#993399" class="Titre3black" width="10%">
                            <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160;<font color="#FFFFFF">
                              <b>
                                <xsl:call-template name="str">
                                  <xsl:with-param name="id">mbean.operations.parametername</xsl:with-param>
                                </xsl:call-template>
                              </b>
                            </font>
                          </td>
                          <td bgcolor="#993399" class="Titre3black" width="57%">
                            <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160;<font color="#FFFFFF">
                              <b>
                                <xsl:call-template name="str">
                                  <xsl:with-param name="id">mbean.operations.parameterdescription</xsl:with-param>
                                </xsl:call-template>
                              </b>
                            </font>
                          </td>
                          <td bgcolor="#993399" class="Titre3black">
                            <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160;<font color="#FFFFFF">
                              <b>
                                <xsl:call-template name="str">
                                  <xsl:with-param name="id">mbean.operations.parameterclass</xsl:with-param>
                                </xsl:call-template>
                              </b>
                            </font>
                          </td>
                          <td bgcolor="#993399"/>
                        </tr>
                        <xsl:call-template name="parameters"/>
                        <tr>
                          <td height="35" align="right" colspan="5">
                            <input class="buttons" type="submit" value="{$invoke.str}"/>
                          </td>
                        </tr>
                      </table>
                    </td>
                  </tr>
                </xsl:if>
              </form>
            </tr>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <tr>
            <td align="center" colspan="5">
              <xsl:call-template name="str">
                <xsl:with-param name="id">mbean.operations.nooperations</xsl:with-param>
              </xsl:call-template><br/><br/>
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
    </table>
  </xsl:template>
  <xsl:template name="constructors">
    <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
      <tr>
        <td>
          <img border="0" height="15" src="images/bkgd_onglet_left.gif"/>
        </td>
        <td align="left" bgcolor="#993399" nowrap="nowrap">
          <span class="Titre2">
             <font color="#FFFFFF">
              <b>
                <xsl:call-template name="str">
						      <xsl:with-param name="id">mbean.mbean.constructors</xsl:with-param>
					      </xsl:call-template>
              </b>
            </font>
          </span>
        </td>
        <td>
          <img border="0" src="images/bkgd_onglet_tit2.gif"/>
        </td>
        <td bgcolor="#FFFFFF" width="100%"/>
      </tr>
    </table>
    <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
      <tr align="left" valign="top">
        <td bgcolor="#993399" class="Titre3black" width="30%">
          <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160; <font color="#FFFFFF">
            <b>
              <xsl:call-template name="str">
                <xsl:with-param name="id">mbean.constructors.class</xsl:with-param>
              </xsl:call-template>
            </b>
          </font>
        </td>
        <td bgcolor="#993399" class="Titre3black">
          <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160; <font color="#FFFFFF">
            <b>
              <xsl:call-template name="str">
                <xsl:with-param name="id">mbean.constructors.description</xsl:with-param>
              </xsl:call-template>
            </b>
          </font>
        </td>
      </tr>
      <xsl:choose>
        <xsl:when test="Constructor">
          <xsl:for-each select="Constructor">
            <form action="create">
              <xsl:variable name="cellcolor">
                <xsl:if test="(position() mod 2)=1">#CCCCCC</xsl:if>
                <xsl:if test="(position() mod 2)=0">#FFFFFF</xsl:if>
              </xsl:variable>
              <xsl:variable name="classname">
                <xsl:value-of select="../@classname"/>
              </xsl:variable>
              <tr>
                <td bgcolor="{$cellcolor}" width="20%">
                  <xsl:value-of select="$classname"/>
                </td>
                <td bgcolor="{$cellcolor}">
                  <xsl:value-of select="@description"/>
                </td>
              </tr>
              <tr>
                <td width="20%"/>
                <td>
                  <table border="0" cellpadding="0" cellspacing="0" width="100%">
                    <tr>
                      <td colspan="4" height="10"/>
                    </tr>
                    <tr>
                      <td>
                        <img border="0" height="15" src="images/bkgd_onglet_left.gif"/>
                      </td>
                      <td align="left" bgcolor="#993399" nowrap="nowrap">
                        <span class="Titre2">
                           <font color="#FFFFFF">
                            <b>
                              <xsl:call-template name="str">
	              					      <xsl:with-param name="id">mbean.constructors.parameter</xsl:with-param>
	              				      </xsl:call-template>
                            </b>
                          </font>
                        </span>
                      </td>
                      <td>
                        <img border="0" src="images/bkgd_onglet_tit2.gif"/>
                      </td>
                      <td bgcolor="#FFFFFF" width="100%"/>
                    </tr>
                  </table>
                  <table border="0" cellpadding="0" cellspacing="0" width="100%">
                    <tr>
                      <td bgcolor="#993399" class="Titre3black">
                        <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160;<font color="#FFFFFF">
                          <b>
                            <xsl:call-template name="str">
                              <xsl:with-param name="id">mbean.constructors.parameterid</xsl:with-param>
                            </xsl:call-template>
                          </b>
                        </font>
                      </td>
                      <td bgcolor="#993399" class="Titre3black">
                        <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160;<font color="#FFFFFF">
                          <b>
                            <xsl:call-template name="str">
                              <xsl:with-param name="id">mbean.constructors.parametername</xsl:with-param>
                            </xsl:call-template>
                          </b>
                        </font>
                      </td>
                      <td bgcolor="#993399" class="Titre3black">
                        <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160;<font color="#FFFFFF">
                          <b>
                            <xsl:call-template name="str">
                              <xsl:with-param name="id">mbean.constructors.parameterdescription</xsl:with-param>
                            </xsl:call-template>
                          </b>
                        </font>
                      </td>
                      <td bgcolor="#993399" class="Titre3black">
                        <img height="7" src="images/arrow_s_tit.gif" width="11"/>&#160;<font color="#FFFFFF">
                          <b>
                            <xsl:call-template name="str">
                              <xsl:with-param name="id">mbean.constructors.parameterclass</xsl:with-param>
                            </xsl:call-template>
                          </b>
                        </font>
                      </td>
                      <td bgcolor="#993399"/>
                    </tr>
                    <xsl:call-template name="parameters"/>
                  </table>
                </td>
              </tr>
              <tr>
                <td align="right" class="mbean_row" colspan="2">
                  <strong>
                    <xsl:call-template name="str">
                      <xsl:with-param name="id">mbean.constructors.objectname</xsl:with-param>
                    </xsl:call-template>
                  </strong>
                  <input name="objectname" value=""/>
                </td>
              </tr>
              <tr>
                <td colspan="2" align="right" height="35">
                  <xsl:variable name="create.str">
                    <xsl:call-template name="str">
                      <xsl:with-param name="id">mbean.constructors.create</xsl:with-param>
                    </xsl:call-template>
                  </xsl:variable>
                  <input class="buttons" type="submit" value="{$create.str}"/>
                  <input name="class" type="hidden" value="{$classname}"/>  
                </td>
              </tr>
            </form>
          </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
          <tr>
            <td align="center" colspan="2">
              <xsl:call-template name="str">
                <xsl:with-param name="id">mbean.constructors.noconstructors</xsl:with-param>
              </xsl:call-template><br/><br/>
            </td>
          </tr>
        </xsl:otherwise>
      </xsl:choose>
    </table>
  </xsl:template>
  <!-- Main processing template -->
  <xsl:template match="MBean">
    <html>
      <xsl:call-template name="head"/>
      <body bgcolor="#FFFFFF" leftmargin="0"
        onLoad="MM_preloadImages('images/bkgd_onglet_contact_on.gif','images/btn_top_on.gif')" text="#000000" topmargin="0">
        <xsl:call-template name="toprow">
          <xsl:with-param name="selection">mbean</xsl:with-param>
        </xsl:call-template>
        <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
          <tr bgcolor="#660066">
            <td class="titre1" height="17">&#160;
              <xsl:call-template name="str">
                <xsl:with-param name="id">mbean.mbean.title</xsl:with-param>
                <xsl:with-param name="p0">
                  <xsl:value-of select="@objectname"/>
                </xsl:with-param>
              </xsl:call-template>
            </td>
            <td align="right" class="titre1" height="17" valign="middle">
              <img src="images/titres/tit_mbean_{$request.locale}.gif"/>
            </td>
          </tr>
        </table>
        <xsl:call-template name="attribute"/>
        <xsl:call-template name="operations"/>
        <xsl:call-template name="constructors"/>
        <xsl:call-template name="bottom"/>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
