<?xml version="1.0" encoding="UTF-8"?>
<!--
 Copyright (C) MX4J.
 All rights reserved.

 This software is distributed under the terms of the MX4J License version 1.0.
 See the terms of the MX4J License in the documentation provided with this software.

 Author: Carlos Quiroz (tibu@users.sourceforge.net)
 Revision: $Revision: 1.2 $
																																					-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output encoding="UTF-8" indent="yes" method="html"/>
  <xsl:param name="html.stylesheet">stylesheet.css</xsl:param>
  <xsl:param name="html.stylesheet.type">text/css</xsl:param>
  <xsl:param name="head.title">constructors.title</xsl:param>
  <xsl:include href="common.xsl"/>
  <xsl:include href="mbean_attributes.xsl"/>
  <xsl:param name="request.objectname"/>
  <!-- Constructor's parameters tempalte -->
  <xsl:template match="Parameter" name="parameters">
    <xsl:param name="class"/>
    <tr>
      <td colspan="3">
        <p>
          <xsl:call-template name="str">
            <xsl:with-param name="id">constructors.parameters.title</xsl:with-param>
          </xsl:call-template>
        </p>
      </td>
    </tr>
    <tr>
      <td width="3%">
        <div>
          <xsl:call-template name="str">
            <xsl:with-param name="id">constructors.parameters.id</xsl:with-param>
          </xsl:call-template>
        </div>
      </td>
      <td>
        <div>
          <xsl:call-template name="str">
            <xsl:with-param name="id">constructors.parameters.type</xsl:with-param>
          </xsl:call-template>
        </div>
      </td>
      <td align="right">
        <div>
          <xsl:call-template name="str">
            <xsl:with-param name="id">constructors.parameters.value</xsl:with-param>
          </xsl:call-template>
        </div>
      </td>
    </tr>
    <xsl:for-each select="Parameter">
      <xsl:sort data-type="text" order="ascending" select="@id"/>
      <xsl:variable name="type.id" select="concat('type', position()-1)"/>
      <xsl:variable name="name.id" select="concat('value', position()-1)"/>
      <xsl:variable name="type" select="@type"/>
      <tr class="{$class}">
        <td align="left">
          <div align="left">
            <xsl:value-of select="@id"/>
          </div>
        </td>
        <td align="left">
          <xsl:choose>
            <xsl:when test="starts-with( @type, 'java.lang.' )">
              <xsl:value-of select="substring-after( @type, 'java.lang.' )"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="@type"/>
            </xsl:otherwise>
          </xsl:choose>
        </td>
        <td align="right" width="15%">
          <xsl:choose>
            <xsl:when test="@type='java.lang.String'        or @type='java.lang.Double'        or @type='java.lang.Short'        or @type='java.lang.Integer'        or @type='java.lang.Long'        or @type='java.lang.Float'        or @type='java.lang.Byte'        or @type='java.lang.Character'        or @type='java.lang.Boolean'        or @type='javax.management.ObjectName'        or @type='int'        or @type='long'        or @type='short'        or @type='boolean'        or @type='byte'        or @type='char'        or @type='double'        or @type='float'">
              <xsl:attribute name="valid"> true </xsl:attribute>
              <xsl:call-template name="raw-input">
                <xsl:with-param name="name" select="$name.id"/>
                <xsl:with-param name="type" select="$type"/>
                <xsl:with-param name="value"/>
                <xsl:with-param name="strinit">false</xsl:with-param>
              </xsl:call-template>
            </xsl:when>
            <xsl:when test="@strinit='true'">
              <xsl:attribute name="valid">true</xsl:attribute>
              <xsl:call-template name="raw-input">
                <xsl:with-param name="name" select="$name.id"/>
                <xsl:with-param name="type" select="$type"/>
                <xsl:with-param name="value"/>
                <xsl:with-param name="strinit">true</xsl:with-param>
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="valid"> false </xsl:attribute>
              <xsl:call-template name="str">
                <xsl:with-param name="id">constructors.parameters.unknowntype</xsl:with-param>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
          <input name="{$type.id}" type="hidden" value="{$type}"/>
        </td>
      </tr>
    </xsl:for-each>
  </xsl:template>
  <!-- Template for a Constructor node -->
  <xsl:template match="Constructor" name="constructors">
    <xsl:for-each select="//Constructor">
      <form action="create">
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
          <xsl:variable name="classtype">
            <xsl:if test="(position() mod 2)=1">clearline</xsl:if>
            <xsl:if test="(position() mod 2)=0">darkline</xsl:if>
          </xsl:variable>
          <xsl:variable name="hasParameters">
            <xsl:if test="count(Parameter)&gt;0">true</xsl:if>
            <xsl:if test="count(Parameter)=0">false</xsl:if>
          </xsl:variable>
          <xsl:variable name="classname">
            <xsl:value-of select="@name"/>
          </xsl:variable>
          <tr>
            <td valign="top">
              <xsl:call-template name="str">
                <xsl:with-param name="id">constructors.constructors.intro</xsl:with-param>
                <xsl:with-param name="p0">
                  <xsl:value-of select="@name"/>
                </xsl:with-param>
              </xsl:call-template>
            </td>
          </tr>
          <tr>
            <td>
              <table border="0" cellpadding="0" cellspacing="0" width="100%">
                <xsl:if test="$hasParameters='true'">
                  <xsl:call-template name="parameters"/>
                </xsl:if>
                <xsl:if test="$hasParameters='false'">
                  <tr>
                    <td colspan="3" width="{$pageWidth}"/>
                  </tr>
                </xsl:if>
              </table>
            </td>
          </tr>
          <tr>
            <td align="right" valign="bottom">
              <xsl:call-template name="str">
                <xsl:with-param name="id">constructors.constructors.objectnameinput</xsl:with-param>
              </xsl:call-template>
              <input name="objectname" type="input"/>
            </td>
          </tr>
          <tr>
            <td align="right">
              <xsl:variable name="str.createnew">
                <xsl:call-template name="str">
                  <xsl:with-param name="id">constructors.constructors.createnew</xsl:with-param>
                </xsl:call-template>
              </xsl:variable>
              <input class="buttons" type="submit" value="{$str.createnew}"/>
              <input name="class" type="hidden" value="{$classname}"/>
            </td>
          </tr>
        </table>
      </form>
    </xsl:for-each>
  </xsl:template>
  <!-- Exception handling template -->
  <xsl:template match="Exception" name="error">
    <xsl:for-each select="Exception">
      <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
        <tr>
          <td class="fronttab">
            <xsl:call-template name="str">
              <xsl:with-param name="id">constructors.error.exception</xsl:with-param>
              <xsl:with-param name="p0">
                <xsl:value-of select="@errorMsg"/>
              </xsl:with-param>
            </xsl:call-template>
          </td>
        </tr>
      </table>
    </xsl:for-each>
  </xsl:template>
  <!-- Main template -->
  <xsl:template match="/" name="main">
    <html>
      <xsl:call-template name="head"/>
      <body bgcolor="#FFFFFF" leftmargin="0"
        onLoad="MM_preloadImages('images/bkgd_onglet_contact_on.gif','images/btn_top_on.gif')" text="#000000" topmargin="0">
        <xsl:call-template name="toprow">
          <xsl:with-param name="selection">mbean</xsl:with-param>
        </xsl:call-template>
        <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
          <tr bgcolor="#660066">
            <td class="titre1" height="17"/>
            <td align="right" class="titre1" height="17" valign="middle">
              <img src="images/titres/tit_mbean_{$request.locale}.gif"/>
            </td>
          </tr>
        </table>
        <xsl:for-each select="Class|Exception">
          <xsl:variable name="img-onglet">
            <xsl:choose>
              <xsl:when test="position() = 1">bkgd_onglet_tit.gif</xsl:when>
              <xsl:otherwise>bkgd_onglet_tit2.gif</xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:variable name="bgcolor-onglet">
            <xsl:choose>
              <xsl:when test="position() = 1">#660066</xsl:when>
              <xsl:otherwise>#FFFFFF</xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <table border="0" cellpadding="0" cellspacing="0" width="{$pageWidth}">
            <tr>
              <td>
                <img border="0" height="15" src="images/bkgd_onglet_left.gif"/>
              </td>
              <td align="left" bgcolor="#993399" nowrap="nowrap">
                <span class="Titre2">
                  <font color="#FFFFFF">
                    <b>
                      <xsl:call-template name="str">
                        <xsl:with-param name="id">constructors.main.title</xsl:with-param>
                        <xsl:with-param name="p0">
                          <xsl:value-of select="@classname"/>
                        </xsl:with-param>
                      </xsl:call-template>
                    </b>
                  </font>
                </span>
              </td>
              <td>
                <img border="0" src="images/{$img-onglet}"/>
              </td>
              <td bgcolor="{$bgcolor-onglet}" width="{$pageWidth}"/>
            </tr>
          </table>
        </xsl:for-each>
        <xsl:call-template name="error"/>
        <xsl:call-template name="constructors"/>
        <xsl:call-template name="bottom"/>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
