/*
 * Copyright 2006 National Institute of Advanced Industrial Science
 * and Technology (AIST), and contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ow.ipmulticast.igmpd;

import java.util.Set;

import ow.ipmulticast.Group;
import ow.ipmulticast.VirtualInterface;

/**
 * These callbacks are invoked when groups which this node joins are changed.
 */
public interface GroupChangeCallback {
	void included(Set<Group> includedGroupSet, VirtualInterface vif);
	void excluded(Set<Group> excludedGroupSet, VirtualInterface vif);
}
