/*
 * Decompiled with CFR 0.152.
 */
package mx4j.remote;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.remote.SubjectDelegationPermission;
import javax.security.auth.AuthPermission;
import javax.security.auth.Policy;
import javax.security.auth.Subject;
import mx4j.log.Log;
import mx4j.log.Logger;

public class MX4JRemoteUtils {
    private static int connectionNumber;
    static /* synthetic */ Class class$mx4j$remote$MX4JRemoteUtils;
    static /* synthetic */ Class class$java$security$CodeSource;
    static /* synthetic */ Class class$java$security$PermissionCollection;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class array$Ljava$security$Principal;
    static /* synthetic */ Class class$java$security$ProtectionDomain;

    public static Map removeNonSerializableEntries(Map map) {
        HashMap newMap = new HashMap(map.size());
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (!MX4JRemoteUtils.isSerializable(entry)) continue;
            newMap.put(entry.getKey(), entry.getValue());
        }
        return newMap;
    }

    private static boolean isSerializable(Object object) {
        if (object instanceof Map.Entry) {
            return MX4JRemoteUtils.isSerializable(((Map.Entry)object).getKey()) && MX4JRemoteUtils.isSerializable(((Map.Entry)object).getValue());
        }
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return true;
        }
        if (object instanceof Number) {
            return true;
        }
        if (!(object instanceof Serializable)) {
            return false;
        }
        return MX4JRemoteUtils.isTrulySerializable(object);
    }

    public static boolean isTrulySerializable(Object object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            oos.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String createConnectionID(String protocol, String callerAddress, int callerPort, Subject subject) {
        StringBuffer buffer = new StringBuffer(protocol);
        buffer.append(':');
        if (callerAddress != null) {
            buffer.append("//").append(callerAddress);
        }
        if (callerPort >= 0) {
            buffer.append(':').append(callerPort);
        }
        buffer.append(' ');
        if (subject != null) {
            Set<Principal> principals = subject.getPrincipals();
            Iterator<Principal> i = principals.iterator();
            while (i.hasNext()) {
                Principal principal = i.next();
                String name = principal.getName();
                name = name.replace(' ', '_');
                buffer.append(name);
                if (!i.hasNext()) continue;
                buffer.append(';');
            }
        }
        buffer.append(' ');
        buffer.append("0x").append(Integer.toHexString(MX4JRemoteUtils.getNextConnectionNumber()).toUpperCase());
        return buffer.toString();
    }

    private static synchronized int getNextConnectionNumber() {
        return ++connectionNumber;
    }

    private static Logger getLogger() {
        return Log.getLogger((class$mx4j$remote$MX4JRemoteUtils == null ? (class$mx4j$remote$MX4JRemoteUtils = MX4JRemoteUtils.class$("mx4j.remote.MX4JRemoteUtils")) : class$mx4j$remote$MX4JRemoteUtils).getName());
    }

    public static Object subjectInvoke(Subject subject, Subject delegate, AccessControlContext context, Map environment, PrivilegedExceptionAction action) throws Exception {
        if (delegate != null) {
            if (subject == null) {
                throw new SecurityException("There is no authenticated subject to delegate to");
            }
            MX4JRemoteUtils.checkSubjectDelegationPermission(delegate, MX4JRemoteUtils.getSubjectContext(subject, null, context, environment));
        }
        Logger logger = MX4JRemoteUtils.getLogger();
        if (subject == null) {
            if (logger.isEnabledFor(0)) {
                logger.trace("No authenticated subject, invoking action without using Subject.doAs");
            }
            return action.run();
        }
        try {
            if (delegate == null) {
                if (logger.isEnabledFor(0)) {
                    logger.trace("Invoking Subject.doAs using authenticated subject " + subject);
                }
                return Subject.doAsPrivileged(subject, action, MX4JRemoteUtils.getSubjectContext(subject, delegate, context, environment));
            }
            if (logger.isEnabledFor(0)) {
                logger.trace("Invoking Subject.doAs using delegate subject " + delegate);
            }
            return Subject.doAsPrivileged(delegate, action, MX4JRemoteUtils.getSubjectContext(subject, delegate, context, environment));
        }
        catch (PrivilegedActionException x) {
            throw x.getException();
        }
    }

    private static void checkSubjectDelegationPermission(final Subject delegate, AccessControlContext context) throws SecurityException {
        Logger logger = MX4JRemoteUtils.getLogger();
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            if (logger.isEnabledFor(0)) {
                logger.trace("No SecurityManager, skipping Subject delegation permission check");
            }
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                StringBuffer buffer = new StringBuffer();
                Set<Principal> principals = delegate.getPrincipals();
                Iterator<Principal> i = principals.iterator();
                while (i.hasNext()) {
                    Principal principal = i.next();
                    buffer.setLength(0);
                    String permission = buffer.append(principal.getClass().getName()).append(".").append(principal.getName()).toString();
                    AccessController.checkPermission(new SubjectDelegationPermission(permission));
                }
                return null;
            }
        }, context);
    }

    private static AccessControlContext getSubjectContext(final Subject subject, Subject delegate, final AccessControlContext context, Map environment) {
        final Logger logger = MX4JRemoteUtils.getLogger();
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            if (logger.isEnabledFor(0)) {
                logger.trace("No security manager, injecting JSR 160 domain only");
            }
            InjectingDomainCombiner combiner = new InjectingDomainCombiner(delegate != null ? delegate : subject);
            return new AccessControlContext(new ProtectionDomain[]{combiner.getInjectedProtectionDomain()});
        }
        boolean combine = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    MX4JRemoteUtils.checkSubjectDelegationPermission(subject, context);
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Check for SubjectDelegationPermission passed, avoiding security domains combination");
                    }
                    return Boolean.FALSE;
                }
                catch (AccessControlException x) {
                    if (logger.isEnabledFor(0)) {
                        logger.trace("Check for SubjectDelegationPermission not passed, combining security domains");
                    }
                    return Boolean.TRUE;
                }
            }
        }, context);
        if (combine) {
            final InjectingDomainCombiner combiner = new InjectingDomainCombiner(delegate != null ? delegate : subject);
            AccessControlContext acc = (AccessControlContext)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new AccessControlContext(context, combiner);
                }
            });
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        AccessController.checkPermission(new AuthPermission("doAsPrivileged"));
                    }
                    catch (AccessControlException accessControlException) {
                        // empty catch block
                    }
                    return null;
                }
            }, acc);
            ProtectionDomain[] combined = combiner.getCombinedDomains();
            return new AccessControlContext(combined);
        }
        InjectingDomainCombiner combiner = new InjectingDomainCombiner(delegate != null ? delegate : subject);
        return new AccessControlContext(new ProtectionDomain[]{combiner.getInjectedProtectionDomain()});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class InjectingDomainCombiner
    implements DomainCombiner {
        private static Constructor domainConstructor;
        private ProtectionDomain domain;
        private ProtectionDomain[] combined;

        public InjectingDomainCombiner(Subject subject) {
            if (domainConstructor != null) {
                Principal[] principals = subject.getPrincipals().toArray(new Principal[0]);
                try {
                    this.domain = (ProtectionDomain)domainConstructor.newInstance(new CodeSource(null, null), null, null, principals);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.domain == null) {
                this.domain = new SubjectProtectionDomain(new CodeSource(null, null), subject);
            }
        }

        public ProtectionDomain getInjectedProtectionDomain() {
            return this.domain;
        }

        public ProtectionDomain[] combine(ProtectionDomain[] current, ProtectionDomain[] assigned) {
            int length = current.length;
            ProtectionDomain[] result = null;
            if (assigned == null || assigned.length == 0) {
                result = new ProtectionDomain[length + 1];
                System.arraycopy(current, 0, result, 1, length);
            } else {
                result = new ProtectionDomain[length + assigned.length + 1];
                System.arraycopy(current, 0, result, 1, length);
                System.arraycopy(assigned, 0, result, length + 1, assigned.length);
            }
            result[0] = this.domain;
            this.combined = result;
            Logger logger = MX4JRemoteUtils.getLogger();
            if (logger.isEnabledFor(0)) {
                logger.trace("Security domains combination");
                logger.trace("Current domains");
                logger.trace(this.dumpDomains(current));
                logger.trace("Assigned domains");
                logger.trace(this.dumpDomains(assigned));
                logger.trace("Combined domains");
                logger.trace(this.dumpDomains(result));
            }
            return result;
        }

        private String dumpDomains(ProtectionDomain[] domains) {
            if (domains == null) {
                return "null";
            }
            StringBuffer buffer = new StringBuffer();
            for (int i = domains.length - 1; i >= 0; --i) {
                int k = domains.length - 1 - i;
                while (k-- > 0) {
                    buffer.append("  ");
                }
                buffer.append(domains[i].getCodeSource().getLocation());
                buffer.append("\n");
            }
            return buffer.toString();
        }

        public ProtectionDomain[] getCombinedDomains() {
            return this.combined;
        }

        static {
            try {
                domainConstructor = (class$java$security$ProtectionDomain == null ? (class$java$security$ProtectionDomain = MX4JRemoteUtils.class$("java.security.ProtectionDomain")) : class$java$security$ProtectionDomain).getConstructor(class$java$security$CodeSource == null ? (class$java$security$CodeSource = MX4JRemoteUtils.class$("java.security.CodeSource")) : class$java$security$CodeSource, class$java$security$PermissionCollection == null ? (class$java$security$PermissionCollection = MX4JRemoteUtils.class$("java.security.PermissionCollection")) : class$java$security$PermissionCollection, class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = MX4JRemoteUtils.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader, array$Ljava$security$Principal == null ? (array$Ljava$security$Principal = MX4JRemoteUtils.class$("[Ljava.security.Principal;")) : array$Ljava$security$Principal);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private static class SubjectProtectionDomain
        extends ProtectionDomain {
            private final Subject subject;

            public SubjectProtectionDomain(CodeSource codesource, Subject subject) {
                super(codesource, null);
                this.subject = subject;
            }

            public boolean implies(Permission permission) {
                Policy policy = (Policy)AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ SubjectProtectionDomain this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        return Policy.getPolicy();
                    }
                });
                PermissionCollection permissions = policy.getPermissions(this.subject, this.getCodeSource());
                return permissions.implies(permission);
            }
        }
    }
}

