/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.PackedOffsets;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.tree.LN;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class FileSummaryLN
extends LN {
    private static final String BEGIN_TAG = "<fileSummaryLN>";
    private static final String END_TAG = "</fileSummaryLN>";
    private MemoryBudget memBudget;
    private FileSummary baseSummary;
    private TrackedFileSummary trackedSummary;
    private PackedOffsets obsoleteOffsets;
    private boolean needOffsets;
    private byte entryVersion;

    public FileSummaryLN(EnvironmentImpl envImpl, FileSummary baseSummary) {
        super(new byte[0], envImpl, false);
        this.memBudget = envImpl.getMemoryBudget();
        assert (baseSummary != null);
        this.baseSummary = baseSummary;
        this.obsoleteOffsets = new PackedOffsets();
        this.entryVersion = (byte)-1;
    }

    public FileSummaryLN() throws DatabaseException {
        this.baseSummary = new FileSummary();
        this.obsoleteOffsets = new PackedOffsets();
    }

    public void setTrackedSummary(TrackedFileSummary trackedSummary) {
        this.trackedSummary = trackedSummary;
        this.needOffsets = true;
    }

    public TrackedFileSummary getTrackedSummary() {
        return this.trackedSummary;
    }

    public FileSummary getBaseSummary() {
        return this.baseSummary;
    }

    public PackedOffsets getObsoleteOffsets() {
        return this.obsoleteOffsets;
    }

    public boolean hasStringKey(byte[] bytes) {
        if (this.entryVersion == 0 || bytes.length != 8) {
            return true;
        }
        return bytes[4] >= 48 && bytes[4] <= 57;
    }

    public long getFileNumber(byte[] bytes) {
        if (this.hasStringKey(bytes)) {
            try {
                return Long.valueOf(new String(bytes, "UTF-8"));
            }
            catch (UnsupportedEncodingException shouldNeverHappen) {
                assert (false) : shouldNeverHappen;
                return 0L;
            }
        }
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        return (long)LogUtils.readIntMSB(buf) & 0xFFFFFFFFL;
    }

    public static byte[] makePartialKey(long fileNum) {
        byte[] bytes = new byte[4];
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        LogUtils.writeIntMSB(buf, (int)fileNum);
        return bytes;
    }

    public static byte[] makeFullKey(long fileNum, int sequence) {
        assert (sequence >= 0);
        byte[] bytes = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        LogUtils.writeIntMSB(buf, (int)fileNum);
        LogUtils.writeIntMSB(buf, Integer.MAX_VALUE - sequence);
        return bytes;
    }

    public void postFetchInit(DatabaseImpl db, long sourceLsn) throws DatabaseException {
        super.postFetchInit(db, sourceLsn);
        this.memBudget = db.getDbEnvironment().getMemoryBudget();
        if (this.entryVersion == 1 && db.getDbEnvironment().getUtilizationProfile().isRMWFixEnabled()) {
            this.obsoleteOffsets = new PackedOffsets();
        }
    }

    public String toString() {
        return this.dumpString(0, true);
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        sb.append(super.dumpString(nSpaces, dumpTags));
        sb.append('\n');
        if (!this.isDeleted()) {
            sb.append(this.baseSummary.toString());
            sb.append(this.obsoleteOffsets.toString());
        }
        return sb.toString();
    }

    protected void dumpLogAdditional(StringBuffer sb, boolean verbose) {
        if (!this.isDeleted()) {
            this.baseSummary.dumpLog(sb, true);
            if (verbose) {
                this.obsoleteOffsets.dumpLog(sb, true);
            }
        }
    }

    protected LogEntryType getTransactionalLogType() {
        assert (false) : "Txnl access to UP db not allowed";
        return LogEntryType.LOG_FILESUMMARYLN;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_FILESUMMARYLN;
    }

    public int getLogSize() {
        int size = super.getLogSize();
        if (!this.isDeleted()) {
            size += this.baseSummary.getLogSize();
            this.getOffsets();
            size += this.obsoleteOffsets.getLogSize();
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        if (this.trackedSummary != null) {
            this.baseSummary.add(this.trackedSummary);
            if (!this.isDeleted()) {
                this.getOffsets();
            }
            this.trackedSummary.reset();
        }
        super.writeToLog(logBuffer);
        if (!this.isDeleted()) {
            this.baseSummary.writeToLog(logBuffer);
            this.obsoleteOffsets.writeToLog(logBuffer);
        }
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryVersion) throws LogException {
        this.entryVersion = entryVersion;
        super.readFromLog(itemBuffer, entryVersion);
        if (!this.isDeleted()) {
            this.baseSummary.readFromLog(itemBuffer, entryVersion);
            if (entryVersion > 0) {
                this.obsoleteOffsets.readFromLog(itemBuffer, entryVersion);
            }
        }
    }

    public boolean logicalEquals(Loggable other) {
        return false;
    }

    private void getOffsets() {
        if (this.needOffsets) {
            long[] offsets = this.trackedSummary.getObsoleteOffsets();
            if (offsets != null) {
                int oldSize = this.obsoleteOffsets.getExtraMemorySize();
                this.obsoleteOffsets.pack(offsets);
                int newSize = this.obsoleteOffsets.getExtraMemorySize();
                this.memBudget.updateTreeMemoryUsage(newSize - oldSize);
            }
            this.needOffsets = false;
        }
    }

    public long getMemorySizeIncludedByParent() {
        return super.getMemorySizeIncludedByParent() + (long)(MemoryBudget.FILESUMMARYLN_OVERHEAD - MemoryBudget.LN_OVERHEAD) + (long)this.obsoleteOffsets.getExtraMemorySize();
    }

    void makeDeleted() {
        super.makeDeleted();
        this.obsoleteOffsets = new PackedOffsets();
    }
}

