/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.sqltype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.gen.internal.sqltype.AbstractSqlType;
import org.seasar.framework.util.FloatConversionUtil;
import org.seasar.framework.util.StringConversionUtil;

public class FloatType
extends AbstractSqlType {
    public FloatType() {
        this("float");
    }

    public FloatType(String dataType) {
        super(dataType);
    }

    public void bindValue(PreparedStatement ps, int index, String value) throws SQLException {
        if (value == null) {
            ps.setNull(index, 6);
        } else {
            ps.setFloat(index, FloatConversionUtil.toPrimitiveFloat((Object)value));
        }
    }

    public String getValue(ResultSet resultSet, int index) throws SQLException {
        Float value = Float.valueOf(resultSet.getFloat(index));
        return value != null ? StringConversionUtil.toString((Object)value) : null;
    }
}

