/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.meta;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.exception.TableNotFoundRuntimeException;
import org.seasar.extension.jdbc.gen.meta.DbColumnMeta;
import org.seasar.extension.jdbc.gen.meta.DbForeignKeyMeta;
import org.seasar.extension.jdbc.gen.meta.DbTableMeta;
import org.seasar.extension.jdbc.gen.meta.DbTableMetaReader;
import org.seasar.extension.jdbc.gen.meta.DbUniqueKeyMeta;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.extension.jdbc.util.DatabaseMetaDataUtil;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ArrayMap;
import org.seasar.framework.util.ResultSetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbTableMetaReaderImpl
implements DbTableMetaReader {
    protected Logger logger = Logger.getLogger(DbTableMetaReaderImpl.class);
    protected DataSource dataSource;
    protected GenDialect dialect;
    protected String schemaName;
    protected Pattern tableNamePattern;
    protected Pattern ignoreTableNamePattern;
    protected boolean readComment;

    public DbTableMetaReaderImpl(DataSource dataSource, GenDialect dialect, String schemaName, String tableNamePattern, String ignoreTableNamePattern, boolean readComment) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource");
        }
        if (dialect == null) {
            throw new NullPointerException("dialect");
        }
        if (tableNamePattern == null) {
            throw new NullPointerException("tableNamePattern");
        }
        if (ignoreTableNamePattern == null) {
            throw new NullPointerException("ignoreTableNamePattern");
        }
        this.dataSource = dataSource;
        this.dialect = dialect;
        this.schemaName = schemaName;
        this.tableNamePattern = Pattern.compile(tableNamePattern, 2);
        this.ignoreTableNamePattern = Pattern.compile(ignoreTableNamePattern, 2);
        this.readComment = readComment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DbTableMeta> read() {
        Connection con = DataSourceUtil.getConnection((DataSource)this.dataSource);
        try {
            DatabaseMetaData metaData = ConnectionUtil.getMetaData((Connection)con);
            List<DbTableMeta> dbTableMetaList = this.getDbTableMetaList(metaData, this.schemaName != null ? this.schemaName : this.getDefaultSchemaName(metaData));
            if (dbTableMetaList.isEmpty()) {
                throw new TableNotFoundRuntimeException(this.dialect.getClass().getName(), this.schemaName, this.tableNamePattern.pattern(), this.ignoreTableNamePattern.pattern());
            }
            for (DbTableMeta tableMeta : dbTableMetaList) {
                Set<String> primaryKeySet = this.getPrimaryKeySet(metaData, tableMeta);
                this.doDbUniqueKeyMeta(metaData, tableMeta, primaryKeySet);
                this.doDbColumnMeta(metaData, tableMeta, primaryKeySet);
                this.doDbForeignKeyMeta(metaData, tableMeta);
            }
            if (this.readComment && !this.dialect.isJdbcCommentAvailable()) {
                this.readCommentFromDictinary(con, dbTableMetaList);
            }
            List<DbTableMeta> list = dbTableMetaList;
            return list;
        }
        finally {
            ConnectionUtil.close((Connection)con);
        }
    }

    protected void doDbUniqueKeyMeta(DatabaseMetaData metaData, DbTableMeta tableMeta, Set<String> primaryKeySet) {
        for (DbUniqueKeyMeta ukMeta : this.getDbUniqueKeyMetaList(metaData, tableMeta)) {
            if (primaryKeySet.size() == ukMeta.getColumnNameList().size() && primaryKeySet.containsAll(ukMeta.getColumnNameList())) {
                ukMeta.setPrimaryKey(true);
            }
            tableMeta.addUniqueKeyMeta(ukMeta);
        }
    }

    protected void doDbColumnMeta(DatabaseMetaData metaData, DbTableMeta tableMeta, Set<String> primaryKeySet) {
        for (DbColumnMeta columnMeta : this.getDbColumnMetaList(metaData, tableMeta)) {
            if (primaryKeySet.contains(columnMeta.getName())) {
                columnMeta.setPrimaryKey(true);
                if (primaryKeySet.size() == 1) {
                    columnMeta.setAutoIncrement(this.isAutoIncrement(metaData, tableMeta, columnMeta.getName()));
                }
            }
            for (DbUniqueKeyMeta ukMeta : tableMeta.getUniqueKeyMetaList()) {
                if (ukMeta.getColumnNameList().size() != 1) continue;
                String ukColumnName = ukMeta.getColumnNameList().get(0);
                if (!columnMeta.getName().equals(ukColumnName)) continue;
                columnMeta.setUnique(true);
            }
            tableMeta.addColumnMeta(columnMeta);
        }
    }

    protected void doDbForeignKeyMeta(DatabaseMetaData metaData, DbTableMeta tableMeta) {
        for (DbForeignKeyMeta fkMeta : this.getDbForeignKeyMetaList(metaData, tableMeta)) {
            for (DbUniqueKeyMeta ukMeta : tableMeta.getUniqueKeyMetaList()) {
                if (!((Object)fkMeta.getForeignKeyColumnNameList()).equals(ukMeta.getColumnNameList())) continue;
                fkMeta.setUnique(true);
            }
            tableMeta.addForeignKeyMeta(fkMeta);
        }
    }

    protected String getDefaultSchemaName(DatabaseMetaData metaData) {
        String userName = DatabaseMetaDataUtil.getUserName((DatabaseMetaData)metaData);
        return this.dialect.getDefaultSchemaName(userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DbTableMeta> getDbTableMetaList(DatabaseMetaData metaData, String schemaName) {
        ArrayList<DbTableMeta> arrayList;
        ArrayList<DbTableMeta> result = new ArrayList<DbTableMeta>();
        ResultSet rs = metaData.getTables(null, schemaName, null, new String[]{"TABLE"});
        try {
            while (rs.next()) {
                DbTableMeta dbTableMeta = new DbTableMeta();
                dbTableMeta.setCatalogName(rs.getString("TABLE_CAT"));
                dbTableMeta.setSchemaName(rs.getString("TABLE_SCHEM"));
                dbTableMeta.setName(rs.getString("TABLE_NAME"));
                if (this.readComment) {
                    dbTableMeta.setComment(rs.getString("REMARKS"));
                }
                if (!this.isTargetTable(dbTableMeta)) continue;
                result.add(dbTableMeta);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            try {
                ResultSetUtil.close((ResultSet)rs);
                throw throwable;
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e);
            }
        }
        ResultSetUtil.close((ResultSet)rs);
        return arrayList;
    }

    protected boolean isTargetTable(DbTableMeta dbTableMeta) {
        String name = dbTableMeta.getName();
        if (!this.tableNamePattern.matcher(name).matches()) {
            return false;
        }
        return !this.ignoreTableNamePattern.matcher(name).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DbColumnMeta> getDbColumnMetaList(DatabaseMetaData metaData, DbTableMeta tableMeta) {
        ArrayList<DbColumnMeta> arrayList;
        ArrayList<DbColumnMeta> result = new ArrayList<DbColumnMeta>();
        ResultSet rs = metaData.getColumns(tableMeta.getCatalogName(), tableMeta.getSchemaName(), tableMeta.getName(), null);
        try {
            while (rs.next()) {
                DbColumnMeta columnDesc = new DbColumnMeta();
                columnDesc.setName(rs.getString("COLUMN_NAME"));
                columnDesc.setSqlType(rs.getInt("DATA_TYPE"));
                columnDesc.setTypeName(rs.getString("TYPE_NAME"));
                columnDesc.setLength(rs.getInt("COLUMN_SIZE"));
                columnDesc.setScale(rs.getInt("DECIMAL_DIGITS"));
                columnDesc.setNullable(rs.getBoolean("NULLABLE"));
                columnDesc.setDefaultValue(rs.getString("COLUMN_DEF"));
                if (this.readComment) {
                    columnDesc.setComment(rs.getString("REMARKS"));
                }
                result.add(columnDesc);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            try {
                ResultSetUtil.close((ResultSet)rs);
                throw throwable;
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
        }
        ResultSetUtil.close((ResultSet)rs);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getPrimaryKeySet(DatabaseMetaData metaData, DbTableMeta tableMeta) {
        HashSet<String> result = new HashSet<String>();
        try {
            ResultSet rs = metaData.getPrimaryKeys(tableMeta.getCatalogName(), tableMeta.getSchemaName(), tableMeta.getName());
            try {
                while (rs.next()) {
                    result.add(rs.getString("COLUMN_NAME"));
                }
            }
            finally {
                ResultSetUtil.close((ResultSet)rs);
            }
            return result;
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DbForeignKeyMeta> getDbForeignKeyMetaList(DatabaseMetaData metaData, DbTableMeta tableMeta) {
        ArrayMap map = new ArrayMap();
        try {
            ResultSet rs = metaData.getImportedKeys(tableMeta.getCatalogName(), tableMeta.getSchemaName(), tableMeta.getName());
            try {
                while (rs.next()) {
                    DbForeignKeyMeta fkMeta;
                    String name = rs.getString("FK_NAME");
                    if (!map.containsKey(name)) {
                        fkMeta = new DbForeignKeyMeta();
                        fkMeta.setName(name);
                        fkMeta.setPrimaryKeyCatalogName(rs.getString("PKTABLE_CAT"));
                        fkMeta.setPrimaryKeySchemaName(rs.getString("PKTABLE_SCHEM"));
                        fkMeta.setPrimaryKeyTableName(rs.getString("PKTABLE_NAME"));
                        map.put(name, fkMeta);
                    }
                    fkMeta = (DbForeignKeyMeta)map.get(name);
                    fkMeta.addPrimaryKeyColumnName(rs.getString("PKCOLUMN_NAME"));
                    fkMeta.addForeignKeyColumnName(rs.getString("FKCOLUMN_NAME"));
                }
            }
            finally {
                ResultSetUtil.close((ResultSet)rs);
            }
            DbForeignKeyMeta[] array = map.values().toArray(new DbForeignKeyMeta[map.size()]);
            return Arrays.asList(array);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DbUniqueKeyMeta> getDbUniqueKeyMetaList(DatabaseMetaData metaData, DbTableMeta tableMeta) {
        if (!this.dialect.supportsGetIndexInfo(tableMeta.getCatalogName(), tableMeta.getSchemaName(), tableMeta.getName())) {
            this.logger.log("WS2JDBCGen0002", new Object[]{tableMeta.getCatalogName(), tableMeta.getSchemaName(), tableMeta.getName()});
            return Collections.emptyList();
        }
        ArrayMap map = new ArrayMap();
        try {
            ResultSet rs = metaData.getIndexInfo(tableMeta.getCatalogName(), tableMeta.getSchemaName(), tableMeta.getName(), true, false);
            try {
                while (rs.next()) {
                    DbUniqueKeyMeta ukMeta;
                    String name = rs.getString("INDEX_NAME");
                    if (!map.containsKey(name)) {
                        ukMeta = new DbUniqueKeyMeta();
                        ukMeta.setName(name);
                        map.put(name, ukMeta);
                    }
                    ukMeta = (DbUniqueKeyMeta)map.get(name);
                    ukMeta.addColumnName(rs.getString("COLUMN_NAME"));
                }
            }
            finally {
                ResultSetUtil.close((ResultSet)rs);
            }
            DbUniqueKeyMeta[] array = map.values().toArray(new DbUniqueKeyMeta[map.size()]);
            return Arrays.asList(array);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    protected boolean isAutoIncrement(DatabaseMetaData metaData, DbTableMeta tableMeta, String columnName) {
        try {
            return this.dialect.isAutoIncrement(metaData.getConnection(), tableMeta.getCatalogName(), tableMeta.getSchemaName(), tableMeta.getName(), columnName);
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    protected void readCommentFromDictinary(Connection connection, List<DbTableMeta> dbTableMetaList) {
        try {
            for (DbTableMeta tableMeta : dbTableMetaList) {
                String tableComment = this.dialect.getTableComment(connection, tableMeta.getCatalogName(), tableMeta.getSchemaName(), tableMeta.getName());
                tableMeta.setComment(tableComment);
                Map<String, String> columnCommentMap = this.dialect.getColumnCommentMap(connection, tableMeta.getCatalogName(), tableMeta.getSchemaName(), tableMeta.getName());
                for (DbColumnMeta columnMeta : tableMeta.getColumnMetaList()) {
                    String columnName = columnMeta.getName();
                    if (!columnCommentMap.containsKey(columnName)) continue;
                    String columnComment = columnCommentMap.get(columnName);
                    columnMeta.setComment(columnComment);
                }
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }
}

