/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ProductInfo {
    protected final String PRODUCT_NAME = "S2JDBC-Gen";
    protected final String UNKNOWN = "unknown";
    protected final String groupId;
    protected final String artifactId;
    protected final String version;

    protected ProductInfo(String version, String groupId, String artifactId) {
        this.version = version != null ? version : "unknown";
        this.groupId = groupId != null ? groupId : "unknown";
        this.artifactId = artifactId != null ? artifactId : "unknown";
    }

    public String getName() {
        return "S2JDBC-Gen";
    }

    public String getVersion() {
        return this.version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public static ProductInfo getInstance() {
        return ProductInfoHolder.productInfo;
    }

    public static void main(String[] args) {
        ProductInfo info = ProductInfoHolder.productInfo;
        System.out.printf("s2jdbc-gen name : %s\n", info.getName());
        System.out.printf("s2jdbc-gen version : %s\n", info.getVersion());
        System.out.printf("s2jdbc-gen groupId : %s\n", info.getGroupId());
        System.out.printf("s2jdbc-gen artifactId : %s\n", info.getArtifactId());
    }

    protected static class ProductInfoHolder {
        protected static final String POM_PROPERTIES_PATH = "META-INF/maven/org.seasar.container/s2jdbc-gen/pom.properties";
        protected static final ProductInfo productInfo = ProductInfoHolder.createProductInfo();

        protected ProductInfoHolder() {
        }

        protected static ProductInfo createProductInfo() {
            Properties props = ProductInfoHolder.loadProperties();
            return new ProductInfo(props.getProperty("version"), props.getProperty("groupId"), props.getProperty("artifactId"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static Properties loadProperties() {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(POM_PROPERTIES_PATH);
            Properties props = new Properties();
            if (is != null) {
                try {
                    props.load(is);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return props;
        }
    }
}

