/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.filter.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class RequestDumpUtil {
    public static void dumpRequestHeaders(StringBuffer sb, HttpServletRequest request, String lf, String indent) {
        Iterator it = RequestDumpUtil.toSortedSet(request.getHeaderNames()).iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            String value = request.getHeader(name);
            sb.append(indent);
            sb.append("[header]").append(name);
            sb.append("=").append(value);
            sb.append(lf);
        }
    }

    public static void dumpContextAttributes(StringBuffer sb, ServletContext context, String lf, String indent) {
        if (context == null) {
            return;
        }
        Iterator it = RequestDumpUtil.toSortedSet(context.getAttributeNames()).iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Object attr = context.getAttribute(name);
            sb.append(indent);
            sb.append("[context]").append(name).append("=").append(attr);
            sb.append(lf);
        }
    }

    public static void dumpCookies(StringBuffer sb, HttpServletRequest request, String lf, String indent) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return;
        }
        for (int i = 0; i < cookies.length; ++i) {
            sb.append(indent);
            sb.append("[cookie]").append(cookies[i].getName());
            sb.append("=").append(cookies[i].getValue());
            sb.append(lf);
        }
    }

    public static void dumpRequestAttributes(StringBuffer sb, HttpServletRequest request, String lf, String indent) {
        Iterator it = RequestDumpUtil.toSortedSet(request.getAttributeNames()).iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Object attr = request.getAttribute(name);
            sb.append(indent);
            sb.append("[request]").append(name).append("=").append(attr);
            sb.append(lf);
        }
    }

    public static void dumpSessionAttributes(StringBuffer sb, HttpServletRequest request, String lf, String indent) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        Iterator it = RequestDumpUtil.toSortedSet(session.getAttributeNames()).iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Object attr = session.getAttribute(name);
            sb.append(indent);
            sb.append("[session]").append(name).append("=").append(attr);
            sb.append(lf);
        }
    }

    private static SortedSet toSortedSet(Enumeration enu) {
        TreeSet set = new TreeSet();
        set.addAll(Collections.list(enu));
        return set;
    }

    public static void dumpRequestParameters(StringBuffer sb, HttpServletRequest request, String lf, String indent) {
        Iterator it = RequestDumpUtil.toSortedSet(request.getParameterNames()).iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            sb.append(indent);
            sb.append("[param]").append(name).append("=");
            String[] values = request.getParameterValues(name);
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(values[i]);
            }
            sb.append(lf);
        }
    }

    public static void dumpRequestProperties(StringBuffer sb, HttpServletRequest request, String lf, String indent) {
        sb.append(indent);
        sb.append("Request class=" + request.getClass().getName()).append(", instance=").append(request.toString().trim());
        sb.append(lf);
        sb.append(indent);
        sb.append("RequestedSessionId=").append(request.getRequestedSessionId());
        sb.append(lf);
        sb.append(indent);
        sb.append("REQUEST_URI=").append(request.getRequestURI());
        sb.append(", SERVLET_PATH=").append(request.getServletPath());
        sb.append(lf);
        sb.append(indent);
        sb.append("CharacterEncoding=" + request.getCharacterEncoding());
        sb.append(", ContentLength=").append(request.getContentLength());
        sb.append(", ContentType=").append(request.getContentType());
        sb.append(", Locale=").append(request.getLocale());
        sb.append(", Locales=");
        Enumeration locales = request.getLocales();
        boolean first = true;
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(locale.toString());
        }
        sb.append(", Scheme=").append(request.getScheme());
        sb.append(", isSecure=").append(request.isSecure());
        sb.append(lf).append(indent);
        sb.append("SERVER_PROTOCOL=").append(request.getProtocol());
        sb.append(", REMOTE_ADDR=").append(request.getRemoteAddr());
        sb.append(", REMOTE_HOST=").append(request.getRemoteHost());
        sb.append(", SERVER_NAME=").append(request.getServerName());
        sb.append(", SERVER_PORT=").append(request.getServerPort());
        sb.append(lf).append(indent);
        sb.append("ContextPath=").append(request.getContextPath());
        sb.append(", REQUEST_METHOD=").append(request.getMethod());
        sb.append(", QUERY_STRING=").append(request.getQueryString());
        sb.append(", PathInfo=").append(request.getPathInfo());
        sb.append(", RemoteUser=").append(request.getRemoteUser());
        sb.append(lf);
    }

    public static void dumpContextProperties(StringBuffer sb, ServletContext context, String lf, String indent) {
        sb.append(indent);
        sb.append("ContextRealPath=").append(context.getRealPath("/"));
        sb.append(lf).append(indent);
        sb.append("SERVER_SOFTWARE=").append(context.getServerInfo());
        sb.append(", ServletContextName=").append(context.getServletContextName());
        sb.append(", MajorVersion=").append(context.getMajorVersion());
        sb.append(", MinorVersion=").append(context.getMinorVersion());
    }

    public static void dumpSessionProperties(StringBuffer sb, HttpServletRequest request, String lf, String indent) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        sb.append(indent);
        sb.append("Session SessionId=").append(session.getId());
        sb.append(lf).append(indent);
        sb.append("Session :: CreationTime=").append(session.getCreationTime());
        sb.append(", LastAccessedTime=").append(session.getLastAccessedTime());
        sb.append(", MaxInactiveInterval=").append(session.getMaxInactiveInterval());
        sb.append(lf);
    }

    public static void dumpResponseProperties(StringBuffer sb, HttpServletResponse response, String lf, String indent) {
        sb.append(indent);
        sb.append("Response class=" + response.getClass().getName()).append(", instance=").append(response.toString().trim());
        sb.append(lf);
    }
}

