/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.ejb.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.Interceptors;
import org.seasar.framework.ejb.EJB3BusinessMethodDesc;
import org.seasar.framework.ejb.EJB3Desc;
import org.seasar.framework.ejb.EJB3InterceptorDesc;
import org.seasar.framework.ejb.impl.EJB3InterceptorDescImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJB3BusinessMethodDescImpl
implements EJB3BusinessMethodDesc {
    protected EJB3Desc ejb3desc;
    protected Method method;
    protected TransactionAttributeType transactionAttributeType;
    protected List<EJB3InterceptorDesc> interceptors = new ArrayList<EJB3InterceptorDesc>();

    public EJB3BusinessMethodDescImpl(EJB3Desc ejb3desc, Method method) {
        this.ejb3desc = ejb3desc;
        this.method = method;
        this.detectTransactionAttribute();
        this.detectInterceptors();
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public TransactionAttributeType getTransactionAttributeType() {
        return this.transactionAttributeType;
    }

    @Override
    public List<EJB3InterceptorDesc> getInterceptors() {
        return this.interceptors;
    }

    protected void detectTransactionAttribute() {
        Class<?> declaringClass;
        if (!this.ejb3desc.isCMT()) {
            return;
        }
        TransactionAttribute attribute = this.method.getAnnotation(TransactionAttribute.class);
        if (attribute == null && (attribute = (declaringClass = this.method.getDeclaringClass()).getAnnotation(TransactionAttribute.class)) == null) {
            this.transactionAttributeType = TransactionAttributeType.REQUIRED;
            return;
        }
        this.transactionAttributeType = attribute.value();
    }

    protected void detectInterceptors() {
        Interceptors annotation;
        ExcludeClassInterceptors exclude = this.method.getAnnotation(ExcludeClassInterceptors.class);
        if (exclude == null) {
            this.interceptors.addAll(this.ejb3desc.getInterceptors());
        }
        if ((annotation = this.method.getAnnotation(Interceptors.class)) == null) {
            return;
        }
        for (Class interceptorClass : annotation.value()) {
            this.interceptors.add(new EJB3InterceptorDescImpl(this.ejb3desc, interceptorClass));
        }
    }
}

