/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.jmx.upnp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import net.sbbi.upnp.jmx.UPNPDiscovery;
import net.sbbi.upnp.jmx.UPNPMBeanDevice;
import net.sbbi.upnp.jmx.UPNPServiceMBean;
import net.sbbi.upnp.jmx.upnp.UPNPMBeanBuilder;
import net.sbbi.upnp.jmx.upnp.UPNPMBeanBuilderImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UPNPConnectorServer
extends JMXConnectorServer
implements NotificationListener {
    private static final Log log = LogFactory.getLog((Class)UPNPConnectorServer.class);
    public static final String UPNP_MBEANS_BUILDER = UPNPConnectorServer.class.getName() + ".upnpbeans.builder";
    public static final String EXPOSE_UPNP_DEVICES_AS_MBEANS = UPNPConnectorServer.class.getName() + ".upnpdevices.as.mbeans";
    public static final String EXPOSE_UPNP_DEVICES_AS_MBEANS_TIMEOUT = UPNPConnectorServer.class.getName() + ".upnpdevices.as.mbeans.timeout";
    public static final String HANDLE_SSDP_MESSAGES = UPNPConnectorServer.class.getName() + ".upnpdevices.as.mbeans.ssdp";
    public static final String EXPOSE_MBEANS_AS_UPNP_DEVICES = UPNPConnectorServer.class.getName() + ".mbeans.as.upnpdevices";
    public static final String EXPOSE_EXISTING_MBEANS_AS_UPNP_DEVICES = UPNPConnectorServer.class.getName() + ".existing.mbeans.as.upnpdevices";
    private JMXServiceURL serviceURL;
    private Map env;
    private InetSocketAddress sktAddress;
    private UPNPMBeanBuilder builder;
    private Boolean exposeUPNPAsMBeans;
    private Boolean exposeMBeansAsUPNP;
    private Boolean exposeExistingMBeansAsUPNP;
    private Boolean handleSSDPMessages;
    private final Object STOP_PROCESS = new Object();
    private Map registeredMBeans = Collections.synchronizedMap(new HashMap());
    private ObjectName discoveryBeanName;

    public UPNPConnectorServer(MBeanServer server, JMXServiceURL serviceURL, Map env) throws IOException {
        super(server);
        this.serviceURL = serviceURL;
        this.env = env;
        this.sktAddress = new InetSocketAddress(InetAddress.getByName(serviceURL.getHost()), serviceURL.getPort());
        this.builder = (UPNPMBeanBuilder)env.get(UPNP_MBEANS_BUILDER);
        if (this.builder == null) {
            this.builder = new UPNPMBeanBuilderImpl();
        }
        this.exposeUPNPAsMBeans = (Boolean)env.get(EXPOSE_UPNP_DEVICES_AS_MBEANS);
        if (this.exposeUPNPAsMBeans == null) {
            this.exposeUPNPAsMBeans = Boolean.FALSE;
        }
        this.exposeMBeansAsUPNP = (Boolean)env.get(EXPOSE_MBEANS_AS_UPNP_DEVICES);
        if (this.exposeMBeansAsUPNP == null) {
            this.exposeMBeansAsUPNP = Boolean.TRUE;
        }
        this.handleSSDPMessages = (Boolean)env.get(HANDLE_SSDP_MESSAGES);
        if (this.handleSSDPMessages == null) {
            this.handleSSDPMessages = Boolean.FALSE;
        }
        this.exposeExistingMBeansAsUPNP = (Boolean)env.get(EXPOSE_EXISTING_MBEANS_AS_UPNP_DEVICES);
        if (this.exposeExistingMBeansAsUPNP == null) {
            this.exposeExistingMBeansAsUPNP = Boolean.FALSE;
        }
        if (!(this.exposeMBeansAsUPNP.booleanValue() || this.exposeUPNPAsMBeans.booleanValue() || this.exposeExistingMBeansAsUPNP.booleanValue())) {
            throw new IOException("Useless UPNPConnectorServer since nothing will be deployed, unregister it");
        }
    }

    public JMXServiceURL getAddress() {
        return this.serviceURL;
    }

    public Map getAttributes() {
        return Collections.unmodifiableMap(this.env);
    }

    public boolean isActive() {
        return false;
    }

    public void start() throws IOException {
        MBeanServer server = this.getMBeanServer();
        if (this.exposeMBeansAsUPNP.booleanValue()) {
            try {
                ObjectName delegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
                NotificationEmitter emmiter = (NotificationEmitter)MBeanServerInvocationHandler.newProxyInstance(server, delegate, NotificationEmitter.class, false);
                emmiter.addNotificationListener(this, null, this);
            }
            catch (Exception ex) {
                IOException ioEx = new IOException("UPNPConnector start error");
                ioEx.initCause(ex);
                throw ioEx;
            }
        }
        if (this.exposeUPNPAsMBeans.booleanValue()) {
            int timeout = 2500;
            if (this.env.containsKey(EXPOSE_UPNP_DEVICES_AS_MBEANS_TIMEOUT)) {
                timeout = (Integer)this.env.get(EXPOSE_UPNP_DEVICES_AS_MBEANS_TIMEOUT);
            }
            try {
                this.discoveryBeanName = new ObjectName("UPNPLib discovery:name=Discovery MBean_" + this.hashCode());
                UPNPDiscovery bean = new UPNPDiscovery(timeout, this.handleSSDPMessages, true);
                server.registerMBean(bean, this.discoveryBeanName);
            }
            catch (Exception ex) {
                IOException ioEx = new IOException("Error occured during MBeans discovery");
                ioEx.initCause(ex);
                throw ioEx;
            }
        }
        if (this.exposeExistingMBeansAsUPNP.booleanValue()) {
            int c = 0;
            Set<ObjectName> objectInstances = super.getMBeanServer().queryNames(null, null);
            Iterator<ObjectName> i = objectInstances.iterator();
            while (i.hasNext()) {
                ObjectName name = i.next();
                MBeanServerNotification not = new MBeanServerNotification("JMX.mbean.registered", (Object)this, (long)c++, name);
                this.handleNotification(not, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        IOException ioEx;
        MBeanServer server = this.getMBeanServer();
        IOException error = null;
        if (this.exposeMBeansAsUPNP.booleanValue()) {
            block13: {
                try {
                    ObjectName delegate = new ObjectName("JMImplementation:type=MBeanServerDelegate");
                    NotificationEmitter emmiter = (NotificationEmitter)MBeanServerInvocationHandler.newProxyInstance(server, delegate, NotificationEmitter.class, false);
                    emmiter.removeNotificationListener(this, null, this);
                }
                catch (Exception ex) {
                    if (ex instanceof ListenerNotFoundException) break block13;
                    ioEx = new IOException("UPNPConnector stop error");
                    ioEx.initCause(ex);
                    error = ioEx;
                }
            }
            Object ex = this.STOP_PROCESS;
            synchronized (ex) {
                Iterator i = this.registeredMBeans.values().iterator();
                while (i.hasNext()) {
                    UPNPMBeanDevice dv = (UPNPMBeanDevice)i.next();
                    try {
                        dv.stop();
                    }
                    catch (IOException ex2) {
                        log.error((Object)"Error during UPNPMBean device stop", (Throwable)ex2);
                    }
                }
                this.registeredMBeans.clear();
            }
        }
        if (this.exposeUPNPAsMBeans.booleanValue()) {
            try {
                server.unregisterMBean(this.discoveryBeanName);
            }
            catch (Exception ex) {
                ioEx = new IOException("Error occured during MBeans discovery");
                ioEx.initCause(ex);
                throw ioEx;
            }
        }
        if (error != null) {
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification, Object handBack) {
        block13: {
            if (notification.getType().equals("JMX.mbean.registered")) {
                MBeanServerNotification regNot = (MBeanServerNotification)notification;
                MBeanServer srv = this.getMBeanServer();
                ObjectName name = regNot.getMBeanName();
                try {
                    ObjectInstance objIn = srv.getObjectInstance(name);
                    String className = objIn.getClassName();
                    if (className.equals(UPNPServiceMBean.class.getName())) {
                        return;
                    }
                    if (!this.builder.select(name, className)) break block13;
                    MBeanInfo info = srv.getMBeanInfo(name);
                    UPNPMBeanDevice dv = this.builder.buildUPNPMBean(this.getMBeanServer(), objIn, info);
                    if (dv != null) {
                        dv.setBindAddress(this.sktAddress);
                        dv.start();
                        this.registeredMBeans.put(name.toString(), dv);
                    }
                }
                catch (Exception ex) {
                    log.error((Object)("Error during UPNP Mbean device " + name.toString() + " creation"), (Throwable)ex);
                }
            } else if (notification.getType().equals("JMX.mbean.unregistered")) {
                MBeanServerNotification regNot = (MBeanServerNotification)notification;
                String beanName = regNot.getMBeanName().toString();
                Object object = this.STOP_PROCESS;
                synchronized (object) {
                    UPNPMBeanDevice dv = (UPNPMBeanDevice)this.registeredMBeans.get(beanName);
                    if (dv != null) {
                        try {
                            dv.stop();
                        }
                        catch (Exception ex) {
                            log.error((Object)"Error during UPNPMBean device stop", (Throwable)ex);
                        }
                        this.registeredMBeans.remove(beanName);
                    }
                }
            }
        }
    }
}

