/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import org.h2.command.Command;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

public class Merge
extends Prepared {
    private Table table;
    private Column[] columns;
    private Column[] keys;
    private ObjectArray list = new ObjectArray();
    private Query query;
    private Prepared update;

    public Merge(Session session) {
        super(session);
    }

    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columns) {
        this.columns = columns;
    }

    public void setKeys(Column[] keys) {
        this.keys = keys;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addRow(Expression[] expr) {
        this.list.add(expr);
    }

    public int update() throws SQLException {
        int count;
        int i;
        this.session.getUser().checkRight(this.table, 4);
        this.session.getUser().checkRight(this.table, 8);
        if (this.keys == null) {
            Index idx = this.table.getPrimaryKey();
            if (idx == null) {
                throw Message.getSQLException(90057, "PRIMARY KEY");
            }
            this.keys = idx.getColumns();
        }
        StringBuffer buff = new StringBuffer("UPDATE ");
        buff.append(this.table.getSQL());
        buff.append(" SET ");
        for (i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.columns[i].getSQL());
            buff.append("=?");
        }
        buff.append(" WHERE ");
        for (i = 0; i < this.keys.length; ++i) {
            if (i > 0) {
                buff.append(" AND ");
            }
            buff.append(this.keys[i].getSQL());
            buff.append("=?");
        }
        String sql = buff.toString();
        this.update = this.session.prepare(sql);
        this.setCurrentRowNumber(0);
        if (this.list.size() > 0) {
            count = 0;
            for (int x = 0; x < this.list.size(); ++x) {
                this.setCurrentRowNumber(x + 1);
                Expression[] expr = (Expression[])this.list.get(x);
                Row newRow = this.table.getTemplateRow();
                for (int i2 = 0; i2 < this.columns.length; ++i2) {
                    Column c = this.columns[i2];
                    int index = c.getColumnId();
                    Expression e = expr[i2];
                    if (e == null) continue;
                    Value v = expr[i2].getValue(this.session).convertTo(c.getType());
                    newRow.setValue(index, v);
                }
                this.merge(newRow);
                ++count;
            }
        } else {
            LocalResult rows = this.query.query(0);
            count = 0;
            this.table.fireBefore(this.session);
            this.table.lock(this.session, true, false);
            while (rows.next()) {
                this.checkCancelled();
                Value[] r = rows.currentRow();
                Row newRow = this.table.getTemplateRow();
                this.setCurrentRowNumber(++count);
                for (int j = 0; j < this.columns.length; ++j) {
                    Column c = this.columns[j];
                    int index = c.getColumnId();
                    Value v = r[j].convertTo(c.getType());
                    newRow.setValue(index, v);
                }
                this.merge(newRow);
            }
            rows.close();
            this.table.fireAfter(this.session);
        }
        return count;
    }

    private void merge(Row row) throws SQLException {
        Parameter p;
        Value v;
        Column col;
        int i;
        ObjectArray k = this.update.getParameters();
        for (i = 0; i < this.columns.length; ++i) {
            col = this.columns[i];
            v = row.getValue(col.getColumnId());
            p = (Parameter)k.get(i);
            p.setValue(v);
        }
        for (i = 0; i < this.keys.length; ++i) {
            col = this.keys[i];
            v = row.getValue(col.getColumnId());
            if (v == null) {
                throw Message.getSQLException(90081, col.getSQL());
            }
            p = (Parameter)k.get(this.columns.length + i);
            p.setValue(v);
        }
        int count = this.update.update();
        if (count == 0) {
            this.table.fireBefore(this.session);
            this.table.validateConvertUpdateSequence(this.session, row);
            this.table.fireBeforeRow(this.session, null, row);
            this.table.lock(this.session, true, false);
            this.table.addRow(this.session, row);
            this.session.log(this.table, (short)0, row);
            this.table.fireAfter(this.session);
            this.table.fireAfterRow(this.session, null, row);
        } else if (count != 1) {
            throw Message.getSQLException(23001, this.table.getSQL());
        }
    }

    public String getPlanSQL() {
        int i;
        StringBuffer buff = new StringBuffer();
        buff.append("MERGE INTO ");
        buff.append(this.table.getSQL());
        buff.append('(');
        for (i = 0; i < this.columns.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.columns[i].getSQL());
        }
        buff.append(")");
        if (this.keys != null) {
            buff.append(" KEY(");
            for (i = 0; i < this.keys.length; ++i) {
                if (i > 0) {
                    buff.append(", ");
                }
                buff.append(this.keys[i].getSQL());
            }
            buff.append(")");
        }
        buff.append('\n');
        if (this.list.size() > 0) {
            buff.append("VALUES ");
            for (int x = 0; x < this.list.size(); ++x) {
                Expression[] expr = (Expression[])this.list.get(x);
                if (x > 0) {
                    buff.append(", ");
                }
                buff.append("(");
                for (int i2 = 0; i2 < this.columns.length; ++i2) {
                    Expression e;
                    if (i2 > 0) {
                        buff.append(", ");
                    }
                    if ((e = expr[i2]) == null) {
                        buff.append("DEFAULT");
                        continue;
                    }
                    buff.append(e.getSQL());
                }
                buff.append(')');
            }
        } else {
            buff.append(this.query.getPlanSQL());
        }
        return buff.toString();
    }

    public void prepare() throws SQLException {
        if (this.columns == null) {
            this.columns = this.list.size() > 0 && ((Expression[])this.list.get(0)).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (this.list.size() > 0) {
            for (int x = 0; x < this.list.size(); ++x) {
                Expression[] expr = (Expression[])this.list.get(x);
                if (expr.length != this.columns.length) {
                    throw Message.getSQLException(21002);
                }
                for (int i = 0; i < expr.length; ++i) {
                    Expression e = expr[i];
                    if (e == null) continue;
                    expr[i] = e.optimize(this.session);
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw Message.getSQLException(21002);
            }
        }
    }

    public boolean isTransactional() {
        return true;
    }

    public LocalResult queryMeta() {
        return null;
    }
}

